/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesDetectorWrapper;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesUtilsKt;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.NoOpInteractionPredicate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B5\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\t0\tH\u0096\u0001J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0019\u0010\u001a\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00190\u0019H\u0096\u0001J\u0019\u0010\u001b\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J\u0012\u0010\u001d\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016J\u0019\u0010\u001e\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\t0\tH\u0096\u0001J\u0019\u0010\u001f\u001a\u00020 2\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010!0!H\u0096\u0001J\u0019\u0010\"\u001a\u00020 2\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010!0!H\u0096\u0001J\t\u0010#\u001a\u00020 H\u0096\u0001J\t\u0010$\u001a\u00020 H\u0096\u0001J\u001b\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0096\u0001J\u0013\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0015\u001a\u00020&H\u0097\u0001J\t\u0010+\u001a\u00020 H\u0096\u0001J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0016J\u001b\u00100\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0096\u0001J\u001b\u00101\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0096\u0001J'\u00102\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020&2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010*2\b\b\u0001\u00103\u001a\u00020(H\u0096\u0001J\t\u00104\u001a\u00020\u0014H\u0096\u0001J\u0019\u00104\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010505H\u0096\u0001J\u0019\u00106\u001a\u00020 2\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010707H\u0096\u0001J\u0011\u00108\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0001J\u001b\u00109\u001a\u0004\u0018\u00010!2\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010:0:H\u0097\u0001J#\u00109\u001a\u0004\u0018\u00010!2\u000e\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010:0:2\u0006\u0010'\u001a\u00020&H\u0097\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006<"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper;", "Landroid/view/Window$Callback;", "wrappedCallback", "gesturesDetector", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "copyEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "(Landroid/view/Window$Callback;Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;Lcom/datadog/android/rum/tracking/InteractionPredicate;Lkotlin/jvm/functions/Function1;)V", "getCopyEvent", "()Lkotlin/jvm/functions/Function1;", "getGesturesDetector", "()Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "getInteractionPredicate", "()Lcom/datadog/android/rum/tracking/InteractionPredicate;", "getWrappedCallback", "()Landroid/view/Window$Callback;", "dispatchGenericMotionEvent", "", "p0", "kotlin.jvm.PlatformType", "dispatchKeyEvent", "event", "Landroid/view/KeyEvent;", "dispatchKeyShortcutEvent", "dispatchPopulateAccessibilityEvent", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchTouchEvent", "dispatchTrackballEvent", "onActionModeFinished", "", "Landroid/view/ActionMode;", "onActionModeStarted", "onAttachedToWindow", "onContentChanged", "onCreatePanelMenu", "", "p1", "Landroid/view/Menu;", "onCreatePanelView", "Landroid/view/View;", "onDetachedFromWindow", "onMenuItemSelected", "featureId", "item", "Landroid/view/MenuItem;", "onMenuOpened", "onPanelClosed", "onPreparePanel", "p2", "onSearchRequested", "Landroid/view/SearchEvent;", "onWindowAttributesChanged", "Landroid/view/WindowManager$LayoutParams;", "onWindowFocusChanged", "onWindowStartingActionMode", "Landroid/view/ActionMode$Callback;", "Companion", "dd-sdk-android_release"})
public final class WindowCallbackWrapper
implements Window.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Window.Callback wrappedCallback;
    @NotNull
    private final GesturesDetectorWrapper gesturesDetector;
    @NotNull
    private final InteractionPredicate interactionPredicate;
    @NotNull
    private final Function1<MotionEvent, MotionEvent> copyEvent;
    @NotNull
    public static final String BACK_DEFAULT_TARGET_NAME = "back";
    public static final boolean EVENT_CONSUMED = true;

    public WindowCallbackWrapper(@NotNull Window.Callback wrappedCallback, @NotNull GesturesDetectorWrapper gesturesDetector, @NotNull InteractionPredicate interactionPredicate, @NotNull Function1<? super MotionEvent, MotionEvent> copyEvent) {
        Intrinsics.checkNotNullParameter((Object)wrappedCallback, (String)"wrappedCallback");
        Intrinsics.checkNotNullParameter((Object)gesturesDetector, (String)"gesturesDetector");
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter(copyEvent, (String)"copyEvent");
        this.wrappedCallback = wrappedCallback;
        this.gesturesDetector = gesturesDetector;
        this.interactionPredicate = interactionPredicate;
        this.copyEvent = copyEvent;
    }

    public /* synthetic */ WindowCallbackWrapper(Window.Callback callback, GesturesDetectorWrapper gesturesDetectorWrapper, InteractionPredicate interactionPredicate, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            interactionPredicate = new NoOpInteractionPredicate();
        }
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(callback, gesturesDetectorWrapper, interactionPredicate, (Function1<? super MotionEvent, MotionEvent>)function1);
    }

    @NotNull
    public final Window.Callback getWrappedCallback() {
        return this.wrappedCallback;
    }

    @NotNull
    public final GesturesDetectorWrapper getGesturesDetector() {
        return this.gesturesDetector;
    }

    @NotNull
    public final InteractionPredicate getInteractionPredicate() {
        return this.interactionPredicate;
    }

    @NotNull
    public final Function1<MotionEvent, MotionEvent> getCopyEvent() {
        return this.copyEvent;
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public View onCreatePanelView(int p0) {
        return this.wrappedCallback.onCreatePanelView(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0) {
        return this.wrappedCallback.onWindowStartingActionMode(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0, int p1) {
        return this.wrappedCallback.onWindowStartingActionMode(p0, p1);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchGenericMotionEvent(p0);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyShortcutEvent(p0);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent p0) {
        return this.wrappedCallback.dispatchPopulateAccessibilityEvent(p0);
    }

    public boolean dispatchTrackballEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchTrackballEvent(p0);
    }

    public void onActionModeFinished(ActionMode p0) {
        this.wrappedCallback.onActionModeFinished(p0);
    }

    public void onActionModeStarted(ActionMode p0) {
        this.wrappedCallback.onActionModeStarted(p0);
    }

    public void onAttachedToWindow() {
        this.wrappedCallback.onAttachedToWindow();
    }

    public void onContentChanged() {
        this.wrappedCallback.onContentChanged();
    }

    public boolean onCreatePanelMenu(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onCreatePanelMenu(p0, p1);
    }

    public void onDetachedFromWindow() {
        this.wrappedCallback.onDetachedFromWindow();
    }

    public boolean onMenuOpened(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuOpened(p0, p1);
    }

    public void onPanelClosed(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.wrappedCallback.onPanelClosed(p0, p1);
    }

    public boolean onPreparePanel(int p0, @Nullable @org.jetbrains.annotations.Nullable View p1, @NonNull @NotNull Menu p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return this.wrappedCallback.onPreparePanel(p0, p1, p2);
    }

    public boolean onSearchRequested() {
        return this.wrappedCallback.onSearchRequested();
    }

    public boolean onSearchRequested(SearchEvent p0) {
        return this.wrappedCallback.onSearchRequested(p0);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams p0) {
        this.wrappedCallback.onWindowAttributesChanged(p0);
    }

    public void onWindowFocusChanged(boolean p0) {
        this.wrappedCallback.onWindowFocusChanged(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(@org.jetbrains.annotations.Nullable MotionEvent event) {
        boolean bl;
        if (event != null) {
            MotionEvent copy = (MotionEvent)this.copyEvent.invoke((Object)event);
            try {
                this.gesturesDetector.onTouchEvent(copy);
            }
            catch (Exception e) {
                Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Error processing MotionEvent", e, null, 4, null);
            }
            finally {
                copy.recycle();
            }
        } else {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Received MotionEvent=null", null, null, 6, null);
        }
        try {
            bl = this.wrappedCallback.dispatchTouchEvent(event);
        }
        catch (Exception e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Wrapped callback failed processing MotionEvent", e, null, 4, null);
            bl = true;
        }
        return bl;
    }

    public boolean onMenuItemSelected(int featureId, @NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        String resourceId = GesturesUtilsKt.resourceIdName(item.getItemId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)item.getClass().getCanonicalName()), TuplesKt.to((Object)"action.target.resource_id", (Object)resourceId), TuplesKt.to((Object)"action.target.title", (Object)item.getTitle())};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        GlobalRum.get().addUserAction(RumActionType.TAP, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, item), attributes);
        try {
            bl = this.wrappedCallback.onMenuItemSelected(featureId, item);
        }
        catch (Exception e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Wrapped callback failed processing MenuItem selection", e, null, 4, null);
            bl = true;
        }
        return bl;
    }

    public boolean dispatchKeyEvent(@org.jetbrains.annotations.Nullable KeyEvent event) {
        boolean bl;
        if (event == null) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Received KeyEvent=null", null, null, 6, null);
        } else if (event.getKeyCode() == 4 && event.getAction() == 1) {
            String customTargetName = this.interactionPredicate.getTargetName(event);
            CharSequence charSequence = customTargetName;
            boolean bl2 = false;
            boolean bl3 = false;
            String targetName = charSequence == null || charSequence.length() == 0 ? BACK_DEFAULT_TARGET_NAME : customTargetName;
            GlobalRum.get().addUserAction(RumActionType.CUSTOM, targetName, MapsKt.emptyMap());
        }
        try {
            bl = this.wrappedCallback.dispatchKeyEvent(event);
        }
        catch (Exception e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Wrapped callback failed processing KeyEvent", e, null, 4, null);
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper$Companion;", "", "()V", "BACK_DEFAULT_TARGET_NAME", "", "EVENT_CONSUMED", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

