/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation;

import android.content.Context;
import android.os.Looper;
import android.util.Printer;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.tracking.TrackingStrategy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0012\u0010\u001b\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/MainLooperLongTaskStrategy;", "Landroid/util/Printer;", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "thresholdMs", "", "(J)V", "startUptimeNs", "target", "", "getThresholdMs$dd_sdk_android_release", "()J", "thresholdNS", "detectLongTask", "", "message", "equals", "", "other", "", "hashCode", "", "println", "x", "register", "context", "Landroid/content/Context;", "toString", "unregister", "Companion", "dd-sdk-android_release"})
public final class MainLooperLongTaskStrategy
implements Printer,
TrackingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long thresholdMs;
    private final long thresholdNS;
    private long startUptimeNs;
    @NotNull
    private String target;
    @NotNull
    private static final String PREFIX_START = ">>>>> Dispatching to ";
    @NotNull
    private static final String PREFIX_END = "<<<<< Finished to ";
    private static final int PREFIX_START_LENGTH = 21;

    public MainLooperLongTaskStrategy(long thresholdMs) {
        this.thresholdMs = thresholdMs;
        this.thresholdNS = TimeUnit.MILLISECONDS.toNanos(this.thresholdMs);
        this.target = "";
    }

    public final long getThresholdMs$dd_sdk_android_release() {
        return this.thresholdMs;
    }

    @Override
    public void register(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Looper.getMainLooper().setMessageLogging((Printer)this);
    }

    @Override
    public void unregister(@Nullable Context context) {
        Looper.getMainLooper().setMessageLogging(null);
    }

    public void println(@Nullable String x) {
        if (x != null) {
            this.detectLongTask(x);
        }
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.datadog.android.rum.internal.instrumentation.MainLooperLongTaskStrategy");
        }
        MainLooperLongTaskStrategy cfr_ignored_0 = (MainLooperLongTaskStrategy)other;
        return this.thresholdMs == ((MainLooperLongTaskStrategy)other).thresholdMs;
    }

    public int hashCode() {
        return Long.hashCode(this.thresholdMs);
    }

    @NotNull
    public String toString() {
        return "MainLooperLongTaskStrategy(" + this.thresholdMs + ')';
    }

    private final void detectLongTask(String message) {
        long durationNs;
        long now = System.nanoTime();
        if (StringsKt.startsWith$default((String)message, (String)PREFIX_START, (boolean)false, (int)2, null)) {
            String string = message;
            int n = 21;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            this.target = string3;
            this.startUptimeNs = now;
        } else if (StringsKt.startsWith$default((String)message, (String)PREFIX_END, (boolean)false, (int)2, null) && (durationNs = now - this.startUptimeNs) > this.thresholdNS) {
            AdvancedRumMonitor advancedRumMonitor;
            RumMonitor rumMonitor = GlobalRum.get();
            AdvancedRumMonitor advancedRumMonitor2 = advancedRumMonitor = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
            if (advancedRumMonitor != null) {
                advancedRumMonitor.addLongTask(durationNs, this.target);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/MainLooperLongTaskStrategy$Companion;", "", "()V", "PREFIX_END", "", "PREFIX_START", "PREFIX_START_LENGTH", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

