/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.persistence.NoOpDataWriter;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.vitals.NoOpVitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 L2\u00020\u0001:\u0001LBc\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J\b\u00109\u001a\u00020:H\u0016J\u001e\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020(0?H\u0016J\u001e\u0010@\u001a\u00020A2\u0006\u0010<\u001a\u00020=2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020(0?H\u0002J+\u0010C\u001a\u00020A2\u0006\u0010<\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020(0?H\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020F2\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\bIJ\b\u0010J\u001a\u00020\u0012H\u0002J\b\u0010K\u001a\u00020AH\u0002R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010,R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010%R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "samplingRate", "", "backgroundTrackingEnabled", "", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "sessionInactivityNanos", "", "sessionMaxDurationNanos", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;FZLcom/datadog/android/core/internal/net/FirstPartyHostDetector;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/core/internal/time/TimeProvider;Lcom/datadog/android/rum/RumSessionListener;JJ)V", "activeChildrenScopes", "", "getActiveChildrenScopes$dd_sdk_android_release", "()Ljava/util/List;", "applicationDisplayed", "getBackgroundTrackingEnabled$dd_sdk_android_release", "()Z", "getFirstPartyHostDetector$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "keepSession", "getKeepSession$dd_sdk_android_release", "setKeepSession$dd_sdk_android_release", "(Z)V", "lastUserInteractionNs", "Ljava/util/concurrent/atomic/AtomicLong;", "getLastUserInteractionNs$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicLong;", "noOpWriter", "Lcom/datadog/android/core/internal/persistence/NoOpDataWriter;", "", "random", "Ljava/security/SecureRandom;", "resetSessionTime", "Ljava/lang/Long;", "getSamplingRate$dd_sdk_android_release", "()F", "sessionId", "", "getSessionId$dd_sdk_android_release", "()Ljava/lang/String;", "setSessionId$dd_sdk_android_release", "(Ljava/lang/String;)V", "getSessionListener$dd_sdk_android_release", "()Lcom/datadog/android/rum/RumSessionListener;", "sessionStartNs", "getSessionStartNs$dd_sdk_android_release", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "handleOrphanEvent", "", "actualWriter", "onApplicationDisplayed", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "viewScope", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "onApplicationDisplayed$dd_sdk_android_release", "produceRumBackgroundViewScope", "produceRumBackgroundViewScope$dd_sdk_android_release", "resolveStartupTimeNs", "updateSessionIdIfNeeded", "Companion", "dd-sdk-android_release"})
public final class RumSessionScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    private final float samplingRate;
    private final boolean backgroundTrackingEnabled;
    @NotNull
    private final FirstPartyHostDetector firstPartyHostDetector;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    @NotNull
    private final TimeProvider timeProvider;
    @Nullable
    private final RumSessionListener sessionListener;
    private final long sessionInactivityNanos;
    private final long sessionMaxDurationNanos;
    @NotNull
    private final List<RumScope> activeChildrenScopes;
    private boolean keepSession;
    @NotNull
    private String sessionId;
    @NotNull
    private final AtomicLong sessionStartNs;
    @NotNull
    private final AtomicLong lastUserInteractionNs;
    @Nullable
    private Long resetSessionTime;
    private boolean applicationDisplayed;
    @NotNull
    private final SecureRandom random;
    @NotNull
    private final NoOpDataWriter<Object> noOpWriter;
    private static final long DEFAULT_SESSION_INACTIVITY_NS = TimeUnit.MINUTES.toNanos(15L);
    private static final long DEFAULT_SESSION_MAX_DURATION_NS = TimeUnit.HOURS.toNanos(4L);
    @NotNull
    public static final String MESSAGE_MISSING_VIEW = "A RUM event was detected, but no view is active. To track views automatically, try calling the Configuration.Builder.useViewTrackingStrategy() method.\nYou can also track views manually using the RumMonitor.startView() and RumMonitor.stopView() methods.";

    public RumSessionScope(@NotNull RumScope parentScope, float samplingRate, boolean backgroundTrackingEnabled, @NotNull FirstPartyHostDetector firstPartyHostDetector, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull TimeProvider timeProvider, @Nullable RumSessionListener sessionListener, long sessionInactivityNanos, long sessionMaxDurationNanos) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.parentScope = parentScope;
        this.samplingRate = samplingRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.firstPartyHostDetector = firstPartyHostDetector;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.timeProvider = timeProvider;
        this.sessionListener = sessionListener;
        this.sessionInactivityNanos = sessionInactivityNanos;
        this.sessionMaxDurationNanos = sessionMaxDurationNanos;
        boolean bl = false;
        this.activeChildrenScopes = new ArrayList();
        this.sessionId = RumContext.Companion.getNULL_UUID();
        this.sessionStartNs = new AtomicLong(System.nanoTime());
        this.lastUserInteractionNs = new AtomicLong(0L);
        this.random = new SecureRandom();
        this.noOpWriter = new NoOpDataWriter();
        GlobalRum.INSTANCE.updateRumContext$dd_sdk_android_release(this.getRumContext());
    }

    public /* synthetic */ RumSessionScope(RumScope rumScope, float f, boolean bl, FirstPartyHostDetector firstPartyHostDetector, VitalMonitor vitalMonitor, VitalMonitor vitalMonitor2, VitalMonitor vitalMonitor3, TimeProvider timeProvider, RumSessionListener rumSessionListener, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            l = DEFAULT_SESSION_INACTIVITY_NS;
        }
        if ((n & 0x400) != 0) {
            l2 = DEFAULT_SESSION_MAX_DURATION_NS;
        }
        this(rumScope, f, bl, firstPartyHostDetector, vitalMonitor, vitalMonitor2, vitalMonitor3, timeProvider, rumSessionListener, l, l2);
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return this.samplingRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_release() {
        return this.backgroundTrackingEnabled;
    }

    @NotNull
    public final FirstPartyHostDetector getFirstPartyHostDetector$dd_sdk_android_release() {
        return this.firstPartyHostDetector;
    }

    @Nullable
    public final RumSessionListener getSessionListener$dd_sdk_android_release() {
        return this.sessionListener;
    }

    @NotNull
    public final List<RumScope> getActiveChildrenScopes$dd_sdk_android_release() {
        return this.activeChildrenScopes;
    }

    public final boolean getKeepSession$dd_sdk_android_release() {
        return this.keepSession;
    }

    public final void setKeepSession$dd_sdk_android_release(boolean bl) {
        this.keepSession = bl;
    }

    @NotNull
    public final String getSessionId$dd_sdk_android_release() {
        return this.sessionId;
    }

    public final void setSessionId$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sessionId = string;
    }

    @NotNull
    public final AtomicLong getSessionStartNs$dd_sdk_android_release() {
        return this.sessionStartNs;
    }

    @NotNull
    public final AtomicLong getLastUserInteractionNs$dd_sdk_android_release() {
        return this.lastUserInteractionNs;
    }

    @Override
    @NotNull
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (event instanceof RumRawEvent.ResetSession) {
            this.sessionId = RumContext.Companion.getNULL_UUID();
            this.resetSessionTime = System.nanoTime();
            this.applicationDisplayed = false;
        }
        this.updateSessionIdIfNeeded();
        DataWriter actualWriter = this.keepSession ? writer : (DataWriter)this.noOpWriter;
        Iterator<RumScope> iterator = this.activeChildrenScopes.iterator();
        while (iterator.hasNext()) {
            RumScope scope = iterator.next().handleEvent(event, actualWriter);
            if (scope != null) continue;
            iterator.remove();
        }
        if (event instanceof RumRawEvent.StartView) {
            RumViewScope viewScope = RumViewScope.Companion.fromEvent$dd_sdk_android_release(this, (RumRawEvent.StartView)event, this.firstPartyHostDetector, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.timeProvider);
            this.onApplicationDisplayed$dd_sdk_android_release((RumRawEvent.StartView)event, viewScope, actualWriter);
            this.activeChildrenScopes.add(viewScope);
        } else if (this.activeChildrenScopes.size() == 0) {
            this.handleOrphanEvent(event, actualWriter);
        }
        return this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        this.updateSessionIdIfNeeded();
        return this.keepSession ? RumContext.copy$default(this.parentScope.getRumContext(), null, this.sessionId, null, null, null, null, 61, null) : new RumContext(null, null, null, null, null, null, 63, null);
    }

    private final void handleOrphanEvent(RumRawEvent event, DataWriter<Object> actualWriter) {
        boolean isValidBackgroundEvent;
        boolean bl = isValidBackgroundEvent = event instanceof RumRawEvent.AddError || event instanceof RumRawEvent.AddLongTask || event instanceof RumRawEvent.StartAction || event instanceof RumRawEvent.StartResource;
        if (isValidBackgroundEvent && this.backgroundTrackingEnabled) {
            RumViewScope viewScope = this.produceRumBackgroundViewScope$dd_sdk_android_release(event);
            viewScope.handleEvent(event, actualWriter);
            this.activeChildrenScopes.add(viewScope);
        } else {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), MESSAGE_MISSING_VIEW, null, null, 6, null);
        }
    }

    @NotNull
    public final RumViewScope produceRumBackgroundViewScope$dd_sdk_android_release(@NotNull RumRawEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return new RumViewScope(this, "com/datadog/background/view", "Background", event.getEventTime(), MapsKt.emptyMap(), this.firstPartyHostDetector, new NoOpVitalMonitor(), new NoOpVitalMonitor(), new NoOpVitalMonitor(), this.timeProvider);
    }

    public final void onApplicationDisplayed$dd_sdk_android_release(@NotNull RumRawEvent.StartView event, @NotNull RumViewScope viewScope, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)viewScope, (String)"viewScope");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (!this.applicationDisplayed) {
            this.applicationDisplayed = true;
            long applicationStartTime = this.resolveStartupTimeNs();
            viewScope.handleEvent(new RumRawEvent.ApplicationStarted(event.getEventTime(), applicationStartTime), writer);
        }
    }

    private final long resolveStartupTimeNs() {
        long l;
        Long resetTimeNs = this.resetSessionTime;
        if (resetTimeNs != null) {
            l = resetTimeNs;
        } else if (Build.VERSION.SDK_INT >= 24) {
            long diffMs = SystemClock.elapsedRealtime() - Process.getStartElapsedRealtime();
            l = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(diffMs);
        } else {
            l = Datadog.INSTANCE.getStartupTimeNs$dd_sdk_android_release();
        }
        return l;
    }

    private final synchronized void updateSessionIdIfNeeded() {
        boolean isLongSession;
        long nanoTime = System.nanoTime();
        boolean isNewSession = Intrinsics.areEqual((Object)this.sessionId, (Object)RumContext.Companion.getNULL_UUID());
        long sessionLength = nanoTime - this.sessionStartNs.get();
        long duration = nanoTime - this.lastUserInteractionNs.get();
        boolean isInactiveSession = duration >= this.sessionInactivityNanos;
        boolean bl = isLongSession = sessionLength >= this.sessionMaxDurationNanos;
        if (isNewSession || isInactiveSession || isLongSession) {
            this.keepSession = this.random.nextFloat() * 100.0f < this.samplingRate;
            this.sessionStartNs.set(nanoTime);
            Object object = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
            this.sessionId = object;
            object = this.sessionListener;
            if (object != null) {
                object.onSessionStarted(this.sessionId, !this.keepSession);
            }
        }
        this.lastUserInteractionNs.set(nanoTime);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$Companion;", "", "()V", "DEFAULT_SESSION_INACTIVITY_NS", "", "getDEFAULT_SESSION_INACTIVITY_NS$dd_sdk_android_release", "()J", "DEFAULT_SESSION_MAX_DURATION_NS", "getDEFAULT_SESSION_MAX_DURATION_NS$dd_sdk_android_release", "MESSAGE_MISSING_VIEW", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_SESSION_INACTIVITY_NS$dd_sdk_android_release() {
            return DEFAULT_SESSION_INACTIVITY_NS;
        }

        public final long getDEFAULT_SESSION_MAX_DURATION_NS$dd_sdk_android_release() {
            return DEFAULT_SESSION_MAX_DURATION_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

