/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.ExternalResourceTimingsKt;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.ResourceEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OBS\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u00102\u001a\u00020\u001bH\u0016J \u00103\u001a\u0004\u0018\u00010\u00012\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0016J\u001e\u00108\u001a\u0002092\u0006\u00104\u001a\u00020:2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002J\u001e\u0010;\u001a\u0002092\u0006\u00104\u001a\u00020<2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002J\u001e\u0010=\u001a\u0002092\u0006\u00104\u001a\u00020>2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\n\u0010@\u001a\u0004\u0018\u00010AH\u0002J#\u0010B\u001a\u0004\u0018\u00010\u00042\b\u0010,\u001a\u0004\u0018\u00010\r2\b\u0010C\u001a\u0004\u0018\u00010DH\u0002\u00a2\u0006\u0002\u0010EJ\n\u0010F\u001a\u0004\u0018\u00010GH\u0002J?\u0010H\u001a\u0002092\u0006\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020K2\b\u0010,\u001a\u0004\u0018\u00010\r2\b\u0010C\u001a\u0004\u0018\u00010D2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u0010LJ?\u0010M\u001a\u0002092\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b07H\u0002\u00a2\u0006\u0002\u0010NR\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001dR\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010+\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010-\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001dR\u000e\u00101\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumResourceScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "url", "", "method", "key", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialAttributes", "", "", "serverTimeOffsetInMs", "", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/Time;Ljava/util/Map;JLcom/datadog/android/core/internal/net/FirstPartyHostDetector;)V", "attributes", "", "getAttributes$dd_sdk_android_release", "()Ljava/util/Map;", "eventTimestamp", "getEventTimestamp$dd_sdk_android_release", "()J", "getFirstPartyHostDetector$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "initialContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "getKey$dd_sdk_android_release", "()Ljava/lang/String;", "kind", "Lcom/datadog/android/rum/RumResourceKind;", "getMethod$dd_sdk_android_release", "networkInfo", "Lcom/datadog/android/core/model/NetworkInfo;", "getParentScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "resourceId", "getResourceId$dd_sdk_android_release", "sent", "", "size", "Ljava/lang/Long;", "startedNanos", "statusCode", "stopped", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "getUrl$dd_sdk_android_release", "waitForTiming", "getRumContext", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "onAddResourceTiming", "", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddResourceTiming;", "onStopResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResource;", "onStopResourceWithError", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResourceWithError;", "resolveDomain", "resolveErrorProvider", "Lcom/datadog/android/rum/model/ErrorEvent$Provider;", "resolveErrorType", "throwable", "", "(Ljava/lang/Long;Ljava/lang/Throwable;)Ljava/lang/String;", "resolveResourceProvider", "Lcom/datadog/android/rum/model/ResourceEvent$Provider;", "sendError", "message", "source", "Lcom/datadog/android/rum/RumErrorSource;", "(Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Long;Ljava/lang/Throwable;Lcom/datadog/android/core/internal/persistence/DataWriter;)V", "sendResource", "(Lcom/datadog/android/rum/RumResourceKind;Ljava/lang/Long;Ljava/lang/Long;Lcom/datadog/android/rum/internal/domain/Time;Lcom/datadog/android/core/internal/persistence/DataWriter;)V", "Companion", "dd-sdk-android_release"})
public final class RumResourceScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final String url;
    @NotNull
    private final String method;
    @NotNull
    private final String key;
    @NotNull
    private final FirstPartyHostDetector firstPartyHostDetector;
    @NotNull
    private final String resourceId;
    @NotNull
    private final Map<String, Object> attributes;
    @Nullable
    private ResourceTiming timing;
    @NotNull
    private final RumContext initialContext;
    private final long eventTimestamp;
    private final long startedNanos;
    @NotNull
    private final NetworkInfo networkInfo;
    private boolean sent;
    private boolean waitForTiming;
    private boolean stopped;
    @NotNull
    private RumResourceKind kind;
    @Nullable
    private Long statusCode;
    @Nullable
    private Long size;
    @NotNull
    public static final String ERROR_TYPE_BASED_ON_STATUS_CODE_FORMAT = "HTTP %d";

    /*
     * WARNING - void declaration
     */
    public RumResourceScope(@NotNull RumScope parentScope, @NotNull String url, @NotNull String method, @NotNull String key, @NotNull Time eventTime, @NotNull Map<String, ? extends Object> initialAttributes, long serverTimeOffsetInMs, @NotNull FirstPartyHostDetector firstPartyHostDetector) {
        void $this$attributes_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
        this.parentScope = parentScope;
        this.url = url;
        this.method = method;
        this.key = key;
        this.firstPartyHostDetector = firstPartyHostDetector;
        Object object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        this.resourceId = object;
        object = MapsKt.toMutableMap(initialAttributes);
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        RumResourceScope rumResourceScope = this;
        boolean bl3 = false;
        $this$attributes_u24lambda_u2d0.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        Unit unit = Unit.INSTANCE;
        rumResourceScope.attributes = object;
        this.initialContext = this.parentScope.getRumContext();
        this.eventTimestamp = eventTime.getTimestamp() + serverTimeOffsetInMs;
        this.startedNanos = eventTime.getNanoTime();
        this.networkInfo = CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release().getLatestNetworkInfo();
        this.kind = RumResourceKind.UNKNOWN;
    }

    @NotNull
    public final RumScope getParentScope$dd_sdk_android_release() {
        return this.parentScope;
    }

    @NotNull
    public final String getUrl$dd_sdk_android_release() {
        return this.url;
    }

    @NotNull
    public final String getMethod$dd_sdk_android_release() {
        return this.method;
    }

    @NotNull
    public final String getKey$dd_sdk_android_release() {
        return this.key;
    }

    @NotNull
    public final FirstPartyHostDetector getFirstPartyHostDetector$dd_sdk_android_release() {
        return this.firstPartyHostDetector;
    }

    @NotNull
    public final String getResourceId$dd_sdk_android_release() {
        return this.resourceId;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_release() {
        return this.attributes;
    }

    public final long getEventTimestamp$dd_sdk_android_release() {
        return this.eventTimestamp;
    }

    @Override
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        RumRawEvent rumRawEvent = event;
        if (rumRawEvent instanceof RumRawEvent.WaitForResourceTiming) {
            if (Intrinsics.areEqual((Object)this.key, (Object)((RumRawEvent.WaitForResourceTiming)event).getKey())) {
                this.waitForTiming = true;
            }
        } else if (rumRawEvent instanceof RumRawEvent.AddResourceTiming) {
            this.onAddResourceTiming((RumRawEvent.AddResourceTiming)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResource) {
            this.onStopResource((RumRawEvent.StopResource)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResourceWithError) {
            this.onStopResourceWithError((RumRawEvent.StopResourceWithError)event, writer);
        }
        return this.sent ? null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.initialContext;
    }

    private final void onStopResource(RumRawEvent.StopResource event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.stopped = true;
        this.attributes.putAll(event.getAttributes());
        this.kind = event.getKind();
        this.statusCode = event.getStatusCode();
        this.size = event.getSize();
        if (!this.waitForTiming || this.timing != null) {
            this.sendResource(this.kind, event.getStatusCode(), event.getSize(), event.getEventTime(), writer);
        }
    }

    private final void onAddResourceTiming(RumRawEvent.AddResourceTiming event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.timing = event.getTiming();
        if (this.stopped && !this.sent) {
            this.sendResource(this.kind, this.statusCode, this.size, event.getEventTime(), writer);
        }
    }

    private final void onStopResourceWithError(RumRawEvent.StopResourceWithError event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.attributes.putAll(event.getAttributes());
        this.sendError(event.getMessage(), event.getSource(), event.getStatusCode(), event.getThrowable(), writer);
    }

    private final void sendResource(RumResourceKind kind, Long statusCode, Long size, Time eventTime, DataWriter<Object> writer) {
        ResourceEvent.Action action;
        Object object;
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        Object object2 = this.attributes.remove("_dd.trace_id");
        String traceId = object2 == null ? null : object2.toString();
        Object object3 = this.attributes.remove("_dd.span_id");
        String spanId = object3 == null ? null : object3.toString();
        RumContext context = this.getRumContext();
        UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        ResourceTiming resourceTiming = this.timing;
        ResourceTiming finalTiming = resourceTiming == null ? ExternalResourceTimingsKt.extractResourceTiming((object = this.attributes.remove("_dd.resource_timings")) instanceof Map ? (Map)object : null) : resourceTiming;
        long duration = eventTime.getNanoTime() - this.startedNanos;
        long l = this.eventTimestamp;
        String string = this.resourceId;
        Object object4 = RumEventExtKt.toSchemaType(kind);
        Object object5 = this.url;
        Object object6 = RumEventExtKt.toMethod(this.method);
        Object object7 = finalTiming;
        ResourceEvent.Dns dns = object7 == null ? null : RumEventExtKt.dns((ResourceTiming)object7);
        Object object8 = finalTiming;
        object7 = object8 == null ? null : RumEventExtKt.connect((ResourceTiming)object8);
        Object object9 = finalTiming;
        object8 = object9 == null ? null : RumEventExtKt.ssl((ResourceTiming)object9);
        Object object10 = finalTiming;
        object9 = object10 == null ? null : RumEventExtKt.firstByte((ResourceTiming)object10);
        Object object11 = finalTiming;
        object10 = object11 == null ? null : RumEventExtKt.download((ResourceTiming)object11);
        object11 = this.resolveResourceProvider();
        ResourceEvent.Resource resource = new ResourceEvent.Resource(string, (ResourceEvent.ResourceType)((Object)object4), (ResourceEvent.Method)((Object)object6), (String)object5, statusCode, duration, size, null, dns, (ResourceEvent.Connect)object7, (ResourceEvent.Ssl)object8, (ResourceEvent.FirstByte)object9, (ResourceEvent.Download)object10, (ResourceEvent.Provider)object11, 128, null);
        object4 = context.getActionId();
        if (object4 == null) {
            action = null;
        } else {
            object5 = object4;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object5;
            boolean bl3 = false;
            action = new ResourceEvent.Action((String)it);
        }
        string = action;
        object6 = context.getViewId();
        boolean bl = false;
        Object object12 = object6;
        if (object12 == null) {
            object12 = "";
        }
        object5 = object12;
        object6 = context.getViewName();
        object7 = context.getViewUrl();
        boolean bl4 = false;
        Object object13 = object7;
        if (object13 == null) {
            object13 = "";
        }
        Object object14 = object13;
        object4 = new ResourceEvent.View((String)object5, null, (String)object14, (String)object6, 2, null);
        object5 = new ResourceEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
        object6 = RumEventExtKt.toResourceConnectivity(this.networkInfo);
        object14 = new ResourceEvent.Application(context.getApplicationId());
        object7 = new ResourceEvent.ResourceEventSession(context.getSessionId(), ResourceEvent.ResourceEventSessionType.USER, null, 4, null);
        ResourceEvent.Context context2 = new ResourceEvent.Context(this.attributes);
        object10 = new ResourceEvent.DdSession(ResourceEvent.Plan.PLAN_1);
        object9 = new ResourceEvent.Dd((ResourceEvent.DdSession)object10, spanId, traceId);
        ResourceEvent resourceEvent = new ResourceEvent(l, (ResourceEvent.Application)object14, null, (ResourceEvent.ResourceEventSession)object7, (ResourceEvent.View)object4, (ResourceEvent.Usr)object5, (ResourceEvent.Connectivity)object6, null, (ResourceEvent.Dd)object9, context2, resource, (ResourceEvent.Action)((Object)string), 132, null);
        writer.write(resourceEvent);
        this.sent = true;
    }

    private final ResourceEvent.Provider resolveResourceProvider() {
        return this.firstPartyHostDetector.isFirstPartyUrl(this.url) ? new ResourceEvent.Provider(this.resolveDomain(this.url), null, ResourceEvent.ProviderType.FIRST_PARTY, 2, null) : (ResourceEvent.Provider)null;
    }

    private final void sendError(String message, RumErrorSource source, Long statusCode, Throwable throwable, DataWriter<Object> writer) {
        ErrorEvent.Action action;
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        RumContext context = this.getRumContext();
        UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        long l = this.eventTimestamp;
        ErrorEvent.Source source2 = RumEventExtKt.toSchemaSource(source);
        Object object = throwable;
        Object object2 = object == null ? null : ThrowableExtKt.loggableStackTrace((Throwable)object);
        String string = this.url;
        Enum enum_ = RumEventExtKt.toErrorMethod(this.method);
        Object object3 = statusCode;
        long l2 = object3 == null ? 0L : (Long)object3;
        object3 = this.resolveErrorProvider();
        object = new ErrorEvent.Resource((ErrorEvent.Method)enum_, l2, string, (ErrorEvent.Provider)object3);
        string = this.resolveErrorType(statusCode, throwable);
        enum_ = ErrorEvent.SourceType.ANDROID;
        ErrorEvent.Error error = new ErrorEvent.Error(null, message, source2, (String)object2, false, string, null, null, (ErrorEvent.SourceType)enum_, (ErrorEvent.Resource)object, 193, null);
        object2 = context.getActionId();
        if (object2 == null) {
            action = null;
        } else {
            object = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            action = new ErrorEvent.Action((String)it);
        }
        source2 = action;
        Object object4 = context.getViewId();
        boolean bl = false;
        Object object5 = object4;
        if (object5 == null) {
            object5 = "";
        }
        object = object5;
        object4 = context.getViewName();
        Object object6 = context.getViewUrl();
        boolean bl4 = false;
        Object object7 = object6;
        if (object7 == null) {
            object7 = "";
        }
        Object object8 = object7;
        object2 = new ErrorEvent.View((String)object, null, (String)object8, (String)object4, null, 18, null);
        object = new ErrorEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
        object4 = RumEventExtKt.toErrorConnectivity(this.networkInfo);
        object8 = new ErrorEvent.Application(context.getApplicationId());
        object6 = new ErrorEvent.ErrorEventSession(context.getSessionId(), ErrorEvent.ErrorEventSessionType.USER, null, 4, null);
        ErrorEvent.Context context2 = new ErrorEvent.Context(this.attributes);
        object3 = new ErrorEvent.Dd(new ErrorEvent.DdSession(ErrorEvent.Plan.PLAN_1));
        ErrorEvent errorEvent = new ErrorEvent(l, (ErrorEvent.Application)object8, null, (ErrorEvent.ErrorEventSession)object6, (ErrorEvent.View)object2, (ErrorEvent.Usr)object, (ErrorEvent.Connectivity)object4, null, (ErrorEvent.Dd)object3, context2, error, (ErrorEvent.Action)((Object)source2), 132, null);
        writer.write(errorEvent);
        this.sent = true;
    }

    private final ErrorEvent.Provider resolveErrorProvider() {
        return this.firstPartyHostDetector.isFirstPartyUrl(this.url) ? new ErrorEvent.Provider(this.resolveDomain(this.url), null, ErrorEvent.ProviderType.FIRST_PARTY, 2, null) : (ErrorEvent.Provider)null;
    }

    private final String resolveDomain(String url) {
        String string;
        try {
            string = new URL(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            URL(url).host\n        }");
        }
        catch (MalformedURLException e) {
            string = url;
        }
        return string;
    }

    private final String resolveErrorType(Long statusCode, Throwable throwable) {
        String string;
        if (throwable != null) {
            string = throwable.getClass().getCanonicalName();
        } else if (statusCode != null) {
            String string2 = ERROR_TYPE_BASED_ON_STATUS_CODE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{statusCode};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumResourceScope$Companion;", "", "()V", "ERROR_TYPE_BASED_ON_STATUS_CODE_FORMAT", "", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "timestampOffset", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumScope fromEvent(@NotNull RumScope parentScope, @NotNull RumRawEvent.StartResource event, @NotNull FirstPartyHostDetector firstPartyHostDetector, long timestampOffset) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
            return new RumResourceScope(parentScope, event.getUrl(), event.getMethod(), event.getKey(), event.getEventTime(), event.getAttributes(), timestampOffset, firstPartyHostDetector);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

