/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.RumErrorSourceType;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0000\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0000\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0002H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000bH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000bH\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0012H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000bH\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0000\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0000\u001a\f\u0010\u001f\u001a\u00020 *\u00020!H\u0000\u001a\f\u0010\u001f\u001a\u00020\"*\u00020#H\u0000\u00a8\u0006$"}, d2={"connect", "Lcom/datadog/android/rum/model/ResourceEvent$Connect;", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "dns", "Lcom/datadog/android/rum/model/ResourceEvent$Dns;", "download", "Lcom/datadog/android/rum/model/ResourceEvent$Download;", "firstByte", "Lcom/datadog/android/rum/model/ResourceEvent$FirstByte;", "isConnected", "", "Lcom/datadog/android/core/model/NetworkInfo;", "ssl", "Lcom/datadog/android/rum/model/ResourceEvent$Ssl;", "toErrorConnectivity", "Lcom/datadog/android/rum/model/ErrorEvent$Connectivity;", "toErrorMethod", "Lcom/datadog/android/rum/model/ErrorEvent$Method;", "", "toLongTaskConnectivity", "Lcom/datadog/android/rum/model/LongTaskEvent$Connectivity;", "toMethod", "Lcom/datadog/android/rum/model/ResourceEvent$Method;", "toResourceConnectivity", "Lcom/datadog/android/rum/model/ResourceEvent$Connectivity;", "toSchemaSource", "Lcom/datadog/android/rum/model/ErrorEvent$Source;", "Lcom/datadog/android/rum/RumErrorSource;", "toSchemaSourceType", "Lcom/datadog/android/rum/model/ErrorEvent$SourceType;", "Lcom/datadog/android/rum/internal/RumErrorSourceType;", "toSchemaType", "Lcom/datadog/android/rum/model/ActionEvent$ActionType;", "Lcom/datadog/android/rum/RumActionType;", "Lcom/datadog/android/rum/model/ResourceEvent$ResourceType;", "Lcom/datadog/android/rum/RumResourceKind;", "dd-sdk-android_release"})
public final class RumEventExtKt {
    @NotNull
    public static final ResourceEvent.Method toMethod(@NotNull String $this$toMethod) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toMethod, (String)"<this>");
        try {
            object = $this$toMethod;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl = false;
            String string = object.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
            object = ResourceEvent.Method.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            Logger.i$default(RuntimeUtilsKt.getSdkLogger(), "Unable to convert [" + $this$toMethod + "] to a valid http method", e, null, 4, null);
            object = ResourceEvent.Method.GET;
        }
        return object;
    }

    @NotNull
    public static final ErrorEvent.Method toErrorMethod(@NotNull String $this$toErrorMethod) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toErrorMethod, (String)"<this>");
        try {
            object = $this$toErrorMethod;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl = false;
            String string = object.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
            object = ErrorEvent.Method.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            Logger.i$default(RuntimeUtilsKt.getSdkLogger(), "Unable to convert [" + $this$toErrorMethod + "] to a valid http method", e, null, 4, null);
            object = ErrorEvent.Method.GET;
        }
        return object;
    }

    @NotNull
    public static final ResourceEvent.ResourceType toSchemaType(@NotNull RumResourceKind $this$toSchemaType) {
        ResourceEvent.ResourceType resourceType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaType), (String)"<this>");
        RumResourceKind rumResourceKind = $this$toSchemaType;
        int n = WhenMappings.$EnumSwitchMapping$0[rumResourceKind.ordinal()];
        switch (n) {
            case 1: {
                resourceType = ResourceEvent.ResourceType.BEACON;
                break;
            }
            case 2: {
                resourceType = ResourceEvent.ResourceType.FETCH;
                break;
            }
            case 3: {
                resourceType = ResourceEvent.ResourceType.XHR;
                break;
            }
            case 4: {
                resourceType = ResourceEvent.ResourceType.DOCUMENT;
                break;
            }
            case 5: {
                resourceType = ResourceEvent.ResourceType.IMAGE;
                break;
            }
            case 6: {
                resourceType = ResourceEvent.ResourceType.JS;
                break;
            }
            case 7: {
                resourceType = ResourceEvent.ResourceType.FONT;
                break;
            }
            case 8: {
                resourceType = ResourceEvent.ResourceType.CSS;
                break;
            }
            case 9: {
                resourceType = ResourceEvent.ResourceType.MEDIA;
                break;
            }
            case 10: {
                resourceType = ResourceEvent.ResourceType.NATIVE;
                break;
            }
            case 11: 
            case 12: {
                resourceType = ResourceEvent.ResourceType.OTHER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resourceType;
    }

    @NotNull
    public static final ErrorEvent.Source toSchemaSource(@NotNull RumErrorSource $this$toSchemaSource) {
        ErrorEvent.Source source;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaSource), (String)"<this>");
        RumErrorSource rumErrorSource = $this$toSchemaSource;
        int n = WhenMappings.$EnumSwitchMapping$1[rumErrorSource.ordinal()];
        switch (n) {
            case 1: {
                source = ErrorEvent.Source.NETWORK;
                break;
            }
            case 2: {
                source = ErrorEvent.Source.SOURCE;
                break;
            }
            case 3: {
                source = ErrorEvent.Source.CONSOLE;
                break;
            }
            case 4: {
                source = ErrorEvent.Source.LOGGER;
                break;
            }
            case 5: {
                source = ErrorEvent.Source.AGENT;
                break;
            }
            case 6: {
                source = ErrorEvent.Source.WEBVIEW;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return source;
    }

    @NotNull
    public static final ErrorEvent.SourceType toSchemaSourceType(@NotNull RumErrorSourceType $this$toSchemaSourceType) {
        ErrorEvent.SourceType sourceType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaSourceType), (String)"<this>");
        RumErrorSourceType rumErrorSourceType = $this$toSchemaSourceType;
        int n = WhenMappings.$EnumSwitchMapping$2[rumErrorSourceType.ordinal()];
        switch (n) {
            case 1: {
                sourceType = ErrorEvent.SourceType.ANDROID;
                break;
            }
            case 2: {
                sourceType = ErrorEvent.SourceType.BROWSER;
                break;
            }
            case 3: {
                sourceType = ErrorEvent.SourceType.REACT_NATIVE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sourceType;
    }

    @Nullable
    public static final ResourceEvent.Dns dns(@NotNull ResourceTiming $this$dns) {
        Intrinsics.checkNotNullParameter((Object)$this$dns, (String)"<this>");
        return $this$dns.getDnsStart() > 0L ? new ResourceEvent.Dns($this$dns.getDnsDuration(), $this$dns.getDnsStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.Connect connect(@NotNull ResourceTiming $this$connect) {
        Intrinsics.checkNotNullParameter((Object)$this$connect, (String)"<this>");
        return $this$connect.getConnectStart() > 0L ? new ResourceEvent.Connect($this$connect.getConnectDuration(), $this$connect.getConnectStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.Ssl ssl(@NotNull ResourceTiming $this$ssl) {
        Intrinsics.checkNotNullParameter((Object)$this$ssl, (String)"<this>");
        return $this$ssl.getSslStart() > 0L ? new ResourceEvent.Ssl($this$ssl.getSslDuration(), $this$ssl.getSslStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.FirstByte firstByte(@NotNull ResourceTiming $this$firstByte) {
        Intrinsics.checkNotNullParameter((Object)$this$firstByte, (String)"<this>");
        return $this$firstByte.getFirstByteStart() >= 0L && $this$firstByte.getFirstByteDuration() > 0L ? new ResourceEvent.FirstByte($this$firstByte.getFirstByteDuration(), $this$firstByte.getFirstByteStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.Download download(@NotNull ResourceTiming $this$download) {
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"<this>");
        return $this$download.getDownloadStart() > 0L ? new ResourceEvent.Download($this$download.getDownloadDuration(), $this$download.getDownloadStart()) : null;
    }

    @NotNull
    public static final ActionEvent.ActionType toSchemaType(@NotNull RumActionType $this$toSchemaType) {
        ActionEvent.ActionType actionType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaType), (String)"<this>");
        RumActionType rumActionType = $this$toSchemaType;
        int n = WhenMappings.$EnumSwitchMapping$3[rumActionType.ordinal()];
        switch (n) {
            case 1: {
                actionType = ActionEvent.ActionType.TAP;
                break;
            }
            case 2: {
                actionType = ActionEvent.ActionType.SCROLL;
                break;
            }
            case 3: {
                actionType = ActionEvent.ActionType.SWIPE;
                break;
            }
            case 4: {
                actionType = ActionEvent.ActionType.CLICK;
                break;
            }
            case 5: {
                actionType = ActionEvent.ActionType.CUSTOM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return actionType;
    }

    @NotNull
    public static final ResourceEvent.Connectivity toResourceConnectivity(@NotNull NetworkInfo $this$toResourceConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toResourceConnectivity, (String)"<this>");
        ResourceEvent.Status status = RumEventExtKt.isConnected($this$toResourceConnectivity) ? ResourceEvent.Status.CONNECTED : ResourceEvent.Status.NOT_CONNECTED;
        NetworkInfo.Connectivity connectivity = $this$toResourceConnectivity.getConnectivity();
        int n = WhenMappings.$EnumSwitchMapping$4[connectivity.ordinal()];
        switch (n) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ResourceEvent.Cellular cellular = $this$toResourceConnectivity.getCellularTechnology() != null || $this$toResourceConnectivity.getCarrierName() != null ? new ResourceEvent.Cellular($this$toResourceConnectivity.getCellularTechnology(), $this$toResourceConnectivity.getCarrierName()) : (ResourceEvent.Cellular)null;
        return new ResourceEvent.Connectivity(status, interfaces, cellular);
    }

    @NotNull
    public static final ErrorEvent.Connectivity toErrorConnectivity(@NotNull NetworkInfo $this$toErrorConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toErrorConnectivity, (String)"<this>");
        ErrorEvent.Status status = RumEventExtKt.isConnected($this$toErrorConnectivity) ? ErrorEvent.Status.CONNECTED : ErrorEvent.Status.NOT_CONNECTED;
        NetworkInfo.Connectivity connectivity = $this$toErrorConnectivity.getConnectivity();
        int n = WhenMappings.$EnumSwitchMapping$4[connectivity.ordinal()];
        switch (n) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ErrorEvent.Cellular cellular = $this$toErrorConnectivity.getCellularTechnology() != null || $this$toErrorConnectivity.getCarrierName() != null ? new ErrorEvent.Cellular($this$toErrorConnectivity.getCellularTechnology(), $this$toErrorConnectivity.getCarrierName()) : (ErrorEvent.Cellular)null;
        return new ErrorEvent.Connectivity(status, interfaces, cellular);
    }

    @NotNull
    public static final LongTaskEvent.Connectivity toLongTaskConnectivity(@NotNull NetworkInfo $this$toLongTaskConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toLongTaskConnectivity, (String)"<this>");
        LongTaskEvent.Status status = RumEventExtKt.isConnected($this$toLongTaskConnectivity) ? LongTaskEvent.Status.CONNECTED : LongTaskEvent.Status.NOT_CONNECTED;
        NetworkInfo.Connectivity connectivity = $this$toLongTaskConnectivity.getConnectivity();
        int n = WhenMappings.$EnumSwitchMapping$4[connectivity.ordinal()];
        switch (n) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        LongTaskEvent.Cellular cellular = $this$toLongTaskConnectivity.getCellularTechnology() != null || $this$toLongTaskConnectivity.getCarrierName() != null ? new LongTaskEvent.Cellular($this$toLongTaskConnectivity.getCellularTechnology(), $this$toLongTaskConnectivity.getCarrierName()) : (LongTaskEvent.Cellular)null;
        return new LongTaskEvent.Connectivity(status, interfaces, cellular);
    }

    public static final boolean isConnected(@NotNull NetworkInfo $this$isConnected) {
        Intrinsics.checkNotNullParameter((Object)$this$isConnected, (String)"<this>");
        return $this$isConnected.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[RumResourceKind.values().length];
            nArray[RumResourceKind.BEACON.ordinal()] = 1;
            nArray[RumResourceKind.FETCH.ordinal()] = 2;
            nArray[RumResourceKind.XHR.ordinal()] = 3;
            nArray[RumResourceKind.DOCUMENT.ordinal()] = 4;
            nArray[RumResourceKind.IMAGE.ordinal()] = 5;
            nArray[RumResourceKind.JS.ordinal()] = 6;
            nArray[RumResourceKind.FONT.ordinal()] = 7;
            nArray[RumResourceKind.CSS.ordinal()] = 8;
            nArray[RumResourceKind.MEDIA.ordinal()] = 9;
            nArray[RumResourceKind.NATIVE.ordinal()] = 10;
            nArray[RumResourceKind.UNKNOWN.ordinal()] = 11;
            nArray[RumResourceKind.OTHER.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RumErrorSource.values().length];
            nArray[RumErrorSource.NETWORK.ordinal()] = 1;
            nArray[RumErrorSource.SOURCE.ordinal()] = 2;
            nArray[RumErrorSource.CONSOLE.ordinal()] = 3;
            nArray[RumErrorSource.LOGGER.ordinal()] = 4;
            nArray[RumErrorSource.AGENT.ordinal()] = 5;
            nArray[RumErrorSource.WEBVIEW.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RumErrorSourceType.values().length];
            nArray[RumErrorSourceType.ANDROID.ordinal()] = 1;
            nArray[RumErrorSourceType.BROWSER.ordinal()] = 2;
            nArray[RumErrorSourceType.REACT_NATIVE.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RumActionType.values().length];
            nArray[RumActionType.TAP.ordinal()] = 1;
            nArray[RumActionType.SCROLL.ordinal()] = 2;
            nArray[RumActionType.SWIPE.ordinal()] = 3;
            nArray[RumActionType.CLICK.ordinal()] = 4;
            nArray[RumActionType.CUSTOM.ordinal()] = 5;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[NetworkInfo.Connectivity.values().length];
            nArray[NetworkInfo.Connectivity.NETWORK_ETHERNET.ordinal()] = 1;
            nArray[NetworkInfo.Connectivity.NETWORK_WIFI.ordinal()] = 2;
            nArray[NetworkInfo.Connectivity.NETWORK_WIMAX.ordinal()] = 3;
            nArray[NetworkInfo.Connectivity.NETWORK_BLUETOOTH.ordinal()] = 4;
            nArray[NetworkInfo.Connectivity.NETWORK_2G.ordinal()] = 5;
            nArray[NetworkInfo.Connectivity.NETWORK_3G.ordinal()] = 6;
            nArray[NetworkInfo.Connectivity.NETWORK_4G.ordinal()] = 7;
            nArray[NetworkInfo.Connectivity.NETWORK_5G.ordinal()] = 8;
            nArray[NetworkInfo.Connectivity.NETWORK_MOBILE_OTHER.ordinal()] = 9;
            nArray[NetworkInfo.Connectivity.NETWORK_CELLULAR.ordinal()] = 10;
            nArray[NetworkInfo.Connectivity.NETWORK_OTHER.ordinal()] = 11;
            nArray[NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED.ordinal()] = 12;
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

