/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.RumActionScope;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.model.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0017\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 `2\u00020\u0001:\u0001`B_\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\bH\u0002J\b\u0010H\u001a\u00020IH\u0016J \u0010J\u001a\u0004\u0018\u00010\u00012\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\r0NH\u0016J&\u0010O\u001a\u00020P2\u0006\u0010K\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u000f2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\r0NH\u0002J\u0010\u0010S\u001a\u00020P2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u0018\u0010T\u001a\u00020P2\u0006\u0010K\u001a\u00020U2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u0018\u0010V\u001a\u00020P2\u0006\u0010K\u001a\u00020W2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u0018\u0010X\u001a\u00020P2\u0006\u0010K\u001a\u00020Y2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u0018\u0010Z\u001a\u00020P2\u0006\u0010K\u001a\u00020[2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u001e\u0010\\\u001a\u00020P2\u0006\u0010R\u001a\u00020\u000f2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\r0NH\u0002J\u0010\u0010]\u001a\u00020P2\u0006\u0010R\u001a\u00020\u000fH\u0002J\u001e\u0010^\u001a\u00020P2\u0006\u0010_\u001a\u00020\u000f2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\r0NH\u0002R\u0014\u0010\u0013\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0014\u0010\"\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR\u000e\u0010$\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001c\"\u0004\b(\u0010\u001eR\u000e\u0010)\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r000/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001c\"\u0004\b5\u0010\u001eR\u000e\u00106\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006a"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumActionScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "waitForStop", "", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialType", "Lcom/datadog/android/rum/RumActionType;", "initialName", "", "initialAttributes", "", "", "serverTimeOffsetInMs", "", "inactivityThresholdMs", "maxDurationMs", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;ZLcom/datadog/android/rum/internal/domain/Time;Lcom/datadog/android/rum/RumActionType;Ljava/lang/String;Ljava/util/Map;JJJ)V", "actionId", "getActionId$dd_sdk_android_release", "()Ljava/lang/String;", "attributes", "", "getAttributes$dd_sdk_android_release", "()Ljava/util/Map;", "crashCount", "getCrashCount$dd_sdk_android_release", "()J", "setCrashCount$dd_sdk_android_release", "(J)V", "errorCount", "getErrorCount$dd_sdk_android_release", "setErrorCount$dd_sdk_android_release", "eventTimestamp", "getEventTimestamp$dd_sdk_android_release", "inactivityThresholdNs", "lastInteractionNanos", "longTaskCount", "getLongTaskCount$dd_sdk_android_release", "setLongTaskCount$dd_sdk_android_release", "maxDurationNs", "name", "getName$dd_sdk_android_release", "setName$dd_sdk_android_release", "(Ljava/lang/String;)V", "ongoingResourceKeys", "", "Ljava/lang/ref/WeakReference;", "getParentScope", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "resourceCount", "getResourceCount$dd_sdk_android_release", "setResourceCount$dd_sdk_android_release", "sent", "startedNanos", "stopped", "type", "getType$dd_sdk_android_release", "()Lcom/datadog/android/rum/RumActionType;", "setType$dd_sdk_android_release", "(Lcom/datadog/android/rum/RumActionType;)V", "viewTreeChangeCount", "", "getViewTreeChangeCount$dd_sdk_android_release", "()I", "setViewTreeChangeCount$dd_sdk_android_release", "(I)V", "getWaitForStop", "()Z", "actionCanBeSent", "actualType", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "onError", "", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddError;", "now", "onLongTask", "onResourceError", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResourceWithError;", "onStartResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "onStopAction", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopAction;", "onStopResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResource;", "onStopView", "onViewTreeChanged", "sendAction", "endNanos", "Companion", "dd-sdk-android_release"})
public final class RumActionScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    private final boolean waitForStop;
    private final long inactivityThresholdNs;
    private final long maxDurationNs;
    private final long eventTimestamp;
    @NotNull
    private final String actionId;
    @NotNull
    private RumActionType type;
    @NotNull
    private String name;
    private final long startedNanos;
    private long lastInteractionNanos;
    @NotNull
    private final Map<String, Object> attributes;
    @NotNull
    private final List<WeakReference<Object>> ongoingResourceKeys;
    private long resourceCount;
    private long errorCount;
    private long crashCount;
    private long longTaskCount;
    private int viewTreeChangeCount;
    private boolean sent;
    private boolean stopped;
    public static final long ACTION_INACTIVITY_MS = 100L;
    public static final long ACTION_MAX_DURATION_MS = 5000L;

    /*
     * WARNING - void declaration
     */
    public RumActionScope(@NotNull RumScope parentScope, boolean waitForStop, @NotNull Time eventTime, @NotNull RumActionType initialType, @NotNull String initialName, @NotNull Map<String, ? extends Object> initialAttributes, long serverTimeOffsetInMs, long inactivityThresholdMs, long maxDurationMs) {
        void $this$attributes_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)((Object)initialType), (String)"initialType");
        Intrinsics.checkNotNullParameter((Object)initialName, (String)"initialName");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        this.parentScope = parentScope;
        this.waitForStop = waitForStop;
        this.inactivityThresholdNs = TimeUnit.MILLISECONDS.toNanos(inactivityThresholdMs);
        this.maxDurationNs = TimeUnit.MILLISECONDS.toNanos(maxDurationMs);
        this.eventTimestamp = eventTime.getTimestamp() + serverTimeOffsetInMs;
        Object object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        this.actionId = object;
        this.type = initialType;
        this.name = initialName;
        this.lastInteractionNanos = this.startedNanos = eventTime.getNanoTime();
        object = MapsKt.toMutableMap(initialAttributes);
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        RumActionScope rumActionScope = this;
        boolean bl3 = false;
        $this$attributes_u24lambda_u2d0.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        Unit unit = Unit.INSTANCE;
        rumActionScope.attributes = object;
        boolean bl4 = false;
        this.ongoingResourceKeys = new ArrayList();
    }

    public /* synthetic */ RumActionScope(RumScope rumScope, boolean bl, Time time, RumActionType rumActionType, String string, Map map, long l, long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            l2 = 100L;
        }
        if ((n & 0x100) != 0) {
            l3 = 5000L;
        }
        this(rumScope, bl, time, rumActionType, string, map, l, l2, l3);
    }

    @NotNull
    public final RumScope getParentScope() {
        return this.parentScope;
    }

    public final boolean getWaitForStop() {
        return this.waitForStop;
    }

    public final long getEventTimestamp$dd_sdk_android_release() {
        return this.eventTimestamp;
    }

    @NotNull
    public final String getActionId$dd_sdk_android_release() {
        return this.actionId;
    }

    @NotNull
    public final RumActionType getType$dd_sdk_android_release() {
        return this.type;
    }

    public final void setType$dd_sdk_android_release(@NotNull RumActionType rumActionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)rumActionType), (String)"<set-?>");
        this.type = rumActionType;
    }

    @NotNull
    public final String getName$dd_sdk_android_release() {
        return this.name;
    }

    public final void setName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_release() {
        return this.attributes;
    }

    public final long getResourceCount$dd_sdk_android_release() {
        return this.resourceCount;
    }

    public final void setResourceCount$dd_sdk_android_release(long l) {
        this.resourceCount = l;
    }

    public final long getErrorCount$dd_sdk_android_release() {
        return this.errorCount;
    }

    public final void setErrorCount$dd_sdk_android_release(long l) {
        this.errorCount = l;
    }

    public final long getCrashCount$dd_sdk_android_release() {
        return this.crashCount;
    }

    public final void setCrashCount$dd_sdk_android_release(long l) {
        this.crashCount = l;
    }

    public final long getLongTaskCount$dd_sdk_android_release() {
        return this.longTaskCount;
    }

    public final void setLongTaskCount$dd_sdk_android_release(long l) {
        this.longTaskCount = l;
    }

    public final int getViewTreeChangeCount$dd_sdk_android_release() {
        return this.viewTreeChangeCount;
    }

    public final void setViewTreeChangeCount$dd_sdk_android_release(int n) {
        this.viewTreeChangeCount = n;
    }

    @Override
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        long now = event.getEventTime().getNanoTime();
        boolean isInactive = now - this.lastInteractionNanos > this.inactivityThresholdNs;
        boolean isLongDuration = now - this.startedNanos > this.maxDurationNs;
        CollectionsKt.removeAll(this.ongoingResourceKeys, (Function1)handleEvent.1.INSTANCE);
        boolean isOngoing = this.waitForStop && !this.stopped;
        boolean shouldStop = isInactive && this.ongoingResourceKeys.isEmpty() && !isOngoing;
        if (shouldStop) {
            this.sendAction(this.lastInteractionNanos, writer);
        } else if (isLongDuration) {
            this.sendAction(now, writer);
        } else if (event instanceof RumRawEvent.SendCustomActionNow) {
            this.sendAction(this.lastInteractionNanos, writer);
        } else if (event instanceof RumRawEvent.ViewTreeChanged) {
            this.onViewTreeChanged(now);
        } else if (event instanceof RumRawEvent.StopView) {
            this.onStopView(now, writer);
        } else if (event instanceof RumRawEvent.StopAction) {
            this.onStopAction((RumRawEvent.StopAction)event, now);
        } else if (event instanceof RumRawEvent.StartResource) {
            this.onStartResource((RumRawEvent.StartResource)event, now);
        } else if (event instanceof RumRawEvent.StopResource) {
            this.onStopResource((RumRawEvent.StopResource)event, now);
        } else if (event instanceof RumRawEvent.AddError) {
            this.onError((RumRawEvent.AddError)event, now, writer);
        } else if (event instanceof RumRawEvent.StopResourceWithError) {
            this.onResourceError((RumRawEvent.StopResourceWithError)event, now);
        } else if (event instanceof RumRawEvent.AddLongTask) {
            this.onLongTask(now);
        }
        return this.sent ? null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.parentScope.getRumContext();
    }

    private final void onViewTreeChanged(long now) {
        this.lastInteractionNanos = now;
        RumActionScope rumActionScope = this;
        int n = rumActionScope.viewTreeChangeCount;
        rumActionScope.viewTreeChangeCount = n + 1;
    }

    private final void onStopView(long now, DataWriter<Object> writer) {
        this.ongoingResourceKeys.clear();
        this.sendAction(now, writer);
    }

    private final void onStopAction(RumRawEvent.StopAction event, long now) {
        RumActionType it;
        boolean bl;
        boolean bl2;
        RumActionType rumActionType;
        Object object = event.getType();
        if (object != null) {
            rumActionType = object;
            bl2 = false;
            bl = false;
            it = rumActionType;
            boolean bl3 = false;
            this.setType$dd_sdk_android_release(it);
        }
        object = event.getName();
        if (object != null) {
            rumActionType = object;
            bl2 = false;
            bl = false;
            it = rumActionType;
            boolean bl4 = false;
            this.setName$dd_sdk_android_release((String)((Object)it));
        }
        this.attributes.putAll(event.getAttributes());
        this.stopped = true;
        this.lastInteractionNanos = now;
    }

    private final void onStartResource(RumRawEvent.StartResource event, long now) {
        this.lastInteractionNanos = now;
        RumActionScope rumActionScope = this;
        long l = rumActionScope.resourceCount;
        rumActionScope.resourceCount = l + 1L;
        this.ongoingResourceKeys.add(new WeakReference<String>(event.getKey()));
    }

    private final void onStopResource(RumRawEvent.StopResource event, long now) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.ongoingResourceKeys;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.get(), (Object)event.getKey())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        WeakReference keyRef = v0;
        if (keyRef != null) {
            this.ongoingResourceKeys.remove(keyRef);
            this.lastInteractionNanos = now;
        }
    }

    private final void onError(RumRawEvent.AddError event, long now, DataWriter<Object> writer) {
        this.lastInteractionNanos = now;
        RumActionScope rumActionScope = this;
        long l = rumActionScope.errorCount;
        rumActionScope.errorCount = l + 1L;
        if (event.isFatal()) {
            rumActionScope = this;
            l = rumActionScope.crashCount;
            rumActionScope.crashCount = l + 1L;
            this.sendAction(now, writer);
        }
    }

    private final void onResourceError(RumRawEvent.StopResourceWithError event, long now) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.ongoingResourceKeys;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.get(), (Object)event.getKey())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        WeakReference keyRef = v0;
        if (keyRef != null) {
            this.ongoingResourceKeys.remove(keyRef);
            this.lastInteractionNanos = now;
            RumActionScope rumActionScope = this;
            long l = rumActionScope.resourceCount;
            rumActionScope.resourceCount = l + -1L;
            rumActionScope = this;
            l = rumActionScope.errorCount;
            rumActionScope.errorCount = l + 1L;
        }
    }

    private final void onLongTask(long now) {
        this.lastInteractionNanos = now;
        RumActionScope rumActionScope = this;
        long l = rumActionScope.longTaskCount;
        rumActionScope.longTaskCount = l + 1L;
    }

    private final void sendAction(long endNanos, DataWriter<Object> writer) {
        if (this.sent) {
            return;
        }
        RumActionType actualType = this.type;
        if (this.actionCanBeSent(actualType)) {
            this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
            RumContext context = this.getRumContext();
            UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
            long l = this.eventTimestamp;
            Object object = RumEventExtKt.toSchemaType(actualType);
            Object object2 = this.actionId;
            Object object3 = new ActionEvent.Target(this.name);
            ActionEvent.Error error = new ActionEvent.Error(this.errorCount);
            Object object4 = new ActionEvent.Crash(this.crashCount);
            ActionEvent.LongTask longTask = new ActionEvent.LongTask(this.longTaskCount);
            ActionEvent.Resource resource = new ActionEvent.Resource(this.resourceCount);
            long l2 = endNanos - this.startedNanos;
            long l3 = 1L;
            boolean bl = false;
            long l4 = Math.max(l2, l3);
            ActionEvent.Action action = new ActionEvent.Action((ActionEvent.ActionType)((Object)object), (String)object2, l4, (ActionEvent.Target)object3, error, (ActionEvent.Crash)object4, longTask, resource);
            object3 = context.getViewId();
            boolean bl2 = false;
            Object object5 = object3;
            if (object5 == null) {
                object5 = "";
            }
            object2 = object5;
            object3 = context.getViewName();
            object4 = context.getViewUrl();
            boolean bl3 = false;
            Object object6 = object4;
            if (object6 == null) {
                object6 = "";
            }
            Object object7 = object6;
            object = new ActionEvent.View((String)object2, null, (String)object7, (String)object3, null, 18, null);
            object2 = new ActionEvent.Application(context.getApplicationId());
            object3 = new ActionEvent.ActionEventSession(context.getSessionId(), ActionEvent.ActionEventSessionType.USER, null, 4, null);
            object7 = new ActionEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
            object4 = new ActionEvent.Context(this.attributes);
            ActionEvent.Dd dd = new ActionEvent.Dd(new ActionEvent.DdSession(ActionEvent.Plan.PLAN_1));
            ActionEvent actionEvent = new ActionEvent(l, (ActionEvent.Application)object2, null, (ActionEvent.ActionEventSession)object3, (ActionEvent.View)object, (ActionEvent.Usr)object7, null, null, dd, (ActionEvent.Context)object4, action, 196, null);
            writer.write(actionEvent);
        } else {
            String string = this.getRumContext().getViewId();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            this.parentScope.handleEvent(new RumRawEvent.ActionDropped(string2, null, 2, null), writer);
            Logger.i$default(RuntimeUtilsKt.getDevLogger(), "RUM Action " + this.actionId + " (" + (Object)((Object)actualType) + " on " + this.name + ") was dropped (no side effect was registered during its scope)", null, null, 6, null);
        }
        this.sent = true;
    }

    private final boolean actionCanBeSent(RumActionType actualType) {
        long sideEffectsCount = this.resourceCount + this.errorCount + (long)this.viewTreeChangeCount + this.longTaskCount;
        return sideEffectsCount > 0L || actualType == RumActionType.CUSTOM;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumActionScope$Companion;", "", "()V", "ACTION_INACTIVITY_MS", "", "ACTION_MAX_DURATION_MS", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartAction;", "timestampOffset", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumScope fromEvent(@NotNull RumScope parentScope, @NotNull RumRawEvent.StartAction event, long timestampOffset) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return new RumActionScope(parentScope, event.getWaitForStop(), event.getEventTime(), event.getType(), event.getName(), event.getAttributes(), timestampOffset, 0L, 0L, 384, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

