/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain;

import com.datadog.android.core.internal.persistence.PayloadDecoration;
import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.core.internal.persistence.file.FileHandler;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileDataWriter;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.EventType;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001d\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0019H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/datadog/android/rum/internal/domain/RumDataWriter;", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileDataWriter;", "", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "serializer", "Lcom/datadog/android/core/internal/persistence/Serializer;", "decoration", "Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "handler", "Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "internalLogger", "Lcom/datadog/android/log/Logger;", "lastViewEventFile", "Ljava/io/File;", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/Serializer;Lcom/datadog/android/core/internal/persistence/PayloadDecoration;Lcom/datadog/android/core/internal/persistence/file/FileHandler;Lcom/datadog/android/log/Logger;Ljava/io/File;)V", "notifyEventSent", "", "viewId", "", "eventType", "Lcom/datadog/android/rum/internal/monitor/EventType;", "onDataWritten", "data", "rawData", "", "onDataWritten$dd_sdk_android_release", "persistViewEvent", "dd-sdk-android_release"})
public final class RumDataWriter
extends BatchFileDataWriter<Object> {
    @NotNull
    private final File lastViewEventFile;

    public RumDataWriter(@NotNull FileOrchestrator fileOrchestrator, @NotNull Serializer<Object> serializer, @NotNull PayloadDecoration decoration, @NotNull FileHandler handler, @NotNull Logger internalLogger, @NotNull File lastViewEventFile) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"fileOrchestrator");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)lastViewEventFile, (String)"lastViewEventFile");
        super(fileOrchestrator, serializer, decoration, handler, internalLogger);
        this.lastViewEventFile = lastViewEventFile;
    }

    @Override
    public void onDataWritten$dd_sdk_android_release(@NotNull Object data, @NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Object object = data;
        if (object instanceof ViewEvent) {
            this.persistViewEvent(rawData);
        } else if (object instanceof ActionEvent) {
            this.notifyEventSent(((ActionEvent)data).getView().getId(), EventType.ACTION);
        } else if (object instanceof ResourceEvent) {
            this.notifyEventSent(((ResourceEvent)data).getView().getId(), EventType.RESOURCE);
        } else if (object instanceof ErrorEvent) {
            if (!Intrinsics.areEqual((Object)((ErrorEvent)data).getError().isCrash(), (Object)true)) {
                this.notifyEventSent(((ErrorEvent)data).getView().getId(), EventType.ERROR);
            }
        } else if (object instanceof LongTaskEvent) {
            if (Intrinsics.areEqual((Object)((LongTaskEvent)data).getLongTask().isFrozenFrame(), (Object)true)) {
                this.notifyEventSent(((LongTaskEvent)data).getView().getId(), EventType.FROZEN_FRAME);
            } else {
                this.notifyEventSent(((LongTaskEvent)data).getView().getId(), EventType.LONG_TASK);
            }
        }
    }

    private final void persistViewEvent(byte[] data) {
        FileHandler.DefaultImpls.writeData$default(this.getHandler$dd_sdk_android_release(), this.lastViewEventFile, data, false, null, 12, null);
    }

    private final void notifyEventSent(String viewId, EventType eventType) {
        RumMonitor rumMonitor = GlobalRum.get();
        if (rumMonitor instanceof AdvancedRumMonitor) {
            ((AdvancedRumMonitor)rumMonitor).eventSent(viewId, eventType);
        }
    }
}

