/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.anr;

import android.os.Handler;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.anr.ANRException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;", "Ljava/lang/Runnable;", "handler", "Landroid/os/Handler;", "anrThresholdMs", "", "anrTestDelayMs", "(Landroid/os/Handler;JJ)V", "shouldStop", "", "run", "", "stop", "CallbackRunnable", "Companion", "dd-sdk-android_release"})
public final class ANRDetectorRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Handler handler;
    private final long anrThresholdMs;
    private final long anrTestDelayMs;
    private boolean shouldStop;
    private static final long ANR_THRESHOLD_MS = 5000L;
    private static final long ANR_TEST_DELAY_MS = 500L;
    @NotNull
    public static final String ANR_MESSAGE = "Application Not Responding";

    public ANRDetectorRunnable(@NotNull Handler handler, long anrThresholdMs, long anrTestDelayMs) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.anrThresholdMs = anrThresholdMs;
        this.anrTestDelayMs = anrTestDelayMs;
    }

    public /* synthetic */ ANRDetectorRunnable(Handler handler, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 5000L;
        }
        if ((n & 4) != 0) {
            l2 = 500L;
        }
        this(handler, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            if (this.shouldStop) {
                return;
            }
            try {
                CallbackRunnable callback = new CallbackRunnable();
                boolean bl = false;
                boolean bl2 = false;
                synchronized (callback) {
                    boolean bl3 = false;
                    if (!this.handler.post((Runnable)callback)) {
                        return;
                    }
                    callback.wait(this.anrThresholdMs);
                    if (!callback.wasCalled()) {
                        RumMonitor rumMonitor = GlobalRum.get();
                        Thread thread = this.handler.getLooper().getThread();
                        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"handler.looper.thread");
                        rumMonitor.addError(ANR_MESSAGE, RumErrorSource.SOURCE, new ANRException(thread), MapsKt.emptyMap());
                        callback.wait();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Thread.sleep(this.anrTestDelayMs);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public final void stop() {
        this.shouldStop = true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable$CallbackRunnable;", "Ljava/lang/Object;", "Ljava/lang/Runnable;", "()V", "called", "", "run", "", "wasCalled", "dd-sdk-android_release"})
    public static final class CallbackRunnable
    implements Runnable {
        private boolean called;

        @Override
        public synchronized void run() {
            this.called = true;
            this.notifyAll();
        }

        public final boolean wasCalled() {
            return this.called;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable$Companion;", "", "()V", "ANR_MESSAGE", "", "ANR_TEST_DELAY_MS", "", "ANR_THRESHOLD_MS", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

