/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.SdkFeature;
import com.datadog.android.core.internal.event.NoOpEventMapper;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.persistence.PersistenceStrategy;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.event.EventMapper;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.anr.ANRDetectorRunnable;
import com.datadog.android.rum.internal.domain.RumFilePersistenceStrategy;
import com.datadog.android.rum.internal.ndk.DatadogNdkCrashHandler;
import com.datadog.android.rum.internal.net.RumOkHttpUploaderV2;
import com.datadog.android.rum.internal.tracking.NoOpUserActionTrackingStrategy;
import com.datadog.android.rum.internal.tracking.UserActionTrackingStrategy;
import com.datadog.android.rum.internal.tracking.ViewTreeChangeTrackingStrategy;
import com.datadog.android.rum.internal.vitals.AggregatingVitalMonitor;
import com.datadog.android.rum.internal.vitals.CPUVitalReader;
import com.datadog.android.rum.internal.vitals.MemoryVitalReader;
import com.datadog.android.rum.internal.vitals.NoOpVitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalFrameCallback;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalObserver;
import com.datadog.android.rum.internal.vitals.VitalReader;
import com.datadog.android.rum.internal.vitals.VitalReaderRunnable;
import com.datadog.android.rum.tracking.NoOpTrackingStrategy;
import com.datadog.android.rum.tracking.NoOpViewTrackingStrategy;
import com.datadog.android.rum.tracking.TrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0016J\u0010\u0010W\u001a\u00020X2\u0006\u0010V\u001a\u00020\u0003H\u0016J\b\u0010Y\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0002J\b\u0010`\u001a\u00020ZH\u0002J\u0018\u0010a\u001a\u00020Z2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0003H\u0016J\b\u0010b\u001a\u00020ZH\u0016J\u0010\u0010c\u001a\u00020Z2\u0006\u0010d\u001a\u00020UH\u0002J\u0012\u0010e\u001a\u00020Z2\b\u0010d\u001a\u0004\u0018\u00010UH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001a\u0010.\u001a\u00020/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010(\"\u0004\b6\u0010*R \u00107\u001a\b\u0012\u0004\u0012\u00020\u000208X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020DX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u00101\"\u0004\bK\u00103R\u001a\u0010L\u001a\u00020MX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010Q\u00a8\u0006f"}, d2={"Lcom/datadog/android/rum/internal/RumFeature;", "Lcom/datadog/android/core/internal/SdkFeature;", "", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "()V", "VITAL_UPDATE_PERIOD_MS", "", "actionTrackingStrategy", "Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "getActionTrackingStrategy$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "setActionTrackingStrategy$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;)V", "anrDetectorExecutorService", "Ljava/util/concurrent/ExecutorService;", "getAnrDetectorExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ExecutorService;", "setAnrDetectorExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ExecutorService;)V", "anrDetectorHandler", "Landroid/os/Handler;", "getAnrDetectorHandler$dd_sdk_android_release", "()Landroid/os/Handler;", "setAnrDetectorHandler$dd_sdk_android_release", "(Landroid/os/Handler;)V", "anrDetectorRunnable", "Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;", "getAnrDetectorRunnable$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;", "setAnrDetectorRunnable$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;)V", "backgroundEventTracking", "", "getBackgroundEventTracking$dd_sdk_android_release", "()Z", "setBackgroundEventTracking$dd_sdk_android_release", "(Z)V", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "getCpuVitalMonitor$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "setCpuVitalMonitor$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/vitals/VitalMonitor;)V", "frameRateVitalMonitor", "getFrameRateVitalMonitor$dd_sdk_android_release", "setFrameRateVitalMonitor$dd_sdk_android_release", "longTaskTrackingStrategy", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "getLongTaskTrackingStrategy$dd_sdk_android_release", "()Lcom/datadog/android/rum/tracking/TrackingStrategy;", "setLongTaskTrackingStrategy$dd_sdk_android_release", "(Lcom/datadog/android/rum/tracking/TrackingStrategy;)V", "memoryVitalMonitor", "getMemoryVitalMonitor$dd_sdk_android_release", "setMemoryVitalMonitor$dd_sdk_android_release", "rumEventMapper", "Lcom/datadog/android/event/EventMapper;", "getRumEventMapper$dd_sdk_android_release", "()Lcom/datadog/android/event/EventMapper;", "setRumEventMapper$dd_sdk_android_release", "(Lcom/datadog/android/event/EventMapper;)V", "samplingRate", "", "getSamplingRate$dd_sdk_android_release", "()F", "setSamplingRate$dd_sdk_android_release", "(F)V", "viewTrackingStrategy", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "getViewTrackingStrategy$dd_sdk_android_release", "()Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "setViewTrackingStrategy$dd_sdk_android_release", "(Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;)V", "viewTreeTrackingStrategy", "getViewTreeTrackingStrategy$dd_sdk_android_release", "setViewTreeTrackingStrategy$dd_sdk_android_release", "vitalExecutorService", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "getVitalExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "setVitalExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ScheduledThreadPoolExecutor;)V", "createPersistenceStrategy", "Lcom/datadog/android/core/internal/persistence/PersistenceStrategy;", "context", "Landroid/content/Context;", "configuration", "createUploader", "Lcom/datadog/android/core/internal/net/DataUploader;", "initializeANRDetector", "", "initializeVitalMonitor", "vitalReader", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "vitalObserver", "Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "initializeVitalMonitors", "onInitialize", "onStop", "registerTrackingStrategies", "appContext", "unregisterTrackingStrategies", "dd-sdk-android_release"})
public final class RumFeature
extends SdkFeature<Object, Configuration.Feature.RUM> {
    @NotNull
    public static final RumFeature INSTANCE = new RumFeature();
    private static float samplingRate;
    private static boolean backgroundEventTracking;
    @NotNull
    private static ViewTrackingStrategy viewTrackingStrategy;
    @NotNull
    private static UserActionTrackingStrategy actionTrackingStrategy;
    @NotNull
    private static TrackingStrategy viewTreeTrackingStrategy;
    @NotNull
    private static EventMapper<Object> rumEventMapper;
    @NotNull
    private static TrackingStrategy longTaskTrackingStrategy;
    @NotNull
    private static VitalMonitor cpuVitalMonitor;
    @NotNull
    private static VitalMonitor memoryVitalMonitor;
    @NotNull
    private static VitalMonitor frameRateVitalMonitor;
    public static ScheduledThreadPoolExecutor vitalExecutorService;
    public static ExecutorService anrDetectorExecutorService;
    public static ANRDetectorRunnable anrDetectorRunnable;
    public static Handler anrDetectorHandler;
    private static final long VITAL_UPDATE_PERIOD_MS = 100L;

    private RumFeature() {
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return samplingRate;
    }

    public final void setSamplingRate$dd_sdk_android_release(float f) {
        samplingRate = f;
    }

    public final boolean getBackgroundEventTracking$dd_sdk_android_release() {
        return backgroundEventTracking;
    }

    public final void setBackgroundEventTracking$dd_sdk_android_release(boolean bl) {
        backgroundEventTracking = bl;
    }

    @NotNull
    public final ViewTrackingStrategy getViewTrackingStrategy$dd_sdk_android_release() {
        return viewTrackingStrategy;
    }

    public final void setViewTrackingStrategy$dd_sdk_android_release(@NotNull ViewTrackingStrategy viewTrackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)viewTrackingStrategy, (String)"<set-?>");
        RumFeature.viewTrackingStrategy = viewTrackingStrategy;
    }

    @NotNull
    public final UserActionTrackingStrategy getActionTrackingStrategy$dd_sdk_android_release() {
        return actionTrackingStrategy;
    }

    public final void setActionTrackingStrategy$dd_sdk_android_release(@NotNull UserActionTrackingStrategy userActionTrackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)userActionTrackingStrategy, (String)"<set-?>");
        actionTrackingStrategy = userActionTrackingStrategy;
    }

    @NotNull
    public final TrackingStrategy getViewTreeTrackingStrategy$dd_sdk_android_release() {
        return viewTreeTrackingStrategy;
    }

    public final void setViewTreeTrackingStrategy$dd_sdk_android_release(@NotNull TrackingStrategy trackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)trackingStrategy, (String)"<set-?>");
        viewTreeTrackingStrategy = trackingStrategy;
    }

    @NotNull
    public final EventMapper<Object> getRumEventMapper$dd_sdk_android_release() {
        return rumEventMapper;
    }

    public final void setRumEventMapper$dd_sdk_android_release(@NotNull EventMapper<Object> eventMapper) {
        Intrinsics.checkNotNullParameter(eventMapper, (String)"<set-?>");
        rumEventMapper = eventMapper;
    }

    @NotNull
    public final TrackingStrategy getLongTaskTrackingStrategy$dd_sdk_android_release() {
        return longTaskTrackingStrategy;
    }

    public final void setLongTaskTrackingStrategy$dd_sdk_android_release(@NotNull TrackingStrategy trackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)trackingStrategy, (String)"<set-?>");
        longTaskTrackingStrategy = trackingStrategy;
    }

    @NotNull
    public final VitalMonitor getCpuVitalMonitor$dd_sdk_android_release() {
        return cpuVitalMonitor;
    }

    public final void setCpuVitalMonitor$dd_sdk_android_release(@NotNull VitalMonitor vitalMonitor) {
        Intrinsics.checkNotNullParameter((Object)vitalMonitor, (String)"<set-?>");
        cpuVitalMonitor = vitalMonitor;
    }

    @NotNull
    public final VitalMonitor getMemoryVitalMonitor$dd_sdk_android_release() {
        return memoryVitalMonitor;
    }

    public final void setMemoryVitalMonitor$dd_sdk_android_release(@NotNull VitalMonitor vitalMonitor) {
        Intrinsics.checkNotNullParameter((Object)vitalMonitor, (String)"<set-?>");
        memoryVitalMonitor = vitalMonitor;
    }

    @NotNull
    public final VitalMonitor getFrameRateVitalMonitor$dd_sdk_android_release() {
        return frameRateVitalMonitor;
    }

    public final void setFrameRateVitalMonitor$dd_sdk_android_release(@NotNull VitalMonitor vitalMonitor) {
        Intrinsics.checkNotNullParameter((Object)vitalMonitor, (String)"<set-?>");
        frameRateVitalMonitor = vitalMonitor;
    }

    @NotNull
    public final ScheduledThreadPoolExecutor getVitalExecutorService$dd_sdk_android_release() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = vitalExecutorService;
        if (scheduledThreadPoolExecutor != null) {
            return scheduledThreadPoolExecutor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"vitalExecutorService");
        throw null;
    }

    public final void setVitalExecutorService$dd_sdk_android_release(@NotNull ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        Intrinsics.checkNotNullParameter((Object)scheduledThreadPoolExecutor, (String)"<set-?>");
        vitalExecutorService = scheduledThreadPoolExecutor;
    }

    @NotNull
    public final ExecutorService getAnrDetectorExecutorService$dd_sdk_android_release() {
        ExecutorService executorService = anrDetectorExecutorService;
        if (executorService != null) {
            return executorService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"anrDetectorExecutorService");
        throw null;
    }

    public final void setAnrDetectorExecutorService$dd_sdk_android_release(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        anrDetectorExecutorService = executorService;
    }

    @NotNull
    public final ANRDetectorRunnable getAnrDetectorRunnable$dd_sdk_android_release() {
        ANRDetectorRunnable aNRDetectorRunnable = anrDetectorRunnable;
        if (aNRDetectorRunnable != null) {
            return aNRDetectorRunnable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"anrDetectorRunnable");
        throw null;
    }

    public final void setAnrDetectorRunnable$dd_sdk_android_release(@NotNull ANRDetectorRunnable aNRDetectorRunnable) {
        Intrinsics.checkNotNullParameter((Object)aNRDetectorRunnable, (String)"<set-?>");
        anrDetectorRunnable = aNRDetectorRunnable;
    }

    @NotNull
    public final Handler getAnrDetectorHandler$dd_sdk_android_release() {
        Handler handler = anrDetectorHandler;
        if (handler != null) {
            return handler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"anrDetectorHandler");
        throw null;
    }

    public final void setAnrDetectorHandler$dd_sdk_android_release(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        anrDetectorHandler = handler;
    }

    @Override
    public void onInitialize(@NotNull Context context, @NotNull Configuration.Feature.RUM configuration) {
        ViewTrackingStrategy it;
        boolean bl;
        boolean bl2;
        ViewTrackingStrategy viewTrackingStrategy;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        samplingRate = configuration.getSamplingRate();
        backgroundEventTracking = configuration.getBackgroundEventTracking();
        rumEventMapper = configuration.getRumEventMapper();
        TrackingStrategy trackingStrategy = configuration.getViewTrackingStrategy();
        if (trackingStrategy != null) {
            viewTrackingStrategy = trackingStrategy;
            bl2 = false;
            bl = false;
            it = viewTrackingStrategy;
            boolean bl3 = false;
            INSTANCE.setViewTrackingStrategy$dd_sdk_android_release(it);
        }
        trackingStrategy = configuration.getUserActionTrackingStrategy();
        if (trackingStrategy != null) {
            viewTrackingStrategy = trackingStrategy;
            bl2 = false;
            bl = false;
            it = viewTrackingStrategy;
            boolean bl4 = false;
            INSTANCE.setActionTrackingStrategy$dd_sdk_android_release((UserActionTrackingStrategy)((Object)it));
        }
        trackingStrategy = configuration.getLongTaskTrackingStrategy();
        if (trackingStrategy != null) {
            viewTrackingStrategy = trackingStrategy;
            bl2 = false;
            bl = false;
            it = viewTrackingStrategy;
            boolean bl5 = false;
            INSTANCE.setLongTaskTrackingStrategy$dd_sdk_android_release(it);
        }
        this.initializeVitalMonitors();
        this.initializeANRDetector();
        this.registerTrackingStrategies(context);
    }

    @Override
    public void onStop() {
        this.unregisterTrackingStrategies((Context)CoreFeature.INSTANCE.getContextRef$dd_sdk_android_release().get());
        viewTrackingStrategy = new NoOpViewTrackingStrategy();
        actionTrackingStrategy = new NoOpUserActionTrackingStrategy();
        longTaskTrackingStrategy = new NoOpTrackingStrategy();
        rumEventMapper = new NoOpEventMapper();
        cpuVitalMonitor = new NoOpVitalMonitor();
        memoryVitalMonitor = new NoOpVitalMonitor();
        frameRateVitalMonitor = new NoOpVitalMonitor();
        this.getVitalExecutorService$dd_sdk_android_release().shutdownNow();
        this.getAnrDetectorExecutorService$dd_sdk_android_release().shutdownNow();
        this.getAnrDetectorRunnable$dd_sdk_android_release().stop();
    }

    @Override
    @NotNull
    public PersistenceStrategy<Object> createPersistenceStrategy(@NotNull Context context, @NotNull Configuration.Feature.RUM configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return new RumFilePersistenceStrategy(CoreFeature.INSTANCE.getTrackingConsentProvider$dd_sdk_android_release(), context, configuration.getRumEventMapper(), CoreFeature.INSTANCE.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getSdkLogger(), DatadogNdkCrashHandler.Companion.getLastViewEventFile$dd_sdk_android_release(context));
    }

    @Override
    @NotNull
    public DataUploader createUploader(@NotNull Configuration.Feature.RUM configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return new RumOkHttpUploaderV2(configuration.getEndpointUrl(), CoreFeature.INSTANCE.getClientToken$dd_sdk_android_release(), CoreFeature.INSTANCE.getSourceName$dd_sdk_android_release(), CoreFeature.INSTANCE.getSdkVersion$dd_sdk_android_release(), (Call.Factory)CoreFeature.INSTANCE.getOkHttpClient$dd_sdk_android_release());
    }

    private final void registerTrackingStrategies(Context appContext) {
        actionTrackingStrategy.register(appContext);
        viewTrackingStrategy.register(appContext);
        viewTreeTrackingStrategy.register(appContext);
        longTaskTrackingStrategy.register(appContext);
    }

    private final void unregisterTrackingStrategies(Context appContext) {
        actionTrackingStrategy.unregister(appContext);
        viewTrackingStrategy.unregister(appContext);
        viewTreeTrackingStrategy.unregister(appContext);
        longTaskTrackingStrategy.unregister(appContext);
    }

    private final void initializeVitalMonitors() {
        cpuVitalMonitor = new AggregatingVitalMonitor();
        memoryVitalMonitor = new AggregatingVitalMonitor();
        frameRateVitalMonitor = new AggregatingVitalMonitor();
        this.setVitalExecutorService$dd_sdk_android_release(new ScheduledThreadPoolExecutor(1));
        this.initializeVitalMonitor(new CPUVitalReader(null, 1, null), cpuVitalMonitor);
        this.initializeVitalMonitor(new MemoryVitalReader(null, 1, null), memoryVitalMonitor);
        VitalFrameCallback vitalFrameCallback2 = new VitalFrameCallback(frameRateVitalMonitor, (Function0<Boolean>)((Function0)initializeVitalMonitors.vitalFrameCallback.1.INSTANCE));
        try {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)vitalFrameCallback2);
        }
        catch (IllegalStateException e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Unable to initialize the Choreographer FrameCallback", e, null, 4, null);
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), "It seems you initialized the SDK on a thread without a Looper: we won't be able to track your Views' refresh rate.", null, null, 6, null);
        }
    }

    private final void initializeVitalMonitor(VitalReader vitalReader, VitalObserver vitalObserver) {
        VitalReaderRunnable readerRunnable = new VitalReaderRunnable(vitalReader, vitalObserver, this.getVitalExecutorService$dd_sdk_android_release(), 100L);
        this.getVitalExecutorService$dd_sdk_android_release().schedule(readerRunnable, 100L, TimeUnit.MILLISECONDS);
    }

    private final void initializeANRDetector() {
        this.setAnrDetectorHandler$dd_sdk_android_release(new Handler(Looper.getMainLooper()));
        this.setAnrDetectorRunnable$dd_sdk_android_release(new ANRDetectorRunnable(this.getAnrDetectorHandler$dd_sdk_android_release(), 0L, 0L, 6, null));
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.setAnrDetectorExecutorService$dd_sdk_android_release(executorService);
        this.getAnrDetectorExecutorService$dd_sdk_android_release().execute(this.getAnrDetectorRunnable$dd_sdk_android_release());
    }

    static {
        viewTrackingStrategy = new NoOpViewTrackingStrategy();
        actionTrackingStrategy = new NoOpUserActionTrackingStrategy();
        viewTreeTrackingStrategy = new ViewTreeChangeTrackingStrategy();
        rumEventMapper = new NoOpEventMapper();
        longTaskTrackingStrategy = new NoOpTrackingStrategy();
        cpuVitalMonitor = new NoOpVitalMonitor();
        memoryVitalMonitor = new NoOpVitalMonitor();
        frameRateVitalMonitor = new NoOpVitalMonitor();
    }
}

