/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.error.internal.CrashReportsFeature;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.plugin.DatadogContext;
import com.datadog.android.plugin.DatadogPlugin;
import com.datadog.android.plugin.DatadogRumContext;
import com.datadog.android.rum.NoOpRumMonitor;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.tracing.internal.TracesFeature;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u0010\u001d\u001a\u00020\u0010H\u0007J\r\u0010\u001e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010\u000b\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010!\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0007J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0007J\b\u0010%\u001a\u00020\u001aH\u0003J\u001e\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u0015\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b.R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/datadog/android/rum/GlobalRum;", "", "()V", "activeContext", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/datadog/android/rum/internal/domain/RumContext;", "globalAttributes", "", "", "getGlobalAttributes$dd_sdk_android_release", "()Ljava/util/Map;", "isRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRegistered$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "monitor", "Lcom/datadog/android/rum/RumMonitor;", "getMonitor$dd_sdk_android_release", "()Lcom/datadog/android/rum/RumMonitor;", "setMonitor$dd_sdk_android_release", "(Lcom/datadog/android/rum/RumMonitor;)V", "sessionStartNs", "Ljava/util/concurrent/atomic/AtomicLong;", "getSessionStartNs$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicLong;", "addAttribute", "", "key", "value", "get", "getRumContext", "getRumContext$dd_sdk_android_release", "", "registerIfAbsent", "provider", "Ljava/util/concurrent/Callable;", "removeAttribute", "resetSession", "updateContextInPlugins", "pluginContext", "Lcom/datadog/android/plugin/DatadogContext;", "plugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "updateRumContext", "newContext", "updateRumContext$dd_sdk_android_release", "dd-sdk-android_release"})
public final class GlobalRum {
    @NotNull
    public static final GlobalRum INSTANCE = new GlobalRum();
    @NotNull
    private static final Map<String, Object> globalAttributes = new ConcurrentHashMap();
    @NotNull
    private static final AtomicLong sessionStartNs = new AtomicLong(0L);
    @NotNull
    private static final AtomicBoolean isRegistered = new AtomicBoolean(false);
    @NotNull
    private static RumMonitor monitor = new NoOpRumMonitor();
    @NotNull
    private static AtomicReference<RumContext> activeContext = new AtomicReference<RumContext>(new RumContext(null, null, null, null, null, null, 63, null));

    private GlobalRum() {
    }

    @NotNull
    public final Map<String, Object> getGlobalAttributes$dd_sdk_android_release() {
        return globalAttributes;
    }

    @NotNull
    public final AtomicLong getSessionStartNs$dd_sdk_android_release() {
        return sessionStartNs;
    }

    @NotNull
    public final AtomicBoolean isRegistered$dd_sdk_android_release() {
        return isRegistered;
    }

    @NotNull
    public final RumMonitor getMonitor$dd_sdk_android_release() {
        return monitor;
    }

    public final void setMonitor$dd_sdk_android_release(@NotNull RumMonitor rumMonitor) {
        Intrinsics.checkNotNullParameter((Object)rumMonitor, (String)"<set-?>");
        monitor = rumMonitor;
    }

    @JvmStatic
    public static final boolean isRegistered() {
        return isRegistered.get();
    }

    @JvmStatic
    public static final boolean registerIfAbsent(@NotNull RumMonitor monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        return GlobalRum.registerIfAbsent(() -> GlobalRum.registerIfAbsent$lambda-0(monitor));
    }

    @JvmStatic
    public static final boolean registerIfAbsent(@NotNull Callable<RumMonitor> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (isRegistered.get()) {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), "RumMonitor has already been registered", null, null, 6, null);
            return false;
        }
        if (isRegistered.compareAndSet(false, true)) {
            RumMonitor rumMonitor = provider.call();
            Intrinsics.checkNotNullExpressionValue((Object)rumMonitor, (String)"provider.call()");
            monitor = rumMonitor;
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final RumMonitor get() {
        return monitor;
    }

    @JvmStatic
    public static final void addAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            globalAttributes.remove(key);
        } else {
            Map<String, Object> map = globalAttributes;
            boolean bl = false;
            map.put(key, value);
        }
    }

    @JvmStatic
    public static final void removeAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        globalAttributes.remove(key);
    }

    @NotNull
    public final RumContext getRumContext$dd_sdk_android_release() {
        RumContext rumContext = activeContext.get();
        Intrinsics.checkNotNullExpressionValue((Object)rumContext, (String)"activeContext.get()");
        return rumContext;
    }

    public final void updateRumContext$dd_sdk_android_release(@NotNull RumContext newContext) {
        Intrinsics.checkNotNullParameter((Object)newContext, (String)"newContext");
        activeContext.set(newContext);
        DatadogContext pluginContext = new DatadogContext(new DatadogRumContext(newContext.getApplicationId(), newContext.getSessionId(), newContext.getViewId()));
        this.updateContextInPlugins(pluginContext, RumFeature.INSTANCE.getPlugins());
        this.updateContextInPlugins(pluginContext, CrashReportsFeature.INSTANCE.getPlugins());
        this.updateContextInPlugins(pluginContext, LogsFeature.INSTANCE.getPlugins());
        this.updateContextInPlugins(pluginContext, TracesFeature.INSTANCE.getPlugins());
    }

    private final void updateContextInPlugins(DatadogContext pluginContext, List<? extends DatadogPlugin> plugins) {
        Iterable $this$forEach$iv = plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatadogPlugin it = (DatadogPlugin)element$iv;
            boolean bl = false;
            it.onContextChanged(pluginContext);
        }
    }

    @JvmStatic
    private static final void resetSession() {
        AdvancedRumMonitor advancedRumMonitor;
        RumMonitor rumMonitor = monitor;
        AdvancedRumMonitor advancedRumMonitor2 = advancedRumMonitor = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor != null) {
            advancedRumMonitor.resetSession();
        }
    }

    private static final RumMonitor registerIfAbsent$lambda-0(RumMonitor $monitor) {
        Intrinsics.checkNotNullParameter((Object)$monitor, (String)"$monitor");
        return $monitor;
    }
}

