/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.logger;

import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.sampling.RateBasedSampler;
import com.datadog.android.core.internal.sampling.Sampler;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJN\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!2\u0006\u0010\"\u001a\u00020#H\u0002JU\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010&R\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/datadog/android/log/internal/logger/DatadogLogHandler;", "Lcom/datadog/android/log/internal/logger/LogHandler;", "logGenerator", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "bundleWithTraces", "", "bundleWithRum", "sampler", "Lcom/datadog/android/core/internal/sampling/Sampler;", "(Lcom/datadog/android/log/internal/domain/LogGenerator;Lcom/datadog/android/core/internal/persistence/DataWriter;ZZLcom/datadog/android/core/internal/sampling/Sampler;)V", "getBundleWithRum$dd_sdk_android_release", "()Z", "getBundleWithTraces$dd_sdk_android_release", "getLogGenerator$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/domain/LogGenerator;", "getSampler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/sampling/Sampler;", "getWriter$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/DataWriter;", "createLog", "level", "", "message", "", "throwable", "", "attributes", "", "", "tags", "", "timestamp", "", "handleLog", "", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "dd-sdk-android_release"})
public final class DatadogLogHandler
implements LogHandler {
    @NotNull
    private final LogGenerator logGenerator;
    @NotNull
    private final DataWriter<LogEvent> writer;
    private final boolean bundleWithTraces;
    private final boolean bundleWithRum;
    @NotNull
    private final Sampler sampler;

    public DatadogLogHandler(@NotNull LogGenerator logGenerator, @NotNull DataWriter<LogEvent> writer, boolean bundleWithTraces, boolean bundleWithRum, @NotNull Sampler sampler) {
        Intrinsics.checkNotNullParameter((Object)logGenerator, (String)"logGenerator");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)sampler, (String)"sampler");
        this.logGenerator = logGenerator;
        this.writer = writer;
        this.bundleWithTraces = bundleWithTraces;
        this.bundleWithRum = bundleWithRum;
        this.sampler = sampler;
    }

    public /* synthetic */ DatadogLogHandler(LogGenerator logGenerator, DataWriter dataWriter, boolean bl, boolean bl2, Sampler sampler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            sampler = new RateBasedSampler(1.0f);
        }
        this(logGenerator, dataWriter, bl, bl2, sampler);
    }

    @NotNull
    public final LogGenerator getLogGenerator$dd_sdk_android_release() {
        return this.logGenerator;
    }

    @NotNull
    public final DataWriter<LogEvent> getWriter$dd_sdk_android_release() {
        return this.writer;
    }

    public final boolean getBundleWithTraces$dd_sdk_android_release() {
        return this.bundleWithTraces;
    }

    public final boolean getBundleWithRum$dd_sdk_android_release() {
        return this.bundleWithRum;
    }

    @NotNull
    public final Sampler getSampler$dd_sdk_android_release() {
        return this.sampler;
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags2, @Nullable Long timestamp) {
        long resolvedTimeStamp;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        Long l = timestamp;
        long l2 = resolvedTimeStamp = l == null ? System.currentTimeMillis() : l;
        if (this.sampler.sample()) {
            LogEvent log = this.createLog(level, message, throwable, attributes, tags2, resolvedTimeStamp);
            this.writer.write(log);
        }
        if (level >= 6) {
            GlobalRum.get().addError(message, RumErrorSource.LOGGER, throwable, attributes);
        }
    }

    private final LogEvent createLog(int level, String message, Throwable throwable, Map<String, ? extends Object> attributes, Set<String> tags2, long timestamp) {
        boolean bl = this.bundleWithRum;
        boolean bl2 = this.bundleWithTraces;
        return LogGenerator.generateLog$default(this.logGenerator, level, message, throwable, attributes, tags2, timestamp, null, bl2, bl, null, null, 1600, null);
    }
}

