/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.domain;

import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.log.internal.user.UserInfoProvider;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.internal.domain.RumContext;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0084\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\n\b\u0002\u0010/\u001a\u0004\u0018\u0001002\n\b\u0002\u00101\u001a\u0004\u0018\u000102J<\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0001042\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u00107\u001a\u0004\u0018\u0001082\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u00101\u001a\u000202H\u0002J\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00030<2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0002J\u0012\u0010=\u001a\u00020>2\b\u0010/\u001a\u0004\u0018\u000100H\u0002R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006@"}, d2={"Lcom/datadog/android/log/internal/domain/LogGenerator;", "", "serviceName", "", "loggerName", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "userInfoProvider", "Lcom/datadog/android/log/internal/user/UserInfoProvider;", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "sdkVersion", "envName", "appVersion", "(Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/log/internal/user/UserInfoProvider;Lcom/datadog/android/core/internal/time/TimeProvider;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "appVersionTag", "envTag", "getEnvTag$dd_sdk_android_release", "()Ljava/lang/String;", "getLoggerName$dd_sdk_android_release", "getNetworkInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "getSdkVersion$dd_sdk_android_release", "getServiceName$dd_sdk_android_release", "simpleDateFormat", "Ljava/text/SimpleDateFormat;", "getTimeProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/time/TimeProvider;", "getUserInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/user/UserInfoProvider;", "generateLog", "Lcom/datadog/android/log/model/LogEvent;", "level", "", "message", "throwable", "", "attributes", "", "tags", "", "timestamp", "", "threadName", "bundleWithTraces", "", "bundleWithRum", "userInfo", "Lcom/datadog/android/core/model/UserInfo;", "networkInfo", "Lcom/datadog/android/core/model/NetworkInfo;", "resolveAttributes", "", "resolveLogLevelStatus", "Lcom/datadog/android/log/model/LogEvent$Status;", "resolveNetworkInfo", "Lcom/datadog/android/log/model/LogEvent$Network;", "resolveSimCarrier", "Lcom/datadog/android/log/model/LogEvent$SimCarrier;", "resolveTags", "", "resolveUserInfo", "Lcom/datadog/android/log/model/LogEvent$Usr;", "Companion", "dd-sdk-android_release"})
public final class LogGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serviceName;
    @NotNull
    private final String loggerName;
    @Nullable
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final UserInfoProvider userInfoProvider;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final SimpleDateFormat simpleDateFormat;
    @Nullable
    private final String envTag;
    @Nullable
    private final String appVersionTag;
    @NotNull
    public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final int CRASH = 9;

    /*
     * WARNING - void declaration
     */
    public LogGenerator(@NotNull String serviceName, @NotNull String loggerName, @Nullable NetworkInfoProvider networkInfoProvider, @NotNull UserInfoProvider userInfoProvider, @NotNull TimeProvider timeProvider, @NotNull String sdkVersion, @NotNull String envName, @NotNull String appVersion) {
        void $this$simpleDateFormat_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter((Object)userInfoProvider, (String)"userInfoProvider");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
        this.serviceName = serviceName;
        this.loggerName = loggerName;
        this.networkInfoProvider = networkInfoProvider;
        this.userInfoProvider = userInfoProvider;
        this.timeProvider = timeProvider;
        this.sdkVersion = sdkVersion;
        Object object = new SimpleDateFormat(ISO_8601, Locale.US);
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat simpleDateFormat = object;
        LogGenerator logGenerator = this;
        boolean bl3 = false;
        $this$simpleDateFormat_u24lambda_u2d0.setTimeZone(TimeZone.getTimeZone("UTC"));
        Unit unit = Unit.INSTANCE;
        logGenerator.simpleDateFormat = object;
        object = envName;
        bl = false;
        this.envTag = object.length() > 0 ? Intrinsics.stringPlus((String)"env:", (Object)envName) : (String)null;
        object = appVersion;
        bl = false;
        this.appVersionTag = object.length() > 0 ? Intrinsics.stringPlus((String)"version:", (Object)appVersion) : (String)null;
    }

    @NotNull
    public final String getServiceName$dd_sdk_android_release() {
        return this.serviceName;
    }

    @NotNull
    public final String getLoggerName$dd_sdk_android_release() {
        return this.loggerName;
    }

    @Nullable
    public final NetworkInfoProvider getNetworkInfoProvider$dd_sdk_android_release() {
        return this.networkInfoProvider;
    }

    @NotNull
    public final UserInfoProvider getUserInfoProvider$dd_sdk_android_release() {
        return this.userInfoProvider;
    }

    @NotNull
    public final TimeProvider getTimeProvider$dd_sdk_android_release() {
        return this.timeProvider;
    }

    @NotNull
    public final String getSdkVersion$dd_sdk_android_release() {
        return this.sdkVersion;
    }

    @Nullable
    public final String getEnvTag$dd_sdk_android_release() {
        return this.envTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LogEvent generateLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags2, long timestamp, @Nullable String threadName, boolean bundleWithTraces, boolean bundleWithRum, @Nullable UserInfo userInfo, @Nullable NetworkInfo networkInfo) {
        LogEvent.Error error;
        Object object;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        long resolvedTimestamp = timestamp + this.timeProvider.getServerOffsetMillis();
        Map<String, Object> combinedAttributes = this.resolveAttributes(attributes, bundleWithTraces, bundleWithRum);
        SimpleDateFormat simpleDateFormat = this.simpleDateFormat;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (simpleDateFormat) {
            boolean bl3 = false;
            object = this.simpleDateFormat.format(new Date(resolvedTimestamp));
        }
        String formattedDate = object;
        Set<String> combinedTags = this.resolveTags(tags2);
        object = throwable;
        if (object == null) {
            error = null;
        } else {
            Object bl3 = object;
            boolean bl4 = false;
            boolean bl5 = false;
            Object it = bl3;
            boolean bl6 = false;
            String string = it.getClass().getCanonicalName();
            String kind = string == null ? it.getClass().getSimpleName() : string;
            string = ExceptionsKt.stackTraceToString((Throwable)it);
            String string2 = ((Throwable)it).getMessage();
            error = new LogEvent.Error(kind, string2, string);
        }
        LogEvent.Error error2 = error;
        LogEvent.Usr usr = this.resolveUserInfo(userInfo);
        LogEvent.Network network = this.resolveNetworkInfo(networkInfo);
        String string = threadName;
        LogEvent.Logger loggerInfo = new LogEvent.Logger(this.loggerName, string == null ? Thread.currentThread().getName() : string, this.sdkVersion);
        string = this.serviceName;
        LogEvent.Status status = this.resolveLogLevelStatus(level);
        String string3 = CollectionsKt.joinToString$default((Iterable)combinedTags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Intrinsics.checkNotNullExpressionValue((Object)formattedDate, (String)"formattedDate");
        return new LogEvent(status, string, message, formattedDate, loggerInfo, usr, network, error2, string3, combinedAttributes);
    }

    public static /* synthetic */ LogEvent generateLog$default(LogGenerator logGenerator, int n, String string, Throwable throwable, Map map, Set set, long l, String string2, boolean bl, boolean bl2, UserInfo userInfo, NetworkInfo networkInfo, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            string2 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = true;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x200) != 0) {
            userInfo = null;
        }
        if ((n2 & 0x400) != 0) {
            networkInfo = null;
        }
        return logGenerator.generateLog(n, string, throwable, map, set, l, string2, bl, bl2, userInfo, networkInfo);
    }

    private final LogEvent.Network resolveNetworkInfo(NetworkInfo networkInfo) {
        LogEvent.Network network;
        Object object;
        NetworkInfo resolvedNetworkInfo;
        NetworkInfo networkInfo2 = networkInfo;
        networkInfo2 = resolvedNetworkInfo = networkInfo2 == null ? ((object = this.networkInfoProvider) == null ? null : object.getLatestNetworkInfo()) : networkInfo2;
        if (networkInfo2 == null) {
            network = null;
        } else {
            object = networkInfo2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            Long l = ((NetworkInfo)it).getStrength();
            String string = l == null ? null : l.toString();
            l = ((NetworkInfo)it).getDownKbps();
            String string2 = l == null ? null : l.toString();
            l = ((NetworkInfo)it).getUpKbps();
            String string3 = l == null ? null : l.toString();
            network = new LogEvent.Network(new LogEvent.Client(this.resolveSimCarrier((NetworkInfo)it), string, string2, string3, ((NetworkInfo)it).getConnectivity().toString()));
        }
        return network;
    }

    private final LogEvent.Usr resolveUserInfo(UserInfo userInfo) {
        Object object = userInfo;
        UserInfo resolvedUserInfo = object == null ? this.userInfoProvider.getUserInfo() : object;
        object = resolvedUserInfo.getName();
        String string = resolvedUserInfo.getEmail();
        String string2 = resolvedUserInfo.getId();
        Map<String, Object> map = resolvedUserInfo.getAdditionalProperties();
        return new LogEvent.Usr(string2, (String)object, string, map);
    }

    private final Set<String> resolveTags(Set<String> tags2) {
        boolean bl = false;
        Object object = new LinkedHashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        Set $this$resolveTags_u24lambda_u2d4 = object;
        boolean bl4 = false;
        $this$resolveTags_u24lambda_u2d4.addAll((Collection)tags2);
        Set combinedTags = object;
        object = this.envTag;
        if (object != null) {
            Object object2 = object;
            bl3 = false;
            boolean bl5 = false;
            Object it = object2;
            boolean bl6 = false;
            combinedTags.add(it);
        }
        object = this.appVersionTag;
        if (object != null) {
            Object object3 = object;
            bl3 = false;
            boolean bl7 = false;
            Object it = object3;
            boolean bl8 = false;
            combinedTags.add(it);
        }
        return combinedTags;
    }

    private final Map<String, Object> resolveAttributes(Map<String, ? extends Object> attributes, boolean bundleWithTraces, boolean bundleWithRum) {
        String string;
        boolean bl = false;
        Map map = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map $this$resolveAttributes_u24lambda_u2d7 = map;
        boolean bl4 = false;
        $this$resolveAttributes_u24lambda_u2d7.putAll(attributes);
        Map combinedAttributes = map;
        if (bundleWithTraces && GlobalTracer.isRegistered()) {
            SpanContext activeContext;
            Tracer tracer = GlobalTracer.get();
            Object object = tracer.activeSpan();
            SpanContext spanContext = activeContext = object == null ? null : object.context();
            if (activeContext != null) {
                object = combinedAttributes;
                string = "dd.trace_id";
                String string2 = activeContext.toTraceId();
                boolean bl5 = false;
                object.put(string, string2);
                object = combinedAttributes;
                string = "dd.span_id";
                string2 = activeContext.toSpanId();
                bl5 = false;
                object.put(string, string2);
            }
        }
        if (bundleWithRum && GlobalRum.isRegistered()) {
            RumContext activeContext = GlobalRum.INSTANCE.getRumContext$dd_sdk_android_release();
            Map map2 = combinedAttributes;
            String string3 = "application_id";
            string = activeContext.getApplicationId();
            boolean bl6 = false;
            map2.put(string3, string);
            map2 = combinedAttributes;
            string3 = "session_id";
            string = activeContext.getSessionId();
            bl6 = false;
            map2.put(string3, string);
            map2 = combinedAttributes;
            string3 = "view.id";
            string = activeContext.getViewId();
            bl6 = false;
            map2.put(string3, string);
            map2 = combinedAttributes;
            string3 = "user_action.id";
            string = activeContext.getActionId();
            bl6 = false;
            map2.put(string3, string);
        }
        return combinedAttributes;
    }

    private final LogEvent.Status resolveLogLevelStatus(int level) {
        LogEvent.Status status;
        int n = level;
        switch (n) {
            case 7: {
                status = LogEvent.Status.CRITICAL;
                break;
            }
            case 6: {
                status = LogEvent.Status.ERROR;
                break;
            }
            case 5: {
                status = LogEvent.Status.WARN;
                break;
            }
            case 4: {
                status = LogEvent.Status.INFO;
                break;
            }
            case 3: {
                status = LogEvent.Status.DEBUG;
                break;
            }
            case 2: {
                status = LogEvent.Status.TRACE;
                break;
            }
            case 9: {
                status = LogEvent.Status.EMERGENCY;
                break;
            }
            default: {
                status = LogEvent.Status.DEBUG;
            }
        }
        return status;
    }

    private final LogEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        LogEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            String string = l == null ? null : l.toString();
            simCarrier = new LogEvent.SimCarrier(string, networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/log/internal/domain/LogGenerator$Companion;", "", "()V", "CRASH", "", "ISO_8601", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

