/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.datadog.android.core.internal.data.upload.UploadWorker;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"CANCEL_ERROR_MESSAGE", "", "DELAY_MS", "", "SETUP_ERROR_MESSAGE", "TAG_DATADOG_UPLOAD", "UPLOAD_WORKER_NAME", "UPLOAD_WORKER_WAS_SCHEDULED", "cancelUploadWorker", "", "context", "Landroid/content/Context;", "triggerUploadWorker", "dd-sdk-android_release"})
public final class WorkManagerUtilsKt {
    @NotNull
    public static final String CANCEL_ERROR_MESSAGE = "Error cancelling the UploadWorker";
    @NotNull
    public static final String SETUP_ERROR_MESSAGE = "Error while trying to setup the UploadWorker";
    @NotNull
    public static final String UPLOAD_WORKER_WAS_SCHEDULED = "UploadWorker was scheduled.";
    @NotNull
    public static final String UPLOAD_WORKER_NAME = "DatadogUploadWorker";
    @NotNull
    public static final String TAG_DATADOG_UPLOAD = "DatadogBackgroundUpload";
    public static final long DELAY_MS = 5000L;

    public static final void cancelUploadWorker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            WorkManager workManager = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
            WorkManager workManager2 = workManager;
            workManager2.cancelAllWorkByTag(TAG_DATADOG_UPLOAD);
        }
        catch (IllegalStateException e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), CANCEL_ERROR_MESSAGE, e, null, 4, null);
        }
    }

    public static final void triggerUploadWorker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            WorkManager workManager = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
            WorkManager workManager2 = workManager;
            Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
            Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n            .setRequiredNetworkType(NetworkType.CONNECTED)\n            .build()");
            Constraints constraints2 = constraints;
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(UploadWorker.class).setConstraints(constraints2)).addTag(TAG_DATADOG_UPLOAD)).setInitialDelay(5000L, TimeUnit.MILLISECONDS)).build();
            Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(UploadWorker::class.java)\n            .setConstraints(constraints)\n            .addTag(TAG_DATADOG_UPLOAD)\n            .setInitialDelay(DELAY_MS, TimeUnit.MILLISECONDS)\n            .build()");
            OneTimeWorkRequest uploadWorkRequest = (OneTimeWorkRequest)workRequest;
            workManager2.enqueueUniqueWork(UPLOAD_WORKER_NAME, ExistingWorkPolicy.REPLACE, uploadWorkRequest);
            Logger.i$default(RuntimeUtilsKt.getSdkLogger(), UPLOAD_WORKER_WAS_SCHEDULED, null, null, 6, null);
        }
        catch (IllegalStateException e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), SETUP_ERROR_MESSAGE, e, null, 4, null);
        }
    }
}

