/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.BuildConfig;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.logger.ConditionalLogHandler;
import com.datadog.android.log.internal.logger.LogcatLogHandler;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\b\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\b\u0010\u0010\u001a\u00020\u0007H\u0000\u001a\b\u0010\u0011\u001a\u00020\u0012H\u0000\u001a,\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"DEV_LOG_PREFIX", "", "SDK_LOGGER_NAME", "SDK_LOG_PREFIX", "WARN_DEPRECATED", "WARN_DEPRECATED_WITH_ALT", "devLogger", "Lcom/datadog/android/log/Logger;", "getDevLogger", "()Lcom/datadog/android/log/Logger;", "<set-?>", "sdkLogger", "getSdkLogger", "buildDevLogHandler", "Lcom/datadog/android/log/internal/logger/ConditionalLogHandler;", "buildDevLogger", "buildSdkLogger", "rebuildSdkLogger", "", "warnDeprecated", "target", "deprecatedSince", "removedInVersion", "alternative", "dd-sdk-android_release"})
public final class RuntimeUtilsKt {
    @NotNull
    public static final String SDK_LOG_PREFIX = "DD_LOG";
    @NotNull
    public static final String SDK_LOGGER_NAME = "sdkLogger";
    @NotNull
    public static final String DEV_LOG_PREFIX = "Datadog";
    @NotNull
    private static Logger sdkLogger = RuntimeUtilsKt.buildSdkLogger();
    @NotNull
    private static final Logger devLogger = RuntimeUtilsKt.buildDevLogger();
    @NotNull
    public static final String WARN_DEPRECATED = "%s has been deprecated since version %s, and will be removed in version %s.";
    @NotNull
    public static final String WARN_DEPRECATED_WITH_ALT = "%s has been deprecated since version %s, and will be removed in version %s. Please use %s instead";

    @NotNull
    public static final Logger getSdkLogger() {
        return sdkLogger;
    }

    public static final void rebuildSdkLogger() {
        sdkLogger = RuntimeUtilsKt.buildSdkLogger();
    }

    @NotNull
    public static final Logger buildSdkLogger() {
        Logger.Builder builder = new Logger.Builder();
        Boolean bl = BuildConfig.LOGCAT_ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"LOGCAT_ENABLED");
        return builder.setLogcatLogsEnabled(bl).setServiceName(SDK_LOG_PREFIX).setLoggerName(SDK_LOGGER_NAME).setBundleWithRumEnabled(false).setBundleWithTraceEnabled(false).setNetworkInfoEnabled(true).setInternal$dd_sdk_android_release(true).build();
    }

    @NotNull
    public static final Logger getDevLogger() {
        return devLogger;
    }

    private static final Logger buildDevLogger() {
        return new Logger(RuntimeUtilsKt.buildDevLogHandler());
    }

    @NotNull
    public static final ConditionalLogHandler buildDevLogHandler() {
        return new ConditionalLogHandler(new LogcatLogHandler(DEV_LOG_PREFIX, false), (Function2<? super Integer, ? super Throwable, Boolean>)((Function2)buildDevLogHandler.1.INSTANCE));
    }

    public static final void warnDeprecated(@NotNull String target, @NotNull String deprecatedSince, @NotNull String removedInVersion, @Nullable String alternative) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)deprecatedSince, (String)"deprecatedSince");
        Intrinsics.checkNotNullParameter((Object)removedInVersion, (String)"removedInVersion");
        if (alternative == null) {
            String string = WARN_DEPRECATED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target, deprecatedSince, removedInVersion};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.w$default(devLogger, string2, null, null, 6, null);
        } else {
            String string = WARN_DEPRECATED_WITH_ALT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target, deprecatedSince, removedInVersion, alternative};
            boolean bl = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.w$default(devLogger, string3, null, null, 6, null);
        }
    }

    public static /* synthetic */ void warnDeprecated$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        RuntimeUtilsKt.warnDeprecated(string, string2, string3, string4);
    }
}

