/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.thread;

import com.datadog.android.core.internal.thread.ThreadExtKt;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"MAX_SLEEP_DURATION_IN_MS", "", "isIdle", "", "Ljava/util/concurrent/ThreadPoolExecutor;", "waitToIdle", "timeoutInMs", "dd-sdk-android_release"})
public final class ThreadPoolExecutorExtKt {
    public static final long MAX_SLEEP_DURATION_IN_MS = 10L;

    public static final boolean waitToIdle(@NotNull ThreadPoolExecutor $this$waitToIdle, long timeoutInMs) {
        Intrinsics.checkNotNullParameter((Object)$this$waitToIdle, (String)"<this>");
        long startTime = System.nanoTime();
        long timeoutInNs = TimeUnit.MILLISECONDS.toNanos(timeoutInMs);
        long sleepDurationInMs = RangesKt.coerceIn((long)timeoutInMs, (long)0L, (long)10L);
        boolean interrupted = false;
        do {
            if (ThreadPoolExecutorExtKt.isIdle($this$waitToIdle)) {
                return true;
            }
            interrupted = ThreadExtKt.sleepSafe(sleepDurationInMs);
        } while (System.nanoTime() - startTime < timeoutInNs && !interrupted);
        return ThreadPoolExecutorExtKt.isIdle($this$waitToIdle);
    }

    public static final boolean isIdle(@NotNull ThreadPoolExecutor $this$isIdle) {
        Intrinsics.checkNotNullParameter((Object)$this$isIdle, (String)"<this>");
        return $this$isIdle.getTaskCount() - $this$isIdle.getCompletedTaskCount() <= 0L;
    }
}

