/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.thread;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"sleepSafe", "", "durationMs", "", "dd-sdk-android_release"})
public final class ThreadExtKt {
    public static final boolean sleepSafe(long durationMs) {
        try {
            Thread.sleep(durationMs);
            return false;
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException se) {
                Logger.e$default(RuntimeUtilsKt.getSdkLogger(), "Thread was unable to set its own interrupted state", se, null, 4, null);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            Logger.w$default(RuntimeUtilsKt.getSdkLogger(), "Thread tried to sleep for a negative amount of time", e, null, 4, null);
            return false;
        }
    }
}

