/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.system;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.datadog.android.core.internal.receiver.ThreadSafeReceiver;
import com.datadog.android.core.internal.system.SystemInfo;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/system/BroadcastReceiverSystemInfoProvider;", "Lcom/datadog/android/core/internal/receiver/ThreadSafeReceiver;", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "()V", "systemInfo", "Lcom/datadog/android/core/internal/system/SystemInfo;", "getLatestSystemInfo", "handleBatteryIntent", "", "intent", "Landroid/content/Intent;", "handlePowerSaveIntent", "context", "Landroid/content/Context;", "onReceive", "register", "registerIntentFilter", "action", "", "unregister", "dd-sdk-android_release"})
public final class BroadcastReceiverSystemInfoProvider
extends ThreadSafeReceiver
implements SystemInfoProvider {
    @NotNull
    private SystemInfo systemInfo = new SystemInfo(null, 0, false, 7, null);

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        String action;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent2 = intent;
        String string = action = intent2 == null ? null : intent2.getAction();
        if (Intrinsics.areEqual((Object)action, (Object)"android.intent.action.BATTERY_CHANGED")) {
            this.handleBatteryIntent(intent);
        } else if (Intrinsics.areEqual((Object)action, (Object)"android.os.action.POWER_SAVE_MODE_CHANGED")) {
            this.handlePowerSaveIntent(context);
        } else {
            Logger.d$default(RuntimeUtilsKt.getSdkLogger(), "Received unknown broadcast intent: [" + action + ']', null, null, 6, null);
        }
    }

    @Override
    public void register(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.registerIntentFilter(context, "android.intent.action.BATTERY_CHANGED");
        if (Build.VERSION.SDK_INT >= 21) {
            this.registerIntentFilter(context, "android.os.action.POWER_SAVE_MODE_CHANGED");
        }
    }

    @Override
    public void unregister(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.unregisterReceiver(context);
    }

    @Override
    @NotNull
    public SystemInfo getLatestSystemInfo() {
        return this.systemInfo;
    }

    private final void registerIntentFilter(Context context, String action) {
        IntentFilter filter = new IntentFilter();
        filter.addAction(action);
        Intent intent = this.registerReceiver(context, filter);
        if (intent != null) {
            Intent intent2 = intent;
            boolean bl = false;
            boolean bl2 = false;
            Intent it = intent2;
            boolean bl3 = false;
            this.onReceive(context, it);
        }
    }

    private final void handleBatteryIntent(Intent intent) {
        int status = intent.getIntExtra("status", 1);
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", 100);
        SystemInfo.BatteryStatus resolvedBatteryStatus = SystemInfo.BatteryStatus.Companion.fromAndroidStatus(status);
        int resolvedBatteryLevel = level * 100 / scale;
        this.systemInfo = SystemInfo.copy$default(this.systemInfo, resolvedBatteryStatus, resolvedBatteryLevel, false, 4, null);
    }

    private final void handlePowerSaveIntent(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl;
            PowerManager powerManager;
            Object object = context.getSystemService("power");
            PowerManager powerManager2 = powerManager = object instanceof PowerManager ? (PowerManager)object : null;
            boolean powerSaveMode = powerManager2 == null ? false : (bl = powerManager2.isPowerSaveMode());
            this.systemInfo = SystemInfo.copy$default(this.systemInfo, null, 0, powerSaveMode, 3, null);
        }
    }
}

