/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002%&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\rH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000fH\u0002J\b\u0010#\u001a\u00020 H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator;", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "rootDir", "Ljava/io/File;", "config", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Ljava/io/File;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/log/Logger;)V", "fileFilter", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$BatchFileFilter;", "previousFile", "previousFileItemCount", "", "recentReadDelayMs", "", "recentWriteDelayMs", "createNewFile", "deleteObsoleteFiles", "", "freeSpaceIfNeeded", "getAllFiles", "", "getFlushableFiles", "getReadableFile", "excludeFiles", "", "getReusableWritableFile", "dataSize", "getRootDir", "getWritableFile", "isFileRecent", "", "file", "delayMs", "isRootDirValid", "listSortedBatchFiles", "BatchFileFilter", "Companion", "dd-sdk-android_release"})
public final class BatchFileOrchestrator
implements FileOrchestrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDir;
    @NotNull
    private final FilePersistenceConfig config;
    @NotNull
    private final Logger internalLogger;
    @NotNull
    private final BatchFileFilter fileFilter;
    private final long recentReadDelayMs;
    private final long recentWriteDelayMs;
    @Nullable
    private File previousFile;
    private int previousFileItemCount;
    @NotNull
    private static final Regex batchFileNameRegex = new Regex("\\d+");
    @NotNull
    public static final String ERROR_ROOT_NOT_WRITABLE = "The provided root dir is not writable: %s";
    @NotNull
    public static final String ERROR_ROOT_NOT_DIR = "The provided root file is not a directory: %s";
    @NotNull
    public static final String ERROR_CANT_CREATE_ROOT = "The provided root file can't be created: %s";
    @NotNull
    public static final String ERROR_LARGE_DATA = "Can't write data with size %d (max item size is %d)";
    @NotNull
    public static final String ERROR_DISK_FULL = "Too much disk space used (%d/%d): cleaning up to free %d bytes\u2026";

    public BatchFileOrchestrator(@NotNull File rootDir, @NotNull FilePersistenceConfig config, @NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.rootDir = rootDir;
        this.config = config;
        this.internalLogger = internalLogger;
        this.fileFilter = new BatchFileFilter();
        this.recentReadDelayMs = (long)((double)this.config.getRecentDelayMs() * 1.05);
        this.recentWriteDelayMs = (long)((double)this.config.getRecentDelayMs() * 0.95);
    }

    @Override
    @Nullable
    public File getWritableFile(int dataSize) {
        File reusableFile;
        if (!this.isRootDirValid()) {
            return null;
        }
        if ((long)dataSize > this.config.getMaxItemSize()) {
            String string = ERROR_LARGE_DATA;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{dataSize, this.config.getMaxItemSize()};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string2, null, null, 6, null);
            return null;
        }
        this.deleteObsoleteFiles();
        this.freeSpaceIfNeeded();
        File file = reusableFile = this.getReusableWritableFile(dataSize);
        return file == null ? this.createNewFile() : file;
    }

    @Override
    @Nullable
    public File getReadableFile(@NotNull Set<? extends File> excludeFiles) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
            if (!this.isRootDirValid()) {
                return null;
            }
            this.deleteObsoleteFiles();
            List<File> files = this.listSortedBatchFiles();
            Iterable $this$firstOrNull$iv = files;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!(!excludeFiles.contains(it) && !this.isFileRecent(it, this.recentReadDelayMs))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public List<File> getAllFiles() {
        if (!this.isRootDirValid()) {
            return CollectionsKt.emptyList();
        }
        return this.listSortedBatchFiles();
    }

    @Override
    @NotNull
    public List<File> getFlushableFiles() {
        return this.getAllFiles();
    }

    @Override
    @Nullable
    public File getRootDir() {
        if (!this.isRootDirValid()) {
            return null;
        }
        return this.rootDir;
    }

    private final boolean isRootDirValid() {
        if (FileExtKt.existsSafe(this.rootDir)) {
            if (this.rootDir.isDirectory()) {
                if (FileExtKt.canWriteSafe(this.rootDir)) {
                    return true;
                }
                String string = ERROR_ROOT_NOT_WRITABLE;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{this.rootDir.getPath()};
                boolean bl = false;
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
                Logger.e$default(this.internalLogger, string2, null, null, 6, null);
                return false;
            }
            String string = ERROR_ROOT_NOT_DIR;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.rootDir.getPath()};
            boolean bl = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string3, null, null, 6, null);
            return false;
        }
        if (FileExtKt.mkdirsSafe(this.rootDir)) {
            return true;
        }
        String string = ERROR_CANT_CREATE_ROOT;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{this.rootDir.getPath()};
        boolean bl = false;
        String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, this, *args)");
        Logger.e$default(this.internalLogger, string4, null, null, 6, null);
        return false;
    }

    private final File createNewFile() {
        File newFile;
        String newFileName = String.valueOf(System.currentTimeMillis());
        this.previousFile = newFile = new File(this.rootDir, newFileName);
        this.previousFileItemCount = 1;
        return newFile;
    }

    private final File getReusableWritableFile(int dataSize) {
        File file;
        boolean hasSlotForMore;
        List<File> files = this.listSortedBatchFiles();
        File file2 = (File)CollectionsKt.lastOrNull(files);
        if (file2 == null) {
            return null;
        }
        File lastFile = file2;
        File lastKnownFile = this.previousFile;
        int lastKnownFileItemCount = this.previousFileItemCount;
        if (!Intrinsics.areEqual((Object)lastKnownFile, (Object)lastFile)) {
            return null;
        }
        boolean isRecentEnough = this.isFileRecent(lastFile, this.recentWriteDelayMs);
        boolean hasRoomForMore = FileExtKt.lengthSafe(lastFile) + (long)dataSize < this.config.getMaxBatchSize();
        boolean bl = hasSlotForMore = lastKnownFileItemCount < this.config.getMaxItemsPerBatch();
        if (isRecentEnough && hasRoomForMore && hasSlotForMore) {
            this.previousFileItemCount = lastKnownFileItemCount + 1;
            file = lastFile;
        } else {
            file = null;
        }
        return file;
    }

    private final boolean isFileRecent(File file, long delayMs) {
        long now = System.currentTimeMillis();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        boolean bl = false;
        long fileTimestamp = Long.parseLong(string);
        return fileTimestamp >= now - delayMs;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteObsoleteFiles() {
        void $this$forEach$iv;
        List<File> files = this.listSortedBatchFiles();
        long threshold = System.currentTimeMillis() - this.config.getOldFileThreshold();
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)((Function1)new Function1<File, Boolean>(threshold){
            final /* synthetic */ long $threshold;
            {
                this.$threshold = $threshold;
                super(1);
            }

            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                boolean bl = false;
                return Long.parseLong(string) < this.$threshold;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void freeSpaceIfNeeded() {
        Object[] it;
        boolean bl;
        List<File> files = this.listSortedBatchFiles();
        Iterable iterable = files;
        boolean bl2 = false;
        long l = 0L;
        for (Object object : iterable) {
            File file = (File)object;
            long l2 = l;
            bl = false;
            long l3 = FileExtKt.lengthSafe((File)it);
            l = l2 + l3;
        }
        long sizeOnDisk = l;
        long maxDiskSpace = this.config.getMaxDiskSpace();
        long sizeToFree = sizeOnDisk - maxDiskSpace;
        if (sizeToFree > 0L) {
            void $this$fold$iv;
            Object object;
            Object object2 = ERROR_DISK_FULL;
            object = Locale.US;
            it = new Object[]{sizeOnDisk, maxDiskSpace, sizeToFree};
            bl = false;
            String string = String.format(object, (String)object2, Arrays.copyOf(it, it.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string, null, null, 6, null);
            object2 = files;
            long initial$iv = sizeToFree;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                long l4;
                File file = (File)element$iv;
                long remainingSizeToFree = accumulator$iv;
                boolean bl3 = false;
                if (remainingSizeToFree > 0L) {
                    void file2;
                    long fileSize = FileExtKt.lengthSafe((File)file2);
                    l4 = FileExtKt.deleteSafe((File)file2) ? remainingSizeToFree - fileSize : remainingSizeToFree;
                } else {
                    l4 = remainingSizeToFree;
                }
                accumulator$iv = l4;
            }
        }
    }

    private final List<File> listSortedBatchFiles() {
        File[] $this$orEmpty$iv = FileExtKt.listFilesSafe(this.rootDir, this.fileFilter);
        boolean $i$f$orEmpty = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            fileArray = new File[]{};
        }
        return ArraysKt.sorted((Comparable[])fileArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$BatchFileFilter;", "Ljava/io/FileFilter;", "()V", "accept", "", "file", "Ljava/io/File;", "dd-sdk-android_release"})
    public static final class BatchFileFilter
    implements FileFilter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean accept(@Nullable File file) {
            if (file == null) return false;
            if (!FileExtKt.isFileSafe(file)) return false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            CharSequence charSequence = string;
            Regex regex = batchFileNameRegex;
            boolean bl = false;
            if (!regex.matches(charSequence)) return false;
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$Companion;", "", "()V", "ERROR_CANT_CREATE_ROOT", "", "ERROR_DISK_FULL", "ERROR_LARGE_DATA", "ERROR_ROOT_NOT_DIR", "ERROR_ROOT_NOT_WRITABLE", "batchFileNameRegex", "Lkotlin/text/Regex;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

