/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileHandler;
import com.datadog.android.log.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J*\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileHandler;", "Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/log/Logger;)V", "delete", "", "target", "Ljava/io/File;", "lockFileAndWriteData", "", "file", "append", "separator", "", "data", "moveFile", "destDir", "moveFiles", "srcDir", "readData", "prefix", "suffix", "readFileData", "writeData", "Companion", "dd-sdk-android_release"})
public final class BatchFileHandler
implements FileHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger internalLogger;
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @NotNull
    public static final String ERROR_WRITE = "Unable to write data to file: %s";
    @NotNull
    public static final String ERROR_READ = "Unable to read data from file: %s";
    @NotNull
    public static final String ERROR_DELETE = "Unable to delete file: %s";
    @NotNull
    public static final String INFO_MOVE_NO_SRC = "Unable to move files; source directory does not exist: %s";
    @NotNull
    public static final String ERROR_MOVE_NOT_DIR = "Unable to move files; file is not a directory: %s";
    @NotNull
    public static final String ERROR_MOVE_NO_DST = "Unable to move files; could not create directory: %s";

    public BatchFileHandler(@NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Override
    public boolean writeData(@NotNull File file, @NotNull byte[] data, boolean append, @Nullable byte[] separator) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.lockFileAndWriteData(file, append, separator, data);
            bl = true;
        }
        catch (IOException e) {
            String string = ERROR_WRITE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            boolean bl2 = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string2, e, null, 4, null);
            bl = false;
        }
        catch (SecurityException e) {
            String string = ERROR_WRITE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            boolean bl3 = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string3, e, null, 4, null);
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public byte[] readData(@NotNull File file, @Nullable byte[] prefix, @Nullable byte[] suffix) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            byArray = prefix;
            byte[] byArray2 = byArray == null ? EMPTY_BYTE_ARRAY : byArray;
            byArray = suffix;
            byArray = this.readFileData(file, byArray2, byArray == null ? EMPTY_BYTE_ARRAY : byArray);
        }
        catch (IOException e) {
            String string = ERROR_READ;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string2, e, null, 4, null);
            byArray = EMPTY_BYTE_ARRAY;
        }
        catch (SecurityException e) {
            String string = ERROR_READ;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            boolean bl = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string3, e, null, 4, null);
            byArray = EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    @Override
    public boolean delete(@NotNull File target) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        try {
            bl = FilesKt.deleteRecursively((File)target);
        }
        catch (IOException e) {
            String string = ERROR_DELETE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target.getPath()};
            boolean bl2 = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string2, e, null, 4, null);
            bl = false;
        }
        catch (SecurityException e) {
            String string = ERROR_DELETE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{target.getPath()};
            boolean bl3 = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string3, e, null, 4, null);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean moveFiles(@NotNull File srcDir, @NotNull File destDir) {
        boolean bl;
        block8: {
            File[] srcFiles;
            Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
            Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
            if (!srcDir.exists()) {
                String string = INFO_MOVE_NO_SRC;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{srcDir.getPath()};
                boolean bl2 = false;
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
                Logger.i$default(this.internalLogger, string2, null, null, 6, null);
                return true;
            }
            if (!srcDir.isDirectory()) {
                String string = ERROR_MOVE_NOT_DIR;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{srcDir.getPath()};
                boolean bl3 = false;
                String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
                Logger.e$default(this.internalLogger, string3, null, null, 6, null);
                return false;
            }
            if (!destDir.exists()) {
                if (!FileExtKt.mkdirsSafe(destDir)) {
                    String string = ERROR_MOVE_NO_DST;
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{srcDir.getPath()};
                    boolean bl4 = false;
                    String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, this, *args)");
                    Logger.e$default(this.internalLogger, string4, null, null, 6, null);
                    return false;
                }
            } else if (!destDir.isDirectory()) {
                String string = ERROR_MOVE_NOT_DIR;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{destDir.getPath()};
                boolean bl5 = false;
                String string5 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(locale, this, *args)");
                Logger.e$default(this.internalLogger, string5, null, null, 6, null);
                return false;
            }
            File[] $this$orEmpty$iv = srcDir.listFiles();
            boolean $i$f$orEmpty = false;
            File[] fileArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                fileArray = new File[]{};
            }
            File[] $this$all$iv = srcFiles = fileArray;
            boolean $i$f$all = false;
            File[] fileArray2 = $this$all$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = fileArray2[i];
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (this.moveFile(file, destDir)) continue;
                bl = false;
                break block8;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockFileAndWriteData(File file, boolean append, byte[] separator, byte[] data) {
        Closeable closeable = new FileOutputStream(file, append);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl3 = false;
            FileLock fileLock = outputStream.getChannel().lock();
            Intrinsics.checkNotNullExpressionValue((Object)fileLock, (String)"outputStream.channel.lock()");
            FileLock $this$use$iv = fileLock;
            boolean $i$f$use = false;
            try {
                FileLock it = $this$use$iv;
                boolean bl4 = false;
                if (file.length() > 0L && separator != null) {
                    outputStream.write(separator);
                }
                outputStream.write(data);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.release();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] readFileData(File file, byte[] prefix, byte[] suffix) {
        byte[] byArray;
        int inputLength = (int)file.length();
        int outputLength = inputLength + prefix.length + suffix.length;
        byte[] result = new byte[outputLength];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        int offset = 0;
        offset = prefix.length;
        int remaining = 0;
        Object object = file;
        int n = 0;
        object = new FileInputStream((File)object);
        n = 0;
        boolean bl = false;
        Throwable throwable = null;
        try {
            int read2;
            FileInputStream it = (FileInputStream)object;
            boolean bl2 = false;
            for (remaining = inputLength; remaining > 0 && (read2 = it.read(result, offset, remaining)) >= 0; remaining -= read2) {
                offset += read2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        System.arraycopy(suffix, 0, result, offset, suffix.length);
        if (result.length == (offset += suffix.length)) {
            byArray = result;
        } else {
            object = result;
            n = offset;
            boolean bl3 = false;
            byte[] byArray2 = Arrays.copyOf((byte[])object, n);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        }
        return byArray;
    }

    private final boolean moveFile(File file, File destDir) {
        File destFile = new File(destDir, file.getName());
        return FileExtKt.renameToSafe(file, destFile);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileHandler$Companion;", "", "()V", "EMPTY_BYTE_ARRAY", "", "ERROR_DELETE", "", "ERROR_MOVE_NOT_DIR", "ERROR_MOVE_NO_DST", "ERROR_READ", "ERROR_WRITE", "INFO_MOVE_NO_SRC", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

