/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.persistence.PayloadDecoration;
import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.core.internal.persistence.SerializerKt;
import com.datadog.android.core.internal.persistence.file.FileHandler;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.log.Logger;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010$\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileDataWriter;", "T", "", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "serializer", "Lcom/datadog/android/core/internal/persistence/Serializer;", "decoration", "Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "handler", "Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/Serializer;Lcom/datadog/android/core/internal/persistence/PayloadDecoration;Lcom/datadog/android/core/internal/persistence/file/FileHandler;Lcom/datadog/android/log/Logger;)V", "getDecoration$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "getFileOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getHandler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "getInternalLogger$dd_sdk_android_release", "()Lcom/datadog/android/log/Logger;", "getSerializer$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/Serializer;", "consume", "", "data", "(Ljava/lang/Object;)V", "onDataWriteFailed", "onDataWriteFailed$dd_sdk_android_release", "onDataWritten", "rawData", "", "onDataWritten$dd_sdk_android_release", "(Ljava/lang/Object;[B)V", "write", "element", "", "writeData", "", "byteArray", "dd-sdk-android_release"})
public class BatchFileDataWriter<T>
implements DataWriter<T> {
    @NotNull
    private final FileOrchestrator fileOrchestrator;
    @NotNull
    private final Serializer<T> serializer;
    @NotNull
    private final PayloadDecoration decoration;
    @NotNull
    private final FileHandler handler;
    @NotNull
    private final Logger internalLogger;

    public BatchFileDataWriter(@NotNull FileOrchestrator fileOrchestrator, @NotNull Serializer<T> serializer, @NotNull PayloadDecoration decoration, @NotNull FileHandler handler, @NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"fileOrchestrator");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.fileOrchestrator = fileOrchestrator;
        this.serializer = serializer;
        this.decoration = decoration;
        this.handler = handler;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_release() {
        return this.fileOrchestrator;
    }

    @NotNull
    public final Serializer<T> getSerializer$dd_sdk_android_release() {
        return this.serializer;
    }

    @NotNull
    public final PayloadDecoration getDecoration$dd_sdk_android_release() {
        return this.decoration;
    }

    @NotNull
    public final FileHandler getHandler$dd_sdk_android_release() {
        return this.handler;
    }

    @NotNull
    public final Logger getInternalLogger$dd_sdk_android_release() {
        return this.internalLogger;
    }

    @Override
    public void write(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.consume(element);
    }

    @Override
    public void write(@NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.consume(it);
        }
    }

    public void onDataWritten$dd_sdk_android_release(@NotNull T data, @NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
    }

    public void onDataWriteFailed$dd_sdk_android_release(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void consume(T data) {
        byte[] byArray = SerializerKt.serializeToByteArray(this.serializer, data, this.internalLogger);
        if (byArray == null) {
            return;
        }
        byte[] byteArray = byArray;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            boolean success = this.writeData(byteArray);
            if (success) {
                this.onDataWritten$dd_sdk_android_release(data, byteArray);
            } else {
                this.onDataWriteFailed$dd_sdk_android_release(data);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean writeData(byte[] byteArray) {
        File file = this.fileOrchestrator.getWritableFile(byteArray.length);
        if (file == null) {
            return false;
        }
        File file2 = file;
        return this.handler.writeData(file2, byteArray, true, this.decoration.getSeparatorBytes());
    }
}

