/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net.info;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.log.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0001\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/core/internal/net/info/CallbackNetworkInfoProvider;", "Landroid/net/ConnectivityManager$NetworkCallback;", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "dataWriter", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/core/model/NetworkInfo;", "(Lcom/datadog/android/core/internal/persistence/DataWriter;)V", "value", "lastNetworkInfo", "setLastNetworkInfo", "(Lcom/datadog/android/core/model/NetworkInfo;)V", "getLatestNetworkInfo", "getNetworkType", "Lcom/datadog/android/core/model/NetworkInfo$Connectivity;", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "onCapabilitiesChanged", "", "network", "Landroid/net/Network;", "onLost", "register", "context", "Landroid/content/Context;", "resolveDownBandwidth", "", "(Landroid/net/NetworkCapabilities;)Ljava/lang/Long;", "resolveStrength", "resolveUpBandwidth", "unregister", "Companion", "dd-sdk-android_release"})
@TargetApi(value=24)
public final class CallbackNetworkInfoProvider
extends ConnectivityManager.NetworkCallback
implements NetworkInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataWriter<NetworkInfo> dataWriter;
    @NotNull
    private NetworkInfo lastNetworkInfo;
    @NotNull
    public static final String ERROR_REGISTER = "We couldn't register a Network Callback, the network information reported will be less accurate.";
    @NotNull
    public static final String ERROR_UNREGISTER = "We couldn't unregister the Network Callback";

    public CallbackNetworkInfoProvider(@NotNull DataWriter<NetworkInfo> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"dataWriter");
        this.dataWriter = dataWriter;
        this.lastNetworkInfo = new NetworkInfo(null, null, null, null, null, null, null, 127, null);
    }

    private final void setLastNetworkInfo(NetworkInfo value) {
        this.lastNetworkInfo = value;
        this.dataWriter.write(this.lastNetworkInfo);
    }

    public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
        super.onCapabilitiesChanged(network, networkCapabilities);
        this.setLastNetworkInfo(new NetworkInfo(this.getNetworkType(networkCapabilities), null, null, this.resolveUpBandwidth(networkCapabilities), this.resolveDownBandwidth(networkCapabilities), this.resolveStrength(networkCapabilities), null, 70, null));
    }

    public void onLost(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onLost(network);
        this.setLastNetworkInfo(new NetworkInfo(NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED, null, null, null, null, null, null, 126, null));
    }

    @Override
    public void register(@NotNull Context context) {
        ConnectivityManager connMgr;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object systemService = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = connMgr = systemService instanceof ConnectivityManager ? (ConnectivityManager)systemService : null;
        if (connMgr == null) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), ERROR_REGISTER, null, null, 6, null);
            return;
        }
        try {
            connMgr.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this);
            Network activeNetwork = connMgr.getActiveNetwork();
            NetworkCapabilities activeCaps = connMgr.getNetworkCapabilities(activeNetwork);
            if (activeNetwork != null && activeCaps != null) {
                this.onCapabilitiesChanged(activeNetwork, activeCaps);
            }
        }
        catch (SecurityException e) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), ERROR_REGISTER, e, null, 4, null);
            this.setLastNetworkInfo(new NetworkInfo(NetworkInfo.Connectivity.NETWORK_OTHER, null, null, null, null, null, null, 126, null));
        }
        catch (RuntimeException e) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), ERROR_REGISTER, e, null, 4, null);
            this.setLastNetworkInfo(new NetworkInfo(NetworkInfo.Connectivity.NETWORK_OTHER, null, null, null, null, null, null, 126, null));
        }
    }

    @Override
    public void unregister(@NotNull Context context) {
        ConnectivityManager connMgr;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object systemService = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = connMgr = systemService instanceof ConnectivityManager ? (ConnectivityManager)systemService : null;
        if (connMgr == null) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), ERROR_UNREGISTER, null, null, 6, null);
            return;
        }
        try {
            connMgr.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
        }
        catch (SecurityException e) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), ERROR_UNREGISTER, e, null, 4, null);
        }
        catch (RuntimeException e) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), ERROR_UNREGISTER, e, null, 4, null);
        }
    }

    @Override
    @NotNull
    public NetworkInfo getLatestNetworkInfo() {
        return this.lastNetworkInfo;
    }

    private final Long resolveUpBandwidth(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.getLinkUpstreamBandwidthKbps() > 0 ? Long.valueOf(networkCapabilities.getLinkUpstreamBandwidthKbps()) : (Long)null;
    }

    private final Long resolveDownBandwidth(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.getLinkDownstreamBandwidthKbps() > 0 ? Long.valueOf(networkCapabilities.getLinkDownstreamBandwidthKbps()) : (Long)null;
    }

    private final Long resolveStrength(NetworkCapabilities networkCapabilities) {
        return Build.VERSION.SDK_INT >= 29 && networkCapabilities.getSignalStrength() != Integer.MIN_VALUE ? Long.valueOf(networkCapabilities.getSignalStrength()) : (Long)null;
    }

    private final NetworkInfo.Connectivity getNetworkType(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.hasTransport(1) ? NetworkInfo.Connectivity.NETWORK_WIFI : (networkCapabilities.hasTransport(3) ? NetworkInfo.Connectivity.NETWORK_ETHERNET : (networkCapabilities.hasTransport(0) ? NetworkInfo.Connectivity.NETWORK_CELLULAR : (networkCapabilities.hasTransport(2) ? NetworkInfo.Connectivity.NETWORK_BLUETOOTH : NetworkInfo.Connectivity.NETWORK_OTHER)));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/net/info/CallbackNetworkInfoProvider$Companion;", "", "()V", "ERROR_REGISTER", "", "ERROR_UNREGISTER", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

