/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net.info;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.receiver.ThreadSafeReceiver;
import com.datadog.android.core.model.NetworkInfo;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/core/internal/net/info/BroadcastReceiverNetworkInfoProvider;", "Lcom/datadog/android/core/internal/receiver/ThreadSafeReceiver;", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "dataWriter", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/core/model/NetworkInfo;", "(Lcom/datadog/android/core/internal/persistence/DataWriter;)V", "value", "networkInfo", "setNetworkInfo", "(Lcom/datadog/android/core/model/NetworkInfo;)V", "buildMobileNetworkInfo", "context", "Landroid/content/Context;", "subtype", "", "buildNetworkInfo", "activeNetworkInfo", "Landroid/net/NetworkInfo;", "getCellularTechnology", "", "getLatestNetworkInfo", "onReceive", "", "intent", "Landroid/content/Intent;", "register", "unregister", "Companion", "dd-sdk-android_release"})
@SuppressLint(value={"InlinedApi"})
public final class BroadcastReceiverNetworkInfoProvider
extends ThreadSafeReceiver
implements NetworkInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataWriter<NetworkInfo> dataWriter;
    @NotNull
    private NetworkInfo networkInfo;
    @NotNull
    private static final Set<Integer> knownMobileTypes;
    @NotNull
    private static final Set<Integer> known2GSubtypes;
    @NotNull
    private static final Set<Integer> known3GSubtypes;
    @NotNull
    private static final Set<Integer> known4GSubtypes;
    @NotNull
    private static final Set<Integer> known5GSubtypes;
    @NotNull
    private static final String UNKNOWN_CARRIER_NAME = "Unknown Carrier Name";

    public BroadcastReceiverNetworkInfoProvider(@NotNull DataWriter<NetworkInfo> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"dataWriter");
        this.dataWriter = dataWriter;
        this.networkInfo = new NetworkInfo(null, null, null, null, null, null, null, 127, null);
    }

    private final void setNetworkInfo(NetworkInfo value) {
        this.networkInfo = value;
        this.dataWriter.write(this.networkInfo);
    }

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        ConnectivityManager connectivityMgr;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = connectivityMgr = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        android.net.NetworkInfo activeNetworkInfo = connectivityManager == null ? null : connectivityManager.getActiveNetworkInfo();
        this.setNetworkInfo(this.buildNetworkInfo(context, activeNetworkInfo));
    }

    @Override
    public void register(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        Intent intent = this.registerReceiver(context, filter);
        boolean bl = false;
        boolean bl2 = false;
        Intent it = intent;
        boolean bl3 = false;
        this.onReceive(context, it);
    }

    @Override
    public void unregister(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.unregisterReceiver(context);
    }

    @Override
    @NotNull
    public NetworkInfo getLatestNetworkInfo() {
        return this.networkInfo;
    }

    private final NetworkInfo buildNetworkInfo(Context context, android.net.NetworkInfo activeNetworkInfo) {
        return activeNetworkInfo == null || !activeNetworkInfo.isConnected() ? new NetworkInfo(NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED, null, null, null, null, null, null, 126, null) : (activeNetworkInfo.getType() == 1 ? new NetworkInfo(NetworkInfo.Connectivity.NETWORK_WIFI, null, null, null, null, null, null, 126, null) : (activeNetworkInfo.getType() == 9 ? new NetworkInfo(NetworkInfo.Connectivity.NETWORK_ETHERNET, null, null, null, null, null, null, 126, null) : (knownMobileTypes.contains(activeNetworkInfo.getType()) ? this.buildMobileNetworkInfo(context, activeNetworkInfo.getSubtype()) : new NetworkInfo(NetworkInfo.Connectivity.NETWORK_OTHER, null, null, null, null, null, null, 126, null))));
    }

    private final NetworkInfo buildMobileNetworkInfo(Context context, int subtype) {
        NetworkInfo networkInfo;
        int n = subtype;
        NetworkInfo.Connectivity connectivity = known2GSubtypes.contains(n) ? NetworkInfo.Connectivity.NETWORK_2G : (known3GSubtypes.contains(n) ? NetworkInfo.Connectivity.NETWORK_3G : (known4GSubtypes.contains(n) ? NetworkInfo.Connectivity.NETWORK_4G : (known5GSubtypes.contains(n) ? NetworkInfo.Connectivity.NETWORK_5G : NetworkInfo.Connectivity.NETWORK_MOBILE_OTHER)));
        String cellularTechnology = this.getCellularTechnology(subtype);
        if (Build.VERSION.SDK_INT >= 28) {
            Long l;
            CharSequence charSequence;
            CharSequence charSequence2;
            Object object = context.getSystemService("phone");
            TelephonyManager telephonyMgr = object instanceof TelephonyManager ? (TelephonyManager)object : null;
            TelephonyManager telephonyManager = telephonyMgr;
            CharSequence carrierName = charSequence2 = telephonyManager == null ? (CharSequence)UNKNOWN_CARRIER_NAME : ((charSequence = telephonyManager.getSimCarrierIdName()) == null ? (CharSequence)UNKNOWN_CARRIER_NAME : charSequence);
            telephonyManager = telephonyMgr;
            if (telephonyManager == null) {
                l = null;
            } else {
                int n2 = telephonyManager.getSimCarrierId();
                l = n2;
            }
            Long carrierId = l;
            networkInfo = new NetworkInfo(connectivity, ((Object)carrierName).toString(), carrierId, null, null, null, cellularTechnology, 56, null);
        } else {
            networkInfo = new NetworkInfo(connectivity, null, null, null, null, null, cellularTechnology, 62, null);
        }
        return networkInfo;
    }

    private final String getCellularTechnology(int subtype) {
        String string;
        int n = subtype;
        switch (n) {
            case 1: {
                string = "GPRS";
                break;
            }
            case 2: {
                string = "Edge";
                break;
            }
            case 4: {
                string = "CDMA";
                break;
            }
            case 7: {
                string = "CDMA1x";
                break;
            }
            case 11: {
                string = "iDen";
                break;
            }
            case 16: {
                string = "GSM";
                break;
            }
            case 3: {
                string = "UMTS";
                break;
            }
            case 5: {
                string = "CDMAEVDORev0";
                break;
            }
            case 6: {
                string = "CDMAEVDORevA";
                break;
            }
            case 12: {
                string = "CDMAEVDORevB";
                break;
            }
            case 8: {
                string = "HSDPA";
                break;
            }
            case 9: {
                string = "HSUPA";
                break;
            }
            case 10: {
                string = "HSPA";
                break;
            }
            case 14: {
                string = "eHRPD";
                break;
            }
            case 15: {
                string = "HSPA+";
                break;
            }
            case 17: {
                string = "TD_SCDMA";
                break;
            }
            case 13: {
                string = "LTE";
                break;
            }
            case 18: {
                string = "IWLAN";
                break;
            }
            case 19: {
                string = "LTE_CA";
                break;
            }
            case 20: {
                string = "New Radio";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    static {
        Object[] objectArray = new Integer[]{0, 4, 5, 2, 3};
        knownMobileTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{1, 2, 4, 7, 11, 16};
        known2GSubtypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{3, 5, 6, 8, 9, 10, 12, 14, 15, 17};
        known3GSubtypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{13, 18, 19};
        known4GSubtypes = SetsKt.setOf((Object[])objectArray);
        known5GSubtypes = SetsKt.setOf((Object)20);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/net/info/BroadcastReceiverNetworkInfoProvider$Companion;", "", "()V", "UNKNOWN_CARRIER_NAME", "", "known2GSubtypes", "", "", "known3GSubtypes", "known4GSubtypes", "known5GSubtypes", "knownMobileTypes", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

