/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/net/GzipRequestInterceptor;", "Lokhttp3/Interceptor;", "()V", "gzip", "Lokhttp3/RequestBody;", "body", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "dd-sdk-android_release"})
public final class GzipRequestInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HEADER_ENCODING = "Content-Encoding";
    @NotNull
    private static final String ENCODING_GZIP = "gzip";

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"chain.request()");
        Request originalRequest = request;
        RequestBody body = originalRequest.body();
        if (body == null || originalRequest.header(HEADER_ENCODING) != null) {
            Response response2 = chain.proceed(originalRequest);
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"{\n            chain.proceed(originalRequest)\n        }");
            response = response2;
        } else {
            Request compressedRequest = originalRequest.newBuilder().header(HEADER_ENCODING, ENCODING_GZIP).method(originalRequest.method(), this.gzip(body)).build();
            Response response3 = chain.proceed(compressedRequest);
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"{\n            val compressedRequest = originalRequest.newBuilder()\n                .header(HEADER_ENCODING, ENCODING_GZIP)\n                .method(originalRequest.method(), gzip(body))\n                .build()\n            chain.proceed(compressedRequest)\n        }");
            response = response3;
        }
        return response;
    }

    private final RequestBody gzip(RequestBody body) {
        return new RequestBody(body){
            final /* synthetic */ RequestBody $body;
            {
                this.$body = $body;
            }

            @Nullable
            public MediaType contentType() {
                return this.$body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(@NotNull BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                BufferedSink bufferedSink = Okio.buffer((Sink)((Sink)new GzipSink((Sink)sink)));
                Intrinsics.checkNotNullExpressionValue((Object)bufferedSink, (String)"buffer(GzipSink(sink))");
                BufferedSink gzipSink = bufferedSink;
                this.$body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/net/GzipRequestInterceptor$Companion;", "", "()V", "ENCODING_GZIP", "", "HEADER_ENCODING", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

