/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import android.os.Build;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b \u0018\u0000 22\u00020\u0001:\u000223B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020&0%H\u0014J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0003H\u0002J\b\u0010+\u001a\u00020\u0003H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0016\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001c\u0010\u0010\u00a8\u00064"}, d2={"Lcom/datadog/android/core/internal/net/DataOkHttpUploaderV2;", "Lcom/datadog/android/core/internal/net/DataUploader;", "intakeUrl", "", "clientToken", "source", "sdkVersion", "callFactory", "Lokhttp3/Call$Factory;", "contentType", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lokhttp3/Call$Factory;Ljava/lang/String;Lcom/datadog/android/log/Logger;)V", "getCallFactory$dd_sdk_android_release", "()Lokhttp3/Call$Factory;", "getClientToken$dd_sdk_android_release", "()Ljava/lang/String;", "getContentType$dd_sdk_android_release", "getIntakeUrl$dd_sdk_android_release", "setIntakeUrl$dd_sdk_android_release", "(Ljava/lang/String;)V", "getInternalLogger$dd_sdk_android_release", "()Lcom/datadog/android/log/Logger;", "getSdkVersion$dd_sdk_android_release", "getSource$dd_sdk_android_release", "uploaderName", "kotlin.jvm.PlatformType", "userAgent", "getUserAgent", "userAgent$delegate", "Lkotlin/Lazy;", "buildHeaders", "", "builder", "Lokhttp3/Request$Builder;", "requestId", "buildQueryParameters", "", "", "buildRequest", "Lokhttp3/Request;", "data", "", "buildUrl", "executeUploadRequest", "Lcom/datadog/android/core/internal/net/UploadStatus;", "responseCodeToUploadStatus", "code", "", "upload", "Companion", "TrackType", "dd-sdk-android_release"})
public abstract class DataOkHttpUploaderV2
implements DataUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String intakeUrl;
    @NotNull
    private final String clientToken;
    @NotNull
    private final String source;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final String contentType;
    @NotNull
    private final Logger internalLogger;
    private final String uploaderName;
    @NotNull
    private final Lazy userAgent$delegate;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_UNAVAILABLE = 503;
    @NotNull
    public static final String HEADER_API_KEY = "DD-API-KEY";
    @NotNull
    public static final String HEADER_EVP_ORIGIN = "DD-EVP-ORIGIN";
    @NotNull
    public static final String HEADER_EVP_ORIGIN_VERSION = "DD-EVP-ORIGIN-VERSION";
    @NotNull
    public static final String HEADER_REQUEST_ID = "DD-REQUEST-ID";
    @NotNull
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String HEADER_USER_AGENT = "User-Agent";
    @NotNull
    public static final String QUERY_PARAM_SOURCE = "ddsource";
    @NotNull
    public static final String QUERY_PARAM_TAGS = "ddtags";
    @NotNull
    public static final String CONTENT_TYPE_JSON = "application/json";
    @NotNull
    public static final String CONTENT_TYPE_TEXT_UTF8 = "text/plain;charset=UTF-8";
    @NotNull
    private static final String UPLOAD_URL = "%s/api/v2/%s";

    public DataOkHttpUploaderV2(@NotNull String intakeUrl, @NotNull String clientToken, @NotNull String source, @NotNull String sdkVersion, @NotNull Call.Factory callFactory, @NotNull String contentType, @NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)intakeUrl, (String)"intakeUrl");
        Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.intakeUrl = intakeUrl;
        this.clientToken = clientToken;
        this.source = source;
        this.sdkVersion = sdkVersion;
        this.callFactory = callFactory;
        this.contentType = contentType;
        this.internalLogger = internalLogger;
        this.uploaderName = this.getClass().getSimpleName();
        this.userAgent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DataOkHttpUploaderV2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                CharSequence charSequence;
                String string = System.getProperty("http.agent");
                DataOkHttpUploaderV2 dataOkHttpUploaderV2 = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                CharSequence charSequence2 = it;
                boolean bl4 = false;
                boolean bl5 = false;
                if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                    charSequence = "Datadog/" + dataOkHttpUploaderV2.getSdkVersion$dd_sdk_android_release() + " (Linux; U; Android " + Build.VERSION.RELEASE + "; " + Build.MODEL + " Build/" + Build.ID + ')';
                } else {
                    charSequence2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"{\n                it\n            }");
                    charSequence = charSequence2;
                }
                return charSequence;
            }
        }));
    }

    @NotNull
    public final String getIntakeUrl$dd_sdk_android_release() {
        return this.intakeUrl;
    }

    public final void setIntakeUrl$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.intakeUrl = string;
    }

    @NotNull
    public final String getClientToken$dd_sdk_android_release() {
        return this.clientToken;
    }

    @NotNull
    public final String getSource$dd_sdk_android_release() {
        return this.source;
    }

    @NotNull
    public final String getSdkVersion$dd_sdk_android_release() {
        return this.sdkVersion;
    }

    @NotNull
    public final Call.Factory getCallFactory$dd_sdk_android_release() {
        return this.callFactory;
    }

    @NotNull
    public final String getContentType$dd_sdk_android_release() {
        return this.contentType;
    }

    @NotNull
    public final Logger getInternalLogger$dd_sdk_android_release() {
        return this.internalLogger;
    }

    private final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public UploadStatus upload(@NotNull byte[] data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        try {
            object = this.executeUploadRequest(data, requestId);
        }
        catch (Throwable e) {
            Logger.e$default(this.internalLogger, "Unable to upload batch data.", e, null, 4, null);
            object = UploadStatus.NETWORK_ERROR;
        }
        UploadStatus uploadStatus = object;
        object = this.uploaderName;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uploaderName");
        uploadStatus.logStatus((String)object, data.length, RuntimeUtilsKt.getDevLogger(), false, requestId);
        object = this.uploaderName;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uploaderName");
        uploadStatus.logStatus((String)object, data.length, this.internalLogger, true, requestId);
        return uploadStatus;
    }

    private final UploadStatus executeUploadRequest(byte[] data, String requestId) {
        Request request = this.buildRequest(data, requestId);
        Call call = this.callFactory.newCall(request);
        Response response = call.execute();
        response.close();
        return this.responseCodeToUploadStatus(response.code());
    }

    private final Request buildRequest(byte[] data, String requestId) {
        Request.Builder builder = new Request.Builder().url(this.buildUrl()).post(RequestBody.create(null, (byte[])data));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.buildHeaders(builder, requestId);
        Request request = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"builder.build()");
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildUrl() {
        String string;
        Map<String, Object> queryParams = this.buildQueryParameters();
        if (queryParams.isEmpty()) {
            string = this.intakeUrl;
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, Object> map = queryParams;
            String string2 = this.intakeUrl;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_8.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string3 = (String)it.getKey() + '=' + it.getValue();
                collection.add(string3);
            }
            collection = (List)destination$iv$iv;
            string = Intrinsics.stringPlus((String)string2, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null));
        }
        return string;
    }

    private final void buildHeaders(Request.Builder builder, String requestId) {
        builder.addHeader(HEADER_API_KEY, this.clientToken);
        builder.addHeader(HEADER_EVP_ORIGIN, this.source);
        builder.addHeader(HEADER_EVP_ORIGIN_VERSION, this.sdkVersion);
        builder.addHeader(HEADER_USER_AGENT, this.getUserAgent());
        builder.addHeader(HEADER_CONTENT_TYPE, this.contentType);
        builder.addHeader(HEADER_REQUEST_ID, requestId);
    }

    @NotNull
    protected Map<String, Object> buildQueryParameters() {
        return MapsKt.emptyMap();
    }

    private final UploadStatus responseCodeToUploadStatus(int code) {
        UploadStatus uploadStatus;
        int n = code;
        switch (n) {
            case 202: {
                uploadStatus = UploadStatus.SUCCESS;
                break;
            }
            case 400: {
                uploadStatus = UploadStatus.HTTP_CLIENT_ERROR;
                break;
            }
            case 401: {
                uploadStatus = UploadStatus.INVALID_TOKEN_ERROR;
                break;
            }
            case 403: {
                uploadStatus = UploadStatus.HTTP_CLIENT_ERROR;
                break;
            }
            case 408: {
                uploadStatus = UploadStatus.HTTP_CLIENT_RATE_LIMITING;
                break;
            }
            case 413: {
                uploadStatus = UploadStatus.HTTP_CLIENT_ERROR;
                break;
            }
            case 429: {
                uploadStatus = UploadStatus.HTTP_CLIENT_RATE_LIMITING;
                break;
            }
            case 500: {
                uploadStatus = UploadStatus.HTTP_SERVER_ERROR;
                break;
            }
            case 503: {
                uploadStatus = UploadStatus.HTTP_SERVER_ERROR;
                break;
            }
            default: {
                uploadStatus = UploadStatus.UNKNOWN_ERROR;
            }
        }
        return uploadStatus;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/internal/net/DataOkHttpUploaderV2$TrackType;", "", "trackName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getTrackName", "()Ljava/lang/String;", "LOGS", "RUM", "SPANS", "dd-sdk-android_release"})
    public static final class TrackType
    extends Enum<TrackType> {
        @NotNull
        private final String trackName;
        public static final /* enum */ TrackType LOGS = new TrackType("logs");
        public static final /* enum */ TrackType RUM = new TrackType("rum");
        public static final /* enum */ TrackType SPANS = new TrackType("spans");
        private static final /* synthetic */ TrackType[] $VALUES;

        private TrackType(String trackName) {
            this.trackName = trackName;
        }

        @NotNull
        public final String getTrackName() {
            return this.trackName;
        }

        public static TrackType[] values() {
            return (TrackType[])$VALUES.clone();
        }

        public static TrackType valueOf(String value) {
            return Enum.valueOf(TrackType.class, value);
        }

        static {
            $VALUES = trackTypeArray = new TrackType[]{TrackType.LOGS, TrackType.RUM, TrackType.SPANS};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/core/internal/net/DataOkHttpUploaderV2$Companion;", "", "()V", "CONTENT_TYPE_JSON", "", "CONTENT_TYPE_TEXT_UTF8", "HEADER_API_KEY", "HEADER_CONTENT_TYPE", "HEADER_EVP_ORIGIN", "HEADER_EVP_ORIGIN_VERSION", "HEADER_REQUEST_ID", "HEADER_USER_AGENT", "HTTP_ACCEPTED", "", "HTTP_BAD_REQUEST", "HTTP_CLIENT_TIMEOUT", "HTTP_ENTITY_TOO_LARGE", "HTTP_FORBIDDEN", "HTTP_INTERNAL_ERROR", "HTTP_TOO_MANY_REQUESTS", "HTTP_UNAUTHORIZED", "HTTP_UNAVAILABLE", "QUERY_PARAM_SOURCE", "QUERY_PARAM_TAGS", "UPLOAD_URL", "buildUrl", "endpoint", "trackType", "Lcom/datadog/android/core/internal/net/DataOkHttpUploaderV2$TrackType;", "buildUrl$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String buildUrl$dd_sdk_android_release(@NotNull String endpoint, @NotNull TrackType trackType) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            Intrinsics.checkNotNullParameter((Object)((Object)trackType), (String)"trackType");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string = DataOkHttpUploaderV2.UPLOAD_URL;
            Object[] objectArray = new Object[]{endpoint, trackType.getTrackName()};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

