/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.constraints;

import com.datadog.android.core.internal.constraints.DataConstraints;
import com.datadog.android.core.internal.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u001a\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u000bH\u0002JP\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00160\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0016J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u0016J(\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0\u0015H\u0016R&\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005j\u0002`\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/datadog/android/core/internal/constraints/DatadogDataConstraints;", "Lcom/datadog/android/core/internal/constraints/DataConstraints;", "()V", "tagTransforms", "", "Lkotlin/Function1;", "", "Lcom/datadog/android/core/internal/constraints/StringTransform;", "convertAttributeKey", "rawKey", "prefixDotCount", "", "convertTag", "rawTag", "isKeyReserved", "", "tag", "resolveDiscardedAttrsWarning", "attributesGroupName", "discardedCount", "validateAttributes", "", "T", "attributes", "keyPrefix", "reservedKeys", "", "validateTags", "tags", "validateTimings", "", "timings", "Companion", "dd-sdk-android_release"})
public final class DatadogDataConstraints
implements DataConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Function1<String, String>> tagTransforms;
    private static final int MAX_TAG_LENGTH = 200;
    private static final int MAX_TAG_COUNT = 100;
    private static final int MAX_ATTR_COUNT = 128;
    private static final int MAX_DEPTH_LEVEL = 9;
    @NotNull
    public static final String CUSTOM_TIMING_KEY_REPLACED_WARNING = "Invalid timing name: %s, sanitized to: %s";
    @NotNull
    private static final Set<String> reservedTagKeys;

    public DatadogDataConstraints() {
        Object[] objectArray = new Function1[]{tagTransforms.1.INSTANCE, tagTransforms.2.INSTANCE, tagTransforms.3.INSTANCE, tagTransforms.4.INSTANCE, tagTransforms.5.INSTANCE, (Function1)new Function1<String, String>(this){
            final /* synthetic */ DatadogDataConstraints this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DatadogDataConstraints.access$isKeyReserved(this.this$0, it) ? null : it;
            }
        }};
        this.tagTransforms = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> validateTags(@NotNull List<String> tags2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        Iterable $this$mapNotNull$iv = tags2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String tag = this.convertTag(it);
            if (tag == null) {
                Logger.e$default(RuntimeUtilsKt.getDevLogger(), '\"' + it + "\" is an invalid tag, and was ignored.", null, null, 6, null);
            } else if (!Intrinsics.areEqual((Object)tag, (Object)it)) {
                Logger.w$default(RuntimeUtilsKt.getDevLogger(), "tag \"" + it + "\" was modified to \"" + tag + "\" to match our constraints.", null, null, 6, null);
            }
            if (tag == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedTags = (List)destination$iv$iv;
        int discardedCount = convertedTags.size() - 100;
        if (discardedCount > 0) {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), "too many tags were added, " + discardedCount + " had to be discarded.", null, null, 6, null);
        }
        return CollectionsKt.take((Iterable)convertedTags, (int)100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Map<String, T> validateAttributes(@NotNull Map<String, ? extends T> attributes, @Nullable String keyPrefix, @Nullable String attributesGroupName, @NotNull Set<String> reservedKeys) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        int n;
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(reservedKeys, (String)"reservedKeys");
        String string = keyPrefix;
        if (string == null) {
            n = 0;
        } else {
            int n2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence $this$count$iv = it;
            boolean $i$f$count = false;
            int count$iv = 0;
            object = $this$count$iv;
            for (int i = 0; i < object.length(); ++i) {
                char element$iv;
                char character = element$iv = object.charAt(i);
                boolean bl4 = false;
                if (!(character == '.')) continue;
                ++count$iv;
            }
            n = n2 = count$iv + 1;
        }
        int prefixDotCount = n;
        Map<String, ? extends T> $this$mapNotNull$iv = attributes;
        boolean $i$f$mapNotNull = false;
        Map<String, ? extends T> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var14_20 = $this$forEach$iv$iv$iv;
        boolean bl = false;
        object = var14_20.entrySet().iterator();
        while (object.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)object.next();
            boolean bl5 = false;
            Map.Entry it = element$iv$iv;
            boolean bl6 = false;
            if (it.getKey() == null) {
                Logger.e$default(RuntimeUtilsKt.getDevLogger(), "" + '\"' + it + "\" is an invalid attribute, and was ignored.", null, null, 6, null);
                pair = null;
            } else if (reservedKeys.contains(it.getKey())) {
                Logger.e$default(RuntimeUtilsKt.getDevLogger(), "" + '\"' + it + "\" key was in the reservedKeys set, and was dropped.", null, null, 6, null);
                pair = null;
            } else {
                String key = this.convertAttributeKey((String)it.getKey(), prefixDotCount);
                if (!Intrinsics.areEqual((Object)key, it.getKey())) {
                    Logger.w$default(RuntimeUtilsKt.getDevLogger(), "Key \"" + (String)it.getKey() + "\" was modified to \"" + key + "\" to match our constraints.", null, null, 6, null);
                }
                pair = TuplesKt.to((Object)key, it.getValue());
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl7 = false;
            boolean bl8 = false;
            Pair it$iv$iv = pair2;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedAttributes = (List)destination$iv$iv;
        int discardedCount = convertedAttributes.size() - 128;
        if (discardedCount > 0) {
            String warningMessage = this.resolveDiscardedAttrsWarning(attributesGroupName, discardedCount);
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), warningMessage, null, null, 6, null);
        }
        return MapsKt.toMap((Iterable)CollectionsKt.take((Iterable)convertedAttributes, (int)128));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Long> validateTimings(@NotNull Map<String, Long> timings) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter(timings, (String)"timings");
        Map<String, Long> $this$mapKeys$iv = timings;
        boolean $i$f$mapKeys = false;
        Map<String, Long> map = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)entry.getKey();
            Object object = new Regex("[^a-zA-Z0-9\\-_.@$]");
            Object[] objectArray = "_";
            boolean bl2 = false;
            String sanitizedKey = object.replace(charSequence, (String)objectArray);
            if (!Intrinsics.areEqual((Object)sanitizedKey, entry.getKey())) {
                Logger logger = RuntimeUtilsKt.getDevLogger();
                charSequence = CUSTOM_TIMING_KEY_REPLACED_WARNING;
                object = Locale.US;
                objectArray = new Object[]{entry.getKey(), sanitizedKey};
                bl2 = false;
                String string = String.format((Locale)object, (String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(locale, this, *args)");
                Logger.w$default(logger, string, null, null, 6, null);
            }
            String string = sanitizedKey;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            String string2 = string;
            Map map3 = map2;
            boolean bl3 = false;
            entry2 = it$iv$iv.getValue();
            map3.put(string2, entry2);
        }
        return destination$iv$iv;
    }

    private final String resolveDiscardedAttrsWarning(String attributesGroupName, int discardedCount) {
        return attributesGroupName != null ? "Too many attributes were added for [" + attributesGroupName + "], " + discardedCount + " had to be discarded." : "Too many attributes were added, " + discardedCount + " had to be discarded.";
    }

    /*
     * WARNING - void declaration
     */
    private final String convertTag(String rawTag) {
        Iterable $this$fold$iv = this.tagTransforms;
        boolean $i$f$fold = false;
        String accumulator$iv = rawTag;
        for (Object element$iv : $this$fold$iv) {
            void transform;
            Function1 function1 = (Function1)element$iv;
            String tag = accumulator$iv;
            boolean bl = false;
            accumulator$iv = tag == null ? null : (String)transform.invoke((Object)tag);
        }
        return accumulator$iv;
    }

    private final boolean isKeyReserved(String tag) {
        boolean bl;
        int firstColon = StringsKt.indexOf$default((CharSequence)tag, (char)':', (int)0, (boolean)false, (int)6, null);
        if (firstColon > 0) {
            String string = tag;
            int n = 0;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, firstColon);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String key = string3;
            bl = reservedTagKeys.contains(key);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertAttributeKey(String rawKey, int prefixDotCount) {
        void $this$mapTo$iv$iv;
        int dotCount = 0;
        dotCount = prefixDotCount;
        CharSequence $this$map$iv = rawKey;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var10_9 = $this$mapTo$iv$iv;
        for (int i = 0; i < var10_9.length(); ++i) {
            int n;
            void it;
            char item$iv$iv;
            char c = item$iv$iv = var10_9.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Character c2 = Character.valueOf((char)(it == 46 ? ((dotCount = (n = dotCount) + 1) > 9 ? 95 : it) : it));
            collection.add(c2);
        }
        List mapped = (List)destination$iv$iv;
        char[] cArray = CollectionsKt.toCharArray((Collection)mapped);
        boolean bl = false;
        return new String(cArray);
    }

    public static final /* synthetic */ boolean access$isKeyReserved(DatadogDataConstraints $this, String tag) {
        return $this.isKeyReserved(tag);
    }

    static {
        Object[] objectArray = new String[]{"host", "device", "source", "service"};
        reservedTagKeys = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/constraints/DatadogDataConstraints$Companion;", "", "()V", "CUSTOM_TIMING_KEY_REPLACED_WARNING", "", "MAX_ATTR_COUNT", "", "MAX_DEPTH_LEVEL", "MAX_TAG_COUNT", "MAX_TAG_LENGTH", "reservedTagKeys", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

