/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Process;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.Credentials;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.net.GzipRequestInterceptor;
import com.datadog.android.core.internal.net.info.BroadcastReceiverNetworkInfoProvider;
import com.datadog.android.core.internal.net.info.CallbackNetworkInfoProvider;
import com.datadog.android.core.internal.net.info.NetworkInfoDeserializer;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.net.info.NoOpNetworkInfoProvider;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.advanced.ScheduledWriter;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileHandler;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.core.internal.privacy.NoOpConsentProvider;
import com.datadog.android.core.internal.privacy.TrackingConsentProvider;
import com.datadog.android.core.internal.system.BroadcastReceiverSystemInfoProvider;
import com.datadog.android.core.internal.system.NoOpSystemInfoProvider;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.time.KronosTimeProvider;
import com.datadog.android.core.internal.time.LoggingSyncListener;
import com.datadog.android.core.internal.time.NoOpTimeProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.user.DatadogUserInfoProvider;
import com.datadog.android.log.internal.user.MutableUserInfoProvider;
import com.datadog.android.log.internal.user.NoOpMutableUserInfoProvider;
import com.datadog.android.log.internal.user.UserInfoDeserializer;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.rum.internal.domain.event.RumEventDeserializer;
import com.datadog.android.rum.internal.ndk.DatadogNdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashLogDeserializer;
import com.datadog.android.rum.internal.ndk.NdkNetworkInfoDataWriter;
import com.datadog.android.rum.internal.ndk.NdkUserInfoDataWriter;
import com.datadog.android.rum.internal.ndk.NoOpNdkCrashHandler;
import com.lyft.kronos.AndroidClockFactory;
import com.lyft.kronos.Clock;
import com.lyft.kronos.KronosClock;
import com.lyft.kronos.SyncListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\n\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0002J\n\u0010\u008d\u0001\u001a\u00030\u008c\u0001H\u0002J\b\u0010\u008e\u0001\u001a\u00030\u008c\u0001J/\u0010\u008f\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001a2\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001J\u0013\u0010\u0097\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0002J\u0013\u0010\u0098\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0002J\u001d\u0010\u0099\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001a2\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0002J\u0014\u0010\u009a\u0001\u001a\u00030\u008c\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0002J\u0013\u0010\u009b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0002J\n\u0010\u009c\u0001\u001a\u00030\u008c\u0001H\u0002J\u001d\u0010\u009d\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001a2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0002J\u0013\u0010\u009e\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0002J\u0014\u0010\u009f\u0001\u001a\u00030\u008c\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0002J\u0013\u0010\u00a0\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u001aH\u0002J\n\u0010\u00a1\u0001\u001a\u00030\u008c\u0001H\u0002J\b\u0010\u00a2\u0001\u001a\u00030\u008c\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R\u001a\u0010\"\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020EX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0015\"\u0004\bL\u0010\u0017R\u001a\u0010M\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u0015\"\u0004\bO\u0010\u0017R\u001a\u0010P\u001a\u00020QX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001c\u0010V\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\u0015\"\u0004\bX\u0010\u0017R\u001a\u0010Y\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u0015\"\u0004\b[\u0010\u0017R\u001a\u0010\\\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\u0015\"\u0004\b^\u0010\u0017R\u001a\u0010_\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010\u0015\"\u0004\ba\u0010\u0017R\u001a\u0010b\u001a\u00020cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u001a\u0010h\u001a\u00020iX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u001a\u0010n\u001a\u00020oX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR\u001a\u0010t\u001a\u00020uX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR\u001a\u0010z\u001a\u00020{X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010}\"\u0004\b~\u0010\u007fR \u0010\u0080\u0001\u001a\u00030\u0081\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R\u001d\u0010\u0086\u0001\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0087\u0001\u0010\u0015\"\u0005\b\u0088\u0001\u0010\u0017\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/datadog/android/core/internal/CoreFeature;", "", "()V", "CORE_DEFAULT_POOL_SIZE", "", "DEFAULT_SDK_VERSION", "", "DEFAULT_SOURCE_NAME", "NETWORK_TIMEOUT_MS", "", "getNETWORK_TIMEOUT_MS$dd_sdk_android_release", "()J", "THREAD_POOL_MAX_KEEP_ALIVE_MS", "batchSize", "Lcom/datadog/android/core/configuration/BatchSize;", "getBatchSize$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/BatchSize;", "setBatchSize$dd_sdk_android_release", "(Lcom/datadog/android/core/configuration/BatchSize;)V", "clientToken", "getClientToken$dd_sdk_android_release", "()Ljava/lang/String;", "setClientToken$dd_sdk_android_release", "(Ljava/lang/String;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "getContextRef$dd_sdk_android_release", "()Ljava/lang/ref/WeakReference;", "setContextRef$dd_sdk_android_release", "(Ljava/lang/ref/WeakReference;)V", "envName", "getEnvName$dd_sdk_android_release", "setEnvName$dd_sdk_android_release", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "getFirstPartyHostDetector$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "setFirstPartyHostDetector$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isMainProcess", "", "isMainProcess$dd_sdk_android_release", "()Z", "setMainProcess$dd_sdk_android_release", "(Z)V", "kronosClock", "Lcom/lyft/kronos/KronosClock;", "getKronosClock$dd_sdk_android_release", "()Lcom/lyft/kronos/KronosClock;", "setKronosClock$dd_sdk_android_release", "(Lcom/lyft/kronos/KronosClock;)V", "ndkCrashHandler", "Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;", "getNdkCrashHandler$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;", "setNdkCrashHandler$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;)V", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "getNetworkInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "setNetworkInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient$dd_sdk_android_release", "()Lokhttp3/OkHttpClient;", "setOkHttpClient$dd_sdk_android_release", "(Lokhttp3/OkHttpClient;)V", "packageName", "getPackageName$dd_sdk_android_release", "setPackageName$dd_sdk_android_release", "packageVersion", "getPackageVersion$dd_sdk_android_release", "setPackageVersion$dd_sdk_android_release", "persistenceExecutorService", "Ljava/util/concurrent/ExecutorService;", "getPersistenceExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ExecutorService;", "setPersistenceExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ExecutorService;)V", "rumApplicationId", "getRumApplicationId$dd_sdk_android_release", "setRumApplicationId$dd_sdk_android_release", "sdkVersion", "getSdkVersion$dd_sdk_android_release", "setSdkVersion$dd_sdk_android_release", "serviceName", "getServiceName$dd_sdk_android_release", "setServiceName$dd_sdk_android_release", "sourceName", "getSourceName$dd_sdk_android_release", "setSourceName$dd_sdk_android_release", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "getSystemInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "setSystemInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/system/SystemInfoProvider;)V", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "getTimeProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/time/TimeProvider;", "setTimeProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/time/TimeProvider;)V", "trackingConsentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "getTrackingConsentProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "setTrackingConsentProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/privacy/ConsentProvider;)V", "uploadExecutorService", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "getUploadExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "setUploadExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ScheduledThreadPoolExecutor;)V", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "getUploadFrequency$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/UploadFrequency;", "setUploadFrequency$dd_sdk_android_release", "(Lcom/datadog/android/core/configuration/UploadFrequency;)V", "userInfoProvider", "Lcom/datadog/android/log/internal/user/MutableUserInfoProvider;", "getUserInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/user/MutableUserInfoProvider;", "setUserInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/log/internal/user/MutableUserInfoProvider;)V", "variant", "getVariant$dd_sdk_android_release", "setVariant$dd_sdk_android_release", "buildFilePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "cleanupApplicationInfo", "", "cleanupProviders", "drainAndShutdownExecutors", "initialize", "appContext", "credentials", "Lcom/datadog/android/core/configuration/Credentials;", "configuration", "Lcom/datadog/android/core/configuration/Configuration$Core;", "consent", "Lcom/datadog/android/privacy/TrackingConsent;", "initializeClockSync", "prepareNdkCrashData", "readApplicationInformation", "readConfigurationSettings", "resolveIsMainProcess", "setupExecutors", "setupInfoProviders", "setupNetworkInfoProviders", "setupOkHttpClient", "setupUserInfoProvider", "shutDownExecutors", "stop", "dd-sdk-android_release"})
public final class CoreFeature {
    @NotNull
    public static final CoreFeature INSTANCE = new CoreFeature();
    private static final long NETWORK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(45L);
    private static final long THREAD_POOL_MAX_KEEP_ALIVE_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final int CORE_DEFAULT_POOL_SIZE = 1;
    @NotNull
    public static final String DEFAULT_SOURCE_NAME = "android";
    @NotNull
    public static final String DEFAULT_SDK_VERSION = "1.11.1";
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    @NotNull
    private static WeakReference<Context> contextRef = new WeakReference<Object>(null);
    @NotNull
    private static FirstPartyHostDetector firstPartyHostDetector = new FirstPartyHostDetector(CollectionsKt.emptyList());
    @NotNull
    private static NetworkInfoProvider networkInfoProvider = new NoOpNetworkInfoProvider();
    @NotNull
    private static SystemInfoProvider systemInfoProvider = new NoOpSystemInfoProvider();
    @NotNull
    private static TimeProvider timeProvider = new NoOpTimeProvider();
    @NotNull
    private static ConsentProvider trackingConsentProvider = new NoOpConsentProvider();
    @NotNull
    private static MutableUserInfoProvider userInfoProvider = new NoOpMutableUserInfoProvider();
    @NotNull
    private static OkHttpClient okHttpClient;
    public static KronosClock kronosClock;
    @NotNull
    private static String clientToken;
    @NotNull
    private static String packageName;
    @NotNull
    private static String packageVersion;
    @NotNull
    private static String serviceName;
    @NotNull
    private static String sourceName;
    @NotNull
    private static String sdkVersion;
    @Nullable
    private static String rumApplicationId;
    private static boolean isMainProcess;
    @NotNull
    private static String envName;
    @NotNull
    private static String variant;
    @NotNull
    private static BatchSize batchSize;
    @NotNull
    private static UploadFrequency uploadFrequency;
    @NotNull
    private static NdkCrashHandler ndkCrashHandler;
    public static ScheduledThreadPoolExecutor uploadExecutorService;
    public static ExecutorService persistenceExecutorService;

    private CoreFeature() {
    }

    public final long getNETWORK_TIMEOUT_MS$dd_sdk_android_release() {
        return NETWORK_TIMEOUT_MS;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return initialized;
    }

    @NotNull
    public final WeakReference<Context> getContextRef$dd_sdk_android_release() {
        return contextRef;
    }

    public final void setContextRef$dd_sdk_android_release(@NotNull WeakReference<Context> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        contextRef = weakReference;
    }

    @NotNull
    public final FirstPartyHostDetector getFirstPartyHostDetector$dd_sdk_android_release() {
        return firstPartyHostDetector;
    }

    public final void setFirstPartyHostDetector$dd_sdk_android_release(@NotNull FirstPartyHostDetector firstPartyHostDetector) {
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"<set-?>");
        CoreFeature.firstPartyHostDetector = firstPartyHostDetector;
    }

    @NotNull
    public final NetworkInfoProvider getNetworkInfoProvider$dd_sdk_android_release() {
        return networkInfoProvider;
    }

    public final void setNetworkInfoProvider$dd_sdk_android_release(@NotNull NetworkInfoProvider networkInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"<set-?>");
        CoreFeature.networkInfoProvider = networkInfoProvider;
    }

    @NotNull
    public final SystemInfoProvider getSystemInfoProvider$dd_sdk_android_release() {
        return systemInfoProvider;
    }

    public final void setSystemInfoProvider$dd_sdk_android_release(@NotNull SystemInfoProvider systemInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"<set-?>");
        CoreFeature.systemInfoProvider = systemInfoProvider;
    }

    @NotNull
    public final TimeProvider getTimeProvider$dd_sdk_android_release() {
        return timeProvider;
    }

    public final void setTimeProvider$dd_sdk_android_release(@NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"<set-?>");
        CoreFeature.timeProvider = timeProvider;
    }

    @NotNull
    public final ConsentProvider getTrackingConsentProvider$dd_sdk_android_release() {
        return trackingConsentProvider;
    }

    public final void setTrackingConsentProvider$dd_sdk_android_release(@NotNull ConsentProvider consentProvider) {
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"<set-?>");
        trackingConsentProvider = consentProvider;
    }

    @NotNull
    public final MutableUserInfoProvider getUserInfoProvider$dd_sdk_android_release() {
        return userInfoProvider;
    }

    public final void setUserInfoProvider$dd_sdk_android_release(@NotNull MutableUserInfoProvider mutableUserInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)mutableUserInfoProvider, (String)"<set-?>");
        userInfoProvider = mutableUserInfoProvider;
    }

    @NotNull
    public final OkHttpClient getOkHttpClient$dd_sdk_android_release() {
        return okHttpClient;
    }

    public final void setOkHttpClient$dd_sdk_android_release(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"<set-?>");
        CoreFeature.okHttpClient = okHttpClient;
    }

    @NotNull
    public final KronosClock getKronosClock$dd_sdk_android_release() {
        KronosClock kronosClock = CoreFeature.kronosClock;
        if (kronosClock != null) {
            return kronosClock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"kronosClock");
        throw null;
    }

    public final void setKronosClock$dd_sdk_android_release(@NotNull KronosClock kronosClock) {
        Intrinsics.checkNotNullParameter((Object)kronosClock, (String)"<set-?>");
        CoreFeature.kronosClock = kronosClock;
    }

    @NotNull
    public final String getClientToken$dd_sdk_android_release() {
        return clientToken;
    }

    public final void setClientToken$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientToken = string;
    }

    @NotNull
    public final String getPackageName$dd_sdk_android_release() {
        return packageName;
    }

    public final void setPackageName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        packageName = string;
    }

    @NotNull
    public final String getPackageVersion$dd_sdk_android_release() {
        return packageVersion;
    }

    public final void setPackageVersion$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        packageVersion = string;
    }

    @NotNull
    public final String getServiceName$dd_sdk_android_release() {
        return serviceName;
    }

    public final void setServiceName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        serviceName = string;
    }

    @NotNull
    public final String getSourceName$dd_sdk_android_release() {
        return sourceName;
    }

    public final void setSourceName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        sourceName = string;
    }

    @NotNull
    public final String getSdkVersion$dd_sdk_android_release() {
        return sdkVersion;
    }

    public final void setSdkVersion$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        sdkVersion = string;
    }

    @Nullable
    public final String getRumApplicationId$dd_sdk_android_release() {
        return rumApplicationId;
    }

    public final void setRumApplicationId$dd_sdk_android_release(@Nullable String string) {
        rumApplicationId = string;
    }

    public final boolean isMainProcess$dd_sdk_android_release() {
        return isMainProcess;
    }

    public final void setMainProcess$dd_sdk_android_release(boolean bl) {
        isMainProcess = bl;
    }

    @NotNull
    public final String getEnvName$dd_sdk_android_release() {
        return envName;
    }

    public final void setEnvName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        envName = string;
    }

    @NotNull
    public final String getVariant$dd_sdk_android_release() {
        return variant;
    }

    public final void setVariant$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        variant = string;
    }

    @NotNull
    public final BatchSize getBatchSize$dd_sdk_android_release() {
        return batchSize;
    }

    public final void setBatchSize$dd_sdk_android_release(@NotNull BatchSize batchSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"<set-?>");
        CoreFeature.batchSize = batchSize;
    }

    @NotNull
    public final UploadFrequency getUploadFrequency$dd_sdk_android_release() {
        return uploadFrequency;
    }

    public final void setUploadFrequency$dd_sdk_android_release(@NotNull UploadFrequency uploadFrequency) {
        Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"<set-?>");
        CoreFeature.uploadFrequency = uploadFrequency;
    }

    @NotNull
    public final NdkCrashHandler getNdkCrashHandler$dd_sdk_android_release() {
        return ndkCrashHandler;
    }

    public final void setNdkCrashHandler$dd_sdk_android_release(@NotNull NdkCrashHandler ndkCrashHandler) {
        Intrinsics.checkNotNullParameter((Object)ndkCrashHandler, (String)"<set-?>");
        CoreFeature.ndkCrashHandler = ndkCrashHandler;
    }

    @NotNull
    public final ScheduledThreadPoolExecutor getUploadExecutorService$dd_sdk_android_release() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = uploadExecutorService;
        if (scheduledThreadPoolExecutor != null) {
            return scheduledThreadPoolExecutor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uploadExecutorService");
        throw null;
    }

    public final void setUploadExecutorService$dd_sdk_android_release(@NotNull ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        Intrinsics.checkNotNullParameter((Object)scheduledThreadPoolExecutor, (String)"<set-?>");
        uploadExecutorService = scheduledThreadPoolExecutor;
    }

    @NotNull
    public final ExecutorService getPersistenceExecutorService$dd_sdk_android_release() {
        ExecutorService executorService = persistenceExecutorService;
        if (executorService != null) {
            return executorService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"persistenceExecutorService");
        throw null;
    }

    public final void setPersistenceExecutorService$dd_sdk_android_release(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        persistenceExecutorService = executorService;
    }

    public final void initialize(@NotNull Context appContext, @NotNull Credentials credentials, @NotNull Configuration.Core configuration, @NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        if (initialized.get()) {
            return;
        }
        this.readConfigurationSettings(configuration);
        this.readApplicationInformation(appContext, credentials);
        this.resolveIsMainProcess(appContext);
        this.initializeClockSync(appContext);
        this.setupOkHttpClient(configuration);
        firstPartyHostDetector.addKnownHosts(configuration.getFirstPartyHosts());
        this.setupExecutors();
        timeProvider = new KronosTimeProvider((Clock)this.getKronosClock$dd_sdk_android_release());
        this.prepareNdkCrashData(appContext);
        this.setupInfoProviders(appContext, consent);
        initialized.set(true);
    }

    public final void stop() {
        if (initialized.get()) {
            Context context = (Context)contextRef.get();
            if (context != null) {
                Context context2 = context;
                boolean bl = false;
                boolean bl2 = false;
                Context it = context2;
                boolean bl3 = false;
                INSTANCE.getNetworkInfoProvider$dd_sdk_android_release().unregister(it);
                INSTANCE.getSystemInfoProvider$dd_sdk_android_release().unregister(it);
            }
            contextRef.clear();
            trackingConsentProvider.unregisterAllCallbacks();
            this.cleanupApplicationInfo();
            this.cleanupProviders();
            this.shutDownExecutors();
            initialized.set(false);
            ndkCrashHandler = new NoOpNdkCrashHandler();
        }
    }

    @NotNull
    public final FilePersistenceConfig buildFilePersistenceConfig() {
        return new FilePersistenceConfig(batchSize.getWindowDurationMs$dd_sdk_android_release(), 0L, 0L, 0, 0L, 0L, 62, null);
    }

    public final void drainAndShutdownExecutors() {
        ThreadPoolExecutor threadPoolExecutor;
        boolean bl = false;
        ArrayList tasks = new ArrayList();
        Object object = this.getPersistenceExecutorService$dd_sdk_android_release();
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = object instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)object : null;
        if (threadPoolExecutor != null && (object = threadPoolExecutor.getQueue()) != null) {
            object.drainTo(tasks);
        }
        this.getUploadExecutorService$dd_sdk_android_release().getQueue().drainTo(tasks);
        this.getPersistenceExecutorService$dd_sdk_android_release().shutdown();
        this.getUploadExecutorService$dd_sdk_android_release().shutdown();
        this.getPersistenceExecutorService$dd_sdk_android_release().awaitTermination(10L, TimeUnit.SECONDS);
        this.getUploadExecutorService$dd_sdk_android_release().awaitTermination(10L, TimeUnit.SECONDS);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl2 = false;
            it.run();
        }
    }

    private final void prepareNdkCrashData(Context appContext) {
        if (isMainProcess) {
            ndkCrashHandler = new DatadogNdkCrashHandler(appContext, this.getPersistenceExecutorService$dd_sdk_android_release(), new LogGenerator(serviceName, "ndk_crash", networkInfoProvider, userInfoProvider, timeProvider, sdkVersion, envName, packageVersion), new NdkCrashLogDeserializer(RuntimeUtilsKt.getSdkLogger()), new RumEventDeserializer(), new NetworkInfoDeserializer(RuntimeUtilsKt.getSdkLogger()), new UserInfoDeserializer(RuntimeUtilsKt.getSdkLogger()), RuntimeUtilsKt.getSdkLogger(), timeProvider);
            ndkCrashHandler.prepareData();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeClockSync(Context appContext) {
        void $this$initializeClockSync_u24lambda_u2d2;
        Object[] objectArray = new String[]{"0.datadog.pool.ntp.org", "1.datadog.pool.ntp.org", "2.datadog.pool.ntp.org", "3.datadog.pool.ntp.org"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        long l = TimeUnit.MINUTES.toMillis(30L);
        long l2 = TimeUnit.MINUTES.toMillis(5L);
        LoggingSyncListener loggingSyncListener = new LoggingSyncListener();
        list = AndroidClockFactory.createKronosClock$default((Context)appContext, (SyncListener)loggingSyncListener, (List)list, (long)0L, (long)l2, (long)l, (long)0L, (int)72, null);
        boolean bl = false;
        boolean bl2 = false;
        List list2 = list;
        CoreFeature coreFeature = this;
        boolean bl3 = false;
        $this$initializeClockSync_u24lambda_u2d2.syncInBackground();
        Unit unit = Unit.INSTANCE;
        coreFeature.setKronosClock$dd_sdk_android_release((KronosClock)list);
    }

    private final void readApplicationInformation(Context appContext, Credentials credentials) {
        String string;
        String string2 = appContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appContext.packageName");
        packageName = string2;
        string2 = appContext.getPackageManager().getPackageInfo(packageName, 0);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        String string3 = ((PackageInfo)it).versionName;
        packageVersion = string3 == null ? String.valueOf(((PackageInfo)it).versionCode) : string3;
        clientToken = credentials.getClientToken();
        string2 = credentials.getServiceName();
        if (string2 == null) {
            String string4 = appContext.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"appContext.packageName");
            string = string4;
        } else {
            string = string2;
        }
        serviceName = string;
        rumApplicationId = credentials.getRumApplicationId();
        envName = credentials.getEnvName();
        variant = credentials.getVariant();
        contextRef = new WeakReference<Context>(appContext);
    }

    private final void readConfigurationSettings(Configuration.Core configuration) {
        batchSize = configuration.getBatchSize();
        uploadFrequency = configuration.getUploadFrequency();
    }

    private final void setupInfoProviders(Context appContext, TrackingConsent consent) {
        trackingConsentProvider = new TrackingConsentProvider(consent);
        systemInfoProvider = new BroadcastReceiverSystemInfoProvider();
        systemInfoProvider.register(appContext);
        this.setupNetworkInfoProviders(appContext);
        this.setupUserInfoProvider(appContext);
    }

    private final void setupUserInfoProvider(Context appContext) {
        ScheduledWriter userInfoWriter = new ScheduledWriter(new NdkUserInfoDataWriter(appContext, trackingConsentProvider, this.getPersistenceExecutorService$dd_sdk_android_release(), new BatchFileHandler(RuntimeUtilsKt.getSdkLogger()), RuntimeUtilsKt.getSdkLogger()), this.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getSdkLogger());
        userInfoProvider = new DatadogUserInfoProvider(userInfoWriter);
    }

    private final void setupNetworkInfoProviders(Context appContext) {
        ScheduledWriter networkInfoWriter = new ScheduledWriter(new NdkNetworkInfoDataWriter(appContext, trackingConsentProvider, this.getPersistenceExecutorService$dd_sdk_android_release(), new BatchFileHandler(RuntimeUtilsKt.getSdkLogger()), RuntimeUtilsKt.getSdkLogger()), this.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getSdkLogger());
        networkInfoProvider = Build.VERSION.SDK_INT >= 24 ? (NetworkInfoProvider)new CallbackNetworkInfoProvider(networkInfoWriter) : (NetworkInfoProvider)new BroadcastReceiverNetworkInfoProvider(networkInfoWriter);
        networkInfoProvider.register(appContext);
    }

    private final void setupOkHttpClient(Configuration.Core configuration) {
        ConnectionSpec connectionSpec = configuration.getNeedsClearTextHttp() ? ConnectionSpec.CLEARTEXT : (Build.VERSION.SDK_INT >= 21 ? ConnectionSpec.RESTRICTED_TLS : ConnectionSpec.MODERN_TLS);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Protocol[] protocolArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        builder.addInterceptor((Interceptor)new GzipRequestInterceptor()).callTimeout(NETWORK_TIMEOUT_MS, TimeUnit.MILLISECONDS).writeTimeout(NETWORK_TIMEOUT_MS, TimeUnit.MILLISECONDS).protocols(CollectionsKt.listOf((Object[])protocolArray)).connectionSpecs(CollectionsKt.listOf((Object)connectionSpec));
        if (configuration.getProxy() != null) {
            builder.proxy(configuration.getProxy());
            builder.proxyAuthenticator(configuration.getProxyAuth());
        }
        protocolArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)protocolArray, (String)"builder.build()");
        okHttpClient = protocolArray;
    }

    private final void setupExecutors() {
        this.setUploadExecutorService$dd_sdk_android_release(new ScheduledThreadPoolExecutor(1));
        this.setPersistenceExecutorService$dd_sdk_android_release(new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), THREAD_POOL_MAX_KEEP_ALIVE_MS, TimeUnit.MILLISECONDS, new LinkedBlockingDeque()));
    }

    private final void resolveIsMainProcess(Context appContext) {
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
        int currentProcessId = Process.myPid();
        Object object = appContext.getSystemService("activity");
        ActivityManager manager = object instanceof ActivityManager ? (ActivityManager)object : null;
        ActivityManager activityManager = manager;
        if (activityManager == null) {
            runningAppProcessInfo = null;
        } else {
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                runningAppProcessInfo = null;
            } else {
                Object v1;
                block5: {
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ActivityManager.RunningAppProcessInfo it = (ActivityManager.RunningAppProcessInfo)element$iv;
                        boolean bl = false;
                        if (!(it.pid == currentProcessId)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                runningAppProcessInfo = v1;
            }
        }
        ActivityManager.RunningAppProcessInfo currentProcess = runningAppProcessInfo;
        isMainProcess = currentProcess == null ? true : Intrinsics.areEqual((Object)appContext.getPackageName(), (Object)currentProcess.processName);
    }

    private final void shutDownExecutors() {
        this.getUploadExecutorService$dd_sdk_android_release().shutdownNow();
        this.getPersistenceExecutorService$dd_sdk_android_release().shutdownNow();
        this.getUploadExecutorService$dd_sdk_android_release().awaitTermination(1L, TimeUnit.SECONDS);
        this.getPersistenceExecutorService$dd_sdk_android_release().awaitTermination(1L, TimeUnit.SECONDS);
    }

    private final void cleanupApplicationInfo() {
        clientToken = "";
        packageName = "";
        packageVersion = "";
        serviceName = "";
        sourceName = DEFAULT_SOURCE_NAME;
        rumApplicationId = null;
        isMainProcess = true;
        envName = "";
        variant = "";
    }

    private final void cleanupProviders() {
        firstPartyHostDetector = new FirstPartyHostDetector(CollectionsKt.emptyList());
        networkInfoProvider = new NoOpNetworkInfoProvider();
        systemInfoProvider = new NoOpSystemInfoProvider();
        timeProvider = new NoOpTimeProvider();
        trackingConsentProvider = new NoOpConsentProvider();
        userInfoProvider = new NoOpMutableUserInfoProvider();
    }

    static {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"Builder().build()");
        CoreFeature.okHttpClient = okHttpClient;
        clientToken = "";
        packageName = "";
        packageVersion = "";
        serviceName = "";
        sourceName = DEFAULT_SOURCE_NAME;
        sdkVersion = DEFAULT_SDK_VERSION;
        isMainProcess = true;
        envName = "";
        variant = "";
        batchSize = BatchSize.MEDIUM;
        uploadFrequency = UploadFrequency.AVERAGE;
        ndkCrashHandler = new NoOpNdkCrashHandler();
    }
}

