/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.net.RequestUniqueIdentifierKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.NoOpRumResourceAttributesProvider;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumResourceAttributesProvider;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.tracing.NoOpTracedRequestListener;
import com.datadog.android.tracing.TracedRequestListener;
import com.datadog.android.tracing.TracingInterceptor;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B)\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001b\b\u0017\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB=\b\u0000\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0016J.\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/datadog/android/DatadogInterceptor;", "Lcom/datadog/android/tracing/TracingInterceptor;", "firstPartyHosts", "", "", "tracedRequestListener", "Lcom/datadog/android/tracing/TracedRequestListener;", "rumResourceAttributesProvider", "Lcom/datadog/android/rum/RumResourceAttributesProvider;", "(Ljava/util/List;Lcom/datadog/android/tracing/TracedRequestListener;Lcom/datadog/android/rum/RumResourceAttributesProvider;)V", "(Lcom/datadog/android/tracing/TracedRequestListener;Lcom/datadog/android/rum/RumResourceAttributesProvider;)V", "tracedHosts", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "localTracerFactory", "Lkotlin/Function0;", "Lio/opentracing/Tracer;", "(Ljava/util/List;Lcom/datadog/android/tracing/TracedRequestListener;Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;Lcom/datadog/android/rum/RumResourceAttributesProvider;Lkotlin/jvm/functions/Function0;)V", "canSendSpan", "", "canSendSpan$dd_sdk_android_release", "getBodyLength", "", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)Ljava/lang/Long;", "handleResponse", "", "request", "Lokhttp3/Request;", "span", "Lio/opentracing/Span;", "handleThrowable", "throwable", "", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "onRequestIntercepted", "Companion", "dd-sdk-android_release"})
public class DatadogInterceptor
extends TracingInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumResourceAttributesProvider rumResourceAttributesProvider;
    @NotNull
    public static final String WARN_RUM_DISABLED = "You set up a DatadogInterceptor, but RUM features are disabled.Make sure you initialized the Datadog SDK with a valid Application Id, and that RUM features are enabled.";
    @NotNull
    public static final String ERROR_MSG_FORMAT = "OkHttp request error %s %s";
    @NotNull
    public static final String ORIGIN_RUM = "rum";
    private static final long MAX_BODY_PEEK = 0x2000000L;

    public DatadogInterceptor(@NotNull List<String> tracedHosts, @NotNull TracedRequestListener tracedRequestListener, @NotNull FirstPartyHostDetector firstPartyHostDetector, @NotNull RumResourceAttributesProvider rumResourceAttributesProvider, @NotNull Function0<? extends Tracer> localTracerFactory) {
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
        Intrinsics.checkNotNullParameter((Object)rumResourceAttributesProvider, (String)"rumResourceAttributesProvider");
        Intrinsics.checkNotNullParameter(localTracerFactory, (String)"localTracerFactory");
        super(tracedHosts, tracedRequestListener, firstPartyHostDetector, ORIGIN_RUM, localTracerFactory);
        this.rumResourceAttributesProvider = rumResourceAttributesProvider;
    }

    public /* synthetic */ DatadogInterceptor(List list, TracedRequestListener tracedRequestListener, FirstPartyHostDetector firstPartyHostDetector, RumResourceAttributesProvider rumResourceAttributesProvider, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            rumResourceAttributesProvider = new NoOpRumResourceAttributesProvider();
        }
        this((List<String>)list, tracedRequestListener, firstPartyHostDetector, rumResourceAttributesProvider, (Function0<? extends Tracer>)function0);
    }

    @JvmOverloads
    public DatadogInterceptor(@NotNull List<String> firstPartyHosts, @NotNull TracedRequestListener tracedRequestListener, @NotNull RumResourceAttributesProvider rumResourceAttributesProvider) {
        Intrinsics.checkNotNullParameter(firstPartyHosts, (String)"firstPartyHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        Intrinsics.checkNotNullParameter((Object)rumResourceAttributesProvider, (String)"rumResourceAttributesProvider");
        this(firstPartyHosts, tracedRequestListener, CoreFeature.INSTANCE.getFirstPartyHostDetector$dd_sdk_android_release(), rumResourceAttributesProvider, (Function0<? extends Tracer>)((Function0)1.INSTANCE));
    }

    public /* synthetic */ DatadogInterceptor(List list, TracedRequestListener tracedRequestListener, RumResourceAttributesProvider rumResourceAttributesProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        if ((n & 4) != 0) {
            rumResourceAttributesProvider = new NoOpRumResourceAttributesProvider();
        }
        this(list, tracedRequestListener, rumResourceAttributesProvider);
    }

    @JvmOverloads
    public DatadogInterceptor(@NotNull TracedRequestListener tracedRequestListener, @NotNull RumResourceAttributesProvider rumResourceAttributesProvider) {
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        Intrinsics.checkNotNullParameter((Object)rumResourceAttributesProvider, (String)"rumResourceAttributesProvider");
        this((List<String>)CollectionsKt.emptyList(), tracedRequestListener, CoreFeature.INSTANCE.getFirstPartyHostDetector$dd_sdk_android_release(), rumResourceAttributesProvider, (Function0<? extends Tracer>)((Function0)2.INSTANCE));
    }

    public /* synthetic */ DatadogInterceptor(TracedRequestListener tracedRequestListener, RumResourceAttributesProvider rumResourceAttributesProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        if ((n & 2) != 0) {
            rumResourceAttributesProvider = new NoOpRumResourceAttributesProvider();
        }
        this(tracedRequestListener, rumResourceAttributesProvider);
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (RumFeature.INSTANCE.isInitialized()) {
            Request request = chain.request();
            String string = request.url().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url().toString()");
            String url = string;
            String method = request.method();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
            String requestId = RequestUniqueIdentifierKt.identifyRequest(request);
            RumMonitor rumMonitor = GlobalRum.get();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            RumMonitor.DefaultImpls.startResource$default(rumMonitor, requestId, method, url, null, 8, null);
        } else {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), WARN_RUM_DISABLED, null, null, 6, null);
        }
        return super.intercept(chain);
    }

    @Override
    protected void onRequestIntercepted(@NotNull Request request, @Nullable Span span, @Nullable Response response, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super.onRequestIntercepted(request, span, response, throwable);
        if (RumFeature.INSTANCE.isInitialized()) {
            if (throwable != null) {
                this.handleThrowable(request, throwable);
            } else {
                this.handleResponse(request, response, span);
            }
        }
    }

    @Override
    public boolean canSendSpan$dd_sdk_android_release() {
        return !RumFeature.INSTANCE.isInitialized();
    }

    private final void handleResponse(Request request, Response response, Span span) {
        Map map;
        RumResourceKind kind;
        String requestId = RequestUniqueIdentifierKt.identifyRequest(request);
        Response response2 = response;
        Integer statusCode = response2 == null ? null : Integer.valueOf(response2.code());
        Response response3 = response;
        String mimeType = response3 == null ? null : response3.header("Content-Type");
        RumResourceKind rumResourceKind = kind = mimeType == null ? RumResourceKind.NATIVE : RumResourceKind.Companion.fromMimeType$dd_sdk_android_release(mimeType);
        if (span == null) {
            map = MapsKt.emptyMap();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_dd.trace_id", (Object)span.context().toTraceId()), TuplesKt.to((Object)"_dd.span_id", (Object)span.context().toSpanId())};
            map = MapsKt.mapOf((Pair[])pairArray);
        }
        Map attributes = map;
        GlobalRum.get().stopResource(requestId, statusCode, this.getBodyLength(response), kind, MapsKt.plus((Map)attributes, this.rumResourceAttributesProvider.onProvideAttributes(request, response, null)));
    }

    private final void handleThrowable(Request request, Throwable throwable) {
        String requestId = RequestUniqueIdentifierKt.identifyRequest(request);
        String method = request.method();
        String string = request.url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url().toString()");
        String url = string;
        RumMonitor rumMonitor = GlobalRum.get();
        string = ERROR_MSG_FORMAT;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{method, url};
        boolean bl = false;
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
        rumMonitor.stopResourceWithError(requestId, null, string2, RumErrorSource.NETWORK, throwable, this.rumResourceAttributesProvider.onProvideAttributes(request, null, throwable));
    }

    private final Long getBodyLength(Response response) {
        Long contentLength;
        ResponseBody body;
        Response response2 = response;
        ResponseBody responseBody = body = response2 == null ? null : response2.peekBody(0x2000000L);
        Long l = contentLength = responseBody == null ? null : Long.valueOf(responseBody.contentLength());
        long l2 = 0L;
        return l != null && l == l2 ? null : contentLength;
    }

    @JvmOverloads
    public DatadogInterceptor(@NotNull List<String> firstPartyHosts, @NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter(firstPartyHosts, (String)"firstPartyHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(firstPartyHosts, tracedRequestListener, null, 4, null);
    }

    @JvmOverloads
    public DatadogInterceptor(@NotNull List<String> firstPartyHosts) {
        Intrinsics.checkNotNullParameter(firstPartyHosts, (String)"firstPartyHosts");
        this(firstPartyHosts, null, null, 6, null);
    }

    @JvmOverloads
    public DatadogInterceptor(@NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(tracedRequestListener, null, 2, null);
    }

    @JvmOverloads
    public DatadogInterceptor() {
        this((TracedRequestListener)null, (RumResourceAttributesProvider)null, 3, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/DatadogInterceptor$Companion;", "", "()V", "ERROR_MSG_FORMAT", "", "MAX_BODY_PEEK", "", "ORIGIN_RUM", "WARN_RUM_DISABLED", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

