/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import com.datadog.android.webview.internal.rum.domain.NativeRumViewsCache;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventMapper;", "", "nativeRumViewsCache", "Lcom/datadog/android/webview/internal/rum/domain/NativeRumViewsCache;", "(Lcom/datadog/android/webview/internal/rum/domain/NativeRumViewsCache;)V", "mapEvent", "Lcom/google/gson/JsonObject;", "event", "rumContext", "Lcom/datadog/android/webview/internal/rum/domain/RumContext;", "timeOffset", "", "sessionReplayEnabled", "", "Companion", "dd-sdk-android-webview_release"})
public final class WebViewRumEventMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativeRumViewsCache nativeRumViewsCache;
    @NotNull
    public static final String APPLICATION_KEY_NAME = "application";
    @NotNull
    public static final String SESSION_KEY_NAME = "session";
    @NotNull
    public static final String DD_KEY_NAME = "_dd";
    @NotNull
    public static final String DD_SESSION_KEY_NAME = "session";
    @NotNull
    public static final String DD_REPLAY_STATS = "replay_stats";
    @NotNull
    public static final String DATE_KEY_NAME = "date";
    @NotNull
    public static final String ID_KEY_NAME = "id";
    @NotNull
    public static final String SESSION_HAS_REPLAY_NAME = "has_replay";
    @NotNull
    public static final String VIEW_KEY_NAME = "view";
    @NotNull
    public static final String CONTAINER_KEY_NAME = "container";
    @NotNull
    public static final String SOURCE_KEY_NAME = "source";
    @NotNull
    public static final String SOURCE_VALUE = "android";

    public WebViewRumEventMapper(@NotNull NativeRumViewsCache nativeRumViewsCache) {
        Intrinsics.checkNotNullParameter((Object)nativeRumViewsCache, (String)"nativeRumViewsCache");
        this.nativeRumViewsCache = nativeRumViewsCache;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject mapEvent(@NotNull JsonObject event, @Nullable RumContext rumContext, long timeOffset, boolean sessionReplayEnabled) throws ClassCastException, IllegalStateException, NumberFormatException {
        JsonObject dd;
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JsonObject $this$mapEvent_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl5 = false;
        $this$mapEvent_u24lambda_u240.addProperty(SOURCE_KEY_NAME, SOURCE_VALUE);
        JsonObject containerObject = jsonObject;
        JsonElement jsonElement = event.get(DATE_KEY_NAME);
        if (jsonElement != null) {
            long eventDate = jsonElement.getAsLong();
            boolean bl2 = false;
            String string = this.nativeRumViewsCache.resolveLastParentIdForBrowserEvent(eventDate);
            if (string != null) {
                void $this$mapEvent_u24lambda_u243_u24lambda_u242_u24lambda_u241;
                JsonObject jsonObject2;
                String it = string;
                boolean bl3 = false;
                JsonObject jsonObject3 = jsonObject2 = new JsonObject();
                String string2 = VIEW_KEY_NAME;
                JsonObject jsonObject4 = containerObject;
                boolean bl4 = false;
                $this$mapEvent_u24lambda_u243_u24lambda_u242_u24lambda_u241.addProperty(ID_KEY_NAME, it);
                Unit unit = Unit.INSTANCE;
                jsonObject4.add(string2, (JsonElement)jsonObject2);
            }
            event.addProperty(DATE_KEY_NAME, (Number)(eventDate + timeOffset));
        }
        event.add(CONTAINER_KEY_NAME, (JsonElement)containerObject);
        JsonElement jsonElement2 = event.get(DD_KEY_NAME);
        Object object = dd = jsonElement2 != null ? jsonElement2.getAsJsonObject() : null;
        if (dd != null) {
            JsonElement jsonElement3 = dd.get("session");
            Object object2 = jsonElement3 != null ? jsonElement3.getAsJsonObject() : null;
            if (object2 == null) {
                object2 = new JsonObject();
            }
            JsonObject ddSession = object2;
            dd.add("session", (JsonElement)ddSession);
            if (!sessionReplayEnabled) {
                dd.remove(DD_REPLAY_STATS);
            }
        }
        if (rumContext != null) {
            JsonObject jsonObject5 = event.getAsJsonObject(APPLICATION_KEY_NAME);
            JsonObject bl5 = jsonObject5 != null ? jsonObject5.getAsJsonObject() : null;
            JsonObject application = bl5 == null ? new JsonObject() : bl5;
            JsonObject jsonObject6 = event.getAsJsonObject("session");
            Object object3 = jsonObject6 != null ? jsonObject6.getAsJsonObject() : null;
            if (object3 == null) {
                object3 = new JsonObject();
            }
            JsonObject session = object3;
            application.addProperty(ID_KEY_NAME, rumContext.getApplicationId());
            session.addProperty(ID_KEY_NAME, rumContext.getSessionId());
            if (!sessionReplayEnabled) {
                session.remove(SESSION_HAS_REPLAY_NAME);
            }
            event.add(APPLICATION_KEY_NAME, (JsonElement)application);
            event.add("session", (JsonElement)session);
        }
        return event;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventMapper$Companion;", "", "()V", "APPLICATION_KEY_NAME", "", "CONTAINER_KEY_NAME", "DATE_KEY_NAME", "DD_KEY_NAME", "DD_REPLAY_STATS", "DD_SESSION_KEY_NAME", "ID_KEY_NAME", "SESSION_HAS_REPLAY_NAME", "SESSION_KEY_NAME", "SOURCE_KEY_NAME", "SOURCE_VALUE", "VIEW_KEY_NAME", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

