/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview;

import android.webkit.WebView;
import androidx.annotation.FloatRange;
import androidx.annotation.MainThread;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.NoOpDataWriter;
import com.datadog.android.lint.InternalApi;
import com.datadog.android.webview.WebViewTracking;
import com.datadog.android.webview.internal.DatadogEventBridge;
import com.datadog.android.webview.internal.MixedWebViewEventConsumer;
import com.datadog.android.webview.internal.NoOpWebViewEventConsumer;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogsFeature;
import com.datadog.android.webview.internal.replay.WebViewReplayEventConsumer;
import com.datadog.android.webview.internal.replay.WebViewReplayEventMapper;
import com.datadog.android.webview.internal.replay.WebViewReplayFeature;
import com.datadog.android.webview.internal.rum.TimestampOffsetProvider;
import com.datadog.android.webview.internal.rum.WebViewRumEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.WebViewRumEventMapper;
import com.datadog.android.webview.internal.rum.WebViewRumFeature;
import com.datadog.android.webview.internal.rum.domain.NativeRumViewsCache;
import com.datadog.android.webview.internal.rum.domain.NoOpNativeRumViewsCache;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\b\b\u0003\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\r\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/webview/WebViewTracking;", "", "()V", "DATADOG_EVENT_BRIDGE_NAME", "", "JAVA_SCRIPT_NOT_ENABLED_WARNING_MESSAGE", "LOGS_FEATURE_MISSING_INFO", "RUM_FEATURE_MISSING_INFO", "SESSION_REPLAY_FEATURE_MISSING_INFO", "SESSION_REPLAY_MASK_ALL_PRIVACY", "SESSION_REPLAY_PRIVACY_KEY", "buildWebViewEventConsumer", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "logsSampleRate", "", "webViewId", "enable", "", "webView", "Landroid/webkit/WebView;", "allowedHosts", "", "Lcom/datadog/android/api/SdkCore;", "resolveLogsFeature", "Lcom/datadog/android/webview/internal/log/WebViewLogsFeature;", "resolveReplayFeature", "Lcom/datadog/android/webview/internal/replay/WebViewReplayFeature;", "resolveRumFeature", "Lcom/datadog/android/webview/internal/rum/WebViewRumFeature;", "_InternalWebViewProxy", "dd-sdk-android-webview_release"})
@SourceDebugExtension(value={"SMAP\nWebViewTracking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewTracking.kt\ncom/datadog/android/webview/WebViewTracking\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
public final class WebViewTracking {
    @NotNull
    public static final WebViewTracking INSTANCE = new WebViewTracking();
    @NotNull
    public static final String SESSION_REPLAY_PRIVACY_KEY = "session_replay_privacy";
    @NotNull
    public static final String SESSION_REPLAY_MASK_ALL_PRIVACY = "mask";
    @NotNull
    public static final String JAVA_SCRIPT_NOT_ENABLED_WARNING_MESSAGE = "You are trying to enable the WebViewtracking but the java script capability was not enabled for the given WebView.";
    @NotNull
    public static final String DATADOG_EVENT_BRIDGE_NAME = "DatadogEventBridge";
    @NotNull
    public static final String RUM_FEATURE_MISSING_INFO = "RUM feature is not registered, will ignore RUM events from WebView.";
    @NotNull
    public static final String LOGS_FEATURE_MISSING_INFO = "Logs feature is not registered, will ignore Log events from WebView.";
    @NotNull
    public static final String SESSION_REPLAY_FEATURE_MISSING_INFO = "Session replay feature is not registered, will ignore replay records from WebView.";

    private WebViewTracking() {
    }

    @JvmStatic
    @MainThread
    @JvmOverloads
    public static final void enable(@NotNull WebView webView, @NotNull List<String> allowedHosts, @FloatRange(from=0.0, to=100.0) float logsSampleRate, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter(allowedHosts, (String)"allowedHosts");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        if (!webView.getSettings().getJavaScriptEnabled()) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)((FeatureSdkCore)sdkCore).getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)enable.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        FeatureSdkCore featureSdkCore = (FeatureSdkCore)sdkCore;
        Map featureContext = ((FeatureSdkCore)sdkCore).getFeatureContext("session-replay");
        Object v = featureContext.get(SESSION_REPLAY_PRIVACY_KEY);
        String string = v instanceof String ? (String)v : null;
        if (string == null) {
            string = SESSION_REPLAY_MASK_ALL_PRIVACY;
        }
        String privacyLevel = string;
        WebViewEventConsumer<String> webViewEventConsumer = INSTANCE.buildWebViewEventConsumer(featureSdkCore, logsSampleRate, String.valueOf(System.identityHashCode(webView)));
        webView.addJavascriptInterface((Object)new DatadogEventBridge(webViewEventConsumer, allowedHosts, privacyLevel), DATADOG_EVENT_BRIDGE_NAME);
    }

    public static /* synthetic */ void enable$default(WebView webView, List list, float f, SdkCore sdkCore, int n, Object object) {
        if ((n & 4) != 0) {
            f = 100.0f;
        }
        if ((n & 8) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        WebViewTracking.enable(webView, list, f, sdkCore);
    }

    /*
     * WARNING - void declaration
     */
    private final WebViewEventConsumer<String> buildWebViewEventConsumer(FeatureSdkCore sdkCore, float logsSampleRate, String webViewId) {
        DataWriter dataWriter;
        WebViewEventConsumer webViewEventConsumer;
        DataWriter dataWriter2;
        Object nativeRumActivityHandler;
        DataWriter webViewRumFeature = this.resolveRumFeature(sdkCore);
        DataWriter webViewLogsFeature = this.resolveLogsFeature(sdkCore);
        DataWriter webViewReplayFeature = this.resolveReplayFeature(sdkCore);
        if (webViewLogsFeature == null && webViewRumFeature == null) {
            return new NoOpWebViewEventConsumer();
        }
        TimestampOffsetProvider timestampOffsetProvider = new TimestampOffsetProvider(sdkCore.getInternalLogger());
        WebViewRumEventContextProvider contextProvider = new WebViewRumEventContextProvider(sdkCore.getInternalLogger());
        Object object = webViewRumFeature;
        if (object == null || (object = ((WebViewRumFeature)object).getNativeRumViewsCache$dd_sdk_android_webview_release()) == null) {
            object = nativeRumActivityHandler = (NativeRumViewsCache)new NoOpNativeRumViewsCache();
        }
        if ((dataWriter2 = webViewRumFeature) == null || (dataWriter2 = dataWriter2.getDataWriter$dd_sdk_android_webview_release()) == null) {
            dataWriter2 = (DataWriter)new NoOpDataWriter();
        }
        DataWriter dataWriter3 = dataWriter2;
        WebViewRumEventMapper webViewRumEventMapper = new WebViewRumEventMapper((NativeRumViewsCache)nativeRumActivityHandler);
        WebViewEventConsumer webViewEventConsumer2 = new WebViewRumEventConsumer(sdkCore, (DataWriter<JsonObject>)dataWriter3, timestampOffsetProvider, webViewRumEventMapper, contextProvider);
        String string = webViewId;
        if (string != null) {
            void it;
            String string2 = string;
            WebViewEventConsumer webViewEventConsumer3 = webViewEventConsumer2;
            boolean bl = false;
            DataWriter dataWriter4 = webViewReplayFeature;
            if (dataWriter4 == null || (dataWriter4 = dataWriter4.getDataWriter$dd_sdk_android_webview_release()) == null) {
                dataWriter4 = (DataWriter)new NoOpDataWriter();
            }
            webViewEventConsumer2 = webViewEventConsumer3;
            webViewEventConsumer = new WebViewReplayEventConsumer(sdkCore, (DataWriter<JsonObject>)dataWriter4, contextProvider, new WebViewReplayEventMapper((String)it, timestampOffsetProvider));
        } else {
            webViewEventConsumer = new NoOpWebViewEventConsumer();
        }
        if ((dataWriter = webViewLogsFeature) == null || (dataWriter = dataWriter.getDataWriter$dd_sdk_android_webview_release()) == null) {
            dataWriter = (DataWriter)new NoOpDataWriter();
        }
        InternalLogger internalLogger = sdkCore.getInternalLogger();
        WebViewEventConsumer webViewEventConsumer4 = new WebViewLogEventConsumer(sdkCore, (DataWriter<JsonObject>)dataWriter, contextProvider, logsSampleRate);
        WebViewEventConsumer webViewEventConsumer5 = webViewEventConsumer;
        WebViewEventConsumer webViewEventConsumer6 = webViewEventConsumer2;
        return new MixedWebViewEventConsumer(webViewEventConsumer6, webViewEventConsumer5, webViewEventConsumer4, internalLogger);
    }

    private final WebViewRumFeature resolveRumFeature(FeatureSdkCore sdkCore) {
        StorageBackedFeature storageBackedFeature;
        StorageBackedFeature rumFeature;
        WebViewRumFeature webViewRumFeature;
        FeatureScope featureScope = sdkCore.getFeature("web-rum");
        StorageBackedFeature storageBackedFeature2 = featureScope != null ? (StorageBackedFeature)featureScope.unwrap() : null;
        WebViewRumFeature webViewRumFeature2 = webViewRumFeature = storageBackedFeature2 instanceof WebViewRumFeature ? (WebViewRumFeature)storageBackedFeature2 : null;
        if (webViewRumFeature != null) {
            WebViewRumFeature it = webViewRumFeature;
            boolean bl = false;
            return it;
        }
        storageBackedFeature2 = sdkCore.getFeature("rum");
        StorageBackedFeature storageBackedFeature3 = rumFeature = storageBackedFeature2 != null ? (StorageBackedFeature)storageBackedFeature2.unwrap() : null;
        if (rumFeature != null) {
            StorageBackedFeature $this$resolveRumFeature_u24lambda_u242 = storageBackedFeature2 = new WebViewRumFeature(sdkCore, rumFeature.getRequestFactory(), null, 4, null);
            boolean bl = false;
            sdkCore.registerFeature((Feature)$this$resolveRumFeature_u24lambda_u242);
            storageBackedFeature = storageBackedFeature2;
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)resolveRumFeature.3.INSTANCE, null, (boolean)false, null, (int)56, null);
            storageBackedFeature = null;
        }
        return storageBackedFeature;
    }

    private final WebViewReplayFeature resolveReplayFeature(FeatureSdkCore sdkCore) {
        StorageBackedFeature storageBackedFeature;
        StorageBackedFeature sessionReplayFeature;
        WebViewReplayFeature webViewReplayFeature;
        FeatureScope featureScope = sdkCore.getFeature("web-replay");
        StorageBackedFeature storageBackedFeature2 = featureScope != null ? (StorageBackedFeature)featureScope.unwrap() : null;
        WebViewReplayFeature webViewReplayFeature2 = webViewReplayFeature = storageBackedFeature2 instanceof WebViewReplayFeature ? (WebViewReplayFeature)storageBackedFeature2 : null;
        if (webViewReplayFeature != null) {
            WebViewReplayFeature it = webViewReplayFeature;
            boolean bl = false;
            return it;
        }
        storageBackedFeature2 = sdkCore.getFeature("session-replay");
        StorageBackedFeature storageBackedFeature3 = sessionReplayFeature = storageBackedFeature2 != null ? (StorageBackedFeature)storageBackedFeature2.unwrap() : null;
        if (sessionReplayFeature != null) {
            StorageBackedFeature $this$resolveReplayFeature_u24lambda_u244 = storageBackedFeature2 = new WebViewReplayFeature(sdkCore, sessionReplayFeature.getRequestFactory());
            boolean bl = false;
            sdkCore.registerFeature((Feature)$this$resolveReplayFeature_u24lambda_u244);
            storageBackedFeature = storageBackedFeature2;
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)resolveReplayFeature.3.INSTANCE, null, (boolean)false, null, (int)56, null);
            storageBackedFeature = null;
        }
        return storageBackedFeature;
    }

    private final WebViewLogsFeature resolveLogsFeature(FeatureSdkCore sdkCore) {
        StorageBackedFeature storageBackedFeature;
        StorageBackedFeature logsFeature;
        WebViewLogsFeature webViewLogsFeature;
        FeatureScope featureScope = sdkCore.getFeature("web-logs");
        StorageBackedFeature storageBackedFeature2 = featureScope != null ? (StorageBackedFeature)featureScope.unwrap() : null;
        WebViewLogsFeature webViewLogsFeature2 = webViewLogsFeature = storageBackedFeature2 instanceof WebViewLogsFeature ? (WebViewLogsFeature)storageBackedFeature2 : null;
        if (webViewLogsFeature != null) {
            WebViewLogsFeature it = webViewLogsFeature;
            boolean bl = false;
            return it;
        }
        storageBackedFeature2 = sdkCore.getFeature("logs");
        StorageBackedFeature storageBackedFeature3 = logsFeature = storageBackedFeature2 != null ? (StorageBackedFeature)storageBackedFeature2.unwrap() : null;
        if (logsFeature != null) {
            StorageBackedFeature $this$resolveLogsFeature_u24lambda_u246 = storageBackedFeature2 = new WebViewLogsFeature(sdkCore, logsFeature.getRequestFactory());
            boolean bl = false;
            sdkCore.registerFeature((Feature)$this$resolveLogsFeature_u24lambda_u246);
            storageBackedFeature = storageBackedFeature2;
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)resolveLogsFeature.3.INSTANCE, null, (boolean)false, null, (int)56, null);
            storageBackedFeature = null;
        }
        return storageBackedFeature;
    }

    @JvmStatic
    @MainThread
    @JvmOverloads
    public static final void enable(@NotNull WebView webView, @NotNull List<String> allowedHosts, @FloatRange(from=0.0, to=100.0) float logsSampleRate) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter(allowedHosts, (String)"allowedHosts");
        WebViewTracking.enable$default(webView, allowedHosts, logsSampleRate, null, 8, null);
    }

    @JvmStatic
    @MainThread
    @JvmOverloads
    public static final void enable(@NotNull WebView webView, @NotNull List<String> allowedHosts) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter(allowedHosts, (String)"allowedHosts");
        WebViewTracking.enable$default(webView, allowedHosts, 0.0f, null, 12, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/webview/WebViewTracking$_InternalWebViewProxy;", "", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "webViewId", "", "(Lcom/datadog/android/api/SdkCore;Ljava/lang/String;)V", "consumer", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "getConsumer$dd_sdk_android_webview_release", "()Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "consumeWebviewEvent", "", "event", "dd-sdk-android-webview_release"})
    @InternalApi
    public static final class _InternalWebViewProxy {
        @NotNull
        private final WebViewEventConsumer<String> consumer;

        public _InternalWebViewProxy(@NotNull SdkCore sdkCore, @Nullable String webViewId) {
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            this.consumer = INSTANCE.buildWebViewEventConsumer((FeatureSdkCore)sdkCore, 100.0f, webViewId);
        }

        public /* synthetic */ _InternalWebViewProxy(SdkCore sdkCore, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(sdkCore, string);
        }

        @NotNull
        public final WebViewEventConsumer<String> getConsumer$dd_sdk_android_webview_release() {
            return this.consumer;
        }

        public final void consumeWebviewEvent(@NotNull String event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.consumer.consume(event);
        }
    }
}

