/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.storage;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.core.persistence.SerializerKt;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/webview/internal/storage/WebViewDataWriter;", "Lcom/datadog/android/api/storage/DataWriter;", "Lcom/google/gson/JsonObject;", "serializer", "Lcom/datadog/android/core/persistence/Serializer;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/core/persistence/Serializer;Lcom/datadog/android/api/InternalLogger;)V", "write", "", "writer", "Lcom/datadog/android/api/storage/EventBatchWriter;", "element", "eventType", "Lcom/datadog/android/api/storage/EventType;", "dd-sdk-android-webview_release"})
public final class WebViewDataWriter
implements DataWriter<JsonObject> {
    @NotNull
    private final Serializer<JsonObject> serializer;
    @NotNull
    private final InternalLogger internalLogger;

    public WebViewDataWriter(@NotNull Serializer<JsonObject> serializer, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.serializer = serializer;
        this.internalLogger = internalLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean write(@NotNull EventBatchWriter writer, @NotNull JsonObject element, @NotNull EventType eventType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        byte[] byArray = SerializerKt.serializeToByteArray(this.serializer, (Object)element, (InternalLogger)this.internalLogger);
        if (byArray == null) {
            return false;
        }
        byte[] serialized = byArray;
        WebViewDataWriter webViewDataWriter = this;
        synchronized (webViewDataWriter) {
            boolean bl2 = false;
            bl = writer.write(new RawBatchEvent(serialized, null, 2, null), null, eventType);
        }
        return bl;
    }
}

