/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "rumFeatureDisabled", "", "getRumContext", "Lcom/datadog/android/webview/internal/rum/domain/RumContext;", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "Companion", "dd-sdk-android-webview_release"})
public final class WebViewRumEventContextProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    private boolean rumFeatureDisabled;
    @NotNull
    public static final String RUM_NOT_INITIALIZED_WARNING_MESSAGE = "You are trying to use the WebView tracking API but the RUM feature was not properly initialized.";

    public WebViewRumEventContextProvider(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Nullable
    public final RumContext getRumContext(@NotNull DatadogContext datadogContext) {
        RumContext rumContext;
        String rumSessionState;
        Map rumContext2;
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        if (this.rumFeatureDisabled) {
            return null;
        }
        Map map2 = rumContext2 = (Map)datadogContext.getFeaturesContext().get("rum");
        Object v = map2 != null ? map2.get("application_id") : null;
        String rumApplicationId = v instanceof String ? (String)v : null;
        Map map3 = rumContext2;
        Object v2 = map3 != null ? map3.get("session_id") : null;
        String rumSessionId = v2 instanceof String ? (String)v2 : null;
        Map map4 = rumContext2;
        Object object = map4 != null ? map4.get("session_state") : null;
        String string = rumSessionState = object instanceof String ? (String)object : null;
        if (rumApplicationId == null || Intrinsics.areEqual((Object)rumApplicationId, (Object)RumContext.Companion.getNULL_UUID()) || rumSessionId == null || Intrinsics.areEqual((Object)rumSessionId, (Object)RumContext.Companion.getNULL_UUID()) || (object = (CharSequence)rumSessionState) == null || StringsKt.isBlank(object)) {
            this.rumFeatureDisabled = true;
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)getRumContext.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            rumContext = null;
        } else {
            rumContext = new RumContext(rumApplicationId, rumSessionId, rumSessionState);
        }
        return rumContext;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider$Companion;", "", "()V", "RUM_NOT_INITIALIZED_WARNING_MESSAGE", "", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

