/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.rum.TimestampOffsetProvider;
import com.datadog.android.webview.internal.rum.WebViewRumEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.WebViewRumEventMapper;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0017J*\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventConsumer;", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "Lcom/google/gson/JsonObject;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "dataWriter", "Lcom/datadog/android/api/storage/DataWriter;", "offsetProvider", "Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;", "webViewRumEventMapper", "Lcom/datadog/android/webview/internal/rum/WebViewRumEventMapper;", "contextProvider", "Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/api/storage/DataWriter;Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;Lcom/datadog/android/webview/internal/rum/WebViewRumEventMapper;Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;)V", "getDataWriter$dd_sdk_android_webview_release", "()Lcom/datadog/android/api/storage/DataWriter;", "getOffsetProvider$dd_sdk_android_webview_release", "()Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;", "consume", "", "event", "map", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "rumContext", "Lcom/datadog/android/webview/internal/rum/domain/RumContext;", "sessionReplayEnabled", "", "Companion", "dd-sdk-android-webview_release"})
@SourceDebugExtension(value={"SMAP\nWebViewRumEventConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewRumEventConsumer.kt\ncom/datadog/android/webview/internal/rum/WebViewRumEventConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class WebViewRumEventConsumer
implements WebViewEventConsumer<JsonObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final DataWriter<JsonObject> dataWriter;
    @NotNull
    private final TimestampOffsetProvider offsetProvider;
    @NotNull
    private final WebViewRumEventMapper webViewRumEventMapper;
    @NotNull
    private final WebViewRumEventContextProvider contextProvider;
    @NotNull
    public static final String VIEW_EVENT_TYPE = "view";
    @NotNull
    public static final String ACTION_EVENT_TYPE = "action";
    @NotNull
    public static final String RESOURCE_EVENT_TYPE = "resource";
    @NotNull
    public static final String ERROR_EVENT_TYPE = "error";
    @NotNull
    public static final String LONG_TASK_EVENT_TYPE = "long_task";
    @NotNull
    public static final String RUM_EVENT_TYPE = "rum";
    @NotNull
    public static final String VIEW_KEY_NAME = "view";
    @NotNull
    public static final String VIEW_ID_KEY_NAME = "id";
    @NotNull
    public static final String JSON_PARSING_ERROR_MESSAGE = "The bundled web RUM event could not be deserialized";
    @NotNull
    private static final Set<String> RUM_EVENT_TYPES;

    public WebViewRumEventConsumer(@NotNull FeatureSdkCore sdkCore, @NotNull DataWriter<JsonObject> dataWriter, @NotNull TimestampOffsetProvider offsetProvider, @NotNull WebViewRumEventMapper webViewRumEventMapper, @NotNull WebViewRumEventContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(dataWriter, (String)"dataWriter");
        Intrinsics.checkNotNullParameter((Object)offsetProvider, (String)"offsetProvider");
        Intrinsics.checkNotNullParameter((Object)webViewRumEventMapper, (String)"webViewRumEventMapper");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        this.sdkCore = sdkCore;
        this.dataWriter = dataWriter;
        this.offsetProvider = offsetProvider;
        this.webViewRumEventMapper = webViewRumEventMapper;
        this.contextProvider = contextProvider;
    }

    public /* synthetic */ WebViewRumEventConsumer(FeatureSdkCore featureSdkCore, DataWriter dataWriter, TimestampOffsetProvider timestampOffsetProvider, WebViewRumEventMapper webViewRumEventMapper, WebViewRumEventContextProvider webViewRumEventContextProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            webViewRumEventContextProvider = new WebViewRumEventContextProvider(featureSdkCore.getInternalLogger());
        }
        this(featureSdkCore, (DataWriter<JsonObject>)dataWriter, timestampOffsetProvider, webViewRumEventMapper, webViewRumEventContextProvider);
    }

    @NotNull
    public final DataWriter<JsonObject> getDataWriter$dd_sdk_android_webview_release() {
        return this.dataWriter;
    }

    @NotNull
    public final TimestampOffsetProvider getOffsetProvider$dd_sdk_android_webview_release() {
        return this.offsetProvider;
    }

    @Override
    @WorkerThread
    public void consume(@NotNull JsonObject event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FeatureScope featureScope = this.sdkCore.getFeature(RUM_EVENT_TYPE);
        if (featureScope != null) {
            featureScope.sendEvent((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"web_view_ingested_notification")));
        }
        FeatureScope featureScope2 = this.sdkCore.getFeature("web-rum");
        if (featureScope2 != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope2, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, event){
                final /* synthetic */ WebViewRumEventConsumer this$0;
                final /* synthetic */ JsonObject $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    RumContext rumContext = WebViewRumEventConsumer.access$getContextProvider$p(this.this$0).getRumContext(datadogContext);
                    if (rumContext != null && Intrinsics.areEqual((Object)rumContext.getSessionState(), (Object)"TRACKED")) {
                        Map sessionReplayFeatureContext;
                        Map map2 = sessionReplayFeatureContext = (Map)datadogContext.getFeaturesContext().get("session-replay");
                        V v = map2 != null ? map2.get("session_replay_is_enabled") : null;
                        Boolean bl = v instanceof Boolean ? (Boolean)v : null;
                        boolean sessionReplayEnabled = bl != null ? bl : false;
                        JsonObject mappedEvent = WebViewRumEventConsumer.access$map(this.this$0, this.$event, datadogContext, rumContext, sessionReplayEnabled);
                        this.this$0.getDataWriter$dd_sdk_android_webview_release().write(eventBatchWriter, (Object)mappedEvent, EventType.DEFAULT);
                    }
                }
            }), (int)1, null);
        }
    }

    private final JsonObject map(JsonObject event, DatadogContext datadogContext, RumContext rumContext, boolean sessionReplayEnabled) {
        try {
            long l;
            String string;
            JsonElement jsonElement;
            JsonObject jsonObject;
            JsonElement jsonElement2 = event.get("view");
            if (jsonElement2 != null && (jsonObject = jsonElement2.getAsJsonObject()) != null && (jsonElement = jsonObject.get(VIEW_ID_KEY_NAME)) != null && (string = jsonElement.getAsString()) != null) {
                String it = string;
                boolean bl = false;
                l = this.offsetProvider.getOffset$dd_sdk_android_webview_release(it, datadogContext);
            } else {
                l = 0L;
            }
            long timeOffset = l;
            return this.webViewRumEventMapper.mapEvent(event, rumContext, timeOffset, sessionReplayEnabled);
        }
        catch (ClassCastException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (NumberFormatException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (UnsupportedOperationException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.4.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        return event;
    }

    public static final /* synthetic */ WebViewRumEventContextProvider access$getContextProvider$p(WebViewRumEventConsumer $this) {
        return $this.contextProvider;
    }

    public static final /* synthetic */ JsonObject access$map(WebViewRumEventConsumer $this, JsonObject event, DatadogContext datadogContext, RumContext rumContext, boolean sessionReplayEnabled) {
        return $this.map(event, datadogContext, rumContext, sessionReplayEnabled);
    }

    static {
        Object[] objectArray = new String[]{"view", ACTION_EVENT_TYPE, RESOURCE_EVENT_TYPE, LONG_TASK_EVENT_TYPE, ERROR_EVENT_TYPE, RUM_EVENT_TYPE};
        RUM_EVENT_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventConsumer$Companion;", "", "()V", "ACTION_EVENT_TYPE", "", "ERROR_EVENT_TYPE", "JSON_PARSING_ERROR_MESSAGE", "LONG_TASK_EVENT_TYPE", "RESOURCE_EVENT_TYPE", "RUM_EVENT_TYPE", "RUM_EVENT_TYPES", "", "getRUM_EVENT_TYPES", "()Ljava/util/Set;", "VIEW_EVENT_TYPE", "VIEW_ID_KEY_NAME", "VIEW_KEY_NAME", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getRUM_EVENT_TYPES() {
            return RUM_EVENT_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

