/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.tagprocessor;

import com.datadog.trace.api.Config;
import com.datadog.trace.core.tagprocessor.BaseServiceAdder;
import com.datadog.trace.core.tagprocessor.PeerServiceCalculator;
import com.datadog.trace.core.tagprocessor.PostProcessorChain;
import com.datadog.trace.core.tagprocessor.QueryObfuscator;
import com.datadog.trace.core.tagprocessor.TagsPostProcessor;
import java.util.ArrayList;

public final class TagsPostProcessorFactory {
    private static boolean addBaseService = true;

    public static TagsPostProcessor instance() {
        return Lazy.instance;
    }

    public static void withAddBaseService(boolean enabled) {
        addBaseService = enabled;
        Lazy.instance = Lazy.create();
    }

    public static void reset() {
        TagsPostProcessorFactory.withAddBaseService(true);
        Lazy.instance = Lazy.create();
    }

    private static class Lazy {
        private static TagsPostProcessor instance = Lazy.create();

        private Lazy() {
        }

        private static TagsPostProcessor create() {
            ArrayList<TagsPostProcessor> processors = new ArrayList<TagsPostProcessor>(addBaseService ? 3 : 2);
            processors.add(new PeerServiceCalculator());
            if (addBaseService) {
                processors.add(new BaseServiceAdder(Config.get().getServiceName()));
            }
            processors.add(new QueryObfuscator(Config.get().getObfuscationQueryRegexp()));
            return new PostProcessorChain(processors.toArray(processors.toArray(new TagsPostProcessor[0])));
        }
    }
}

