/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.propagation;

import com.datadog.android.trace.internal.compat.function.Supplier;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.DD64bTraceId;
import com.datadog.trace.api.DDSpanId;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.api.TraceConfig;
import com.datadog.trace.api.TracePropagationStyle;
import com.datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import com.datadog.trace.core.DDSpanContext;
import com.datadog.trace.core.propagation.ContextInterpreter;
import com.datadog.trace.core.propagation.HttpCodec;
import com.datadog.trace.core.propagation.TagContextExtractor;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.Map;
import java.util.TreeMap;

class HaystackHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HaystackHttpCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "Baggage-";
    private static final String TRACE_ID_KEY = "Trace-ID";
    private static final String SPAN_ID_KEY = "Span-ID";
    private static final String PARENT_ID_KEY = "Parent-ID";
    private static final String DD_TRACE_ID_BAGGAGE_KEY = "Baggage-Datadog-Trace-Id";
    private static final String DD_SPAN_ID_BAGGAGE_KEY = "Baggage-Datadog-Span-Id";
    private static final String DD_PARENT_ID_BAGGAGE_KEY = "Baggage-Datadog-Parent-Id";
    private static final String HAYSTACK_TRACE_ID_BAGGAGE_KEY = "Haystack-Trace-ID";
    private static final String HAYSTACK_SPAN_ID_BAGGAGE_KEY = "Haystack-Span-ID";
    private static final String HAYSTACK_PARENT_ID_BAGGAGE_KEY = "Haystack-Parent-ID";
    public static final String DATADOG = "44617461-646f-6721";

    private HaystackHttpCodec() {
    }

    public static HttpCodec.Injector newInjector(Map<String, String> invertedBaggageMapping) {
        return new Injector(invertedBaggageMapping);
    }

    public static HttpCodec.Extractor newExtractor(Config config, Supplier<TraceConfig> traceConfigSupplier) {
        return new TagContextExtractor(traceConfigSupplier, () -> new HaystackContextInterpreter(config));
    }

    private static String convertLongToUUID(long id) {
        String idHex = String.format("%016x", id);
        return "44617461-646f-6721-" + idHex.substring(0, 4) + "-" + idHex.substring(4);
    }

    private static String convertUUIDToHexString(String value) {
        try {
            if (value.contains("-")) {
                String[] strings = value.split("-");
                if (strings.length == 5) {
                    String idHex = strings[3] + strings[4];
                    return idHex;
                }
                throw new NumberFormatException("Invalid UUID format: " + value);
            }
            int length = value.length();
            if (length == 32) {
                return value.substring(16);
            }
            return value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception when converting UUID to BigInteger: " + value, e);
        }
    }

    private static class Injector
    implements HttpCodec.Injector {
        private final Map<String, String> invertedBaggageMapping;

        public Injector(Map<String, String> invertedBaggageMapping) {
            this.invertedBaggageMapping = invertedBaggageMapping;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            try {
                String originalHaystackTraceId = this.getBaggageItemIgnoreCase(context.getBaggageItems(), HaystackHttpCodec.HAYSTACK_TRACE_ID_BAGGAGE_KEY);
                String injectedTraceId = originalHaystackTraceId != null && DDTraceId.fromHex(HaystackHttpCodec.convertUUIDToHexString(originalHaystackTraceId)).equals(context.getTraceId()) ? originalHaystackTraceId : HaystackHttpCodec.convertLongToUUID(context.getTraceId().toLong());
                setter.set(carrier, HaystackHttpCodec.TRACE_ID_KEY, injectedTraceId);
                context.setTag(HaystackHttpCodec.HAYSTACK_TRACE_ID_BAGGAGE_KEY, injectedTraceId);
                setter.set(carrier, HaystackHttpCodec.DD_TRACE_ID_BAGGAGE_KEY, HttpCodec.encode(context.getTraceId().toString()));
                setter.set(carrier, HaystackHttpCodec.SPAN_ID_KEY, HaystackHttpCodec.convertLongToUUID(context.getSpanId()));
                setter.set(carrier, HaystackHttpCodec.DD_SPAN_ID_BAGGAGE_KEY, HttpCodec.encode(DDSpanId.toString(context.getSpanId())));
                setter.set(carrier, HaystackHttpCodec.PARENT_ID_KEY, HaystackHttpCodec.convertLongToUUID(context.getParentId()));
                setter.set(carrier, HaystackHttpCodec.DD_PARENT_ID_BAGGAGE_KEY, HttpCodec.encode(DDSpanId.toString(context.getParentId())));
                for (Map.Entry<String, String> entry : context.baggageItems()) {
                    String header = this.invertedBaggageMapping.get(entry.getKey());
                    header = header != null ? header : HaystackHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey();
                    setter.set(carrier, header, HttpCodec.encodeBaggage(entry.getValue()));
                }
                log.debug("{} - Haystack parent context injected - {}", (Object)context.getTraceId(), (Object)injectedTraceId);
            }
            catch (NumberFormatException e) {
                log.debug("Cannot parse context id(s): {} {}", context.getTraceId(), context.getSpanId(), e);
            }
        }

        private String getBaggageItemIgnoreCase(Map<String, String> baggage, String key) {
            for (Map.Entry<String, String> mapping : baggage.entrySet()) {
                if (!key.equalsIgnoreCase(mapping.getKey())) continue;
                return mapping.getValue();
            }
            return null;
        }
    }

    private static class HaystackContextInterpreter
    extends ContextInterpreter {
        private static final String BAGGAGE_PREFIX_LC = "baggage-";
        private static final int TRACE_ID = 0;
        private static final int SPAN_ID = 1;
        private static final int PARENT_ID = 2;
        private static final int BAGGAGE = 3;
        private static final int IGNORE = -1;

        private HaystackContextInterpreter(Config config) {
            super(config);
        }

        @Override
        public TracePropagationStyle style() {
            return TracePropagationStyle.HAYSTACK;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            char first = Character.toLowerCase(key.charAt(0));
            String lowerCaseKey = null;
            int classification = -1;
            switch (first) {
                case 't': {
                    if (!HaystackHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 0;
                    break;
                }
                case 's': {
                    if (!HaystackHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 1;
                    break;
                }
                case 'p': {
                    if (!HaystackHttpCodec.PARENT_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 2;
                    break;
                }
                case 'x': {
                    if (!this.handledXForwarding(key, value)) break;
                    return true;
                }
                case 'f': {
                    if (!this.handledForwarding(key, value)) break;
                    return true;
                }
                case 'b': {
                    lowerCaseKey = HaystackContextInterpreter.toLowerCase(key);
                    if (!lowerCaseKey.startsWith(BAGGAGE_PREFIX_LC)) break;
                    classification = 3;
                    break;
                }
                case 'u': {
                    if (!this.handledUserAgent(key, value)) break;
                    return true;
                }
            }
            if (-1 != classification) {
                try {
                    String firstValue = HttpCodec.firstHeaderValue(value);
                    if (null == firstValue) return true;
                    switch (classification) {
                        case 0: {
                            this.traceId = DD64bTraceId.fromHex(HaystackHttpCodec.convertUUIDToHexString(value));
                            this.addBaggageItem(HaystackHttpCodec.HAYSTACK_TRACE_ID_BAGGAGE_KEY, value);
                            return true;
                        }
                        case 1: {
                            this.spanId = DDSpanId.fromHex(HaystackHttpCodec.convertUUIDToHexString(value));
                            this.addBaggageItem(HaystackHttpCodec.HAYSTACK_SPAN_ID_BAGGAGE_KEY, value);
                            return true;
                        }
                        case 2: {
                            this.addBaggageItem(HaystackHttpCodec.HAYSTACK_PARENT_ID_BAGGAGE_KEY, value);
                            return true;
                        }
                        case 3: {
                            this.addBaggageItem(lowerCaseKey.substring(BAGGAGE_PREFIX_LC.length()), value);
                            return true;
                        }
                    }
                    return true;
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.debug("Exception when extracting context", e);
                    return false;
                }
            } else {
                if (this.handledIpHeaders(key, value)) {
                    return true;
                }
                if (this.handleTags(key, value)) {
                    return true;
                }
                this.handleMappedBaggage(key, value);
            }
            return true;
        }

        private void addBaggageItem(String key, String value) {
            if (this.baggage.isEmpty()) {
                this.baggage = new TreeMap();
            }
            this.baggage.put(key, HttpCodec.decode(value));
        }

        @Override
        protected int defaultSamplingPriority() {
            return 1;
        }
    }
}

