/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core;

import com.datadog.android.api.InternalLogger;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.time.TimeSource;
import com.datadog.trace.core.DDSpan;
import com.datadog.trace.core.LongRunningTracesTracker;
import com.datadog.trace.core.monitor.HealthMetrics;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.datadog.trace.util.AgentThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscBlockingConsumerArrayQueue;

public abstract class PendingTraceBuffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;

    public boolean longRunningSpansEnabled() {
        return false;
    }

    public static PendingTraceBuffer delaying(TimeSource timeSource, Config config, HealthMetrics healthMetrics) {
        return new DelayingPendingTraceBuffer(4096, timeSource, config, healthMetrics);
    }

    public static PendingTraceBuffer discarding(InternalLogger internalLogger) {
        return new DiscardingPendingTraceBuffer(internalLogger);
    }

    public abstract void start();

    @Override
    public abstract void close();

    public abstract void flush();

    public abstract void enqueue(Element var1);

    private static class DelayingPendingTraceBuffer
    extends PendingTraceBuffer {
        private static final long FORCE_SEND_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
        private static final long SEND_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        private static final long SLEEP_TIME_MS = 100L;
        private final MpscBlockingConsumerArrayQueue<Element> queue;
        private final Thread worker;
        private final TimeSource timeSource;
        private volatile boolean closed = false;
        private final AtomicInteger flushCounter = new AtomicInteger(0);
        private final LongRunningTracesTracker runningTracesTracker;

        @Override
        public boolean longRunningSpansEnabled() {
            return this.runningTracesTracker != null;
        }

        @Override
        public void enqueue(Element pendingTrace) {
            if (pendingTrace.setEnqueued(true) && !this.queue.offer((Object)pendingTrace)) {
                pendingTrace.setEnqueued(false);
                if (!pendingTrace.writeOnBufferFull()) {
                    return;
                }
                pendingTrace.write();
            }
        }

        @Override
        public void start() {
            this.worker.start();
        }

        @Override
        public void close() {
            this.flush();
            this.closed = true;
            this.worker.interrupt();
            try {
                this.worker.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void yieldOrSleep(int loop) {
            if (loop <= 3) {
                Thread.yield();
            } else {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void flush() {
            if (this.worker.isAlive()) {
                int count = this.flushCounter.get();
                int loop = 1;
                boolean signaled = this.queue.offer((Object)FlushElement.FLUSH_ELEMENT);
                while (!this.closed && !signaled) {
                    this.yieldOrSleep(loop++);
                    signaled = this.queue.offer((Object)FlushElement.FLUSH_ELEMENT);
                }
                int newCount = this.flushCounter.get();
                while (!this.closed && count >= newCount) {
                    this.yieldOrSleep(loop++);
                    newCount = this.flushCounter.get();
                }
            }
        }

        public DelayingPendingTraceBuffer(int bufferSize, TimeSource timeSource, Config config, HealthMetrics healthMetrics) {
            this.queue = new MpscBlockingConsumerArrayQueue(bufferSize);
            this.worker = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.TRACE_MONITOR, new Worker());
            this.timeSource = timeSource;
            boolean runningSpansEnabled = config.isLongRunningTraceEnabled();
            this.runningTracesTracker = runningSpansEnabled ? new LongRunningTracesTracker(config, bufferSize, healthMetrics) : null;
        }

        private static final class FlushElement
        implements Element {
            static FlushElement FLUSH_ELEMENT = new FlushElement();

            private FlushElement() {
            }

            @Override
            public long oldestFinishedTime() {
                return 0L;
            }

            @Override
            public boolean lastReferencedNanosAgo(long nanos) {
                return false;
            }

            @Override
            public void write() {
            }

            @Override
            public DDSpan getRootSpan() {
                return null;
            }

            @Override
            public boolean setEnqueued(boolean enqueued) {
                return true;
            }

            @Override
            public boolean writeOnBufferFull() {
                return true;
            }
        }

        private final class Worker
        implements Runnable {
            private Worker() {
            }

            @Override
            public void run() {
                try {
                    while (!DelayingPendingTraceBuffer.this.closed && !Thread.currentThread().isInterrupted()) {
                        Element pendingTrace = null;
                        if (DelayingPendingTraceBuffer.this.longRunningSpansEnabled()) {
                            pendingTrace = (Element)DelayingPendingTraceBuffer.this.queue.poll(1L, TimeUnit.SECONDS);
                            DelayingPendingTraceBuffer.this.runningTracesTracker.flushAndCompact(DelayingPendingTraceBuffer.this.timeSource.getCurrentTimeMillis());
                            if (pendingTrace == null) {
                                continue;
                            }
                        } else {
                            pendingTrace = (Element)DelayingPendingTraceBuffer.this.queue.take();
                        }
                        if (pendingTrace instanceof FlushElement) {
                            DelayingPendingTraceBuffer.this.queue.drain((MessagePassingQueue.Consumer)WriteDrain.WRITE_DRAIN);
                            DelayingPendingTraceBuffer.this.flushCounter.incrementAndGet();
                            continue;
                        }
                        pendingTrace.setEnqueued(false);
                        if (DelayingPendingTraceBuffer.this.longRunningSpansEnabled() && DelayingPendingTraceBuffer.this.runningTracesTracker.add(pendingTrace)) continue;
                        long oldestFinishedTime = pendingTrace.oldestFinishedTime();
                        long finishTimestampMillis = TimeUnit.NANOSECONDS.toMillis(oldestFinishedTime);
                        if (finishTimestampMillis <= DelayingPendingTraceBuffer.this.timeSource.getCurrentTimeMillis() - FORCE_SEND_DELAY_MS) {
                            pendingTrace.write();
                            continue;
                        }
                        if (pendingTrace.lastReferencedNanosAgo(SEND_DELAY_NS)) {
                            pendingTrace.write();
                            continue;
                        }
                        DelayingPendingTraceBuffer.this.enqueue(pendingTrace);
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static final class WriteDrain
        implements MessagePassingQueue.Consumer<Element> {
            private static final WriteDrain WRITE_DRAIN = new WriteDrain();

            private WriteDrain() {
            }

            public void accept(Element pendingTrace) {
                pendingTrace.write();
            }
        }
    }

    static class DiscardingPendingTraceBuffer
    extends PendingTraceBuffer {
        private final Logger log;

        public DiscardingPendingTraceBuffer(InternalLogger internalLogger) {
            this.log = LoggerFactory.getLogger(DiscardingPendingTraceBuffer.class.getSimpleName(), internalLogger);
        }

        @Override
        public void start() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void enqueue(Element pendingTrace) {
            this.log.debug("PendingTrace enqueued but won't be reported. Root span: {}", (Object)pendingTrace.getRootSpan());
        }
    }

    public static interface Element {
        public long oldestFinishedTime();

        public boolean lastReferencedNanosAgo(long var1);

        public void write();

        public DDSpan getRootSpan();

        public boolean setEnqueued(boolean var1);

        public boolean writeOnBufferFull();
    }
}

