/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core;

import com.datadog.trace.api.DDSpanId;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.SpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.SpanLinkAttributes;
import com.datadog.trace.core.propagation.ExtractedContext;
import com.datadog.trace.core.propagation.PropagationTags;
import com.datadog.trace.core.util.MapUtils;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.google.gson.JsonObject;
import java.util.List;

public class DDSpanLink
extends SpanLink {
    private static final Logger LOGGER = LoggerFactory.getLogger(DDSpanLink.class);
    private static final int TAG_MAX_LENGTH = 25000;

    protected DDSpanLink(DDTraceId traceId, long spanId, byte traceFlags, String traceState, AgentSpanLink.Attributes attributes) {
        super(traceId, spanId, traceFlags, traceState, attributes);
    }

    public static SpanLink from(ExtractedContext context) {
        return DDSpanLink.from(context, SpanLinkAttributes.EMPTY);
    }

    public static SpanLink from(ExtractedContext context, AgentSpanLink.Attributes attributes) {
        byte traceFlags = context.getSamplingPriority() > 0 ? (byte)1 : 0;
        String traceState = context.getPropagationTags() == null ? "" : context.getPropagationTags().headerValue(PropagationTags.HeaderType.W3C);
        return new DDSpanLink(context.getTraceId(), context.getSpanId(), traceFlags, traceState, attributes);
    }

    public static String toTag(List<AgentSpanLink> links) {
        int index;
        if (links == null || links.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("[");
        for (index = 0; index < links.size(); ++index) {
            int arrayCharsNeeded;
            String serializedLink = DDSpanLink.asJsonString(links.get(index));
            int n = arrayCharsNeeded = index == 0 ? 1 : 2;
            if (serializedLink.length() + builder.length() + arrayCharsNeeded >= 25000) break;
            if (index > 0) {
                builder.append(',');
            }
            builder.append(serializedLink);
        }
        while (index < links.size()) {
            LOGGER.debug("Span tag full. Dropping span links {}", (Object)links.get(index));
            ++index;
        }
        return builder.append(']').toString();
    }

    private static String asJsonString(AgentSpanLink link) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("trace_id", link.traceId().toHexString());
        jsonObject.addProperty("span_id", DDSpanId.toHexString(link.spanId()));
        jsonObject.addProperty("flags", link.traceFlags() == 0 ? null : Byte.valueOf(link.traceFlags()));
        jsonObject.addProperty("tracestate", link.traceState().isEmpty() ? null : link.traceState());
        if (!link.attributes().isEmpty()) {
            String mapAsJson = MapUtils.getAsJsonObject(link.attributes().asMap()).toString();
            jsonObject.addProperty("attributes", mapAsJson);
        }
        return jsonObject.toString();
    }
}

