/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.api.EndpointTracker;
import com.datadog.trace.api.TraceConfig;
import com.datadog.trace.api.gateway.Flow;
import com.datadog.trace.api.gateway.RequestContext;
import com.datadog.trace.api.metrics.SpanMetricRegistry;
import com.datadog.trace.api.metrics.SpanMetrics;
import com.datadog.trace.api.profiling.TransientProfilingContextHolder;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.core.DDSpanContext;
import com.datadog.trace.core.MetadataConsumer;
import com.datadog.trace.core.PendingTrace;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DDSpan
implements AgentSpan,
CoreSpan<DDSpan>,
TransientProfilingContextHolder,
AttachableWrapper {
    private final Logger log;
    private final SpanMetrics metrics;
    private final DDSpanContext context;
    private final boolean externalClock;
    private final long startTimeNano;
    private static final AtomicLongFieldUpdater<DDSpan> DURATION_NANO_UPDATER = AtomicLongFieldUpdater.newUpdater(DDSpan.class, "durationNano");
    private volatile long durationNano;
    private boolean forceKeep;
    private volatile EndpointTracker endpointTracker;
    private volatile Object wrapper;
    private static final AtomicReferenceFieldUpdater<DDSpan, Object> WRAPPER_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DDSpan.class, Object.class, "wrapper");
    private volatile Flow.Action.RequestBlockingAction requestBlockingAction;
    private volatile int longRunningVersion = 0;
    private final List<AgentSpanLink> links;
    private static final boolean legacyEndToEndEnabled = Config.get().isEndToEndDurationEnabled(false, "legacy");

    static DDSpan create(String instrumentationName, long timestampMicro, @NonNull DDSpanContext context, List<AgentSpanLink> links, InternalLogger internalLogger) {
        DDSpan span = new DDSpan(instrumentationName, timestampMicro, context, links, internalLogger);
        context.getTrace().registerSpan(span);
        return span;
    }

    @VisibleForTesting
    public DDSpan(@NonNull String instrumentationName, long timestampMicro, @NonNull DDSpanContext context, List<AgentSpanLink> links, InternalLogger internalLogger) {
        this.context = context;
        this.metrics = SpanMetricRegistry.getInstance().get(instrumentationName);
        this.metrics.onSpanCreated();
        if (timestampMicro <= 0L) {
            this.startTimeNano = context.getTrace().getCurrentTimeNano();
            this.externalClock = false;
        } else {
            this.startTimeNano = TimeUnit.MICROSECONDS.toNanos(timestampMicro);
            this.externalClock = true;
            context.getTrace().touch();
        }
        this.links = links == null ? new CopyOnWriteArrayList<AgentSpanLink>() : new CopyOnWriteArrayList<AgentSpanLink>(links);
        this.log = LoggerFactory.getLogger(DDSpan.class.getSimpleName(), internalLogger);
        this.log.debug("Started span: {}", (Object)this);
    }

    public boolean isFinished() {
        return this.durationNano != 0L;
    }

    private void finishAndAddToTrace(long durationNano) {
        if (DURATION_NANO_UPDATER.compareAndSet(this, 0L, Math.max(1L, durationNano))) {
            this.setLongRunningVersion(-this.longRunningVersion);
            this.metrics.onSpanFinished();
            PendingTrace.PublishState publishState = this.context.getTrace().onPublish(this);
            this.log.debug("Finished span ({}): {}", (Object)publishState, (Object)this);
        } else {
            this.log.debug("Already finished: {}", (Object)this);
        }
    }

    @Override
    public void finish() {
        if (!this.externalClock) {
            this.finishAndAddToTrace(this.context.getTrace().getCurrentTimeNano() - this.startTimeNano);
        } else {
            this.finish(this.context.getTrace().getTimeSource().getCurrentTimeMicros());
        }
    }

    @Override
    public void finish(long stopTimeMicros) {
        long durationNano;
        if (!this.externalClock) {
            long externalOffsetMicros = stopTimeMicros - this.context.getTrace().getTimeSource().getCurrentTimeMicros();
            durationNano = this.context.getTrace().getCurrentTimeNano() - this.startTimeNano;
            durationNano = TimeUnit.MILLISECONDS.toNanos(TimeUnit.NANOSECONDS.toMillis(durationNano));
            durationNano += TimeUnit.MICROSECONDS.toNanos(externalOffsetMicros);
        } else {
            durationNano = TimeUnit.MICROSECONDS.toNanos(stopTimeMicros) - this.startTimeNano;
            this.context.getTrace().touch();
        }
        this.finishAndAddToTrace(durationNano);
    }

    @Override
    public final void finishWithDuration(long durationNano) {
        this.finishAndAddToTrace(durationNano);
    }

    @Override
    public void beginEndToEnd() {
        if (legacyEndToEndEnabled) {
            if (null == this.getBaggageItem("t0")) {
                this.setBaggageItem("t0", Long.toString(TimeUnit.NANOSECONDS.toMillis(this.startTimeNano)));
            }
        } else {
            this.context.beginEndToEnd();
        }
    }

    @Override
    public void finishWithEndToEnd() {
        long e2eStart;
        if (legacyEndToEndEnabled) {
            String value = this.context.getBaggageItem("t0");
            try {
                e2eStart = null != value ? TimeUnit.MILLISECONDS.toNanos(Long.parseLong(value)) : 0L;
            }
            catch (RuntimeException e) {
                this.log.debug("Ignoring invalid end-to-end start time {}", (Object)value, (Object)e);
                e2eStart = 0L;
            }
        } else {
            e2eStart = this.context.getEndToEndStartTime();
        }
        if (e2eStart > 0L) {
            this.phasedFinish();
            long e2eEnd = this.startTimeNano + (this.durationNano & Long.MAX_VALUE);
            this.setTag("record.e2e_duration_ms", TimeUnit.NANOSECONDS.toMillis(Math.max(0L, e2eEnd - e2eStart)));
            this.publish();
        } else {
            this.finish();
        }
    }

    @Override
    public final boolean phasedFinish() {
        long durationNano;
        if (!this.externalClock) {
            durationNano = this.context.getTrace().getCurrentTimeNano() - this.startTimeNano;
        } else {
            durationNano = this.context.getTrace().getTimeSource().getCurrentTimeNanos() - this.startTimeNano;
            this.context.getTrace().touch();
        }
        if (DURATION_NANO_UPDATER.compareAndSet(this, 0L, Math.max(1L, durationNano) | Long.MIN_VALUE)) {
            this.log.debug("Finished span (PHASED): {}", (Object)this);
            return true;
        }
        this.log.debug("Already finished: {}", (Object)this);
        return false;
    }

    @Override
    public final void publish() {
        long durationNano = this.durationNano;
        if (durationNano == 0L) {
            this.log.debug("Can't publish unfinished span: {}", (Object)this);
        } else if (durationNano > 0L) {
            this.log.debug("Already published: {}", (Object)this);
        } else if (DURATION_NANO_UPDATER.compareAndSet(this, durationNano, durationNano & Long.MAX_VALUE)) {
            PendingTrace.PublishState publishState = this.context.getTrace().onPublish(this);
            this.log.debug("Published span ({}): {}", (Object)publishState, (Object)this);
        }
    }

    @Override
    public DDSpan setError(boolean error) {
        return this.setError(error, (byte)0);
    }

    @Override
    public DDSpan setError(boolean error, byte priority) {
        this.context.setErrorFlag(error, priority);
        return this;
    }

    @Override
    public DDSpan setMeasured(boolean measured) {
        this.context.setMeasured(measured);
        return this;
    }

    public DDSpan forceKeep(boolean forceKeep) {
        this.forceKeep = forceKeep;
        return this;
    }

    @Override
    public boolean isForceKeep() {
        return this.forceKeep;
    }

    public final boolean isRootSpan() {
        return this.context.getParentId() == 0L;
    }

    @Override
    @Deprecated
    public AgentSpan getRootSpan() {
        return this.getLocalRootSpan();
    }

    @Override
    public DDSpan getLocalRootSpan() {
        return this.context.getTrace().getRootSpan();
    }

    public boolean isLocalRootSpan() {
        return this.getLocalRootSpan().equals(this);
    }

    @Override
    public boolean isSameTrace(AgentSpan otherSpan) {
        if (otherSpan instanceof DDSpan) {
            return this.getTraceId().equals(otherSpan.getTraceId());
        }
        return false;
    }

    @Override
    public DDSpan setErrorMessage(String errorMessage) {
        return this.setTag("error.message", errorMessage);
    }

    @Override
    public DDSpan addThrowable(Throwable error) {
        return this.addThrowable(error, (byte)0);
    }

    @Override
    public DDSpan addThrowable(Throwable error, byte errorPriority) {
        if (null != error) {
            String message = error.getMessage();
            if (!("broken pipe".equalsIgnoreCase(message) || error.getCause() != null && "broken pipe".equalsIgnoreCase(error.getCause().getMessage()))) {
                this.setError(true, errorPriority);
                StringWriter errorString = new StringWriter();
                error.printStackTrace(new PrintWriter(errorString));
                this.setTag("error.stack", errorString.toString());
            }
            this.setTag("error.message", message);
            this.setTag("error.type", error.getClass().getName());
        }
        return this;
    }

    @Override
    public final DDSpan setTag(String tag, String value) {
        if (value == null || value.isEmpty()) {
            this.context.setTag(tag, null);
        } else {
            this.context.setTag(tag, value);
        }
        return this;
    }

    @Override
    public final DDSpan setTag(String tag, boolean value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public void setRequestBlockingAction(Flow.Action.RequestBlockingAction rba) {
        this.requestBlockingAction = rba;
    }

    @Override
    public Flow.Action.RequestBlockingAction getRequestBlockingAction() {
        return this.requestBlockingAction;
    }

    @Override
    public DDSpan setTag(String tag, int value) {
        if ("http.status_code".equals(tag)) {
            this.context.setHttpStatusCode((short)value);
        }
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, long value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, double value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, Number value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence metric, int value) {
        this.context.setMetric(metric, value);
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence name, float value) {
        this.context.setMetric(name, Float.valueOf(value));
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence metric, long value) {
        this.context.setMetric(metric, value);
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence metric, double value) {
        this.context.setMetric(metric, value);
        return this;
    }

    @Override
    public DDSpan setFlag(CharSequence name, boolean value) {
        this.context.setMetric(name, value ? 1 : 0);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, CharSequence value) {
        if (value == null || value.length() == 0) {
            this.context.setTag(tag, null);
        } else {
            this.context.setTag(tag, value);
        }
        return this;
    }

    @Override
    public DDSpan setTag(String tag, Object value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan removeTag(String tag) {
        this.context.setTag(tag, null);
        return this;
    }

    @Override
    public Object getTag(String tag) {
        return this.context.getTag(tag);
    }

    @Override
    @NonNull
    public final DDSpanContext context() {
        return this.context;
    }

    @Override
    public final String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    @Override
    public final DDSpan setBaggageItem(String key, String value) {
        this.context.setBaggageItem(key, value);
        return this;
    }

    @Override
    public AgentSpan setHttpStatusCode(int statusCode) {
        this.context.setHttpStatusCode((short)statusCode);
        return this;
    }

    @Override
    public short getHttpStatusCode() {
        return this.context.getHttpStatusCode();
    }

    @Override
    public CharSequence getOrigin() {
        return this.context.getOrigin();
    }

    @Override
    public final DDSpan setOperationName(CharSequence operationName) {
        this.context.setOperationName(operationName);
        return this;
    }

    @Override
    public final DDSpan setServiceName(String serviceName2) {
        this.context.setServiceName(serviceName2);
        return this;
    }

    @Override
    public final DDSpan setResourceName(CharSequence resourceName) {
        return this.setResourceName(resourceName, (byte)0);
    }

    @Override
    public final DDSpan setResourceName(CharSequence resourceName, byte priority) {
        this.context.setResourceName(resourceName, priority);
        return this;
    }

    @Override
    public boolean eligibleForDropping() {
        int samplingPriority = this.context.getSamplingPriority();
        return samplingPriority == -1 || samplingPriority == 0;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.context.getRequestContext();
    }

    @Override
    public Integer forceSamplingDecision() {
        PendingTrace trace = this.context.getTrace();
        DDSpan rootSpan = trace.getRootSpan();
        trace.setSamplingPriorityIfNecessary();
        if (rootSpan == null) {
            return null;
        }
        return rootSpan.getSamplingPriority();
    }

    @Override
    @Deprecated
    public final DDSpan setSamplingPriority(int newPriority) {
        return this.setSamplingPriority(newPriority, -1);
    }

    @Override
    public final DDSpan setSamplingPriority(int newPriority, int samplingMechanism) {
        this.context.setSamplingPriority(newPriority, samplingMechanism);
        return this;
    }

    @Override
    public DDSpan setSamplingPriority(int samplingPriority, CharSequence rate, double sampleRate, int samplingMechanism) {
        if (this.context.setSamplingPriority(samplingPriority, samplingMechanism)) {
            this.setMetric(rate, sampleRate);
        }
        return this;
    }

    @Override
    public DDSpan setSpanSamplingPriority(double rate, int limit) {
        this.context.setSpanSamplingPriority(rate, limit);
        return this;
    }

    @Override
    public final DDSpan setSpanType(CharSequence type) {
        this.context.setSpanType(type);
        return this;
    }

    @Override
    public long getStartTime() {
        return this.startTimeNano;
    }

    @Override
    public long getDurationNano() {
        return this.durationNano;
    }

    @Override
    public String getServiceName() {
        return this.context.getServiceName();
    }

    @Override
    public DDTraceId getTraceId() {
        return this.context.getTraceId();
    }

    @Override
    public long getSpanId() {
        return this.context.getSpanId();
    }

    @Override
    public long getParentId() {
        return this.context.getParentId();
    }

    @Override
    public CharSequence getResourceName() {
        return this.context.getResourceName();
    }

    @Override
    public CharSequence getOperationName() {
        return this.context.getOperationName();
    }

    @Override
    public CharSequence getSpanName() {
        return this.context.getOperationName();
    }

    @Override
    public void setSpanName(CharSequence spanName) {
        this.context.setOperationName(spanName);
    }

    @Override
    public boolean hasResourceName() {
        return this.context.hasResourceName();
    }

    @Override
    public byte getResourceNamePriority() {
        return this.context.getResourceNamePriority();
    }

    @Override
    public Integer getSamplingPriority() {
        int samplingPriority = this.context.getSamplingPriority();
        if (samplingPriority == -128) {
            return null;
        }
        return samplingPriority;
    }

    @Override
    public int samplingPriority() {
        return this.context.getSamplingPriority();
    }

    @Override
    public String getSpanType() {
        CharSequence spanType = this.context.getSpanType();
        return null == spanType ? null : spanType.toString();
    }

    @Override
    public Map<String, Object> getTags() {
        return this.context.getTags();
    }

    @Override
    public CharSequence getType() {
        return this.context.getSpanType();
    }

    @Override
    public void processTagsAndBaggage(MetadataConsumer consumer) {
        this.context.processTagsAndBaggage(consumer, this.longRunningVersion, this.links);
    }

    @Override
    public boolean isError() {
        return this.context.getErrorFlag();
    }

    @Override
    public int getError() {
        return this.context.getErrorFlag() ? 1 : 0;
    }

    @Override
    public <U> U getTag(CharSequence name, U defaultValue) {
        Object tag = this.getTag(String.valueOf(name));
        return (U)(null == tag ? defaultValue : tag);
    }

    @Override
    public <U> U getTag(CharSequence name) {
        return this.getTag(name, null);
    }

    @Override
    public boolean hasSamplingPriority() {
        return this.context.getTrace().getRootSpan() == this;
    }

    @Override
    public boolean isMeasured() {
        return this.context.isMeasured();
    }

    @Override
    public boolean isTopLevel() {
        return this.context.isTopLevel();
    }

    @Nullable
    public EndpointTracker getEndpointTracker() {
        DDSpan localRootSpan = this.getLocalRootSpan();
        if (localRootSpan == null) {
            return null;
        }
        if (this.equals(localRootSpan)) {
            return this.endpointTracker;
        }
        return localRootSpan.endpointTracker;
    }

    public void setEndpointTracker(@NonNull EndpointTracker endpointTracker) {
        DDSpan localRootSpan = this.getLocalRootSpan();
        if (localRootSpan == null) {
            this.log.warn("Span {} has no associated local root span", (Object)this);
            return;
        }
        if (this.equals(localRootSpan)) {
            this.endpointTracker = endpointTracker;
        } else {
            localRootSpan.endpointTracker = endpointTracker;
        }
    }

    public List<AgentSpanLink> getLinks() {
        return this.links;
    }

    public Map<String, String> getBaggage() {
        return Collections.unmodifiableMap(this.context.getBaggageItems());
    }

    public String toString() {
        return this.context.toString() + ", duration_ns=" + this.durationNano + ", forceKeep=" + this.forceKeep + ", links=" + this.links;
    }

    @Override
    public void attachWrapper(Object wrapper) {
        WRAPPER_FIELD_UPDATER.compareAndSet(this, null, wrapper);
    }

    @Override
    public Object getWrapper() {
        return WRAPPER_FIELD_UPDATER.get(this);
    }

    public void setLongRunningVersion(int longRunningVersion) {
        if (this.longRunningVersion < 0) {
            return;
        }
        this.longRunningVersion = longRunningVersion;
    }

    @Override
    public TraceConfig traceConfig() {
        return this.context.getTrace().getTraceConfig();
    }

    @Override
    public void addLink(AgentSpanLink link) {
        if (link != null) {
            this.links.add(link);
        }
    }

    public long getStartTimeNano() {
        return this.startTimeNano;
    }
}

