/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core;

import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.DDSpanId;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.api.DynamicConfig;
import com.datadog.trace.api.EndpointCheckpointer;
import com.datadog.trace.api.EndpointCheckpointerHolder;
import com.datadog.trace.api.EndpointTracker;
import com.datadog.trace.api.IdGenerationStrategy;
import com.datadog.trace.api.InstrumenterConfig;
import com.datadog.trace.api.StatsDClient;
import com.datadog.trace.api.TracePropagationStyle;
import com.datadog.trace.api.gateway.RequestContext;
import com.datadog.trace.api.gateway.RequestContextSlot;
import com.datadog.trace.api.naming.SpanNaming;
import com.datadog.trace.api.profiling.Timer;
import com.datadog.trace.api.scopemanager.ScopeListener;
import com.datadog.trace.api.time.SystemTimeSource;
import com.datadog.trace.api.time.TimeSource;
import com.datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import com.datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import com.datadog.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeState;
import com.datadog.trace.bootstrap.instrumentation.api.TagContext;
import com.datadog.trace.common.metrics.MetricsAggregator;
import com.datadog.trace.common.metrics.NoOpMetricsAggregator;
import com.datadog.trace.common.sampling.Sampler;
import com.datadog.trace.common.sampling.SpanSamplingRules;
import com.datadog.trace.common.sampling.TraceSamplingRules;
import com.datadog.trace.common.writer.NoOpWriter;
import com.datadog.trace.common.writer.Writer;
import com.datadog.trace.core.DDSpan;
import com.datadog.trace.core.DDSpanContext;
import com.datadog.trace.core.PendingTrace;
import com.datadog.trace.core.PendingTraceBuffer;
import com.datadog.trace.core.monitor.HealthMetrics;
import com.datadog.trace.core.propagation.CorePropagation;
import com.datadog.trace.core.propagation.ExtractedContext;
import com.datadog.trace.core.propagation.HttpCodec;
import com.datadog.trace.core.propagation.PropagationTags;
import com.datadog.trace.core.scopemanager.ContinuableScopeManager;
import com.datadog.trace.core.taginterceptor.RuleFlags;
import com.datadog.trace.core.taginterceptor.TagInterceptor;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.datadog.trace.monitor.NoOpRecording;
import com.datadog.trace.monitor.Recording;
import com.datadog.trace.relocate.api.RatelimitedLogger;
import com.datadog.trace.util.AgentThreadFactory;
import com.datadog.trace.util.CollectionUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class CoreTracer
implements AgentTracer.TracerAPI {
    @VisibleForTesting
    final Logger log;
    private final long startTimeNano;
    private final long startNanoTicks;
    private final long clockSyncPeriod;
    private final boolean allowInferredServices;
    private volatile long lastSyncTicks;
    private volatile long counterDrift;
    private final PendingTraceBuffer pendingTraceBuffer;
    final String serviceName;
    final Writer writer;
    final Sampler initialSampler;
    final AgentScopeManager scopeManager;
    final MetricsAggregator metricsAggregator;
    final Config initialConfig;
    private final DynamicConfig<ConfigSnapshot> dynamicConfig;
    private final Map<String, ?> localRootSpanTags;
    private final Map<String, ?> defaultSpanTags;
    private final int partialFlushMinSpans;
    private final StatsDClient statsDClient;
    private final HealthMetrics healthMetrics;
    private final Recording traceWriteTimer;
    private final IdGenerationStrategy idGenerationStrategy;
    private final PendingTrace.Factory pendingTraceFactory;
    private final EndpointCheckpointerHolder endpointCheckpointer;
    private final boolean disableSamplingMechanismValidation;
    private final TimeSource timeSource;
    private final ProfilingContextIntegration profilingContextIntegration;
    private boolean injectBaggageAsTags;
    private Timer timer = Timer.NoOp.INSTANCE;
    private final Thread shutdownCallback;
    private final TagInterceptor tagInterceptor;
    private final AgentPropagation propagation;
    private final boolean logs128bTraceIdEnabled;
    private final PropagationTags.Factory propagationTagsFactory;
    final InternalLogger internalLogger;
    private final RatelimitedLogger rlLog;

    @Override
    public ConfigSnapshot captureTraceConfig() {
        return this.dynamicConfig.captureTraceConfig();
    }

    PropagationTags.Factory getPropagationTagsFactory() {
        return this.propagationTagsFactory;
    }

    @Override
    public void onRootSpanFinished(AgentSpan root, EndpointTracker tracker) {
        this.endpointCheckpointer.onRootSpanFinished(root, tracker);
    }

    @Override
    public EndpointTracker onRootSpanStarted(AgentSpan root) {
        return this.endpointCheckpointer.onRootSpanStarted(root);
    }

    @Override
    public ScopeState newScopeState() {
        return this.scopeManager.newScopeState();
    }

    private CoreTracer(Config config, String serviceName2, Writer writer, IdGenerationStrategy idGenerationStrategy, Sampler sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, AgentScopeManager scopeManager, Map<String, ?> localRootSpanTags, Map<String, ?> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, Map<String, String> baggageMapping, int partialFlushMinSpans, TagInterceptor tagInterceptor, boolean strictTraceWrites, TimeSource timeSource, ProfilingContextIntegration profilingContextIntegration, boolean injectBaggageAsTags, InternalLogger internalLogger) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        assert (baggageMapping != null);
        this.log = LoggerFactory.getLogger(CoreTracer.class.getSimpleName(), internalLogger);
        this.rlLog = new RatelimitedLogger(this.log, 1, TimeUnit.MINUTES);
        this.timeSource = timeSource == null ? SystemTimeSource.INSTANCE : timeSource;
        this.startTimeNano = this.timeSource.getCurrentTimeNanos();
        this.startNanoTicks = this.timeSource.getNanoTicks();
        this.clockSyncPeriod = Math.max(1000000L, TimeUnit.SECONDS.toNanos(config.getClockSyncPeriod()));
        this.lastSyncTicks = this.startNanoTicks;
        this.endpointCheckpointer = EndpointCheckpointerHolder.create();
        this.serviceName = serviceName2;
        this.initialConfig = config;
        this.initialSampler = sampler;
        TraceSamplingRules traceSamplingRules = config.getTraceSamplingRules() == null ? TraceSamplingRules.EMPTY : TraceSamplingRules.deserialize(config.getTraceSamplingRules());
        String spanSamplingRulesJson = config.getSpanSamplingRules();
        String spanSamplingRulesFile = config.getSpanSamplingRulesFile();
        SpanSamplingRules spanSamplingRules = SpanSamplingRules.EMPTY;
        if (spanSamplingRulesJson != null) {
            spanSamplingRules = SpanSamplingRules.deserialize(spanSamplingRulesJson);
        } else if (spanSamplingRulesFile != null) {
            spanSamplingRules = SpanSamplingRules.deserializeFile(spanSamplingRulesFile);
        }
        this.dynamicConfig = DynamicConfig.create((x$0, x$1) -> new ConfigSnapshot((DynamicConfig.Builder)x$0, (ConfigSnapshot)x$1)).setRuntimeMetricsEnabled(config.isRuntimeMetricsEnabled()).setLogsInjectionEnabled(config.isLogsInjectionEnabled()).setDataStreamsEnabled(config.isDataStreamsEnabled()).setServiceMapping(serviceNameMappings).setHeaderTags(taggedHeaders).setBaggageMapping(baggageMapping).setTraceSampleRate(config.getTraceSampleRate()).setSpanSamplingRules(spanSamplingRules.getRules()).setTraceSamplingRules(traceSamplingRules.getRules()).apply();
        this.logs128bTraceIdEnabled = InstrumenterConfig.get().isLogs128bTraceIdEnabled();
        this.defaultSpanTags = defaultSpanTags;
        this.partialFlushMinSpans = partialFlushMinSpans;
        this.idGenerationStrategy = null == idGenerationStrategy ? Config.get().getIdGenerationStrategy() : idGenerationStrategy;
        this.statsDClient = StatsDClient.NO_OP;
        this.traceWriteTimer = NoOpRecording.NO_OP;
        this.healthMetrics = HealthMetrics.NO_OP;
        this.scopeManager = scopeManager == null ? new ContinuableScopeManager(config.getScopeDepthLimit(), config.isScopeStrictMode(), config.isScopeInheritAsyncPropagation(), profilingContextIntegration, this.healthMetrics, internalLogger) : scopeManager;
        this.disableSamplingMechanismValidation = config.isSamplingMechanismValidationDisabled();
        this.writer = writer;
        this.pendingTraceBuffer = strictTraceWrites ? PendingTraceBuffer.discarding(internalLogger) : PendingTraceBuffer.delaying(this.timeSource, config, this.healthMetrics);
        this.pendingTraceFactory = new PendingTrace.Factory(this, this.pendingTraceBuffer, this.timeSource, strictTraceWrites, this.healthMetrics);
        this.pendingTraceBuffer.start();
        this.writer.start();
        this.metricsAggregator = NoOpMetricsAggregator.INSTANCE;
        HttpCodec.Extractor builtExtractor = extractor == null ? HttpCodec.createExtractor(config, this::captureTraceConfig) : extractor;
        Map<TracePropagationStyle, HttpCodec.Injector> injectors = HttpCodec.allInjectorsFor(config, CoreTracer.invertMap(baggageMapping));
        this.propagation = new CorePropagation(builtExtractor, injector, injectors);
        this.tagInterceptor = null == tagInterceptor ? new TagInterceptor(new RuleFlags(config)) : tagInterceptor;
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.propagationTagsFactory = PropagationTags.factory(config);
        this.profilingContextIntegration = profilingContextIntegration;
        this.injectBaggageAsTags = injectBaggageAsTags;
        this.allowInferredServices = SpanNaming.instance().namingSchema().allowInferredServices();
        if (profilingContextIntegration != ProfilingContextIntegration.NoOp.INSTANCE) {
            HashMap tmp = new HashMap(localRootSpanTags);
            tmp.put("_dd.profiling.ctx", profilingContextIntegration.name());
            this.localRootSpanTags = CollectionUtils.tryMakeImmutableMap(tmp);
        } else {
            this.localRootSpanTags = localRootSpanTags;
        }
        this.internalLogger = internalLogger;
    }

    protected void finalize() {
        if (null != this.shutdownCallback) {
            try {
                this.shutdownCallback.run();
                Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception e) {
                this.log.error("Error while finalizing DDTracer.", e);
            }
        }
    }

    PendingTrace createTrace(DDTraceId id, ConfigSnapshot traceConfig) {
        return this.pendingTraceFactory.create(id, traceConfig);
    }

    long getTimeWithNanoTicks(long nanoTicks) {
        long computedNanoTime = this.startTimeNano + Math.max(0L, nanoTicks - this.startNanoTicks);
        if (nanoTicks - this.lastSyncTicks >= this.clockSyncPeriod) {
            long drift = computedNanoTime - this.timeSource.getCurrentTimeNanos();
            if (Math.abs(drift + this.counterDrift) >= 1000000L) {
                this.counterDrift = -TimeUnit.MILLISECONDS.toNanos(TimeUnit.NANOSECONDS.toMillis(drift));
            }
            this.lastSyncTicks = nanoTicks;
        }
        return computedNanoTime + this.counterDrift;
    }

    @Override
    public CoreSpanBuilder buildSpan(String instrumentationName, CharSequence operationName) {
        return new CoreSpanBuilder(instrumentationName, operationName, this);
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
        return this.buildSpan(instrumentationName, spanName).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
        return this.buildSpan(instrumentationName, spanName).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent) {
        return this.buildSpan(instrumentationName, spanName).ignoreActiveSpan().asChildOf(parent).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return this.buildSpan(instrumentationName, spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros).start();
    }

    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activate(span, ScopeSource.INSTRUMENTATION, true);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.activate(span, source);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.scopeManager.activate(span, source, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span) {
        return this.scopeManager.captureSpan(span);
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        this.scopeManager.closePrevious(finishSpan);
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        return this.scopeManager.activateNext(span);
    }

    public TagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public AgentScope activeScope() {
        return this.scopeManager.active();
    }

    @Override
    public AgentPropagation propagate() {
        return this.propagation;
    }

    @Override
    public AgentSpan noopSpan() {
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    void write(List<DDSpan> trace) {
        boolean published;
        List<DDSpan> writtenTrace = this.interceptCompleteTrace(trace);
        if (writtenTrace.isEmpty()) {
            return;
        }
        boolean forceKeep = this.metricsAggregator.publish(writtenTrace);
        PendingTrace pendingTrace = writtenTrace.get(0).context().getTrace();
        pendingTrace.setSamplingPriorityIfNecessary();
        DDSpan rootSpan = pendingTrace.getRootSpan();
        DDSpan spanToSample = rootSpan == null ? writtenTrace.get(0) : rootSpan;
        spanToSample.forceKeep(forceKeep);
        boolean bl = published = forceKeep || pendingTrace.sample(spanToSample);
        if (published) {
            this.writer.write(writtenTrace);
        } else {
            this.writer.incrementDropCounts(writtenTrace.size());
        }
        if (null != rootSpan) {
            this.onRootSpanFinished(rootSpan, rootSpan.getEndpointTracker());
            RequestContext requestContext = rootSpan.getRequestContext();
            if (requestContext != null) {
                try {
                    requestContext.close();
                }
                catch (IOException e) {
                    this.log.warn("Error closing request context data", e);
                }
            }
        }
    }

    private List<DDSpan> interceptCompleteTrace(List<DDSpan> trace) {
        return trace;
    }

    @Override
    public String getTraceId() {
        return this.getTraceId(this.activeSpan());
    }

    @Override
    public String getSpanId() {
        return this.getSpanId(this.activeSpan());
    }

    @Override
    public String getTraceId(AgentSpan span) {
        if (span != null && span.getTraceId() != null) {
            DDTraceId traceId = span.getTraceId();
            if (this.logs128bTraceIdEnabled && traceId.toHighOrderLong() != 0L) {
                return traceId.toHexString();
            }
            return traceId.toString();
        }
        return "0";
    }

    @Override
    public String getSpanId(AgentSpan span) {
        if (span != null) {
            return DDSpanId.toString(span.getSpanId());
        }
        return "0";
    }

    @Override
    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void registerCheckpointer(EndpointCheckpointer implementation) {
        this.endpointCheckpointer.register(implementation);
    }

    @Override
    public void registerTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public void close() {
        this.pendingTraceBuffer.close();
        this.writer.close();
        this.statsDClient.close();
        this.metricsAggregator.close();
    }

    @Override
    public void flush() {
        this.pendingTraceBuffer.flush();
        this.writer.flush();
    }

    @Override
    public ProfilingContextIntegration getProfilingContext() {
        return this.profilingContextIntegration;
    }

    Recording writeTimer() {
        return this.traceWriteTimer.start();
    }

    private static String statsdTag(String tagPrefix, String tagValue) {
        return tagPrefix + ":" + tagValue;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map2) {
        HashMap<V, K> inverted = new HashMap<V, K>(map2.size());
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(inverted);
    }

    protected class ConfigSnapshot
    extends DynamicConfig.Snapshot {
        final Sampler sampler;

        protected ConfigSnapshot(DynamicConfig.Builder builder, ConfigSnapshot oldSnapshot) {
            super(builder, oldSnapshot);
            this.sampler = null == oldSnapshot ? CoreTracer.this.initialSampler : (Objects.equals(this.getTraceSampleRate(), oldSnapshot.getTraceSampleRate()) ? oldSnapshot.sampler : Sampler.Builder.forConfig(CoreTracer.this.initialConfig, this));
        }
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super(AgentThreadFactory.AGENT_THREAD_GROUP, "dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class CoreSpanBuilder
    implements AgentTracer.SpanBuilder {
        private final String instrumentationName;
        private final CharSequence operationName;
        private final CoreTracer tracer;
        private Map<String, Object> tags;
        private long timestampMicro;
        private AgentSpan.Context parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private CharSequence spanType;
        private boolean ignoreScope = false;
        private Object builderRequestContextDataAppSec;
        private Object builderRequestContextDataIast;
        private Object builderCiVisibilityContextData;
        private List<AgentSpanLink> links;

        CoreSpanBuilder(String instrumentationName, CharSequence operationName, CoreTracer tracer) {
            this.instrumentationName = instrumentationName;
            this.operationName = operationName;
            this.tracer = tracer;
        }

        @Override
        public CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan buildSpan() {
            this.addTerminatedContextAsLinks();
            DDSpan span = DDSpan.create(this.instrumentationName, this.timestampMicro, this.buildSpanContext(), this.links, this.tracer.internalLogger);
            if (span.isLocalRootSpan()) {
                EndpointTracker tracker = this.tracer.onRootSpanStarted(span);
                span.setEndpointTracker(tracker);
            }
            return span;
        }

        private void addTerminatedContextAsLinks() {
            List<AgentSpanLink> terminatedContextLinks;
            if (this.parent instanceof TagContext && !(terminatedContextLinks = ((TagContext)this.parent).getTerminatedContextLinks()).isEmpty()) {
                if (this.links == null) {
                    this.links = new ArrayList<AgentSpanLink>();
                }
                this.links.addAll(terminatedContextLinks);
            }
        }

        @Override
        public AgentSpan start() {
            return this.buildSpan();
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)(string == null || string.isEmpty() ? null : string));
        }

        @Override
        public CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        @Override
        public CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        @Override
        public CoreSpanBuilder withServiceName(String serviceName2) {
            this.serviceName = serviceName2;
            return this;
        }

        @Override
        public CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        @Override
        public CoreSpanBuilder withSpanType(CharSequence spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public CoreSpanBuilder asChildOf(AgentSpan.Context spanContext) {
            this.parent = spanContext;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Object value) {
            if (tag == null) {
                return this;
            }
            Map<String, Object> tagMap = this.tags;
            if (tagMap == null) {
                this.tags = tagMap = new LinkedHashMap<String, Object>();
            }
            if (value == null) {
                tagMap.remove(tag);
            } else {
                tagMap.put(tag, value);
            }
            return this;
        }

        @Override
        public <T> AgentTracer.SpanBuilder withRequestContextData(RequestContextSlot slot, T data) {
            switch (slot) {
                case APPSEC: {
                    this.builderRequestContextDataAppSec = data;
                    break;
                }
                case CI_VISIBILITY: {
                    this.builderCiVisibilityContextData = data;
                    break;
                }
                case IAST: {
                    this.builderRequestContextDataIast = data;
                }
            }
            return this;
        }

        @Override
        public AgentTracer.SpanBuilder withLink(AgentSpanLink link) {
            if (link != null) {
                if (this.links == null) {
                    this.links = new ArrayList<AgentSpanLink>();
                }
                this.links.add(link);
            }
            return this;
        }

        private DDSpanContext buildSpanContext() {
            AgentTracer.NoopPathwayContext pathwayContext;
            PropagationTags propagationTags;
            Object ciVisibilityContextData;
            Object requestContextDataIast;
            Object requestContextDataAppSec;
            Map<String, ?> rootSpanTags;
            Map<String, String> coreTags;
            CharSequence origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            long parentSpanId;
            DDTraceId traceId;
            AgentSpan activeSpan;
            long spanId = CoreTracer.this.idGenerationStrategy.generateSpanId();
            AgentSpan.Context parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = CoreTracer.this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            String parentServiceName = null;
            if (parentContext instanceof DDSpanContext) {
                RequestContext requestContext;
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = -128;
                origin = null;
                coreTags = null;
                rootSpanTags = null;
                parentServiceName = ddsc.getServiceName();
                if (this.serviceName == null) {
                    this.serviceName = parentServiceName;
                }
                if ((requestContext = ((DDSpanContext)parentContext).getRequestContext()) != null) {
                    requestContextDataAppSec = requestContext.getData(RequestContextSlot.APPSEC);
                    requestContextDataIast = requestContext.getData(RequestContextSlot.IAST);
                    ciVisibilityContextData = requestContext.getData(RequestContextSlot.CI_VISIBILITY);
                } else {
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                    ciVisibilityContextData = null;
                }
                propagationTags = CoreTracer.this.propagationTagsFactory.empty();
            } else {
                ConfigSnapshot traceConfig;
                long endToEndStartTime;
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    endToEndStartTime = extractedContext.getEndToEndStartTime();
                    propagationTags = extractedContext.getPropagationTags();
                } else if (parentContext != null) {
                    traceId = parentContext.getTraceId() == DDTraceId.ZERO ? CoreTracer.this.idGenerationStrategy.generateTraceId() : parentContext.getTraceId();
                    parentSpanId = parentContext.getSpanId();
                    samplingPriority = parentContext.getSamplingPriority();
                    endToEndStartTime = 0L;
                    propagationTags = CoreTracer.this.propagationTagsFactory.empty();
                } else {
                    traceId = CoreTracer.this.idGenerationStrategy.generateTraceId();
                    parentSpanId = 0L;
                    samplingPriority = -128;
                    endToEndStartTime = 0L;
                    propagationTags = CoreTracer.this.propagationTagsFactory.empty();
                }
                if (parentContext instanceof TagContext) {
                    TagContext tc = (TagContext)parentContext;
                    traceConfig = (ConfigSnapshot)tc.getTraceConfig();
                    coreTags = tc.getTags();
                    origin = tc.getOrigin();
                    baggage = tc.getBaggage();
                    requestContextDataAppSec = tc.getRequestContextDataAppSec();
                    requestContextDataIast = tc.getRequestContextDataIast();
                    ciVisibilityContextData = tc.getCiVisibilityContextData();
                } else {
                    traceConfig = null;
                    coreTags = null;
                    origin = null;
                    baggage = null;
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                    ciVisibilityContextData = null;
                }
                rootSpanTags = CoreTracer.this.localRootSpanTags;
                parentTrace = CoreTracer.this.createTrace(traceId, traceConfig);
                if (endToEndStartTime > 0L) {
                    parentTrace.beginEndToEnd(endToEndStartTime);
                }
            }
            PathwayContext pathwayContext2 = pathwayContext = parentContext != null && parentContext.getPathwayContext() != null && parentContext.getPathwayContext().isStarted() ? parentContext.getPathwayContext() : AgentTracer.NoopPathwayContext.INSTANCE;
            if (!CoreTracer.this.allowInferredServices) {
                DDSpan rootSpan = parentTrace.getRootSpan();
                String string = this.serviceName = rootSpan != null ? rootSpan.getServiceName() : null;
            }
            if (this.serviceName == null) {
                this.serviceName = CoreTracer.this.serviceName;
            }
            CharSequence operationName = this.operationName != null ? this.operationName : this.resourceName;
            int tagsSize = (null == this.tags ? 0 : this.tags.size()) + CoreTracer.this.defaultSpanTags.size() + (null == coreTags ? 0 : coreTags.size()) + (null == rootSpanTags ? 0 : rootSpanTags.size());
            if (this.builderRequestContextDataAppSec != null) {
                requestContextDataAppSec = this.builderRequestContextDataAppSec;
            }
            if (this.builderCiVisibilityContextData != null) {
                ciVisibilityContextData = this.builderCiVisibilityContextData;
            }
            if (this.builderRequestContextDataIast != null) {
                requestContextDataIast = this.builderRequestContextDataIast;
            }
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, parentServiceName, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, tagsSize, parentTrace, requestContextDataAppSec, requestContextDataIast, ciVisibilityContextData, pathwayContext, CoreTracer.this.disableSamplingMechanismValidation, propagationTags, CoreTracer.this.profilingContextIntegration, CoreTracer.this.injectBaggageAsTags);
            context.setAllTags(CoreTracer.this.defaultSpanTags);
            context.setAllTags(this.tags);
            context.setAllTags(coreTags);
            context.setAllTags(rootSpanTags);
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private Writer writer = new NoOpWriter();
        private IdGenerationStrategy idGenerationStrategy;
        private Sampler sampler;
        private HttpCodec.Extractor extractor;
        private HttpCodec.Injector injector;
        private AgentScopeManager scopeManager;
        private Map<String, ?> localRootSpanTags;
        private Map<String, ?> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private Map<String, String> baggageMapping;
        private int partialFlushMinSpans;
        private TagInterceptor tagInterceptor;
        private boolean strictTraceWrites;
        private TimeSource timeSource;
        private ProfilingContextIntegration profilingContextIntegration = ProfilingContextIntegration.NoOp.INSTANCE;
        private InternalLogger internalLogger;
        private boolean injectBaggageAsTags;

        public CoreTracerBuilder serviceName(String serviceName2) {
            this.serviceName = serviceName2;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder idGenerationStrategy(IdGenerationStrategy idGenerationStrategy) {
            this.idGenerationStrategy = idGenerationStrategy;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder scopeManager(AgentScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, ?> localRootSpanTags) {
            this.localRootSpanTags = CollectionUtils.tryMakeImmutableMap(localRootSpanTags);
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, ?> defaultSpanTags) {
            this.defaultSpanTags = CollectionUtils.tryMakeImmutableMap(defaultSpanTags);
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = CollectionUtils.tryMakeImmutableMap(serviceNameMappings);
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = CollectionUtils.tryMakeImmutableMap(taggedHeaders);
            return this;
        }

        public CoreTracerBuilder baggageMapping(Map<String, String> baggageMapping) {
            this.baggageMapping = CollectionUtils.tryMakeImmutableMap(baggageMapping);
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracerBuilder tagInterceptor(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder strictTraceWrites(boolean strictTraceWrites) {
            this.strictTraceWrites = strictTraceWrites;
            return this;
        }

        public CoreTracerBuilder timeSource(TimeSource timeSource) {
            this.timeSource = timeSource;
            return this;
        }

        public CoreTracerBuilder injectBaggageAsTags(boolean injectBaggageAsTags) {
            this.injectBaggageAsTags = injectBaggageAsTags;
            return this;
        }

        public CoreTracerBuilder(InternalLogger internalLogger) {
            this.config(Config.get());
            this.internalLogger = internalLogger;
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config, null));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(config.getMergedSpanTags());
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getRequestHeaderTags());
            this.baggageMapping(config.getBaggageMapping());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            this.strictTraceWrites(config.isTraceStrictWritesEnabled());
            this.injectBaggageAsTags(config.isInjectBaggageAsTagsEnabled());
            this.injector(HttpCodec.createInjector(config, config.getTracePropagationStylesToInject(), CoreTracer.invertMap(config.getBaggageMapping())));
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.writer, this.idGenerationStrategy, this.sampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.baggageMapping, this.partialFlushMinSpans, this.tagInterceptor, this.strictTraceWrites, this.timeSource, this.profilingContextIntegration, this.injectBaggageAsTags, this.internalLogger);
        }
    }
}

