/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import androidx.annotation.NonNull;
import com.datadog.trace.api.sampling.SamplingRule;
import com.datadog.trace.core.util.JsonObjectUtils;
import com.datadog.trace.core.util.MapUtils;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SpanSamplingRules {
    public static final SpanSamplingRules EMPTY = new SpanSamplingRules(Collections.emptyList());
    private static final Logger log = LoggerFactory.getLogger(SpanSamplingRules.class);
    private final List<Rule> rules;

    public SpanSamplingRules(List<Rule> rules) {
        this.rules = Collections.unmodifiableList(rules);
    }

    public static SpanSamplingRules deserialize(String json) {
        SpanSamplingRules result = EMPTY;
        try {
            result = SpanSamplingRules.filterOutNullRules(SpanSamplingRules.deserializeRules(new JsonReader((Reader)new StringReader(json))));
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Span Sampling Rules from JSON: {}", (Object)json, (Object)ex);
        }
        return result;
    }

    public static SpanSamplingRules deserializeFile(String jsonFile) {
        SpanSamplingRules result = EMPTY;
        try (JsonReader reader = new JsonReader((Reader)new FileReader(jsonFile));){
            result = SpanSamplingRules.filterOutNullRules(SpanSamplingRules.deserializeRules(reader));
        }
        catch (FileNotFoundException e) {
            log.warn("Span Sampling Rules file {} doesn't exist", (Object)jsonFile);
        }
        catch (IOException e) {
            log.error("Couldn't read Span Sampling Rules file {}.", (Object)jsonFile, (Object)e);
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Span Sampling Rules from JSON file {}.", (Object)jsonFile, (Object)ex);
        }
        return result;
    }

    private static List<Rule> deserializeRules(JsonReader reader) throws IllegalStateException {
        JsonArray rulesAsJsonArray = JsonParser.parseReader((JsonReader)reader).getAsJsonArray();
        if (rulesAsJsonArray == null || rulesAsJsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Rule> rules = new LinkedList<Rule>();
        for (int i = 0; i < rulesAsJsonArray.size(); ++i) {
            JsonRule rule = JsonRule.deserializeRule(rulesAsJsonArray.get(i).getAsJsonObject());
            rules.add(Rule.create(rule));
        }
        return rules;
    }

    private static SpanSamplingRules filterOutNullRules(List<Rule> rules) {
        if (rules == null || rules.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Rule> notNullRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule == null) continue;
            notNullRules.add(rule);
        }
        if (notNullRules.isEmpty()) {
            return EMPTY;
        }
        return new SpanSamplingRules(notNullRules);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    private static final class JsonRule {
        static final String SERVICE_KEY = "service";
        static final String NAME_KEY = "name";
        static final String RESOURCE_KEY = "resource";
        static final String TAGS_KEY = "tags";
        static final String MAX_PER_SECOND_KEY = "max_per_second";
        static final String SAMPLE_RATE_KEY = "sample_rate";
        String service;
        String name;
        String resource;
        Map<String, String> tags;
        String sample_rate;
        String max_per_second;

        private JsonRule() {
        }

        private static JsonRule deserializeRule(JsonObject ruleAsJsonObject) {
            JsonRule rule = new JsonRule();
            rule.name = JsonObjectUtils.getAsString(ruleAsJsonObject, NAME_KEY);
            rule.resource = JsonObjectUtils.getAsString(ruleAsJsonObject, RESOURCE_KEY);
            rule.sample_rate = JsonObjectUtils.getAsString(ruleAsJsonObject, SAMPLE_RATE_KEY);
            rule.service = JsonObjectUtils.getAsString(ruleAsJsonObject, SERVICE_KEY);
            rule.max_per_second = JsonObjectUtils.getAsString(ruleAsJsonObject, MAX_PER_SECOND_KEY);
            rule.tags = JsonObjectUtils.safeGetAsMap(ruleAsJsonObject, TAGS_KEY);
            return rule;
        }

        @NonNull
        public String toString() {
            JsonObject jsonObject = new JsonObject();
            if (this.max_per_second != null) {
                jsonObject.addProperty(MAX_PER_SECOND_KEY, this.max_per_second);
            }
            if (this.name != null) {
                jsonObject.addProperty(NAME_KEY, this.name);
            }
            if (this.resource != null) {
                jsonObject.addProperty(RESOURCE_KEY, this.resource);
            }
            if (this.sample_rate != null) {
                jsonObject.addProperty(SAMPLE_RATE_KEY, this.sample_rate);
            }
            if (this.service != null) {
                jsonObject.addProperty(SERVICE_KEY, this.service);
            }
            if (this.tags != null) {
                jsonObject.add(TAGS_KEY, (JsonElement)MapUtils.getAsJsonObject(this.tags));
            }
            return jsonObject.toString();
        }
    }

    public static final class Rule
    implements SamplingRule.SpanSamplingRule {
        private final String service;
        private final String name;
        private final String resource;
        private final Map<String, String> tags;
        private final double sampleRate;
        private final int maxPerSecond;

        private Rule(String service, String name, String resource, Map<String, String> tags, double sampleRate, int maxPerSecond) {
            this.service = service;
            this.name = name;
            this.resource = resource;
            this.tags = tags;
            this.sampleRate = sampleRate;
            this.maxPerSecond = maxPerSecond;
        }

        public static Rule create(JsonRule jsonRule) {
            String service = SamplingRule.normalizeGlob(jsonRule.service);
            String name = SamplingRule.normalizeGlob(jsonRule.name);
            String resource = SamplingRule.normalizeGlob(jsonRule.resource);
            Map<String, String> tags = jsonRule.tags;
            if (tags == null) {
                tags = Collections.emptyMap();
            }
            double sampleRate = 1.0;
            if (jsonRule.sample_rate != null) {
                try {
                    sampleRate = Double.parseDouble(jsonRule.sample_rate);
                }
                catch (NumberFormatException ex) {
                    Rule.logRuleError(jsonRule, "sample_rate must be a number between 0.0 and 1.0");
                    return null;
                }
                if (sampleRate < 0.0 || sampleRate > 1.0) {
                    Rule.logRuleError(jsonRule, "sample_rate must be between 0.0 and 1.0");
                    return null;
                }
            }
            int maxPerSecond = Integer.MAX_VALUE;
            if (jsonRule.max_per_second != null) {
                try {
                    double parsedMaxPerSeconds = Double.parseDouble(jsonRule.max_per_second);
                    if (parsedMaxPerSeconds <= 0.0) {
                        Rule.logRuleError(jsonRule, "max_per_second must be greater than 0.0");
                        return null;
                    }
                    maxPerSecond = Math.max((int)parsedMaxPerSeconds, 1);
                }
                catch (NumberFormatException ex) {
                    Rule.logRuleError(jsonRule, "max_per_second must be a number greater than 0.0");
                    return null;
                }
            }
            return new Rule(service, name, resource, tags, sampleRate, maxPerSecond);
        }

        private static void logRuleError(JsonRule rule, String error) {
            log.error("Skipping invalid Span Sampling Rule: {} - {}", (Object)rule, (Object)error);
        }

        @Override
        public String getService() {
            return this.service;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getResource() {
            return this.resource;
        }

        @Override
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public int getMaxPerSecond() {
            return this.maxPerSecond;
        }

        public String asStringJsonRule() {
            JsonRule jsonRule = new JsonRule();
            jsonRule.service = this.service;
            jsonRule.name = this.name;
            jsonRule.resource = this.resource;
            jsonRule.tags = this.tags;
            jsonRule.sample_rate = String.valueOf(this.sampleRate);
            jsonRule.max_per_second = String.valueOf(this.maxPerSecond);
            return jsonRule.toString();
        }
    }
}

