/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import com.datadog.trace.api.Config;
import com.datadog.trace.common.sampling.DeterministicSampler;
import com.datadog.trace.common.sampling.SamplingRule;
import com.datadog.trace.common.sampling.SpanSamplingRules;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.core.util.SimpleRateLimiter;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public interface SingleSpanSampler {
    public <T extends CoreSpan<T>> boolean setSamplingPriority(T var1);

    public static final class RuleBasedSingleSpanSampler
    implements SingleSpanSampler {
        private final List<SamplingRule.SpanSamplingRule> spanSamplingRules;

        public RuleBasedSingleSpanSampler(SpanSamplingRules rules) {
            if (rules == null) {
                throw new NullPointerException("SpanSamplingRules can't be null.");
            }
            this.spanSamplingRules = new ArrayList<SamplingRule.SpanSamplingRule>();
            for (SpanSamplingRules.Rule rule : rules.getRules()) {
                DeterministicSampler.SpanSampler sampler = new DeterministicSampler.SpanSampler(rule.getSampleRate());
                SimpleRateLimiter simpleRateLimiter = rule.getMaxPerSecond() == Integer.MAX_VALUE ? null : new SimpleRateLimiter(rule.getMaxPerSecond());
                SamplingRule.SpanSamplingRule spanSamplingRule = new SamplingRule.SpanSamplingRule(rule.getService(), rule.getName(), sampler, simpleRateLimiter);
                this.spanSamplingRules.add(spanSamplingRule);
            }
        }

        @Override
        public <T extends CoreSpan<T>> boolean setSamplingPriority(T span) {
            for (SamplingRule.SpanSamplingRule rule : this.spanSamplingRules) {
                if (!rule.matches(span)) continue;
                if (!rule.sample(span)) break;
                double rate = rule.getSampler().getSampleRate();
                SimpleRateLimiter rateLimiter = rule.getRateLimiter();
                int limit = rateLimiter == null ? Integer.MAX_VALUE : rateLimiter.getCapacity();
                span.setSpanSamplingPriority(rate, limit);
                return true;
            }
            return false;
        }
    }

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static SingleSpanSampler forConfig(Config config) {
            SpanSamplingRules rules;
            boolean spanSamplingRulesFileDefined;
            String spanSamplingRules = config.getSpanSamplingRules();
            String spanSamplingRulesFile = config.getSpanSamplingRulesFile();
            boolean spanSamplingRulesDefined = spanSamplingRules != null && !spanSamplingRules.isEmpty();
            boolean bl = spanSamplingRulesFileDefined = spanSamplingRulesFile != null && !spanSamplingRulesFile.isEmpty();
            if (spanSamplingRulesDefined && spanSamplingRulesFileDefined) {
                log.warn("Both {} and {} defined. {} will be ignored.", "span.sampling.rules", "span.sampling.rules.file", "span.sampling.rules.file");
            }
            if (spanSamplingRulesDefined) {
                SpanSamplingRules rules2 = SpanSamplingRules.deserialize(spanSamplingRules);
                if (!rules2.isEmpty()) {
                    return new RuleBasedSingleSpanSampler(rules2);
                }
            } else if (spanSamplingRulesFileDefined && !(rules = SpanSamplingRules.deserializeFile(spanSamplingRulesFile)).isEmpty()) {
                return new RuleBasedSingleSpanSampler(rules);
            }
            return null;
        }

        private Builder() {
        }
    }
}

