/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import com.datadog.trace.api.Config;
import com.datadog.trace.api.TraceConfig;
import com.datadog.trace.common.sampling.AllSampler;
import com.datadog.trace.common.sampling.ForcePrioritySampler;
import com.datadog.trace.common.sampling.RateByServiceTraceSampler;
import com.datadog.trace.common.sampling.RuleBasedTraceSampler;
import com.datadog.trace.common.sampling.TraceSamplingRules;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.Map;
import java.util.Properties;

public interface Sampler {
    public <T extends CoreSpan<T>> boolean sample(T var1);

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Sampler forConfig(Config config, TraceConfig traceConfig) {
            Sampler sampler;
            if (config != null) {
                Double traceSampleRate;
                boolean jsonTraceSamplingRulesDefined;
                Map<String, String> serviceRules = config.getTraceSamplingServiceRules();
                Map<String, String> operationRules = config.getTraceSamplingOperationRules();
                String traceSamplingRulesJson = config.getTraceSamplingRules();
                TraceSamplingRules traceSamplingRules = TraceSamplingRules.EMPTY;
                if (traceSamplingRulesJson != null) {
                    traceSamplingRules = TraceSamplingRules.deserialize(traceSamplingRulesJson);
                }
                boolean serviceRulesDefined = serviceRules != null && !serviceRules.isEmpty();
                boolean operationRulesDefined = operationRules != null && !operationRules.isEmpty();
                boolean bl = jsonTraceSamplingRulesDefined = !traceSamplingRules.isEmpty();
                if ((serviceRulesDefined || operationRulesDefined) && jsonTraceSamplingRulesDefined) {
                    log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", "trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules");
                }
                Double d = traceSampleRate = null != traceConfig ? traceConfig.getTraceSampleRate() : config.getTraceSampleRate();
                if (serviceRulesDefined || operationRulesDefined || jsonTraceSamplingRulesDefined || traceSampleRate != null) {
                    try {
                        sampler = RuleBasedTraceSampler.build(serviceRules, operationRules, traceSamplingRules, traceSampleRate, config.getTraceRateLimit());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Invalid sampler configuration. Using AllSampler", e);
                        sampler = new AllSampler();
                    }
                } else if (config.isPrioritySamplingEnabled()) {
                    if ("keep".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_KEEP.");
                        sampler = new ForcePrioritySampler(1, 0);
                    } else if ("drop".equalsIgnoreCase(config.getPrioritySamplingForce())) {
                        log.debug("Force Sampling Priority to: SAMPLER_DROP.");
                        sampler = new ForcePrioritySampler(0, 0);
                    } else {
                        sampler = new RateByServiceTraceSampler();
                    }
                } else {
                    sampler = new AllSampler();
                }
            } else {
                sampler = new AllSampler();
            }
            return sampler;
        }

        public static Sampler forConfig(Properties config) {
            return Builder.forConfig(Config.get(config), null);
        }

        private Builder() {
        }
    }
}

