/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.bootstrap.instrumentation.api;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class UTF8BytesString
implements CharSequence {
    public static final UTF8BytesString EMPTY = UTF8BytesString.create("");
    private final String string;
    private byte[] utf8Bytes;

    public static UTF8BytesString create(CharSequence sequence) {
        if (null == sequence) {
            return null;
        }
        if (sequence instanceof UTF8BytesString) {
            return (UTF8BytesString)sequence;
        }
        return new UTF8BytesString(String.valueOf(sequence));
    }

    public static UTF8BytesString create(byte[] utf8Bytes) {
        if (null == utf8Bytes) {
            return null;
        }
        return new UTF8BytesString(utf8Bytes);
    }

    public static UTF8BytesString create(String string, byte[] utf8Bytes) {
        if (null == utf8Bytes) {
            return null;
        }
        return new UTF8BytesString(string, utf8Bytes);
    }

    public static UTF8BytesString create(ByteBuffer utf8BytesBuffer) {
        if (null == utf8BytesBuffer) {
            return null;
        }
        byte[] utf8Bytes = new byte[utf8BytesBuffer.remaining()];
        utf8BytesBuffer.get(utf8Bytes);
        return new UTF8BytesString(utf8Bytes);
    }

    private UTF8BytesString(String string) {
        this.string = string;
    }

    private UTF8BytesString(byte[] utf8Bytes) {
        this(new String(utf8Bytes, StandardCharsets.UTF_8), utf8Bytes);
    }

    private UTF8BytesString(String string, byte[] utf8Bytes) {
        this.string = string;
        this.utf8Bytes = utf8Bytes;
    }

    public void transferTo(ByteBuffer buffer) {
        this.encodeIfNecessary();
        buffer.put(this.utf8Bytes);
    }

    public byte[] getUtf8Bytes() {
        this.encodeIfNecessary();
        return this.utf8Bytes;
    }

    public int encodedLength() {
        this.encodeIfNecessary();
        return this.utf8Bytes.length;
    }

    @Override
    public String toString() {
        return this.string;
    }

    private void encodeIfNecessary() {
        if (null == this.utf8Bytes) {
            this.utf8Bytes = this.string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        String that = null;
        if (o instanceof UTF8BytesString) {
            that = ((UTF8BytesString)o).string;
        }
        return this.string.equals(that);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public int length() {
        return this.string.length();
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.string.subSequence(start, end);
    }
}

