/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.normalize;

import com.datadog.android.trace.internal.compat.function.Function;
import com.datadog.trace.api.cache.DDCache;
import com.datadog.trace.api.cache.DDCaches;
import com.datadog.trace.api.normalize.AntPathMatcher;
import com.datadog.trace.api.normalize.HttpPathNormalizer;
import com.datadog.trace.bootstrap.instrumentation.api.URIUtils;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.ArrayList;
import java.util.Map;

final class AntPatternHttpPathNormalizer
extends HttpPathNormalizer {
    private static final Logger log = LoggerFactory.getLogger(AntPatternHttpPathNormalizer.class);
    private static final String KEEP_AS_IS = "*";
    private final Map<String, String> resourceNameMatchers;
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final DDCache<String, String> cache = DDCaches.newFixedSizeCache(512);
    private final Function<String, String> cacheLoader = new Function<String, String>(){

        @Override
        public String apply(String path) {
            for (Map.Entry<String, String> resourceNameMatcher : AntPatternHttpPathNormalizer.this.resourceNameMatchers.entrySet()) {
                if (!AntPatternHttpPathNormalizer.this.matcher.match(resourceNameMatcher.getKey(), path)) continue;
                if (AntPatternHttpPathNormalizer.KEEP_AS_IS.equals(resourceNameMatcher.getValue())) {
                    return path;
                }
                return resourceNameMatcher.getValue();
            }
            return null;
        }
    };

    AntPatternHttpPathNormalizer(Map<String, String> httpResourceNameMatchers) {
        this.resourceNameMatchers = httpResourceNameMatchers;
        ArrayList<String> invalidPatterns = new ArrayList<String>(httpResourceNameMatchers.keySet().size());
        for (String pattern : this.resourceNameMatchers.keySet()) {
            if (this.matcher.isPattern(pattern)) continue;
            invalidPatterns.add(pattern);
        }
        for (String invalid : invalidPatterns) {
            log.warn("Invalid pattern {} removed from matchers", (Object)invalid);
            this.resourceNameMatchers.remove(invalid);
        }
    }

    @Override
    public String normalize(String path, boolean encoded) {
        if (encoded) {
            path = URIUtils.decode(path);
        }
        return this.cache.computeIfAbsent(path, this.cacheLoader);
    }
}

