/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.naming.v0;

import androidx.annotation.NonNull;
import com.datadog.trace.api.naming.NamingSchema;

public class ServerNamingV0
implements NamingSchema.ForServer {
    @Override
    @NonNull
    public String operationForProtocol(@NonNull String protocol) {
        if ("grpc".equals(protocol)) {
            return "grpc.server";
        }
        return protocol + ".request";
    }

    @Override
    @NonNull
    public String operationForComponent(@NonNull String component) {
        String prefix;
        switch (component) {
            case "undertow-http-server": {
                prefix = "undertow-http";
                break;
            }
            case "akka-http-server": {
                prefix = "akka-http";
                break;
            }
            case "pekko-http-server": {
                prefix = "pekko-http";
                break;
            }
            case "netty": 
            case "finatra": 
            case "axway-http": {
                prefix = component;
                break;
            }
            case "spray-http-server": {
                prefix = "spray-http";
                break;
            }
            case "restlet-http-server": {
                prefix = "restlet-http";
                break;
            }
            case "synapse-server": {
                prefix = "synapse";
                break;
            }
            default: {
                prefix = "servlet";
            }
        }
        return prefix + ".request";
    }
}

