/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.naming.v0;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.datadog.trace.api.naming.NamingSchema;

public class CloudNamingV0
implements NamingSchema.ForCloud {
    private final boolean allowInferredServices;

    public CloudNamingV0(boolean allowInferredServices) {
        this.allowInferredServices = allowInferredServices;
    }

    @Override
    @NonNull
    public String operationForRequest(@NonNull String provider, @NonNull String cloudService, @NonNull String qualifiedOperation) {
        return "aws.http";
    }

    @Override
    public String serviceForRequest(@NonNull String provider, @Nullable String cloudService) {
        if (!this.allowInferredServices) {
            return null;
        }
        if (cloudService == null) {
            return "java-aws-sdk";
        }
        switch (cloudService) {
            case "sns": 
            case "sqs": {
                return cloudService;
            }
        }
        return "java-aws-sdk";
    }

    @Override
    @NonNull
    public String operationForFaas(@NonNull String provider) {
        return "dd-tracer-serverless-span";
    }
}

