/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api;

import android.os.Build;
import com.datadog.trace.api.DD128bTraceId;
import com.datadog.trace.api.DD64bTraceId;
import com.datadog.trace.api.DDTraceId;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public abstract class IdGenerationStrategy {
    protected final boolean traceId128BitGenerationEnabled;

    private IdGenerationStrategy(boolean traceId128BitGenerationEnabled) {
        this.traceId128BitGenerationEnabled = traceId128BitGenerationEnabled;
    }

    public static IdGenerationStrategy fromName(String name) {
        return IdGenerationStrategy.fromName(name, false);
    }

    public static IdGenerationStrategy fromName(String name, boolean traceId128BitGenerationEnabled) {
        switch (name.toUpperCase(Locale.US)) {
            case "RANDOM": {
                return new Random(traceId128BitGenerationEnabled);
            }
            case "SEQUENTIAL": {
                return new Sequential(traceId128BitGenerationEnabled);
            }
            case "SECURE_RANDOM": {
                return new SRandom(traceId128BitGenerationEnabled);
            }
        }
        return null;
    }

    public DDTraceId generateTraceId() {
        return this.traceId128BitGenerationEnabled ? DD128bTraceId.from(this.generateHighOrderBits(), this.getNonZeroPositiveLong()) : DD64bTraceId.from(this.getNonZeroPositiveLong());
    }

    public long generateSpanId() {
        return this.getNonZeroPositiveLong();
    }

    protected abstract long getNonZeroPositiveLong();

    protected long generateHighOrderBits() {
        long timestamp = System.currentTimeMillis() / 1000L;
        return timestamp << 32;
    }

    static final class Random
    extends IdGenerationStrategy {
        private Random(boolean traceId128BitGenerationEnabled) {
            super(traceId128BitGenerationEnabled);
        }

        @Override
        protected long getNonZeroPositiveLong() {
            return ThreadLocalRandom.current().nextLong(0L, Long.MAX_VALUE) + 1L;
        }
    }

    static final class Sequential
    extends IdGenerationStrategy {
        private final AtomicLong id = new AtomicLong(0L);

        private Sequential(boolean traceId128BitGenerationEnabled) {
            super(traceId128BitGenerationEnabled);
        }

        @Override
        public DDTraceId generateTraceId() {
            return DD64bTraceId.from(this.getNonZeroPositiveLong());
        }

        @Override
        protected long getNonZeroPositiveLong() {
            return this.id.incrementAndGet();
        }
    }

    static final class SRandom
    extends IdGenerationStrategy {
        private final SecureRandom secureRandom;

        private static ThrowingSupplier<SecureRandom> getSecureRandomSupplier() {
            if (Build.VERSION.SDK_INT >= 26) {
                return SecureRandom::getInstanceStrong;
            }
            return SecureRandom::new;
        }

        SRandom(boolean traceId128BitGenerationEnabled) {
            this(traceId128BitGenerationEnabled, SRandom.getSecureRandomSupplier());
        }

        SRandom(boolean traceId128BitGenerationEnabled, ThrowingSupplier<SecureRandom> supplier) {
            super(traceId128BitGenerationEnabled);
            try {
                this.secureRandom = supplier.get();
            }
            catch (Throwable e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        @Override
        protected long getNonZeroPositiveLong() {
            long value = this.secureRandom.nextLong() & Long.MAX_VALUE;
            while (value == 0L) {
                value = this.secureRandom.nextLong() & Long.MAX_VALUE;
            }
            return value;
        }
    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }
}

