/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api;

import com.datadog.trace.api.ConfigOrigin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class ConfigSetting {
    public final String key;
    public final Object value;
    public final ConfigOrigin origin;
    private static final Set<String> CONFIG_FILTER_LIST = new HashSet<String>(Arrays.asList("DD_API_KEY", "dd.api-key", "dd.profiling.api-key", "dd.profiling.apikey"));

    private static Object filterConfigEntry(String key, Object value) {
        return CONFIG_FILTER_LIST.contains(key) ? "<hidden>" : value;
    }

    public ConfigSetting(String key, Object value, ConfigOrigin origin) {
        this.key = key;
        this.value = ConfigSetting.filterConfigEntry(key, value);
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSetting that = (ConfigSetting)o;
        return this.key.equals(that.key) && Objects.equals(this.value, that.value) && this.origin == that.origin;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.value, this.origin});
    }

    public String toString() {
        return "ConfigSetting{key='" + this.key + '\'' + ", value=" + this.value + ", origin=" + (Object)((Object)this.origin) + '}';
    }
}

