/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api;

import androidx.annotation.NonNull;
import com.datadog.android.trace.internal.compat.function.Function;
import com.datadog.trace.api.ConfigCollector;
import com.datadog.trace.api.ConfigDefaults;
import com.datadog.trace.api.ConfigOrigin;
import com.datadog.trace.api.IdGenerationStrategy;
import com.datadog.trace.api.InstrumenterConfig;
import com.datadog.trace.api.Platform;
import com.datadog.trace.api.PropagationStyle;
import com.datadog.trace.api.TracePropagationStyle;
import com.datadog.trace.api.naming.SpanNaming;
import com.datadog.trace.bootstrap.config.provider.ConfigProvider;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import com.datadog.trace.util.CollectionUtils;
import com.datadog.trace.util.PidHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Pattern COLON = Pattern.compile(":");
    private final InstrumenterConfig instrumenterConfig;
    private final long startTimeMillis = System.currentTimeMillis();
    private final boolean timelineEventsEnabled;
    private final boolean runtimeIdEnabled;
    private final String runtimeVersion;
    private final String site;
    private final String serviceName;
    private final boolean serviceNameSetByUser;
    private final String rootContextServiceName;
    private final boolean integrationSynapseLegacyOperationName;
    private final String writerType;
    private final boolean injectBaggageAsTagsEnabled;
    private final boolean agentConfiguredUsingDefault;
    private final String agentUrl;
    private final String agentHost;
    private final int agentPort;
    private final String agentNamedPipe;
    private final int agentTimeout;
    private final Set<String> noProxyHosts;
    private final boolean prioritySamplingEnabled;
    private final String prioritySamplingForce;
    private final boolean traceResolverEnabled;
    private final int spanAttributeSchemaVersion;
    private final boolean peerServiceDefaultsEnabled;
    private final Map<String, String> peerServiceComponentOverrides;
    private final boolean removeIntegrationServiceNamesEnabled;
    private final Map<String, String> peerServiceMapping;
    private final Map<String, String> serviceMapping;
    private final Map<String, String> tags;
    private final Map<String, String> spanTags;
    private final Map<String, String> requestHeaderTags;
    private final Map<String, String> responseHeaderTags;
    private final Map<String, String> baggageMapping;
    private final boolean requestHeaderTagsCommaAllowed;
    private final BitSet httpServerErrorStatuses;
    private final BitSet httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpServerRawQueryString;
    private final boolean httpServerRawResource;
    private final boolean httpServerDecodedResourcePreserveSpaces;
    private final boolean httpServerRouteBasedNaming;
    private final Map<String, String> httpServerPathResourceNameMapping;
    private final Map<String, String> httpClientPathResourceNameMapping;
    private final boolean httpResourceRemoveTrailingSlash;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientTagHeaders;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final boolean dbClientSplitByInstanceTypeSuffix;
    private final boolean dbClientSplitByHost;
    private final Set<String> splitByTags;
    private final int scopeDepthLimit;
    private final boolean scopeStrictMode;
    private final boolean scopeInheritAsyncPropagation;
    private final int scopeIterationKeepAlive;
    private final int partialFlushMinSpans;
    private final boolean traceStrictWritesEnabled;
    private final boolean logExtractHeaderNames;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final boolean tracePropagationStyleB3PaddingEnabled;
    private final Set<TracePropagationStyle> tracePropagationStylesToExtract;
    private final Set<TracePropagationStyle> tracePropagationStylesToInject;
    private final boolean tracePropagationExtractFirst;
    private final int clockSyncPeriod;
    private final boolean logsInjectionEnabled;
    private final String dogStatsDNamedPipe;
    private final int dogStatsDStartDelay;
    private final Integer statsDClientQueueSize;
    private final Integer statsDClientSocketBuffer;
    private final Integer statsDClientSocketTimeout;
    private final boolean runtimeMetricsEnabled;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean perfMetricsEnabled;
    private final boolean tracerMetricsEnabled;
    private final boolean tracerMetricsBufferingEnabled;
    private final int tracerMetricsMaxAggregates;
    private final int tracerMetricsMaxPending;
    private final boolean reportHostName;
    private final boolean traceAnalyticsEnabled;
    private final String traceClientIpHeader;
    private final boolean traceClientIpResolverEnabled;
    private final boolean traceGitMetadataEnabled;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final String traceSamplingRules;
    private final Double traceSampleRate;
    private final int traceRateLimit;
    private final String spanSamplingRules;
    private final String spanSamplingRulesFile;
    private final boolean profilingEnabled;
    private final boolean profilingAgentless;
    private final boolean isDatadogProfilerEnabled;
    @Deprecated
    private final String profilingUrl;
    private final Map<String, String> profilingTags;
    private final int profilingStartDelay;
    private final boolean profilingStartForceFirst;
    private final int profilingUploadPeriod;
    private final String profilingTemplateOverrideFile;
    private final int profilingUploadTimeout;
    private final String profilingUploadCompression;
    private final String profilingProxyHost;
    private final int profilingProxyPort;
    private final String profilingProxyUsername;
    private final String profilingProxyPassword;
    private final int profilingExceptionSampleLimit;
    private final int profilingDirectAllocationSampleLimit;
    private final int profilingExceptionHistogramTopItems;
    private final int profilingExceptionHistogramMaxCollectionSize;
    private final boolean profilingExcludeAgentThreads;
    private final boolean profilingUploadSummaryOn413Enabled;
    private final boolean profilingRecordExceptionMessage;
    private final boolean crashTrackingAgentless;
    private final Map<String, String> crashTrackingTags;
    private final boolean clientIpEnabled;
    private final boolean remoteConfigEnabled;
    private final boolean remoteConfigIntegrityCheckEnabled;
    private final String remoteConfigUrl;
    private final float remoteConfigPollIntervalSeconds;
    private final long remoteConfigMaxPayloadSize;
    private final String remoteConfigTargetsKeyId;
    private final String remoteConfigTargetsKey;
    private final String DBMPropagationMode;
    private final boolean awsPropagationEnabled;
    private final boolean sqsPropagationEnabled;
    private final boolean kafkaClientPropagationEnabled;
    private final Set<String> kafkaClientPropagationDisabledTopics;
    private final boolean kafkaClientBase64DecodingEnabled;
    private final boolean jmsPropagationEnabled;
    private final Set<String> jmsPropagationDisabledTopics;
    private final Set<String> jmsPropagationDisabledQueues;
    private final int jmsUnacknowledgedMaxAge;
    private final boolean rabbitPropagationEnabled;
    private final Set<String> rabbitPropagationDisabledQueues;
    private final Set<String> rabbitPropagationDisabledExchanges;
    private final boolean rabbitIncludeRoutingKeyInResource;
    private final boolean messageBrokerSplitByDestination;
    private final boolean hystrixTagsEnabled;
    private final boolean hystrixMeasuredEnabled;
    private final boolean igniteCacheIncludeKeys;
    private final String obfuscationQueryRegexp;
    private final boolean playReportHttpStatus;
    private final boolean servletPrincipalEnabled;
    private final boolean servletAsyncTimeoutError;
    private final boolean springDataRepositoryInterfaceResourceName;
    private final int xDatadogTagsMaxLength;
    private final boolean traceAgentV05Enabled;
    private final boolean debugEnabled;
    private final boolean triageEnabled;
    private final boolean startupLogsEnabled;
    private final String configFileStatus;
    private final IdGenerationStrategy idGenerationStrategy;
    private final boolean secureRandom;
    private final boolean trace128bitTraceIdGenerationEnabled;
    private final Set<String> grpcIgnoredInboundMethods;
    private final Set<String> grpcIgnoredOutboundMethods;
    private final boolean grpcServerTrimPackageResource;
    private final BitSet grpcServerErrorStatuses;
    private final BitSet grpcClientErrorStatuses;
    private final boolean dataStreamsEnabled;
    private final float dataStreamsBucketDurationSeconds;
    private final float telemetryHeartbeatInterval;
    private final long telemetryExtendedHeartbeatInterval;
    private final float telemetryMetricsInterval;
    private final boolean isTelemetryDependencyServiceEnabled;
    private final boolean telemetryMetricsEnabled;
    private final boolean isTelemetryLogCollectionEnabled;
    private final boolean azureAppServices;
    private final String traceAgentPath;
    private final List<String> traceAgentArgs;
    private final String dogStatsDPath;
    private final List<String> dogStatsDArgs;
    private String env;
    private String version;
    private final String primaryTag;
    private final ConfigProvider configProvider;
    private final boolean longRunningTraceEnabled;
    private final long longRunningTraceFlushInterval;
    private final boolean elasticsearchBodyEnabled;
    private final boolean elasticsearchParamsEnabled;
    private final boolean elasticsearchBodyAndParamsEnabled;
    private final boolean sparkTaskHistogramEnabled;
    private final boolean jaxRsExceptionAsErrorsEnabled;
    private final float traceFlushIntervalSeconds;
    private final boolean telemetryDebugRequestsEnabled;
    public static final String PREFIX = "dd.";
    private static final Config INSTANCE = new Config(ConfigProvider.getInstance(), InstrumenterConfig.get());

    private Config() {
        this(ConfigProvider.createDefault());
    }

    private Config(ConfigProvider configProvider) {
        this(configProvider, new InstrumenterConfig(configProvider));
    }

    private Config(ConfigProvider configProvider, InstrumenterConfig instrumenterConfig) {
        IdGenerationStrategy strategy;
        this.configProvider = configProvider;
        this.instrumenterConfig = instrumenterConfig;
        this.configFileStatus = configProvider.getConfigFileStatus();
        this.runtimeIdEnabled = configProvider.getBoolean("runtime-id.enabled", true, new String[0]);
        this.runtimeVersion = System.getProperty("java.version", "unknown");
        this.site = configProvider.getString("site", "datadoghq.com", new String[0]);
        String userProvidedServiceName = configProvider.getString("service", null, "service.name");
        if (userProvidedServiceName == null) {
            this.serviceNameSetByUser = false;
            this.serviceName = configProvider.getString("service", "unnamed-java-app", "service.name");
        } else {
            this.serviceNameSetByUser = true;
            this.serviceName = userProvidedServiceName;
        }
        this.rootContextServiceName = configProvider.getString("trace.servlet.root-context.service.name", "root-servlet", new String[0]);
        this.integrationSynapseLegacyOperationName = configProvider.getBoolean("integration.synapse.legacy-operation-name", false, new String[0]);
        this.writerType = configProvider.getString("writer.type", "DDAgentWriter", new String[0]);
        this.injectBaggageAsTagsEnabled = configProvider.getBoolean("writer.baggage.inject", true, new String[0]);
        this.secureRandom = configProvider.getBoolean("trace.secure-random", false, new String[0]);
        this.elasticsearchBodyEnabled = configProvider.getBoolean("trace.elasticsearch.body.enabled", false, new String[0]);
        this.elasticsearchParamsEnabled = configProvider.getBoolean("trace.elasticsearch.params.enabled", true, new String[0]);
        this.elasticsearchBodyAndParamsEnabled = configProvider.getBoolean("trace.elasticsearch.body-and-params.enabled", false, new String[0]);
        String strategyName = configProvider.getString("id.generation.strategy");
        this.trace128bitTraceIdGenerationEnabled = configProvider.getBoolean("trace.128.bit.traceid.generation.enabled", true, new String[0]);
        if (this.secureRandom) {
            strategyName = "SECURE_RANDOM";
        }
        if (strategyName == null) {
            strategyName = "RANDOM";
        }
        if ((strategy = IdGenerationStrategy.fromName(strategyName, this.trace128bitTraceIdGenerationEnabled)) == null) {
            log.warn("*** you are trying to use an unknown id generation strategy {} - falling back to RANDOM", (Object)strategyName);
            strategyName = "RANDOM";
            strategy = IdGenerationStrategy.fromName(strategyName, this.trace128bitTraceIdGenerationEnabled);
        }
        if (!strategyName.equals("RANDOM") && !strategyName.equals("SECURE_RANDOM")) {
            log.warn("*** you are using an unsupported id generation strategy {} - this can impact correctness of traces", (Object)strategyName);
        }
        this.idGenerationStrategy = strategy;
        String agentHostFromEnvironment = null;
        int agentPortFromEnvironment = -1;
        boolean rebuildAgentUrl = false;
        String agentUrlFromEnvironment = configProvider.getString("trace.agent.url");
        if (agentUrlFromEnvironment != null) {
            try {
                URI parsedAgentUrl = new URI(agentUrlFromEnvironment);
                agentHostFromEnvironment = parsedAgentUrl.getHost();
                agentPortFromEnvironment = parsedAgentUrl.getPort();
            }
            catch (URISyntaxException e) {
                log.warn("{} not configured correctly: {}. Ignoring", (Object)"trace.agent.url", (Object)e.getMessage());
            }
        }
        if (agentHostFromEnvironment == null) {
            agentHostFromEnvironment = configProvider.getString("agent.host");
            rebuildAgentUrl = true;
        }
        if (agentPortFromEnvironment < 0) {
            agentPortFromEnvironment = configProvider.getInteger("trace.agent.port", -1, "agent.port");
            rebuildAgentUrl = true;
        }
        this.agentHost = agentHostFromEnvironment == null ? "localhost" : agentHostFromEnvironment;
        this.agentPort = agentPortFromEnvironment < 0 ? 8126 : agentPortFromEnvironment;
        this.agentUrl = rebuildAgentUrl ? "http://" + this.agentHost + ":" + this.agentPort : agentUrlFromEnvironment;
        this.agentNamedPipe = configProvider.getString("trace.pipe.name");
        this.agentConfiguredUsingDefault = agentHostFromEnvironment == null && agentPortFromEnvironment < 0 && this.agentNamedPipe == null;
        this.agentTimeout = configProvider.getInteger("trace.agent.timeout", 10, new String[0]);
        this.noProxyHosts = CollectionUtils.tryMakeImmutableSet(configProvider.getSpacedList("proxy.no_proxy"));
        this.prioritySamplingEnabled = configProvider.getBoolean("priority.sampling", true, new String[0]);
        this.prioritySamplingForce = configProvider.getString("priority.sampling.force", ConfigDefaults.DEFAULT_PRIORITY_SAMPLING_FORCE, new String[0]);
        this.traceResolverEnabled = configProvider.getBoolean("trace.resolver.enabled", true, new String[0]);
        this.serviceMapping = configProvider.getMergedMap("service.mapping");
        HashMap<String, String> tags = new HashMap<String, String>(configProvider.getMergedMap("trace.global.tags"));
        tags.putAll(configProvider.getMergedMap("tags"));
        this.tags = this.getMapWithPropertiesDefinedByEnvironment(tags, "env", "version");
        this.spanTags = configProvider.getMergedMap("trace.span.tags");
        this.primaryTag = configProvider.getString("primary.tag");
        if (this.isEnabled(false, "trace.header.tags", ".legacy.parsing.enabled")) {
            this.requestHeaderTags = configProvider.getMergedMap("trace.header.tags");
            this.responseHeaderTags = Collections.emptyMap();
            if (configProvider.isSet("trace.request_header.tags")) {
                this.logIgnoredSettingWarning("trace.request_header.tags", "trace.header.tags", ".legacy.parsing.enabled");
            }
            if (configProvider.isSet("trace.response_header.tags")) {
                this.logIgnoredSettingWarning("trace.response_header.tags", "trace.header.tags", ".legacy.parsing.enabled");
            }
        } else {
            this.requestHeaderTags = configProvider.getMergedMapWithOptionalMappings("http.request.headers.", true, "trace.header.tags", "trace.request_header.tags");
            this.responseHeaderTags = configProvider.getMergedMapWithOptionalMappings("http.response.headers.", true, "trace.header.tags", "trace.response_header.tags");
        }
        this.requestHeaderTagsCommaAllowed = configProvider.getBoolean("trace.request_header.tags.comma.allowed", true, new String[0]);
        this.baggageMapping = configProvider.getMergedMap("trace.header.baggage");
        this.spanAttributeSchemaVersion = this.schemaVersionFromConfig();
        this.peerServiceDefaultsEnabled = configProvider.getBoolean("trace.peer.service.defaults.enabled", false, new String[0]);
        this.peerServiceComponentOverrides = configProvider.getMergedMap("trace.peer.service.component.overrides");
        this.removeIntegrationServiceNamesEnabled = configProvider.getBoolean("trace.remove.integration-service-names.enabled", false, new String[0]);
        this.peerServiceMapping = configProvider.getMergedMap("trace.peer.service.mapping");
        this.httpServerPathResourceNameMapping = configProvider.getOrderedMap("trace.http.server.path-resource-name-mapping");
        this.httpClientPathResourceNameMapping = configProvider.getOrderedMap("trace.http.client.path-resource-name-mapping");
        this.httpResourceRemoveTrailingSlash = configProvider.getBoolean("trace.http.resource.remove-trailing-slash", false, new String[0]);
        this.httpServerErrorStatuses = configProvider.getIntegerRange("http.server.error.statuses", ConfigDefaults.DEFAULT_HTTP_SERVER_ERROR_STATUSES);
        this.httpClientErrorStatuses = configProvider.getIntegerRange("http.client.error.statuses", ConfigDefaults.DEFAULT_HTTP_CLIENT_ERROR_STATUSES);
        this.httpServerTagQueryString = configProvider.getBoolean("http.server.tag.query-string", true, new String[0]);
        this.httpServerRawQueryString = configProvider.getBoolean("http.server.raw.query-string", true, new String[0]);
        this.httpServerRawResource = configProvider.getBoolean("http.server.raw.resource", false, new String[0]);
        this.httpServerDecodedResourcePreserveSpaces = configProvider.getBoolean("http.server.decoded.resource.preserve-spaces", true, new String[0]);
        this.httpServerRouteBasedNaming = configProvider.getBoolean("http.server.route-based-naming", true, new String[0]);
        this.httpClientTagQueryString = configProvider.getBoolean("http.client.tag.query-string", false, new String[0]);
        this.httpClientTagHeaders = configProvider.getBoolean("http.client.tag.headers", true, new String[0]);
        this.httpClientSplitByDomain = configProvider.getBoolean("trace.http.client.split-by-domain", false, new String[0]);
        this.dbClientSplitByInstance = configProvider.getBoolean("trace.db.client.split-by-instance", false, new String[0]);
        this.dbClientSplitByInstanceTypeSuffix = configProvider.getBoolean("trace.db.client.split-by-instance.type.suffix", false, new String[0]);
        this.dbClientSplitByHost = configProvider.getBoolean("trace.db.client.split-by-host", false, new String[0]);
        this.DBMPropagationMode = configProvider.getString("dbm.propagation.mode", "disabled", new String[0]);
        this.splitByTags = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.split-by-tags"));
        this.springDataRepositoryInterfaceResourceName = configProvider.getBoolean("spring-data.repository.interface.resource-name", true, new String[0]);
        this.scopeDepthLimit = configProvider.getInteger("trace.scope.depth.limit", 100, new String[0]);
        this.scopeStrictMode = configProvider.getBoolean("trace.scope.strict.mode", false, new String[0]);
        this.scopeInheritAsyncPropagation = configProvider.getBoolean("trace.scope.inherit.async.propagation", true, new String[0]);
        this.scopeIterationKeepAlive = configProvider.getInteger("trace.scope.iteration.keep.alive", 30, new String[0]);
        boolean partialFlushEnabled = configProvider.getBoolean("trace.partial.flush.enabled", true, new String[0]);
        this.partialFlushMinSpans = !partialFlushEnabled ? 0 : configProvider.getInteger("trace.partial.flush.min.spans", 1000, new String[0]);
        this.traceStrictWritesEnabled = configProvider.getBoolean("trace.strict.writes.enabled", false, new String[0]);
        this.logExtractHeaderNames = configProvider.getBoolean("propagation.extract.log_header_names.enabled", false, new String[0]);
        this.tracePropagationStyleB3PaddingEnabled = this.isEnabled(true, "trace.propagation.style", ".b3.padding.enabled");
        Set<PropagationStyle> deprecatedExtract = this.getSettingsSetFromEnvironment("propagation.style.extract", PropagationStyle::valueOfConfigName, true);
        Set<PropagationStyle> deprecatedInject = this.getSettingsSetFromEnvironment("propagation.style.inject", PropagationStyle::valueOfConfigName, true);
        Set<TracePropagationStyle> common = this.getSettingsSetFromEnvironment("trace.propagation.style", TracePropagationStyle::valueOfDisplayName, false);
        Set<TracePropagationStyle> extract = this.getSettingsSetFromEnvironment("trace.propagation.style.extract", TracePropagationStyle::valueOfDisplayName, false);
        Set<TracePropagationStyle> inject = this.getSettingsSetFromEnvironment("trace.propagation.style.inject", TracePropagationStyle::valueOfDisplayName, false);
        String extractOrigin = "trace.propagation.style.extract";
        String injectOrigin = "trace.propagation.style.inject";
        if (extract.isEmpty()) {
            extract = common;
            extractOrigin = "trace.propagation.style";
        } else if (!common.isEmpty()) {
            this.logOverriddenSettingWarning("trace.propagation.style", "trace.propagation.style.extract", extract);
        }
        if (inject.isEmpty()) {
            inject = common;
            injectOrigin = "trace.propagation.style";
        } else if (!common.isEmpty()) {
            this.logOverriddenSettingWarning("trace.propagation.style", "trace.propagation.style.inject", inject);
        }
        if (extract.isEmpty()) {
            extract = this.convertSettingsSet(deprecatedExtract, PropagationStyle::getNewStyles);
            if (!extract.isEmpty()) {
                this.logDeprecatedConvertedSetting("propagation.style.extract", deprecatedExtract, "trace.propagation.style.extract", extract);
            }
        } else if (!deprecatedExtract.isEmpty()) {
            this.logOverriddenDeprecatedSettingWarning("propagation.style.extract", extractOrigin, extract);
        }
        if (inject.isEmpty()) {
            inject = this.convertSettingsSet(deprecatedInject, PropagationStyle::getNewStyles);
            if (!inject.isEmpty()) {
                this.logDeprecatedConvertedSetting("propagation.style.inject", deprecatedInject, "trace.propagation.style.inject", inject);
            }
        } else if (!deprecatedInject.isEmpty()) {
            this.logOverriddenDeprecatedSettingWarning("propagation.style.inject", injectOrigin, inject);
        }
        this.tracePropagationStylesToExtract = extract.isEmpty() ? ConfigDefaults.DEFAULT_TRACE_PROPAGATION_STYLE : extract;
        this.tracePropagationStylesToInject = inject.isEmpty() ? ConfigDefaults.DEFAULT_TRACE_PROPAGATION_STYLE : inject;
        this.propagationStylesToExtract = deprecatedExtract.isEmpty() ? ConfigDefaults.DEFAULT_PROPAGATION_STYLE : deprecatedExtract;
        this.propagationStylesToInject = deprecatedInject.isEmpty() ? ConfigDefaults.DEFAULT_PROPAGATION_STYLE : deprecatedInject;
        this.tracePropagationExtractFirst = configProvider.getBoolean("trace.propagation.extract.first", false, new String[0]);
        this.clockSyncPeriod = configProvider.getInteger("trace.clock.sync.period", 30, new String[0]);
        this.logsInjectionEnabled = configProvider.getBoolean("logs.injection", true, new String[0]);
        this.dogStatsDNamedPipe = configProvider.getString("dogstatsd.pipe.name");
        this.dogStatsDStartDelay = configProvider.getInteger("dogstatsd.start-delay", 15, new String[0]);
        this.statsDClientQueueSize = configProvider.getInteger("statsd.client.queue.size");
        this.statsDClientSocketBuffer = configProvider.getInteger("statsd.client.socket.buffer");
        this.statsDClientSocketTimeout = configProvider.getInteger("statsd.client.socket.timeout");
        this.runtimeMetricsEnabled = configProvider.getBoolean("runtime.metrics.enabled", true, new String[0]);
        this.healthMetricsEnabled = this.runtimeMetricsEnabled && configProvider.getBoolean("trace.health.metrics.enabled", true, new String[0]);
        this.healthMetricsStatsdHost = configProvider.getString("trace.health.metrics.statsd.host");
        this.healthMetricsStatsdPort = configProvider.getInteger("trace.health.metrics.statsd.port");
        this.perfMetricsEnabled = this.runtimeMetricsEnabled && configProvider.getBoolean("trace.perf.metrics.enabled", false, new String[0]);
        this.tracerMetricsEnabled = configProvider.getBoolean("trace.tracer.metrics.enabled", false, new String[0]);
        this.tracerMetricsBufferingEnabled = configProvider.getBoolean("trace.tracer.metrics.buffering.enabled", false, new String[0]);
        this.tracerMetricsMaxAggregates = configProvider.getInteger("trace.tracer.metrics.max.aggregates", 2048, new String[0]);
        this.tracerMetricsMaxPending = configProvider.getInteger("trace.tracer.metrics.max.pending", 2048, new String[0]);
        this.reportHostName = configProvider.getBoolean("trace.report-hostname", false, new String[0]);
        this.traceAgentV05Enabled = configProvider.getBoolean("trace.agent.v0.5.enabled", false, new String[0]);
        this.traceAnalyticsEnabled = configProvider.getBoolean("trace.analytics.enabled", false, new String[0]);
        String traceClientIpHeader = configProvider.getString("trace.client-ip-header");
        if (traceClientIpHeader != null) {
            traceClientIpHeader = traceClientIpHeader.toLowerCase(Locale.ROOT);
        }
        this.traceClientIpHeader = traceClientIpHeader;
        this.traceClientIpResolverEnabled = configProvider.getBoolean("trace.client-ip.resolver.enabled", true, new String[0]);
        this.traceGitMetadataEnabled = configProvider.getBoolean("trace.git.metadata.enabled", true, new String[0]);
        this.traceSamplingServiceRules = configProvider.getMergedMap("trace.sampling.service.rules");
        this.traceSamplingOperationRules = configProvider.getMergedMap("trace.sampling.operation.rules");
        this.traceSamplingRules = configProvider.getString("trace.sampling.rules");
        this.traceSampleRate = configProvider.getDouble("trace.sample.rate");
        this.traceRateLimit = configProvider.getInteger("trace.rate.limit", 100, new String[0]);
        this.spanSamplingRules = configProvider.getString("span.sampling.rules");
        this.spanSamplingRulesFile = configProvider.getString("span.sampling.rules.file");
        this.profilingEnabled = configProvider.getBoolean("profiling.enabled", instrumenterConfig.isProfilingEnabled(), new String[0]);
        this.profilingAgentless = configProvider.getBoolean("profiling.agentless", false, new String[0]);
        this.isDatadogProfilerEnabled = !Config.isDatadogProfilerEnablementOverridden() && configProvider.getBoolean("profiling.ddprof.enabled", Config.isDatadogProfilerSafeInCurrentEnvironment(), new String[0]);
        this.profilingUrl = configProvider.getString("profiling.url");
        this.profilingTags = configProvider.getMergedMap("profiling.tags");
        this.profilingStartDelay = configProvider.getInteger("profiling.start-delay", 10, new String[0]);
        this.profilingStartForceFirst = configProvider.getBoolean("profiling.start-force-first", false, new String[0]);
        this.profilingUploadPeriod = configProvider.getInteger("profiling.upload.period", 60, new String[0]);
        this.profilingTemplateOverrideFile = configProvider.getString("profiling.jfr-template-override-file");
        this.profilingUploadTimeout = configProvider.getInteger("profiling.upload.timeout", 30, new String[0]);
        this.profilingUploadCompression = configProvider.getString("profiling.upload.compression", "on", new String[0]);
        this.profilingProxyHost = configProvider.getString("profiling.proxy.host");
        this.profilingProxyPort = configProvider.getInteger("profiling.proxy.port", 8080, new String[0]);
        this.profilingProxyUsername = configProvider.getString("profiling.proxy.username");
        this.profilingProxyPassword = configProvider.getString("profiling.proxy.password");
        this.profilingExceptionSampleLimit = configProvider.getInteger("profiling.exception.sample.limit", 10000, new String[0]);
        this.profilingDirectAllocationSampleLimit = configProvider.getInteger("profiling.direct.allocation.sample.limit", 2000, new String[0]);
        this.profilingExceptionHistogramTopItems = configProvider.getInteger("profiling.exception.histogram.top-items", 50, new String[0]);
        this.profilingExceptionHistogramMaxCollectionSize = configProvider.getInteger("profiling.exception.histogram.max-collection-size", 10000, new String[0]);
        this.profilingExcludeAgentThreads = configProvider.getBoolean("profiling.exclude.agent-threads", true, new String[0]);
        this.profilingRecordExceptionMessage = configProvider.getBoolean("profiling.exception.record.message", true, new String[0]);
        this.profilingUploadSummaryOn413Enabled = configProvider.getBoolean("profiling.upload.summary-on-413", false, new String[0]);
        this.crashTrackingAgentless = configProvider.getBoolean("crashtracking.agentless", false, new String[0]);
        this.crashTrackingTags = configProvider.getMergedMap("crashtracking.tags");
        float telemetryInterval = configProvider.getFloat("telemetry.heartbeat.interval", 60.0f);
        if ((double)telemetryInterval < 0.1 || telemetryInterval > 3600.0f) {
            log.warn("Invalid Telemetry heartbeat interval: {}. The value must be in range 0.1-3600", (Object)Float.valueOf(telemetryInterval));
            telemetryInterval = 60.0f;
        }
        this.telemetryHeartbeatInterval = telemetryInterval;
        this.telemetryExtendedHeartbeatInterval = configProvider.getLong("telemetry.extended.heartbeat.interval", 86400L, new String[0]);
        telemetryInterval = configProvider.getFloat("telemetry.metrics.interval", 10.0f);
        if ((double)telemetryInterval < 0.1 || telemetryInterval > 3600.0f) {
            log.warn("Invalid Telemetry metrics interval: {}. The value must be in range 0.1-3600", (Object)Float.valueOf(telemetryInterval));
            telemetryInterval = 10.0f;
        }
        this.telemetryMetricsInterval = telemetryInterval;
        this.telemetryMetricsEnabled = configProvider.getBoolean("telemetry.metrics.enabled", true, new String[0]);
        this.isTelemetryDependencyServiceEnabled = configProvider.getBoolean("telemetry.dependency-collection.enabled", true, new String[0]);
        this.isTelemetryLogCollectionEnabled = configProvider.getBoolean("telemetry.log-collection.enabled", false, new String[0]);
        this.clientIpEnabled = configProvider.getBoolean("trace.client-ip.enabled", false, new String[0]);
        this.remoteConfigEnabled = configProvider.getBoolean("remote_config.enabled", true, new String[0]);
        this.remoteConfigIntegrityCheckEnabled = configProvider.getBoolean("remote_config.integrity_check.enabled", false, new String[0]);
        this.remoteConfigUrl = configProvider.getString("remote_config.url");
        this.remoteConfigPollIntervalSeconds = configProvider.getFloat("remote_config.poll_interval.seconds", 5.0f);
        this.remoteConfigMaxPayloadSize = configProvider.getInteger("remote_config.max.payload.size", 5120, new String[0]) * 1024;
        this.remoteConfigTargetsKeyId = configProvider.getString("rc.targets.key.id", "5c4ece41241a1bb513f6e3e5df74ab7d5183dfffbd71bfd43127920d880569fd", new String[0]);
        this.remoteConfigTargetsKey = configProvider.getString("rc.targets.key", "e3f1f98c9da02a93bb547f448b472d727e14b22455235796fe49863856252508", new String[0]);
        this.awsPropagationEnabled = this.isPropagationEnabled(true, "aws", "aws-sdk");
        this.sqsPropagationEnabled = this.isPropagationEnabled(true, "sqs");
        this.kafkaClientPropagationEnabled = this.isPropagationEnabled(true, "kafka", "kafka.client");
        this.kafkaClientPropagationDisabledTopics = CollectionUtils.tryMakeImmutableSet(configProvider.getList("kafka.client.propagation.disabled.topics"));
        this.kafkaClientBase64DecodingEnabled = configProvider.getBoolean("kafka.client.base64.decoding.enabled", false, new String[0]);
        this.jmsPropagationEnabled = this.isPropagationEnabled(true, "jms");
        this.jmsPropagationDisabledTopics = CollectionUtils.tryMakeImmutableSet(configProvider.getList("jms.propagation.disabled.topics"));
        this.jmsPropagationDisabledQueues = CollectionUtils.tryMakeImmutableSet(configProvider.getList("jms.propagation.disabled.queues"));
        this.jmsUnacknowledgedMaxAge = configProvider.getInteger("jms.unacknowledged.max.age", 3600, new String[0]);
        this.rabbitPropagationEnabled = this.isPropagationEnabled(true, "rabbit", "rabbitmq");
        this.rabbitPropagationDisabledQueues = CollectionUtils.tryMakeImmutableSet(configProvider.getList("rabbit.propagation.disabled.queues"));
        this.rabbitPropagationDisabledExchanges = CollectionUtils.tryMakeImmutableSet(configProvider.getList("rabbit.propagation.disabled.exchanges"));
        this.rabbitIncludeRoutingKeyInResource = configProvider.getBoolean("rabbit.include.routingkey.in.resource", true, new String[0]);
        this.messageBrokerSplitByDestination = configProvider.getBoolean("message.broker.split-by-destination", false, new String[0]);
        this.grpcIgnoredInboundMethods = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.grpc.ignored.inbound.methods"));
        ArrayList<String> tmpGrpcIgnoredOutboundMethods = new ArrayList<String>();
        tmpGrpcIgnoredOutboundMethods.addAll(configProvider.getList("trace.grpc.ignored.outbound.methods"));
        if (InstrumenterConfig.get().isIntegrationEnabled(Collections.singleton("google-pubsub"), true)) {
            tmpGrpcIgnoredOutboundMethods.addAll(configProvider.getList("trace.google-pubsub.ignored.grpc.methods", Arrays.asList("google.pubsub.v1.Subscriber/ModifyAckDeadline", "google.pubsub.v1.Subscriber/Acknowledge", "google.pubsub.v1.Subscriber/Pull", "google.pubsub.v1.Subscriber/StreamingPull", "google.pubsub.v1.Publisher/Publish")));
        }
        this.grpcIgnoredOutboundMethods = CollectionUtils.tryMakeImmutableSet(tmpGrpcIgnoredOutboundMethods);
        this.grpcServerTrimPackageResource = configProvider.getBoolean("trace.grpc.server.trim-package-resource", false, new String[0]);
        this.grpcServerErrorStatuses = configProvider.getIntegerRange("grpc.server.error.statuses", ConfigDefaults.DEFAULT_GRPC_SERVER_ERROR_STATUSES);
        this.grpcClientErrorStatuses = configProvider.getIntegerRange("grpc.client.error.statuses", ConfigDefaults.DEFAULT_GRPC_CLIENT_ERROR_STATUSES);
        this.hystrixTagsEnabled = configProvider.getBoolean("hystrix.tags.enabled", false, new String[0]);
        this.hystrixMeasuredEnabled = configProvider.getBoolean("hystrix.measured.enabled", false, new String[0]);
        this.igniteCacheIncludeKeys = configProvider.getBoolean("ignite.cache.include_keys", false, new String[0]);
        this.obfuscationQueryRegexp = configProvider.getString("trace.obfuscation.query.string.regexp", null, "obfuscation.query.string.regexp");
        this.playReportHttpStatus = configProvider.getBoolean("trace.play.report-http-status", false, new String[0]);
        this.servletPrincipalEnabled = configProvider.getBoolean("trace.servlet.principal.enabled", false, new String[0]);
        this.xDatadogTagsMaxLength = configProvider.getInteger("trace.x-datadog-tags.max.length", 512, new String[0]);
        this.servletAsyncTimeoutError = configProvider.getBoolean("trace.servlet.async-timeout.error", true, new String[0]);
        this.debugEnabled = configProvider.getBoolean("trace.debug", false, new String[0]);
        this.triageEnabled = configProvider.getBoolean("trace.triage", this.debugEnabled, new String[0]);
        this.startupLogsEnabled = configProvider.getBoolean("trace.startup.logs", true, new String[0]);
        this.dataStreamsEnabled = configProvider.getBoolean("data.streams.enabled", false, new String[0]);
        this.dataStreamsBucketDurationSeconds = configProvider.getFloat("data.streams.bucket_duration.seconds", 10.0f);
        this.azureAppServices = configProvider.getBoolean("azure.app.services", false, new String[0]);
        this.traceAgentPath = configProvider.getString("trace.agent.path");
        String traceAgentArgsString = configProvider.getString("trace.agent.args");
        this.traceAgentArgs = traceAgentArgsString == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Config.parseStringIntoSetOfNonEmptyStrings(traceAgentArgsString)));
        this.dogStatsDPath = configProvider.getString("dogstatsd.path");
        String dogStatsDArgsString = configProvider.getString("dogstatsd.args");
        this.dogStatsDArgs = dogStatsDArgsString == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Config.parseStringIntoSetOfNonEmptyStrings(dogStatsDArgsString)));
        boolean longRunningEnabled = configProvider.getBoolean("trace.experimental.long-running.enabled", false, new String[0]);
        long longRunningTraceFlushInterval = configProvider.getLong("trace.experimental.long-running.flush.interval", 300L, new String[0]);
        if (longRunningEnabled && (longRunningTraceFlushInterval < 20L || longRunningTraceFlushInterval > 450L)) {
            log.warn("Provided long running trace flush interval of {} seconds. It should be between 20 seconds and 7.5 minutes.Setting the flush interval to the default value of {} seconds .", (Object)longRunningTraceFlushInterval, (Object)300L);
            longRunningTraceFlushInterval = 300L;
        }
        this.longRunningTraceEnabled = longRunningEnabled;
        this.longRunningTraceFlushInterval = longRunningTraceFlushInterval;
        this.sparkTaskHistogramEnabled = configProvider.getBoolean("spark.task-histogram.enabled", true, new String[0]);
        this.jaxRsExceptionAsErrorsEnabled = configProvider.getBoolean("trace.jax-rs.exception-as-error.enabled", true, new String[0]);
        this.traceFlushIntervalSeconds = configProvider.getFloat("trace.flush.interval", 1.0f);
        this.telemetryDebugRequestsEnabled = configProvider.getBoolean("telemetry.debug.requests.enabled", false, new String[0]);
        this.timelineEventsEnabled = configProvider.getBoolean("profiling.timeline.events.enabled", false, new String[0]);
        log.debug("New instance: {}", (Object)this);
    }

    public String getRuntimeId() {
        return this.runtimeIdEnabled ? RuntimeIdHolder.runtimeId : "";
    }

    public Long getProcessId() {
        return PidHelper.getPidAsLong();
    }

    public String getSite() {
        return this.site;
    }

    public String getHostName() {
        return HostNameHolder.hostName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isServiceNameSetByUser() {
        return this.serviceNameSetByUser;
    }

    public String getRootContextServiceName() {
        return this.rootContextServiceName;
    }

    public boolean isLongRunningTraceEnabled() {
        return this.longRunningTraceEnabled;
    }

    public long getLongRunningTraceFlushInterval() {
        return this.longRunningTraceFlushInterval;
    }

    public boolean isInjectBaggageAsTagsEnabled() {
        return this.injectBaggageAsTagsEnabled;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public String getPrioritySamplingForce() {
        return this.prioritySamplingForce;
    }

    public int getSpanAttributeSchemaVersion() {
        return this.spanAttributeSchemaVersion;
    }

    public boolean isPeerServiceDefaultsEnabled() {
        return this.peerServiceDefaultsEnabled;
    }

    public Map<String, String> getPeerServiceComponentOverrides() {
        return this.peerServiceComponentOverrides;
    }

    public boolean isRemoveIntegrationServiceNamesEnabled() {
        return this.removeIntegrationServiceNamesEnabled;
    }

    public Map<String, String> getPeerServiceMapping() {
        return this.peerServiceMapping;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public Map<String, String> getRequestHeaderTags() {
        return this.requestHeaderTags;
    }

    public Map<String, String> getResponseHeaderTags() {
        return this.responseHeaderTags;
    }

    public boolean isRequestHeaderTagsCommaAllowed() {
        return this.requestHeaderTagsCommaAllowed;
    }

    public Map<String, String> getBaggageMapping() {
        return this.baggageMapping;
    }

    public Map<String, String> getHttpServerPathResourceNameMapping() {
        return this.httpServerPathResourceNameMapping;
    }

    public Map<String, String> getHttpClientPathResourceNameMapping() {
        return this.httpClientPathResourceNameMapping;
    }

    public boolean getHttpResourceRemoveTrailingSlash() {
        return this.httpResourceRemoveTrailingSlash;
    }

    public boolean isHttpServerDecodedResourcePreserveSpaces() {
        return this.httpServerDecodedResourcePreserveSpaces;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public int getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isScopeStrictMode() {
        return this.scopeStrictMode;
    }

    public boolean isScopeInheritAsyncPropagation() {
        return this.scopeInheritAsyncPropagation;
    }

    public int getScopeIterationKeepAlive() {
        return this.scopeIterationKeepAlive;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isTraceStrictWritesEnabled() {
        return this.traceStrictWritesEnabled;
    }

    public boolean isLogExtractHeaderNames() {
        return this.logExtractHeaderNames;
    }

    @Deprecated
    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    @Deprecated
    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public boolean isTracePropagationStyleB3PaddingEnabled() {
        return this.tracePropagationStyleB3PaddingEnabled;
    }

    public Set<TracePropagationStyle> getTracePropagationStylesToExtract() {
        return this.tracePropagationStylesToExtract;
    }

    public Set<TracePropagationStyle> getTracePropagationStylesToInject() {
        return this.tracePropagationStylesToInject;
    }

    public boolean isTracePropagationExtractFirst() {
        return this.tracePropagationExtractFirst;
    }

    public int getClockSyncPeriod() {
        return this.clockSyncPeriod;
    }

    public boolean isRuntimeMetricsEnabled() {
        return this.runtimeMetricsEnabled;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public String getTraceClientIpHeader() {
        return this.traceClientIpHeader;
    }

    public boolean isTraceClientIpResolverEnabled() {
        return this.traceClientIpResolverEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public String getTraceSamplingRules() {
        return this.traceSamplingRules;
    }

    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public int getTraceRateLimit() {
        return this.traceRateLimit;
    }

    public String getSpanSamplingRules() {
        return this.spanSamplingRules;
    }

    public String getSpanSamplingRulesFile() {
        return this.spanSamplingRulesFile;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled && this.instrumenterConfig.isProfilingEnabled();
    }

    public static boolean isDatadogProfilerEnablementOverridden() {
        return Platform.isJavaVersion(18) || Platform.isJavaVersion(16) || Platform.isJavaVersion(15) || Platform.isJavaVersion(14) || Platform.isJavaVersion(13) || Platform.isJavaVersion(12) || Platform.isJavaVersion(10) || Platform.isJavaVersion(9);
    }

    public static boolean isDatadogProfilerSafeInCurrentEnvironment() {
        boolean result;
        String arch;
        if (!Platform.isJ9() && Platform.isJavaVersion(8) && ("aarch64".equalsIgnoreCase(arch = System.getProperty("os.arch")) || "arm64".equalsIgnoreCase(arch))) {
            return false;
        }
        if (Platform.isGraalVM()) {
            return false;
        }
        boolean bl = result = Platform.isJ9() || !Platform.isJavaVersion(18) || Platform.isJavaVersionAtLeast(17, 0, 5) || Platform.isJavaVersion(11) && Platform.isJavaVersionAtLeast(11, 0, 17) || Platform.isJavaVersion(8) && Platform.isJavaVersionAtLeast(8, 0, 352);
        if (result && Platform.isJ9()) {
            result &= !(Platform.isJavaVersion(11) && Platform.isJavaVersionAtLeast(11, 0, 18) || Platform.isJavaVersion(17) && Platform.isJavaVersionAtLeast(17, 0, 6));
        }
        return result;
    }

    public boolean isClientIpEnabled() {
        return this.clientIpEnabled;
    }

    public boolean isCiVisibilityEnabled() {
        return false;
    }

    public boolean isAwsPropagationEnabled() {
        return this.awsPropagationEnabled;
    }

    public String getObfuscationQueryRegexp() {
        return this.obfuscationQueryRegexp;
    }

    public int getxDatadogTagsMaxLength() {
        return this.xDatadogTagsMaxLength;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isDataStreamsEnabled() {
        return this.dataStreamsEnabled;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return this.idGenerationStrategy;
    }

    public Map<String, Object> getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        HashMap<String, Object> result = new HashMap<String, Object>(runtimeTags.size() + 2);
        result.putAll(runtimeTags);
        result.put("language", "jvm");
        result.put("_dd.trace_span_attribute_schema", SpanNaming.instance().version());
        result.put("_dd.profiling.enabled", this.isProfilingEnabled() ? 1 : 0);
        if (this.reportHostName && null != (hostName = this.getHostName()) && !hostName.isEmpty()) {
            result.put("_dd.hostname", hostName);
        }
        if (this.azureAppServices) {
            result.putAll(this.getAzureAppServicesTags());
        }
        result.putAll(this.getProcessIdTag());
        return Collections.unmodifiableMap(result);
    }

    public String getPrimaryTag() {
        return this.primaryTag;
    }

    public String getEnv() {
        if (this.env == null) {
            this.env = this.getMergedSpanTags().get("env");
            if (this.env == null) {
                this.env = "";
            }
        }
        return this.env;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.getMergedSpanTags().get("version");
            if (this.version == null) {
                this.version = "";
            }
        }
        return this.version;
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.spanTags.size());
        result.putAll(this.getGlobalTags());
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getGlobalTags() {
        return this.tags;
    }

    private Map<String, String> getRuntimeTags() {
        return Collections.singletonMap("runtime-id", this.getRuntimeId());
    }

    private Map<String, Long> getProcessIdTag() {
        return Collections.singletonMap("process_id", this.getProcessId());
    }

    private Map<String, String> getAzureAppServicesTags() {
        String websiteOwner;
        HashMap<String, String> aasTags = new HashMap<String, String>();
        String siteName = Config.getEnv("WEBSITE_SITE_NAME");
        if (siteName != null) {
            aasTags.put("aas.site.name", siteName);
        }
        if (Config.getEnv("FUNCTIONS_WORKER_RUNTIME") != null || Config.getEnv("FUNCTIONS_EXTENSIONS_VERSION") != null) {
            aasTags.put("aas.site.kind", "functionapp");
            aasTags.put("aas.site.type", "function");
        } else {
            aasTags.put("aas.site.kind", "app");
            aasTags.put("aas.site.type", "app");
        }
        String resourceGroup = Config.getEnv("WEBSITE_RESOURCE_GROUP");
        if (resourceGroup != null) {
            aasTags.put("aas.resource.group", resourceGroup);
        }
        int plusIndex = (websiteOwner = Config.getEnv("WEBSITE_OWNER_NAME")) == null ? -1 : websiteOwner.indexOf("+");
        String subscriptionId = null;
        if (plusIndex > 0) {
            subscriptionId = websiteOwner.substring(0, plusIndex);
            aasTags.put("aas.subscription.id", subscriptionId);
        }
        if (subscriptionId != null && siteName != null && resourceGroup != null) {
            String resourceId = "/subscriptions/" + subscriptionId + "/resourcegroups/" + resourceGroup + "/providers/microsoft.web/sites/" + siteName;
            resourceId = resourceId.toLowerCase(Locale.ROOT);
            aasTags.put("aas.resource.id", resourceId);
        } else {
            log.warn("Unable to generate resource id subscription id: {}, site name: {}, resource group {}", subscriptionId, siteName, resourceGroup);
        }
        String instanceId = Config.getEnv("WEBSITE_INSTANCE_ID");
        instanceId = instanceId == null ? "unknown" : instanceId;
        aasTags.put("aas.environment.instance_id", instanceId);
        String instanceName = Config.getEnv("COMPUTERNAME");
        instanceName = instanceName == null ? "unknown" : instanceName;
        aasTags.put("aas.environment.instance_name", instanceName);
        String operatingSystem = Config.getEnv("WEBSITE_OS");
        operatingSystem = operatingSystem == null ? "unknown" : operatingSystem;
        aasTags.put("aas.environment.os", operatingSystem);
        String siteExtensionVersion = Config.getEnv("DD_AAS_JAVA_EXTENSION_VERSION");
        siteExtensionVersion = siteExtensionVersion == null ? "unknown" : siteExtensionVersion;
        aasTags.put("aas.environment.extension_version", siteExtensionVersion);
        aasTags.put("aas.environment.runtime", Config.getProp("java.vm.name", "unknown"));
        return aasTags;
    }

    private int schemaVersionFromConfig() {
        String versionStr = this.configProvider.getString("trace.span.attribute.schema", "v0", new String[0]);
        Matcher matcher = Pattern.compile("^v?(0|[1-9]\\d*)$").matcher(versionStr);
        int parsedVersion = -1;
        if (matcher.matches()) {
            parsedVersion = Integer.parseInt(matcher.group(1));
        }
        if (parsedVersion < 0 || parsedVersion > 1) {
            log.warn("Invalid attribute schema version {} invalid or out of range [v{}, v{}]. Defaulting to v{}", versionStr, 0, 1, 0);
            parsedVersion = 0;
        }
        return parsedVersion;
    }

    public boolean isJmxFetchIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "jmxfetch.", ".enabled", defaultEnabled);
    }

    public boolean isRuleEnabled(String name, boolean defaultEnabled) {
        boolean enabled = this.configProvider.getBoolean("trace." + name + ".enabled", defaultEnabled, new String[0]);
        boolean lowerEnabled = this.configProvider.getBoolean("trace." + name.toLowerCase(Locale.ROOT) + ".enabled", defaultEnabled, new String[0]);
        return defaultEnabled ? enabled && lowerEnabled : enabled || lowerEnabled;
    }

    @Deprecated
    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isJmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isEndToEndDurationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".e2e.duration.enabled", defaultEnabled);
    }

    public boolean isPropagationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".propagation.enabled", defaultEnabled);
    }

    public boolean isEnabled(boolean defaultEnabled, String settingName, String settingSuffix) {
        return this.configProvider.isEnabled(Collections.singletonList(settingName), "", settingSuffix, defaultEnabled);
    }

    private void logIgnoredSettingWarning(String setting, String overridingSetting, String overridingSuffix) {
        log.warn("Setting {} ignored since {}{} is enabled.", Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), overridingSuffix);
    }

    private void logOverriddenSettingWarning(String setting, String overridingSetting, Object value) {
        log.warn("Setting {} is overridden by setting {} with value {}.", Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), value);
    }

    private void logOverriddenDeprecatedSettingWarning(String setting, String overridingSetting, Object value) {
        log.warn("Setting {} is deprecated and overridden by setting {} with value {}.", Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), value);
    }

    private void logDeprecatedConvertedSetting(String deprecatedSetting, Object oldValue, String newSetting, Object newValue) {
        log.warn("Setting {} is deprecated and the value {} has been converted to {} for setting {}.", Config.propertyNameToSystemPropertyName(deprecatedSetting), oldValue, newValue, Config.propertyNameToSystemPropertyName(newSetting));
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isSamplingMechanismValidationDisabled() {
        return this.configProvider.getBoolean("trace.sampling.mechanism.validation.disabled", false, new String[0]);
    }

    @Deprecated
    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isTraceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    private <T> Set<T> getSettingsSetFromEnvironment(String name, Function<String, T> mapper, boolean splitOnWS) {
        String value = this.configProvider.getString(name, "", new String[0]);
        return Config.convertStringSetToSet(name, Config.parseStringIntoSetOfNonEmptyStrings(value, splitOnWS), mapper);
    }

    private <F, T> Set<T> convertSettingsSet(Set<F> fromSet, Function<F, Iterable<T>> mapper) {
        if (fromSet.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(fromSet.size());
        for (F from : fromSet) {
            for (T to : mapper.apply(from)) {
                result.add(to);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @NonNull
    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    @NonNull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @NonNull
    private Map<String, String> getMapWithPropertiesDefinedByEnvironment(@NonNull Map<String, String> map2, String ... propNames) {
        HashMap<String, String> res = new HashMap<String, String>(map2);
        for (String propName : propNames) {
            String val = this.configProvider.getString(propName);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @NonNull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str) {
        return Config.parseStringIntoSetOfNonEmptyStrings(str, true);
    }

    @NonNull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str, boolean splitOnWS) {
        int i;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int start = 0;
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != ',' && (!splitOnWS || !Character.isWhitespace(c))) continue;
            if (i - start - 1 > 0) {
                result.add(str.substring(start, i));
            }
            start = i + 1;
        }
        if (i - start - 1 > 0) {
            result.add(str.substring(start));
        }
        return Collections.unmodifiableSet(result);
    }

    private static <T> Set<T> convertStringSetToSet(String setting, Set<String> input, Function<String, T> mapper) {
        if (input.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (String value : input) {
            try {
                result.add(mapper.apply(value));
            }
            catch (IllegalArgumentException e) {
                log.warn("Cannot recognize config string value {} for setting {}", (Object)value, (Object)Config.propertyNameToSystemPropertyName(setting));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    static String initHostName() {
        String possibleHostname = Config.getEnv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream()));){
            possibleHostname = reader.readLine();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static String getEnv(String name) {
        String value = System.getenv(name);
        if (value != null) {
            ConfigCollector.get().put(name, value, ConfigOrigin.ENV);
        }
        return value;
    }

    private static String getProp(String name) {
        return Config.getProp(name, null);
    }

    private static String getProp(String name, String def) {
        String value = System.getProperty(name, def);
        if (value != null) {
            ConfigCollector.get().put(name, value, ConfigOrigin.JVM_PROP);
        }
        return value;
    }

    public static Config get() {
        return INSTANCE;
    }

    @Deprecated
    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(ConfigProvider.withPropertiesOverride(properties));
    }

    public String toString() {
        return "Config{instrumenterConfig=" + this.instrumenterConfig + ", runtimeId='" + this.getRuntimeId() + '\'' + ", runtimeVersion='" + this.runtimeVersion + ", site='" + this.site + '\'' + ", hostName='" + this.getHostName() + '\'' + ", serviceName='" + this.serviceName + '\'' + ", serviceNameSetByUser=" + this.serviceNameSetByUser + ", rootContextServiceName=" + this.rootContextServiceName + ", integrationSynapseLegacyOperationName=" + this.integrationSynapseLegacyOperationName + ", writerType='" + this.writerType + '\'' + ", agentConfiguredUsingDefault=" + this.agentConfiguredUsingDefault + ", agentUrl='" + this.agentUrl + '\'' + ", agentHost='" + this.agentHost + '\'' + ", agentPort=" + this.agentPort + '\'' + ", agentTimeout=" + this.agentTimeout + ", noProxyHosts=" + this.noProxyHosts + ", prioritySamplingEnabled=" + this.prioritySamplingEnabled + ", prioritySamplingForce='" + this.prioritySamplingForce + '\'' + ", traceResolverEnabled=" + this.traceResolverEnabled + ", serviceMapping=" + this.serviceMapping + ", tags=" + this.tags + ", spanTags=" + this.spanTags + ", requestHeaderTags=" + this.requestHeaderTags + ", responseHeaderTags=" + this.responseHeaderTags + ", baggageMapping=" + this.baggageMapping + ", httpServerErrorStatuses=" + this.httpServerErrorStatuses + ", httpClientErrorStatuses=" + this.httpClientErrorStatuses + ", httpServerTagQueryString=" + this.httpServerTagQueryString + ", httpServerRawQueryString=" + this.httpServerRawQueryString + ", httpServerRawResource=" + this.httpServerRawResource + ", httpServerRouteBasedNaming=" + this.httpServerRouteBasedNaming + ", httpServerPathResourceNameMapping=" + this.httpServerPathResourceNameMapping + ", httpClientPathResourceNameMapping=" + this.httpClientPathResourceNameMapping + ", httpClientTagQueryString=" + this.httpClientTagQueryString + ", httpClientSplitByDomain=" + this.httpClientSplitByDomain + ", httpResourceRemoveTrailingSlash" + this.httpResourceRemoveTrailingSlash + ", dbClientSplitByInstance=" + this.dbClientSplitByInstance + ", dbClientSplitByInstanceTypeSuffix=" + this.dbClientSplitByInstanceTypeSuffix + ", dbClientSplitByHost=" + this.dbClientSplitByHost + ", DBMPropagationMode=" + this.DBMPropagationMode + ", splitByTags=" + this.splitByTags + ", scopeDepthLimit=" + this.scopeDepthLimit + ", scopeStrictMode=" + this.scopeStrictMode + ", scopeInheritAsyncPropagation=" + this.scopeInheritAsyncPropagation + ", scopeIterationKeepAlive=" + this.scopeIterationKeepAlive + ", partialFlushMinSpans=" + this.partialFlushMinSpans + ", traceStrictWritesEnabled=" + this.traceStrictWritesEnabled + ", tracePropagationStylesToExtract=" + this.tracePropagationStylesToExtract + ", tracePropagationStylesToInject=" + this.tracePropagationStylesToInject + ", tracePropagationExtractFirst=" + this.tracePropagationExtractFirst + ", clockSyncPeriod=" + this.clockSyncPeriod + ", healthMetricsEnabled=" + this.healthMetricsEnabled + ", healthMetricsStatsdHost='" + this.healthMetricsStatsdHost + '\'' + ", healthMetricsStatsdPort=" + this.healthMetricsStatsdPort + ", perfMetricsEnabled=" + this.perfMetricsEnabled + ", tracerMetricsEnabled=" + this.tracerMetricsEnabled + ", tracerMetricsBufferingEnabled=" + this.tracerMetricsBufferingEnabled + ", tracerMetricsMaxAggregates=" + this.tracerMetricsMaxAggregates + ", tracerMetricsMaxPending=" + this.tracerMetricsMaxPending + ", reportHostName=" + this.reportHostName + ", traceAnalyticsEnabled=" + this.traceAnalyticsEnabled + ", traceSamplingServiceRules=" + this.traceSamplingServiceRules + ", traceSamplingOperationRules=" + this.traceSamplingOperationRules + ", traceSamplingJsonRules=" + this.traceSamplingRules + ", traceSampleRate=" + this.traceSampleRate + ", traceRateLimit=" + this.traceRateLimit + ", spanSamplingRules=" + this.spanSamplingRules + ", spanSamplingRulesFile=" + this.spanSamplingRulesFile + ", profilingAgentless=" + this.profilingAgentless + ", profilingUrl='" + this.profilingUrl + '\'' + ", profilingTags=" + this.profilingTags + ", profilingStartDelay=" + this.profilingStartDelay + ", profilingStartForceFirst=" + this.profilingStartForceFirst + ", profilingUploadPeriod=" + this.profilingUploadPeriod + ", profilingTemplateOverrideFile='" + this.profilingTemplateOverrideFile + '\'' + ", profilingUploadTimeout=" + this.profilingUploadTimeout + ", profilingUploadCompression='" + this.profilingUploadCompression + '\'' + ", profilingProxyHost='" + this.profilingProxyHost + '\'' + ", profilingProxyPort=" + this.profilingProxyPort + ", profilingProxyUsername='" + this.profilingProxyUsername + '\'' + ", profilingProxyPassword=" + (this.profilingProxyPassword == null ? "null" : "****") + ", profilingExceptionSampleLimit=" + this.profilingExceptionSampleLimit + ", profilingExceptionHistogramTopItems=" + this.profilingExceptionHistogramTopItems + ", profilingExceptionHistogramMaxCollectionSize=" + this.profilingExceptionHistogramMaxCollectionSize + ", profilingExcludeAgentThreads=" + this.profilingExcludeAgentThreads + ", crashTrackingTags=" + this.crashTrackingTags + ", crashTrackingAgentless=" + this.crashTrackingAgentless + ", remoteConfigEnabled=" + this.remoteConfigEnabled + ", remoteConfigUrl=" + this.remoteConfigUrl + ", remoteConfigPollIntervalSeconds=" + this.remoteConfigPollIntervalSeconds + ", remoteConfigMaxPayloadSize=" + this.remoteConfigMaxPayloadSize + ", remoteConfigIntegrityCheckEnabled=" + this.remoteConfigIntegrityCheckEnabled + ", awsPropagationEnabled=" + this.awsPropagationEnabled + ", sqsPropagationEnabled=" + this.sqsPropagationEnabled + ", kafkaClientPropagationEnabled=" + this.kafkaClientPropagationEnabled + ", kafkaClientPropagationDisabledTopics=" + this.kafkaClientPropagationDisabledTopics + ", kafkaClientBase64DecodingEnabled=" + this.kafkaClientBase64DecodingEnabled + ", jmsPropagationEnabled=" + this.jmsPropagationEnabled + ", jmsPropagationDisabledTopics=" + this.jmsPropagationDisabledTopics + ", jmsPropagationDisabledQueues=" + this.jmsPropagationDisabledQueues + ", rabbitPropagationEnabled=" + this.rabbitPropagationEnabled + ", rabbitPropagationDisabledQueues=" + this.rabbitPropagationDisabledQueues + ", rabbitPropagationDisabledExchanges=" + this.rabbitPropagationDisabledExchanges + ", messageBrokerSplitByDestination=" + this.messageBrokerSplitByDestination + ", hystrixTagsEnabled=" + this.hystrixTagsEnabled + ", hystrixMeasuredEnabled=" + this.hystrixMeasuredEnabled + ", igniteCacheIncludeKeys=" + this.igniteCacheIncludeKeys + ", servletPrincipalEnabled=" + this.servletPrincipalEnabled + ", servletAsyncTimeoutError=" + this.servletAsyncTimeoutError + ", datadogTagsLimit=" + this.xDatadogTagsMaxLength + ", traceAgentV05Enabled=" + this.traceAgentV05Enabled + ", debugEnabled=" + this.debugEnabled + ", triageEnabled=" + this.triageEnabled + ", startLogsEnabled=" + this.startupLogsEnabled + ", configFile='" + this.configFileStatus + '\'' + ", idGenerationStrategy=" + this.idGenerationStrategy + ", trace128bitTraceIdGenerationEnabled=" + this.trace128bitTraceIdGenerationEnabled + ", grpcIgnoredInboundMethods=" + this.grpcIgnoredInboundMethods + ", grpcIgnoredOutboundMethods=" + this.grpcIgnoredOutboundMethods + ", grpcServerErrorStatuses=" + this.grpcServerErrorStatuses + ", grpcClientErrorStatuses=" + this.grpcClientErrorStatuses + ", clientIpEnabled=" + this.clientIpEnabled + ", longRunningTraceEnabled=" + this.longRunningTraceEnabled + ", longRunningTraceFlushInterval=" + this.longRunningTraceFlushInterval + ", elasticsearchBodyEnabled=" + this.elasticsearchBodyEnabled + ", elasticsearchParamsEnabled=" + this.elasticsearchParamsEnabled + ", elasticsearchBodyAndParamsEnabled=" + this.elasticsearchBodyAndParamsEnabled + ", traceFlushInterval=" + this.traceFlushIntervalSeconds + ", injectBaggageAsTagsEnabled=" + this.injectBaggageAsTagsEnabled + ", logsInjectionEnabled=" + this.logsInjectionEnabled + ", sparkTaskHistogramEnabled=" + this.sparkTaskHistogramEnabled + ", jaxRsExceptionAsErrorsEnabled=" + this.jaxRsExceptionAsErrorsEnabled + ", peerServiceDefaultsEnabled=" + this.peerServiceDefaultsEnabled + ", peerServiceComponentOverrides=" + this.peerServiceComponentOverrides + ", removeIntegrationServiceNamesEnabled=" + this.removeIntegrationServiceNamesEnabled + ", spanAttributeSchemaVersion=" + this.spanAttributeSchemaVersion + ", telemetryDebugRequestsEnabled=" + this.telemetryDebugRequestsEnabled + ", telemetryMetricsEnabled=" + this.telemetryMetricsEnabled + '}';
    }

    static class RuntimeIdHolder {
        static final String runtimeId = UUID.randomUUID().toString();

        RuntimeIdHolder() {
        }
    }

    static class HostNameHolder {
        static final String hostName = Config.initHostName();

        HostNameHolder() {
        }
    }
}

