/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.legacy.trace.common.sampling;

import com.datadog.legacy.trace.common.sampling.RateSampler;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.DDTracer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DeterministicSampler
implements RateSampler {
    private static final BigInteger KNUTH_FACTOR = new BigInteger("1111111111111111111");
    private static final BigDecimal TRACE_ID_MAX_AS_BIG_DECIMAL = new BigDecimal(DDTracer.TRACE_ID_MAX);
    private static final BigInteger MODULUS = new BigInteger("2").pow(64);
    private final BigInteger cutoff;
    private final double rate;

    public DeterministicSampler(double rate) {
        this.rate = rate;
        this.cutoff = new BigDecimal(rate).multiply(TRACE_ID_MAX_AS_BIG_DECIMAL).toBigInteger();
    }

    @Override
    public boolean sample(DDSpan span) {
        boolean sampled = this.rate == 1.0 ? true : (this.rate == 0.0 ? false : span.getTraceId().multiply(KNUTH_FACTOR).mod(MODULUS).compareTo(this.cutoff) < 0);
        return sampled;
    }

    @Override
    public double getSampleRate() {
        return this.rate;
    }
}

