/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.handlers;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.trace.internal.handlers.AndroidSpanLogsHandler;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.LogHandler;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u00062\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J7\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00130\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/trace/internal/handlers/AndroidSpanLogsHandler;", "Lcom/datadog/opentracing/LogHandler;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;)V", "extractError", "", "map", "", "", "span", "Lcom/datadog/opentracing/DDSpan;", "log", "timestampMicroseconds", "", "event", "fields", "", "logFields", "", "(Lcom/datadog/opentracing/DDSpan;Ljava/util/Map;Ljava/lang/Long;)V", "toMilliseconds", "(Ljava/lang/Long;)Ljava/lang/Long;", "Companion", "dd-sdk-android-trace_release"})
@SourceDebugExtension(value={"SMAP\nAndroidSpanLogsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSpanLogsHandler.kt\ncom/datadog/android/trace/internal/handlers/AndroidSpanLogsHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class AndroidSpanLogsHandler
implements LogHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    public static final String DEFAULT_EVENT_MESSAGE = "Span event";
    @NotNull
    public static final String MISSING_LOG_FEATURE_INFO = "Requested to write span log, but Logs feature is not registered.";
    @NotNull
    public static final String TRACE_LOGGER_NAME = "trace";

    public AndroidSpanLogsHandler(@NotNull FeatureSdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
    }

    @Override
    public void log(@NotNull String event, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"event", (Object)event)};
        this.logFields(span, MapsKt.mutableMapOf((Pair[])pairArray), null);
    }

    @Override
    public void log(long timestampMicroseconds, @NotNull String event, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"event", (Object)event)};
        this.logFields(span, MapsKt.mutableMapOf((Pair[])pairArray), timestampMicroseconds);
    }

    @Override
    public void log(@NotNull Map<String, ?> fields, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Map mutableMap = MapsKt.toMutableMap(fields);
        this.extractError(mutableMap, span);
        AndroidSpanLogsHandler.logFields$default(this, span, mutableMap, null, 4, null);
    }

    @Override
    public void log(long timestampMicroseconds, @NotNull Map<String, ?> fields, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Map mutableMap = MapsKt.toMutableMap(fields);
        this.extractError(mutableMap, span);
        this.logFields(span, mutableMap, timestampMicroseconds);
    }

    private final Long toMilliseconds(Long timestampMicroseconds) {
        Long l;
        Long l2 = timestampMicroseconds;
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = TimeUnit.MICROSECONDS.toMillis(it);
        } else {
            l = null;
        }
        return l;
    }

    private final void logFields(DDSpan span, Map<String, Object> fields, Long timestampMicroseconds) {
        FeatureScope logsFeature = this.sdkCore.getFeature("logs");
        if (logsFeature != null && !fields.isEmpty()) {
            Object object = fields.remove("message");
            if (object == null || (object = object.toString()) == null) {
                object = DEFAULT_EVENT_MESSAGE;
            }
            Object message = object;
            fields.put("dd.trace_id", span.getTraceId().toString());
            fields.put("dd.span_id", span.getSpanId().toString());
            Long l = this.toMilliseconds(timestampMicroseconds);
            long timestamp = l != null ? l : System.currentTimeMillis();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"span_log"), TuplesKt.to((Object)"loggerName", (Object)TRACE_LOGGER_NAME), TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"attributes", fields), TuplesKt.to((Object)"timestamp", (Object)timestamp)};
            logsFeature.sendEvent((Object)MapsKt.mapOf((Pair[])pairArray));
        } else if (logsFeature == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)logFields.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    static /* synthetic */ void logFields$default(AndroidSpanLogsHandler androidSpanLogsHandler, DDSpan dDSpan, Map map2, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        androidSpanLogsHandler.logFields(dDSpan, map2, l);
    }

    private final void extractError(Map<String, ?> map2, DDSpan span) {
        Object errorType;
        Object obj = map2.remove("error.object");
        Throwable throwable = obj instanceof Throwable ? (Throwable)obj : null;
        Object kind = map2.remove("error.kind");
        Object object = kind;
        if (object == null || (object = object.toString()) == null) {
            Serializable serializable = throwable;
            object = serializable != null && (serializable = serializable.getClass()) != null ? ((Class)serializable).getName() : null;
        }
        if ((errorType = object) != null) {
            Object object2;
            Object stack;
            Object stackField = map2.remove("stack");
            Object msgField = map2.get("message");
            Object object3 = stackField;
            if (object3 == null || (object3 = object3.toString()) == null) {
                Throwable throwable2 = throwable;
                object3 = stack = throwable2 != null ? ThrowableExtKt.loggableStackTrace((Throwable)throwable2) : null;
            }
            if ((object2 = msgField) == null || (object2 = object2.toString()) == null) {
                Throwable throwable3 = throwable;
                object2 = throwable3 != null ? throwable3.getMessage() : null;
            }
            Object message = object2;
            span.setError(true);
            span.setTag("error.type", (String)errorType);
            span.setTag("error.msg", (String)message);
            span.setTag("error.stack", (String)stack);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/trace/internal/handlers/AndroidSpanLogsHandler$Companion;", "", "()V", "DEFAULT_EVENT_MESSAGE", "", "MISSING_LOG_FEATURE_INFO", "TRACE_LOGGER_NAME", "dd-sdk-android-trace_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

